/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.BoundType;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.DescendingImmutableSortedMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMultisetFauxverideShim;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.google.common.collect.Ordering;
import com.google.common.collect.RegularImmutableSortedMultiset;
import com.google.common.collect.RegularImmutableSortedSet;
import com.google.common.collect.SortedMultiset;
import com.google.common.math.IntMath;
import com.google.errorprone.annotations.concurrent.LazyInit;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

public abstract class ImmutableSortedMultiset<E>
extends ImmutableSortedMultisetFauxverideShim<E>
implements SortedMultiset<E> {
    @LazyInit
    transient ImmutableSortedMultiset<E> descendingMultiset;

    ImmutableSortedMultiset() {
    }

    public static <E> ImmutableSortedMultiset<E> copyOf(Iterable<? extends E> iterable) {
        return ImmutableSortedMultiset.copyOf(Ordering.natural(), iterable);
    }

    public static <E> ImmutableSortedMultiset<E> copyOf(Comparator<? super E> comparator, Iterable<? extends E> iterable) {
        ImmutableSortedMultiset immutableSortedMultiset;
        if (iterable instanceof ImmutableSortedMultiset && comparator.equals((immutableSortedMultiset = (ImmutableSortedMultiset)iterable).comparator())) {
            if (immutableSortedMultiset.isPartialView()) {
                return ImmutableSortedMultiset.copyOfSortedEntries(comparator, ((ImmutableSet)immutableSortedMultiset.entrySet()).asList());
            }
            return immutableSortedMultiset;
        }
        return ((Builder)new Builder<E>(comparator).addAll(iterable)).build();
    }

    public static <E> ImmutableSortedMultiset<E> copyOf(Comparator<? super E> comparator, Iterator<? extends E> iterator2) {
        Preconditions.checkNotNull(comparator);
        return ((Builder)new Builder<E>(comparator).addAll((Iterator)iterator2)).build();
    }

    public static <E> ImmutableSortedMultiset<E> copyOf(Iterator<? extends E> iterator2) {
        return ImmutableSortedMultiset.copyOf(Ordering.natural(), iterator2);
    }

    public static <E extends Comparable<? super E>> ImmutableSortedMultiset<E> copyOf(E[] EArray) {
        return ImmutableSortedMultiset.copyOf(Ordering.natural(), Arrays.asList(EArray));
    }

    public static <E> ImmutableSortedMultiset<E> copyOfSorted(SortedMultiset<E> sortedMultiset) {
        return ImmutableSortedMultiset.copyOfSortedEntries(sortedMultiset.comparator(), Lists.newArrayList(sortedMultiset.entrySet()));
    }

    private static <E> ImmutableSortedMultiset<E> copyOfSortedEntries(Comparator<? super E> comparator, Collection<Multiset.Entry<E>> collection) {
        if (collection.isEmpty()) {
            return ImmutableSortedMultiset.emptyMultiset(comparator);
        }
        ImmutableList.Builder builder = new ImmutableList.Builder(collection.size());
        long[] lArray = new long[collection.size() + 1];
        Iterator<Multiset.Entry<E>> iterator2 = collection.iterator();
        int n2 = 0;
        while (iterator2.hasNext()) {
            Multiset.Entry<E> entry = iterator2.next();
            builder.add((Object)entry.getElement());
            int n3 = n2 + 1;
            lArray[n3] = lArray[n2] + (long)entry.getCount();
            n2 = n3;
        }
        return new RegularImmutableSortedMultiset<E>(new RegularImmutableSortedSet<E>(builder.build(), comparator), lArray, 0, collection.size());
    }

    static <E> ImmutableSortedMultiset<E> emptyMultiset(Comparator<? super E> comparator) {
        if (Ordering.natural().equals(comparator)) {
            return RegularImmutableSortedMultiset.NATURAL_EMPTY_MULTISET;
        }
        return new RegularImmutableSortedMultiset<E>(comparator);
    }

    public static <E extends Comparable<?>> Builder<E> naturalOrder() {
        return new Builder(Ordering.natural());
    }

    public static <E> ImmutableSortedMultiset<E> of() {
        return RegularImmutableSortedMultiset.NATURAL_EMPTY_MULTISET;
    }

    public static <E extends Comparable<? super E>> ImmutableSortedMultiset<E> of(E e2) {
        return new RegularImmutableSortedMultiset((RegularImmutableSortedSet)ImmutableSortedSet.of(e2), new long[]{0L, 1L}, 0, 1);
    }

    public static <E extends Comparable<? super E>> ImmutableSortedMultiset<E> of(E e2, E e3) {
        return ImmutableSortedMultiset.copyOf(Ordering.natural(), Arrays.asList(e2, e3));
    }

    public static <E extends Comparable<? super E>> ImmutableSortedMultiset<E> of(E e2, E e3, E e4) {
        return ImmutableSortedMultiset.copyOf(Ordering.natural(), Arrays.asList(e2, e3, e4));
    }

    public static <E extends Comparable<? super E>> ImmutableSortedMultiset<E> of(E e2, E e3, E e4, E e5) {
        return ImmutableSortedMultiset.copyOf(Ordering.natural(), Arrays.asList(e2, e3, e4, e5));
    }

    public static <E extends Comparable<? super E>> ImmutableSortedMultiset<E> of(E e2, E e3, E e4, E e5, E e6) {
        return ImmutableSortedMultiset.copyOf(Ordering.natural(), Arrays.asList(e2, e3, e4, e5, e6));
    }

    public static <E extends Comparable<? super E>> ImmutableSortedMultiset<E> of(E e2, E e3, E e4, E e5, E e6, E e7, E ... EArray) {
        ArrayList arrayList = Lists.newArrayListWithCapacity(EArray.length + 6);
        Collections.addAll(arrayList, e2, e3, e4, e5, e6, e7);
        Collections.addAll(arrayList, EArray);
        return ImmutableSortedMultiset.copyOf(Ordering.natural(), arrayList);
    }

    public static <E> Builder<E> orderedBy(Comparator<E> comparator) {
        return new Builder<E>(comparator);
    }

    public static <E extends Comparable<?>> Builder<E> reverseOrder() {
        return new Builder(Ordering.natural().reverse());
    }

    @Override
    public final Comparator<? super E> comparator() {
        return ((ImmutableSortedSet)this.elementSet()).comparator();
    }

    @Override
    public ImmutableSortedMultiset<E> descendingMultiset() {
        ImmutableSortedMultiset<E> immutableSortedMultiset;
        ImmutableSortedMultiset<Object> immutableSortedMultiset2 = immutableSortedMultiset = this.descendingMultiset;
        if (immutableSortedMultiset == null) {
            immutableSortedMultiset2 = this.isEmpty() ? ImmutableSortedMultiset.emptyMultiset(Ordering.from(this.comparator()).reverse()) : new DescendingImmutableSortedMultiset(this);
            this.descendingMultiset = immutableSortedMultiset2;
        }
        return immutableSortedMultiset2;
    }

    @Override
    public abstract ImmutableSortedSet<E> elementSet();

    @Override
    public abstract ImmutableSortedMultiset<E> headMultiset(E var1, BoundType var2);

    @Override
    @Deprecated
    public final Multiset.Entry<E> pollFirstEntry() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final Multiset.Entry<E> pollLastEntry() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ImmutableSortedMultiset<E> subMultiset(E e2, BoundType boundType, E e3, BoundType boundType2) {
        boolean bl = this.comparator().compare(e2, e3) <= 0;
        Preconditions.checkArgument(bl, "Expected lowerBound <= upperBound but %s > %s", e2, e3);
        return ((ImmutableSortedMultiset)this.tailMultiset((Object)e2, boundType)).headMultiset((Object)e3, boundType2);
    }

    @Override
    public abstract ImmutableSortedMultiset<E> tailMultiset(E var1, BoundType var2);

    @Override
    Object writeReplace() {
        return new SerializedForm(this);
    }

    public static class Builder<E>
    extends ImmutableMultiset.Builder<E> {
        private final Comparator<? super E> comparator;
        private int[] counts;
        E[] elements;
        private boolean forceCopyElements;
        private int length;

        public Builder(Comparator<? super E> comparator) {
            super(true);
            this.comparator = Preconditions.checkNotNull(comparator);
            this.elements = new Object[4];
            this.counts = new int[4];
        }

        private void dedupAndCoalesce(boolean bl) {
            int n2;
            int n3;
            int n4 = this.length;
            if (n4 == 0) {
                return;
            }
            Object[] objectArray = Arrays.copyOf(this.elements, n4);
            Arrays.sort(objectArray, this.comparator);
            n4 = 1;
            for (n3 = 1; n3 < objectArray.length; ++n3) {
                n2 = n4;
                if (this.comparator.compare(objectArray[n4 - 1], objectArray[n3]) < 0) {
                    objectArray[n4] = objectArray[n3];
                    n2 = n4 + 1;
                }
                n4 = n2;
            }
            Arrays.fill(objectArray, n4, this.length, null);
            Object[] objectArray2 = objectArray;
            if (bl) {
                n3 = this.length;
                objectArray2 = objectArray;
                if (n4 * 4 > n3 * 3) {
                    objectArray2 = Arrays.copyOf(objectArray, IntMath.saturatedAdd((int)n3, (int)(n3 / 2 + 1)));
                }
            }
            int[] nArray = new int[objectArray2.length];
            for (n3 = 0; n3 < this.length; ++n3) {
                n2 = Arrays.binarySearch(objectArray2, 0, n4, this.elements[n3], this.comparator);
                objectArray = this.counts;
                nArray[n2] = objectArray[n3] >= 0 ? nArray[n2] + objectArray[n3] : ~objectArray[n3];
            }
            this.elements = objectArray2;
            this.counts = nArray;
            this.length = n4;
        }

        private void dedupAndCoalesceAndDeleteEmpty() {
            int n2;
            this.dedupAndCoalesce(false);
            int n3 = 0;
            for (int i2 = 0; i2 < (n2 = this.length); ++i2) {
                int[] nArray = this.counts;
                n2 = n3;
                if (nArray[i2] > 0) {
                    E[] EArray = this.elements;
                    EArray[n3] = EArray[i2];
                    nArray[n3] = nArray[i2];
                    n2 = n3 + 1;
                }
                n3 = n2;
            }
            Arrays.fill(this.elements, n3, n2, null);
            Arrays.fill(this.counts, n3, this.length, 0);
            this.length = n3;
        }

        private void maintenance() {
            int n2 = this.length;
            E[] EArray = this.elements;
            if (n2 == EArray.length) {
                this.dedupAndCoalesce(true);
            } else if (this.forceCopyElements) {
                this.elements = Arrays.copyOf(EArray, EArray.length);
            }
            this.forceCopyElements = false;
        }

        @Override
        public Builder<E> add(E e2) {
            return this.addCopies((Object)e2, 1);
        }

        @Override
        public Builder<E> add(E ... EArray) {
            int n2 = EArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.add((Object)EArray[i2]);
            }
            return this;
        }

        @Override
        public Builder<E> addAll(Iterable<? extends E> iterator2) {
            if (iterator2 instanceof Multiset) {
                for (Multiset.Entry entry : ((Multiset)((Object)iterator2)).entrySet()) {
                    this.addCopies(entry.getElement(), entry.getCount());
                }
            } else {
                iterator2 = iterator2.iterator();
                while (iterator2.hasNext()) {
                    this.add(iterator2.next());
                }
            }
            return this;
        }

        @Override
        public Builder<E> addAll(Iterator<? extends E> iterator2) {
            while (iterator2.hasNext()) {
                this.add((Object)iterator2.next());
            }
            return this;
        }

        @Override
        public Builder<E> addCopies(E e2, int n2) {
            Preconditions.checkNotNull(e2);
            CollectPreconditions.checkNonnegative((int)n2, (String)"occurrences");
            if (n2 == 0) {
                return this;
            }
            this.maintenance();
            E[] EArray = this.elements;
            int n3 = this.length;
            EArray[n3] = e2;
            this.counts[n3] = n2;
            this.length = n3 + 1;
            return this;
        }

        @Override
        public ImmutableSortedMultiset<E> build() {
            int n2;
            this.dedupAndCoalesceAndDeleteEmpty();
            int n3 = this.length;
            if (n3 == 0) {
                return ImmutableSortedMultiset.emptyMultiset(this.comparator);
            }
            RegularImmutableSortedSet regularImmutableSortedSet = (RegularImmutableSortedSet)ImmutableSortedSet.construct(this.comparator, n3, this.elements);
            long[] lArray = new long[this.length + 1];
            n3 = 0;
            while (n3 < (n2 = this.length)) {
                n2 = n3 + 1;
                lArray[n2] = lArray[n3] + (long)this.counts[n3];
                n3 = n2;
            }
            this.forceCopyElements = true;
            return new RegularImmutableSortedMultiset(regularImmutableSortedSet, lArray, 0, n2);
        }

        @Override
        public Builder<E> setCount(E e2, int n2) {
            Preconditions.checkNotNull(e2);
            CollectPreconditions.checkNonnegative((int)n2, (String)"count");
            this.maintenance();
            E[] EArray = this.elements;
            int n3 = this.length;
            EArray[n3] = e2;
            this.counts[n3] = ~n2;
            this.length = n3 + 1;
            return this;
        }
    }

    private static final class SerializedForm<E>
    implements Serializable {
        final Comparator<? super E> comparator;
        final int[] counts;
        final E[] elements;

        SerializedForm(SortedMultiset<E> object) {
            this.comparator = object.comparator();
            int n2 = object.entrySet().size();
            this.elements = new Object[n2];
            this.counts = new int[n2];
            Iterator<Multiset.Entry<E>> iterator2 = object.entrySet().iterator();
            n2 = 0;
            while (iterator2.hasNext()) {
                object = iterator2.next();
                this.elements[n2] = object.getElement();
                this.counts[n2] = object.getCount();
                ++n2;
            }
        }

        Object readResolve() {
            int n2 = this.elements.length;
            Builder<E> builder = new Builder<E>(this.comparator);
            for (int i2 = 0; i2 < n2; ++i2) {
                builder.addCopies((Object)this.elements[i2], this.counts[i2]);
            }
            return builder.build();
        }
    }
}

