/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMapEntrySet;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMapFauxverideShim;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.RegularImmutableSortedSet;
import com.google.common.collect.UnmodifiableIterator;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class ImmutableSortedMap<K, V>
extends ImmutableSortedMapFauxverideShim<K, V>
implements NavigableMap<K, V> {
    private static final ImmutableSortedMap<Comparable, Object> NATURAL_EMPTY_MAP;
    private static final Comparator<Comparable> NATURAL_ORDER;
    private static final long serialVersionUID = 0L;
    private transient ImmutableSortedMap<K, V> descendingMap;
    private final transient RegularImmutableSortedSet<K> keySet;
    private final transient ImmutableList<V> valueList;

    static {
        NATURAL_ORDER = Ordering.natural();
        NATURAL_EMPTY_MAP = new ImmutableSortedMap(ImmutableSortedSet.emptySet(Ordering.natural()), ImmutableList.of());
    }

    ImmutableSortedMap(RegularImmutableSortedSet<K> regularImmutableSortedSet, ImmutableList<V> immutableList) {
        this(regularImmutableSortedSet, immutableList, null);
    }

    ImmutableSortedMap(RegularImmutableSortedSet<K> regularImmutableSortedSet, ImmutableList<V> immutableList, ImmutableSortedMap<K, V> immutableSortedMap) {
        this.keySet = regularImmutableSortedSet;
        this.valueList = immutableList;
        this.descendingMap = immutableSortedMap;
    }

    public static <K, V> ImmutableSortedMap<K, V> copyOf(Iterable<? extends Map.Entry<? extends K, ? extends V>> iterable) {
        return ImmutableSortedMap.copyOf(iterable, (Ordering)NATURAL_ORDER);
    }

    public static <K, V> ImmutableSortedMap<K, V> copyOf(Iterable<? extends Map.Entry<? extends K, ? extends V>> iterable, Comparator<? super K> comparator) {
        return ImmutableSortedMap.fromEntries(Preconditions.checkNotNull(comparator), false, iterable);
    }

    public static <K, V> ImmutableSortedMap<K, V> copyOf(Map<? extends K, ? extends V> map) {
        return ImmutableSortedMap.copyOfInternal(map, (Ordering)NATURAL_ORDER);
    }

    public static <K, V> ImmutableSortedMap<K, V> copyOf(Map<? extends K, ? extends V> map, Comparator<? super K> comparator) {
        return ImmutableSortedMap.copyOfInternal(map, Preconditions.checkNotNull(comparator));
    }

    private static <K, V> ImmutableSortedMap<K, V> copyOfInternal(Map<? extends K, ? extends V> map, Comparator<? super K> comparator) {
        Comparator comparator2;
        boolean bl;
        boolean bl2 = map instanceof SortedMap;
        boolean bl3 = bl = false;
        if (bl2) {
            comparator2 = ((SortedMap)map).comparator();
            if (comparator2 == null) {
                bl3 = bl;
                if (comparator == NATURAL_ORDER) {
                    bl3 = true;
                }
            } else {
                bl3 = comparator.equals(comparator2);
            }
        }
        if (bl3 && map instanceof ImmutableSortedMap && !((ImmutableSortedMap)((Object)(comparator2 = (ImmutableSortedMap)map))).isPartialView()) {
            return comparator2;
        }
        return ImmutableSortedMap.fromEntries(comparator, bl3, map.entrySet());
    }

    public static <K, V> ImmutableSortedMap<K, V> copyOfSorted(SortedMap<K, ? extends V> sortedMap) {
        Object object = sortedMap.comparator();
        Comparator<Object> comparator = object;
        if (object == null) {
            comparator = NATURAL_ORDER;
        }
        if (sortedMap instanceof ImmutableSortedMap && !((ImmutableSortedMap)(object = (ImmutableSortedMap)sortedMap)).isPartialView()) {
            return object;
        }
        return ImmutableSortedMap.fromEntries(comparator, true, sortedMap.entrySet());
    }

    static <K, V> ImmutableSortedMap<K, V> emptyMap(Comparator<? super K> comparator) {
        if (Ordering.natural().equals(comparator)) {
            return ImmutableSortedMap.of();
        }
        return new ImmutableSortedMap(ImmutableSortedSet.emptySet(comparator), ImmutableList.of());
    }

    private static <K, V> ImmutableSortedMap<K, V> fromEntries(Comparator<? super K> comparator, boolean bl, Iterable<? extends Map.Entry<? extends K, ? extends V>> entryArray) {
        entryArray = Iterables.toArray(entryArray, EMPTY_ENTRY_ARRAY);
        return ImmutableSortedMap.fromEntries(comparator, bl, entryArray, entryArray.length);
    }

    private static <K, V> ImmutableSortedMap<K, V> fromEntries(final Comparator<? super K> comparator, boolean bl, Map.Entry<K, V>[] entryArray, int n2) {
        if (n2 != 0) {
            if (n2 != 1) {
                int n3;
                Object[] objectArray = new Object[n2];
                Object[] objectArray2 = new Object[n2];
                if (bl) {
                    for (n3 = 0; n3 < n2; ++n3) {
                        K k2 = entryArray[n3].getKey();
                        V v2 = entryArray[n3].getValue();
                        CollectPreconditions.checkEntryNotNull(k2, v2);
                        objectArray[n3] = k2;
                        objectArray2[n3] = v2;
                    }
                } else {
                    Arrays.sort(entryArray, 0, n2, new Comparator<Map.Entry<K, V>>(){

                        @Override
                        public int compare(Map.Entry<K, V> entry, Map.Entry<K, V> entry2) {
                            return comparator.compare(entry.getKey(), entry2.getKey());
                        }
                    });
                    K k3 = entryArray[0].getKey();
                    objectArray[0] = k3;
                    objectArray2[0] = entryArray[0].getValue();
                    CollectPreconditions.checkEntryNotNull((Object)objectArray[0], (Object)objectArray2[0]);
                    for (n3 = 1; n3 < n2; ++n3) {
                        K k4 = entryArray[n3].getKey();
                        V v3 = entryArray[n3].getValue();
                        CollectPreconditions.checkEntryNotNull(k4, v3);
                        objectArray[n3] = k4;
                        objectArray2[n3] = v3;
                        bl = comparator.compare(k3, k4) != 0;
                        ImmutableSortedMap.checkNoConflict(bl, "key", entryArray[n3 - 1], entryArray[n3]);
                        k3 = k4;
                    }
                }
                return new ImmutableSortedMap(new RegularImmutableSortedSet<K>(ImmutableList.asImmutableList(objectArray), comparator), ImmutableList.asImmutableList(objectArray2));
            }
            return ImmutableSortedMap.of(comparator, entryArray[0].getKey(), entryArray[0].getValue());
        }
        return ImmutableSortedMap.emptyMap(comparator);
    }

    private ImmutableSortedMap<K, V> getSubMap(int n2, int n3) {
        if (n2 == 0 && n3 == this.size()) {
            return this;
        }
        if (n2 == n3) {
            return ImmutableSortedMap.emptyMap(this.comparator());
        }
        return new ImmutableSortedMap<K, V>(this.keySet.getSubSet(n2, n3), this.valueList.subList(n2, n3));
    }

    public static <K extends Comparable<?>, V> Builder<K, V> naturalOrder() {
        return new Builder(Ordering.natural());
    }

    public static <K, V> ImmutableSortedMap<K, V> of() {
        return NATURAL_EMPTY_MAP;
    }

    public static <K extends Comparable<? super K>, V> ImmutableSortedMap<K, V> of(K k2, V v2) {
        return ImmutableSortedMap.of(Ordering.natural(), k2, v2);
    }

    public static <K extends Comparable<? super K>, V> ImmutableSortedMap<K, V> of(K k2, V v2, K k3, V v3) {
        return ImmutableSortedMap.ofEntries(new Map.Entry[]{ImmutableSortedMap.entryOf(k2, v2), ImmutableSortedMap.entryOf(k3, v3)});
    }

    public static <K extends Comparable<? super K>, V> ImmutableSortedMap<K, V> of(K k2, V v2, K k3, V v3, K k4, V v4) {
        return ImmutableSortedMap.ofEntries(new Map.Entry[]{ImmutableSortedMap.entryOf(k2, v2), ImmutableSortedMap.entryOf(k3, v3), ImmutableSortedMap.entryOf(k4, v4)});
    }

    public static <K extends Comparable<? super K>, V> ImmutableSortedMap<K, V> of(K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        return ImmutableSortedMap.ofEntries(new Map.Entry[]{ImmutableSortedMap.entryOf(k2, v2), ImmutableSortedMap.entryOf(k3, v3), ImmutableSortedMap.entryOf(k4, v4), ImmutableSortedMap.entryOf(k5, v5)});
    }

    public static <K extends Comparable<? super K>, V> ImmutableSortedMap<K, V> of(K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6) {
        return ImmutableSortedMap.ofEntries(new Map.Entry[]{ImmutableSortedMap.entryOf(k2, v2), ImmutableSortedMap.entryOf(k3, v3), ImmutableSortedMap.entryOf(k4, v4), ImmutableSortedMap.entryOf(k5, v5), ImmutableSortedMap.entryOf(k6, v6)});
    }

    private static <K, V> ImmutableSortedMap<K, V> of(Comparator<? super K> comparator, K k2, V v2) {
        return new ImmutableSortedMap<K, V>(new RegularImmutableSortedSet<K>(ImmutableList.of(k2), Preconditions.checkNotNull(comparator)), ImmutableList.of(v2));
    }

    private static <K extends Comparable<? super K>, V> ImmutableSortedMap<K, V> ofEntries(Map.Entry<K, V> ... entryArray) {
        return ImmutableSortedMap.fromEntries(Ordering.natural(), false, entryArray, entryArray.length);
    }

    public static <K, V> Builder<K, V> orderedBy(Comparator<K> comparator) {
        return new Builder(comparator);
    }

    public static <K extends Comparable<?>, V> Builder<K, V> reverseOrder() {
        return new Builder(Ordering.natural().reverse());
    }

    @Override
    public Map.Entry<K, V> ceilingEntry(K k2) {
        return ((ImmutableSortedMap)this.tailMap((Object)k2, true)).firstEntry();
    }

    @Override
    public K ceilingKey(K k2) {
        return Maps.keyOrNull(this.ceilingEntry(k2));
    }

    @Override
    public Comparator<? super K> comparator() {
        return ((ImmutableSortedSet)this.keySet()).comparator();
    }

    @Override
    ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        1EntrySet entrySet = this.isEmpty() ? ImmutableSet.of() : new 1EntrySet();
        return entrySet;
    }

    @Override
    ImmutableSet<K> createKeySet() {
        throw new AssertionError((Object)"should never be called");
    }

    @Override
    ImmutableCollection<V> createValues() {
        throw new AssertionError((Object)"should never be called");
    }

    @Override
    public ImmutableSortedSet<K> descendingKeySet() {
        return this.keySet.descendingSet();
    }

    @Override
    public ImmutableSortedMap<K, V> descendingMap() {
        ImmutableSortedMap<K, V> immutableSortedMap;
        ImmutableSortedMap<K, V> immutableSortedMap2 = immutableSortedMap = this.descendingMap;
        if (immutableSortedMap == null) {
            if (this.isEmpty()) {
                return ImmutableSortedMap.emptyMap(Ordering.from(this.comparator()).reverse());
            }
            immutableSortedMap2 = new ImmutableSortedMap<K, V>((RegularImmutableSortedSet)this.keySet.descendingSet(), this.valueList.reverse(), this);
        }
        return immutableSortedMap2;
    }

    @Override
    public ImmutableSet<Map.Entry<K, V>> entrySet() {
        return super.entrySet();
    }

    @Override
    public Map.Entry<K, V> firstEntry() {
        Map.Entry entry = this.isEmpty() ? null : (Map.Entry)((ImmutableSet)this.entrySet()).asList().get(0);
        return entry;
    }

    @Override
    public K firstKey() {
        return (K)((ImmutableSortedSet)this.keySet()).first();
    }

    @Override
    public Map.Entry<K, V> floorEntry(K k2) {
        return ((ImmutableSortedMap)this.headMap((Object)k2, true)).lastEntry();
    }

    @Override
    public K floorKey(K k2) {
        return Maps.keyOrNull(this.floorEntry(k2));
    }

    @Override
    public V get(@NullableDecl Object object) {
        int n2 = this.keySet.indexOf(object);
        object = n2 == -1 ? null : this.valueList.get(n2);
        return (V)object;
    }

    @Override
    public ImmutableSortedMap<K, V> headMap(K k2) {
        return this.headMap((Object)k2, false);
    }

    @Override
    public ImmutableSortedMap<K, V> headMap(K k2, boolean bl) {
        return this.getSubMap(0, this.keySet.headIndex(Preconditions.checkNotNull(k2), bl));
    }

    @Override
    public Map.Entry<K, V> higherEntry(K k2) {
        return ((ImmutableSortedMap)this.tailMap((Object)k2, false)).firstEntry();
    }

    @Override
    public K higherKey(K k2) {
        return Maps.keyOrNull(this.higherEntry(k2));
    }

    @Override
    boolean isPartialView() {
        boolean bl = this.keySet.isPartialView() || this.valueList.isPartialView();
        return bl;
    }

    @Override
    public ImmutableSortedSet<K> keySet() {
        return this.keySet;
    }

    @Override
    public Map.Entry<K, V> lastEntry() {
        Map.Entry entry = this.isEmpty() ? null : (Map.Entry)((ImmutableSet)this.entrySet()).asList().get(this.size() - 1);
        return entry;
    }

    @Override
    public K lastKey() {
        return (K)((ImmutableSortedSet)this.keySet()).last();
    }

    @Override
    public Map.Entry<K, V> lowerEntry(K k2) {
        return ((ImmutableSortedMap)this.headMap((Object)k2, false)).lastEntry();
    }

    @Override
    public K lowerKey(K k2) {
        return Maps.keyOrNull(this.lowerEntry(k2));
    }

    @Override
    public ImmutableSortedSet<K> navigableKeySet() {
        return this.keySet;
    }

    @Override
    @Deprecated
    public final Map.Entry<K, V> pollFirstEntry() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final Map.Entry<K, V> pollLastEntry() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.valueList.size();
    }

    @Override
    public ImmutableSortedMap<K, V> subMap(K k2, K k3) {
        return this.subMap((Object)k2, true, (Object)k3, false);
    }

    @Override
    public ImmutableSortedMap<K, V> subMap(K k2, boolean bl, K k3, boolean bl2) {
        Preconditions.checkNotNull(k2);
        Preconditions.checkNotNull(k3);
        boolean bl3 = this.comparator().compare(k2, k3) <= 0;
        Preconditions.checkArgument(bl3, "expected fromKey <= toKey but %s > %s", k2, k3);
        return ((ImmutableSortedMap)this.headMap((Object)k3, bl2)).tailMap((Object)k2, bl);
    }

    @Override
    public ImmutableSortedMap<K, V> tailMap(K k2) {
        return this.tailMap((Object)k2, true);
    }

    @Override
    public ImmutableSortedMap<K, V> tailMap(K k2, boolean bl) {
        return this.getSubMap(this.keySet.tailIndex(Preconditions.checkNotNull(k2), bl), this.size());
    }

    @Override
    public ImmutableCollection<V> values() {
        return this.valueList;
    }

    @Override
    Object writeReplace() {
        return new SerializedForm(this);
    }

    class 1EntrySet
    extends ImmutableMapEntrySet<K, V> {
        1EntrySet() {
        }

        @Override
        ImmutableList<Map.Entry<K, V>> createAsList() {
            return new ImmutableList<Map.Entry<K, V>>(){

                @Override
                public Map.Entry<K, V> get(int n2) {
                    return new AbstractMap.SimpleImmutableEntry(ImmutableSortedMap.this.keySet.asList().get(n2), ImmutableSortedMap.this.valueList.get(n2));
                }

                @Override
                boolean isPartialView() {
                    return true;
                }

                @Override
                public int size() {
                    return ImmutableSortedMap.this.size();
                }
            };
        }

        @Override
        public UnmodifiableIterator<Map.Entry<K, V>> iterator() {
            return this.asList().iterator();
        }

        @Override
        ImmutableMap<K, V> map() {
            return ImmutableSortedMap.this;
        }
    }

    public static class Builder<K, V>
    extends ImmutableMap.Builder<K, V> {
        private final Comparator<? super K> comparator;
        private transient Object[] keys;
        private transient Object[] values;

        public Builder(Comparator<? super K> comparator) {
            this(comparator, 4);
        }

        private Builder(Comparator<? super K> comparator, int n2) {
            this.comparator = Preconditions.checkNotNull(comparator);
            this.keys = new Object[n2];
            this.values = new Object[n2];
        }

        private void ensureCapacity(int n2) {
            Object[] objectArray = this.keys;
            if (n2 > objectArray.length) {
                n2 = ImmutableCollection.Builder.expandedCapacity(objectArray.length, n2);
                this.keys = Arrays.copyOf(this.keys, n2);
                this.values = Arrays.copyOf(this.values, n2);
            }
        }

        @Override
        public ImmutableSortedMap<K, V> build() {
            int n2 = this.size;
            if (n2 != 0) {
                if (n2 != 1) {
                    Object[] objectArray;
                    Object[] objectArray2 = objectArray = Arrays.copyOf(this.keys, this.size);
                    Arrays.sort(objectArray2, this.comparator);
                    Object object = new Object[this.size];
                    for (int i2 = 0; i2 < this.size; ++i2) {
                        Comparator<K> comparator;
                        if (i2 > 0 && (comparator = this.comparator).compare(objectArray[n2 = i2 - 1], objectArray[i2]) == 0) {
                            object = new StringBuilder();
                            ((StringBuilder)object).append("keys required to be distinct but compared as equal: ");
                            ((StringBuilder)object).append(objectArray[n2]);
                            ((StringBuilder)object).append(" and ");
                            ((StringBuilder)object).append(objectArray[i2]);
                            throw new IllegalArgumentException(((StringBuilder)object).toString());
                        }
                        object[Arrays.binarySearch(objectArray2, this.keys[i2], this.comparator)] = this.values[i2];
                    }
                    return new ImmutableSortedMap(new RegularImmutableSortedSet<K>(ImmutableList.asImmutableList(objectArray), this.comparator), ImmutableList.asImmutableList((Object[])object));
                }
                return ImmutableSortedMap.of(this.comparator, this.keys[0], this.values[0]);
            }
            return ImmutableSortedMap.emptyMap(this.comparator);
        }

        @Override
        @Deprecated
        public Builder<K, V> orderEntriesByValue(Comparator<? super V> comparator) {
            throw new UnsupportedOperationException("Not available on ImmutableSortedMap.Builder");
        }

        @Override
        public Builder<K, V> put(K k2, V v2) {
            this.ensureCapacity(this.size + 1);
            CollectPreconditions.checkEntryNotNull(k2, v2);
            this.keys[this.size] = k2;
            this.values[this.size] = v2;
            ++this.size;
            return this;
        }

        @Override
        public Builder<K, V> put(Map.Entry<? extends K, ? extends V> entry) {
            super.put(entry);
            return this;
        }

        @Override
        public Builder<K, V> putAll(Iterable<? extends Map.Entry<? extends K, ? extends V>> iterable) {
            super.putAll(iterable);
            return this;
        }

        @Override
        public Builder<K, V> putAll(Map<? extends K, ? extends V> map) {
            super.putAll(map);
            return this;
        }
    }

    private static class SerializedForm
    extends ImmutableMap.SerializedForm {
        private static final long serialVersionUID = 0L;
        private final Comparator<Object> comparator;

        SerializedForm(ImmutableSortedMap<?, ?> immutableSortedMap) {
            super(immutableSortedMap);
            this.comparator = immutableSortedMap.comparator();
        }

        @Override
        Object readResolve() {
            return this.createMap(new Builder<Object, Object>(this.comparator));
        }
    }
}

