/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.EmptyImmutableSetMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.Platform;
import com.google.common.collect.Serialization;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.UnmodifiableIterator;
import com.google.errorprone.annotations.concurrent.LazyInit;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.compatqual.MonotonicNonNullDecl;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public class ImmutableSetMultimap<K, V>
extends ImmutableMultimap<K, V>
implements SetMultimap<K, V> {
    private static final long serialVersionUID = 0L;
    private final transient ImmutableSet<V> emptySet;
    @MonotonicNonNullDecl
    private transient ImmutableSet<Map.Entry<K, V>> entries;
    @LazyInit
    @MonotonicNonNullDecl
    private transient ImmutableSetMultimap<V, K> inverse;

    ImmutableSetMultimap(ImmutableMap<K, ImmutableSet<V>> immutableMap, int n2, @NullableDecl Comparator<? super V> comparator) {
        super(immutableMap, n2);
        this.emptySet = ImmutableSetMultimap.emptySet(comparator);
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    public static <K, V> ImmutableSetMultimap<K, V> copyOf(Multimap<? extends K, ? extends V> multimap) {
        return ImmutableSetMultimap.copyOf(multimap, null);
    }

    private static <K, V> ImmutableSetMultimap<K, V> copyOf(Multimap<? extends K, ? extends V> multimap, Comparator<? super V> comparator) {
        ImmutableSetMultimap immutableSetMultimap;
        Preconditions.checkNotNull(multimap);
        if (multimap.isEmpty() && comparator == null) {
            return ImmutableSetMultimap.of();
        }
        if (multimap instanceof ImmutableSetMultimap && !(immutableSetMultimap = (ImmutableSetMultimap)multimap).isPartialView()) {
            return immutableSetMultimap;
        }
        return ImmutableSetMultimap.fromMapEntries(multimap.asMap().entrySet(), comparator);
    }

    public static <K, V> ImmutableSetMultimap<K, V> copyOf(Iterable<? extends Map.Entry<? extends K, ? extends V>> iterable) {
        return ((Builder)new Builder().putAll((Iterable)iterable)).build();
    }

    private static <V> ImmutableSet<V> emptySet(@NullableDecl Comparator<? super V> immutableSet) {
        immutableSet = immutableSet == null ? ImmutableSet.of() : ImmutableSortedSet.emptySet(immutableSet);
        return immutableSet;
    }

    static <K, V> ImmutableSetMultimap<K, V> fromMapEntries(Collection<? extends Map.Entry<? extends K, ? extends Collection<? extends V>>> collection, @NullableDecl Comparator<? super V> comparator) {
        if (collection.isEmpty()) {
            return ImmutableSetMultimap.of();
        }
        ImmutableMap.Builder<Collection<Map.Entry<K, Collection<V>>>, ImmutableSet<V>> builder = new ImmutableMap.Builder<Collection<Map.Entry<K, Collection<V>>>, ImmutableSet<V>>(collection.size());
        int n2 = 0;
        for (Map.Entry<K, Collection<V>> entry : collection) {
            collection = entry.getKey();
            ImmutableSet<V> object = ImmutableSetMultimap.valueSet(comparator, entry.getValue());
            if (object.isEmpty()) continue;
            builder.put(collection, object);
            n2 += object.size();
        }
        return new ImmutableSetMultimap(builder.build(), n2, comparator);
    }

    private ImmutableSetMultimap<V, K> invert() {
        Object object2;
        Builder<K, V> builder = ImmutableSetMultimap.builder();
        for (Object object2 : this.entries()) {
            builder.put(object2.getValue(), object2.getKey());
        }
        object2 = builder.build();
        ((ImmutableSetMultimap)object2).inverse = this;
        return object2;
    }

    public static <K, V> ImmutableSetMultimap<K, V> of() {
        return EmptyImmutableSetMultimap.INSTANCE;
    }

    public static <K, V> ImmutableSetMultimap<K, V> of(K k2, V v2) {
        Builder<K, V> builder = ImmutableSetMultimap.builder();
        builder.put((Object)k2, (Object)v2);
        return builder.build();
    }

    public static <K, V> ImmutableSetMultimap<K, V> of(K k2, V v2, K k3, V v3) {
        Builder<K, V> builder = ImmutableSetMultimap.builder();
        builder.put((Object)k2, (Object)v2);
        builder.put((Object)k3, (Object)v3);
        return builder.build();
    }

    public static <K, V> ImmutableSetMultimap<K, V> of(K k2, V v2, K k3, V v3, K k4, V v4) {
        Builder<K, V> builder = ImmutableSetMultimap.builder();
        builder.put((Object)k2, (Object)v2);
        builder.put((Object)k3, (Object)v3);
        builder.put((Object)k4, (Object)v4);
        return builder.build();
    }

    public static <K, V> ImmutableSetMultimap<K, V> of(K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        Builder<K, V> builder = ImmutableSetMultimap.builder();
        builder.put((Object)k2, (Object)v2);
        builder.put((Object)k3, (Object)v3);
        builder.put((Object)k4, (Object)v4);
        builder.put((Object)k5, (Object)v5);
        return builder.build();
    }

    public static <K, V> ImmutableSetMultimap<K, V> of(K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6) {
        Builder<K, V> builder = ImmutableSetMultimap.builder();
        builder.put((Object)k2, (Object)v2);
        builder.put((Object)k3, (Object)v3);
        builder.put((Object)k4, (Object)v4);
        builder.put((Object)k5, (Object)v5);
        builder.put((Object)k6, (Object)v6);
        return builder.build();
    }

    private void readObject(ObjectInputStream serializable) throws IOException, ClassNotFoundException {
        ((ObjectInputStream)((Object)serializable)).defaultReadObject();
        Comparator comparator = (Comparator)((ObjectInputStream)((Object)serializable)).readObject();
        int n2 = ((ObjectInputStream)((Object)serializable)).readInt();
        if (n2 >= 0) {
            ImmutableMap.Builder<Object, Object> builder = ImmutableMap.builder();
            int n3 = 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object = ((ObjectInputStream)((Object)serializable)).readObject();
                int n4 = ((ObjectInputStream)((Object)serializable)).readInt();
                if (n4 > 0) {
                    Object object2 = ImmutableSetMultimap.valuesBuilder(comparator);
                    for (int i3 = 0; i3 < n4; ++i3) {
                        ((ImmutableSet.Builder)object2).add(((ObjectInputStream)((Object)serializable)).readObject());
                    }
                    if (((AbstractCollection)(object2 = ((ImmutableSet.Builder)object2).build())).size() == n4) {
                        builder.put(object, object2);
                        n3 += n4;
                        continue;
                    }
                    serializable = new StringBuilder();
                    ((StringBuilder)serializable).append("Duplicate key-value pairs exist for key ");
                    ((StringBuilder)serializable).append(object);
                    throw new InvalidObjectException(((StringBuilder)serializable).toString());
                }
                serializable = new StringBuilder();
                ((StringBuilder)serializable).append("Invalid value count ");
                ((StringBuilder)serializable).append(n4);
                throw new InvalidObjectException(((StringBuilder)serializable).toString());
            }
            try {
                serializable = builder.build();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw (InvalidObjectException)new InvalidObjectException(illegalArgumentException.getMessage()).initCause(illegalArgumentException);
            }
            ImmutableMultimap.FieldSettersHolder.MAP_FIELD_SETTER.set((Object)this, serializable);
            ImmutableMultimap.FieldSettersHolder.SIZE_FIELD_SETTER.set((Object)this, n3);
            SetFieldSettersHolder.EMPTY_SET_FIELD_SETTER.set((Object)this, ImmutableSetMultimap.emptySet(comparator));
            return;
        }
        serializable = new StringBuilder();
        ((StringBuilder)serializable).append("Invalid key count ");
        ((StringBuilder)serializable).append(n2);
        serializable = new InvalidObjectException(((StringBuilder)serializable).toString());
        throw serializable;
    }

    private static <V> ImmutableSet<V> valueSet(@NullableDecl Comparator<? super V> immutableSet, Collection<? extends V> collection) {
        immutableSet = immutableSet == null ? ImmutableSet.copyOf(collection) : ImmutableSortedSet.copyOf(immutableSet, collection);
        return immutableSet;
    }

    private static <V> ImmutableSet.Builder<V> valuesBuilder(@NullableDecl Comparator<? super V> builder) {
        builder = builder == null ? new ImmutableSet.Builder() : new ImmutableSortedSet.Builder<V>(builder);
        return builder;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.valueComparator());
        Serialization.writeMultimap((Multimap)this, (ObjectOutputStream)objectOutputStream);
    }

    @Override
    public ImmutableSet<Map.Entry<K, V>> entries() {
        ImmutableSet<Map.Entry<K, V>> immutableSet;
        ImmutableSet<Map.Entry<K, V>> immutableSet2 = immutableSet = this.entries;
        if (immutableSet == null) {
            this.entries = immutableSet2 = new EntrySet(this);
        }
        return immutableSet2;
    }

    @Override
    public ImmutableSet<V> get(@NullableDecl K k2) {
        return MoreObjects.firstNonNull((ImmutableSet)this.map.get(k2), this.emptySet);
    }

    @Override
    public ImmutableSetMultimap<V, K> inverse() {
        ImmutableSetMultimap<K, V> immutableSetMultimap;
        ImmutableSetMultimap<K, V> immutableSetMultimap2 = immutableSetMultimap = this.inverse;
        if (immutableSetMultimap == null) {
            immutableSetMultimap2 = this.invert();
            this.inverse = immutableSetMultimap2;
        }
        return immutableSetMultimap2;
    }

    @Override
    @Deprecated
    public ImmutableSet<V> removeAll(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public ImmutableSet<V> replaceValues(K k2, Iterable<? extends V> iterable) {
        throw new UnsupportedOperationException();
    }

    @NullableDecl
    Comparator<? super V> valueComparator() {
        Object object = this.emptySet;
        object = object instanceof ImmutableSortedSet ? ((ImmutableSortedSet)object).comparator() : null;
        return object;
    }

    public static final class Builder<K, V>
    extends ImmutableMultimap.Builder<K, V> {
        @Override
        public ImmutableSetMultimap<K, V> build() {
            Set set;
            Collection collection = set = this.builderMap.entrySet();
            if (this.keyComparator != null) {
                collection = Ordering.from(this.keyComparator).onKeys().immutableSortedCopy(set);
            }
            return ImmutableSetMultimap.fromMapEntries(collection, this.valueComparator);
        }

        @Override
        Collection<V> newMutableValueCollection() {
            return Platform.preservesInsertionOrderOnAddsSet();
        }

        @Override
        public Builder<K, V> orderKeysBy(Comparator<? super K> comparator) {
            super.orderKeysBy(comparator);
            return this;
        }

        @Override
        public Builder<K, V> orderValuesBy(Comparator<? super V> comparator) {
            super.orderValuesBy(comparator);
            return this;
        }

        @Override
        public Builder<K, V> put(K k2, V v2) {
            super.put(k2, v2);
            return this;
        }

        @Override
        public Builder<K, V> put(Map.Entry<? extends K, ? extends V> entry) {
            super.put(entry);
            return this;
        }

        @Override
        public Builder<K, V> putAll(Multimap<? extends K, ? extends V> object2) {
            for (Map.Entry entry : object2.asMap().entrySet()) {
                this.putAll(entry.getKey(), (Iterable)entry.getValue());
            }
            return this;
        }

        @Override
        public Builder<K, V> putAll(Iterable<? extends Map.Entry<? extends K, ? extends V>> iterable) {
            super.putAll(iterable);
            return this;
        }

        @Override
        public Builder<K, V> putAll(K k2, Iterable<? extends V> iterable) {
            super.putAll(k2, iterable);
            return this;
        }

        @Override
        public Builder<K, V> putAll(K k2, V ... VArray) {
            return this.putAll((Object)k2, Arrays.asList(VArray));
        }
    }

    private static final class EntrySet<K, V>
    extends ImmutableSet<Map.Entry<K, V>> {
        private final transient ImmutableSetMultimap<K, V> multimap;

        EntrySet(ImmutableSetMultimap<K, V> immutableSetMultimap) {
            this.multimap = immutableSetMultimap;
        }

        @Override
        public boolean contains(@NullableDecl Object object) {
            if (object instanceof Map.Entry) {
                object = (Map.Entry)object;
                return this.multimap.containsEntry(object.getKey(), object.getValue());
            }
            return false;
        }

        @Override
        boolean isPartialView() {
            return false;
        }

        @Override
        public UnmodifiableIterator<Map.Entry<K, V>> iterator() {
            return this.multimap.entryIterator();
        }

        @Override
        public int size() {
            return this.multimap.size();
        }
    }

    private static final class SetFieldSettersHolder {
        static final Serialization.FieldSetter<ImmutableSetMultimap> EMPTY_SET_FIELD_SETTER = Serialization.getFieldSetter(ImmutableSetMultimap.class, (String)"emptySet");

        private SetFieldSettersHolder() {
        }
    }
}

