/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.Hashing;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.RegularImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.collect.SingletonImmutableSet;
import com.google.common.collect.UnmodifiableIterator;
import com.google.errorprone.annotations.concurrent.LazyInit;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public abstract class ImmutableSet<E>
extends ImmutableCollection<E>
implements Set<E> {
    private static final int CUTOFF = 0x2CCCCCCC;
    private static final double DESIRED_LOAD_FACTOR = 0.7;
    static final int MAX_TABLE_SIZE = 0x40000000;
    @LazyInit
    @NullableDecl
    private transient ImmutableList<E> asList;

    ImmutableSet() {
    }

    public static <E> Builder<E> builder() {
        return new Builder();
    }

    public static <E> Builder<E> builderWithExpectedSize(int n2) {
        CollectPreconditions.checkNonnegative((int)n2, (String)"expectedSize");
        return new Builder(n2);
    }

    static int chooseTableSize(int n2) {
        int n3 = Math.max(n2, 2);
        boolean bl = true;
        if (n3 < 0x2CCCCCCC) {
            n2 = Integer.highestOneBit(n3 - 1) << 1;
            while (true) {
                double d2 = n2;
                Double.isNaN(d2);
                if (!(d2 * 0.7 < (double)n3)) break;
                n2 <<= 1;
            }
            return n2;
        }
        if (n3 >= 0x40000000) {
            bl = false;
        }
        Preconditions.checkArgument(bl, "collection too large");
        return 0x40000000;
    }

    private static <E> ImmutableSet<E> construct(int n2, Object ... objectArray) {
        if (n2 != 0) {
            if (n2 != 1) {
                Object object;
                int n3 = ImmutableSet.chooseTableSize(n2);
                Object[] objectArray2 = new Object[n3];
                int n4 = n3 - 1;
                int n5 = 0;
                int n6 = 0;
                block0: for (int i2 = 0; i2 < n2; ++i2) {
                    Object object2 = ObjectArrays.checkElementNotNull(objectArray[i2], i2);
                    int n7 = object2.hashCode();
                    int n8 = Hashing.smear(n7);
                    while (true) {
                        int n9;
                        if ((object = objectArray2[n9 = n8 & n4]) == null) {
                            objectArray[n6] = object2;
                            objectArray2[n9] = object2;
                            n5 += n7;
                            ++n6;
                            continue block0;
                        }
                        if (object.equals(object2)) {
                            continue block0;
                        }
                        ++n8;
                    }
                }
                Arrays.fill(objectArray, n6, n2, null);
                if (n6 == 1) {
                    return new SingletonImmutableSet<Object>(objectArray[0], n5);
                }
                if (ImmutableSet.chooseTableSize(n6) < n3 / 2) {
                    return ImmutableSet.construct(n6, objectArray);
                }
                object = objectArray;
                if (ImmutableSet.shouldTrim(n6, objectArray.length)) {
                    object = Arrays.copyOf(objectArray, n6);
                }
                return new RegularImmutableSet((Object[])object, n5, objectArray2, n4, n6);
            }
            return ImmutableSet.of(objectArray[0]);
        }
        return ImmutableSet.of();
    }

    public static <E> ImmutableSet<E> copyOf(Iterable<? extends E> iterable) {
        iterable = iterable instanceof Collection ? ImmutableSet.copyOf((Collection)iterable) : ImmutableSet.copyOf(iterable.iterator());
        return iterable;
    }

    public static <E> ImmutableSet<E> copyOf(Collection<? extends E> objectArray) {
        ImmutableSet immutableSet;
        if (objectArray instanceof ImmutableSet && !(objectArray instanceof SortedSet) && !(immutableSet = (ImmutableSet)objectArray).isPartialView()) {
            return immutableSet;
        }
        objectArray = objectArray.toArray();
        return ImmutableSet.construct(objectArray.length, objectArray);
    }

    public static <E> ImmutableSet<E> copyOf(Iterator<? extends E> iterator2) {
        if (!iterator2.hasNext()) {
            return ImmutableSet.of();
        }
        E e2 = iterator2.next();
        if (!iterator2.hasNext()) {
            return ImmutableSet.of(e2);
        }
        return ((Builder)((Builder)new Builder().add((Object)e2)).addAll(iterator2)).build();
    }

    public static <E> ImmutableSet<E> copyOf(E[] EArray) {
        int n2 = EArray.length;
        if (n2 != 0) {
            if (n2 != 1) {
                return ImmutableSet.construct(EArray.length, (Object[])EArray.clone());
            }
            return ImmutableSet.of(EArray[0]);
        }
        return ImmutableSet.of();
    }

    public static <E> ImmutableSet<E> of() {
        return RegularImmutableSet.EMPTY;
    }

    public static <E> ImmutableSet<E> of(E e2) {
        return new SingletonImmutableSet<E>(e2);
    }

    public static <E> ImmutableSet<E> of(E e2, E e3) {
        return ImmutableSet.construct(2, e2, e3);
    }

    public static <E> ImmutableSet<E> of(E e2, E e3, E e4) {
        return ImmutableSet.construct(3, e2, e3, e4);
    }

    public static <E> ImmutableSet<E> of(E e2, E e3, E e4, E e5) {
        return ImmutableSet.construct(4, e2, e3, e4, e5);
    }

    public static <E> ImmutableSet<E> of(E e2, E e3, E e4, E e5, E e6) {
        return ImmutableSet.construct(5, e2, e3, e4, e5, e6);
    }

    @SafeVarargs
    public static <E> ImmutableSet<E> of(E e2, E e3, E e4, E e5, E e6, E e7, E ... EArray) {
        boolean bl = EArray.length <= 0x7FFFFFF9;
        Preconditions.checkArgument(bl, "the total number of elements must fit in an int");
        Object[] objectArray = new Object[EArray.length + 6];
        objectArray[0] = e2;
        objectArray[1] = e3;
        objectArray[2] = e4;
        objectArray[3] = e5;
        objectArray[4] = e6;
        objectArray[5] = e7;
        System.arraycopy(EArray, 0, objectArray, 6, EArray.length);
        return ImmutableSet.construct(objectArray.length, objectArray);
    }

    private static boolean shouldTrim(int n2, int n3) {
        boolean bl = n2 < (n3 >> 1) + (n3 >> 2);
        return bl;
    }

    @Override
    public ImmutableList<E> asList() {
        ImmutableList<E> immutableList;
        ImmutableList<E> immutableList2 = immutableList = this.asList;
        if (immutableList == null) {
            this.asList = immutableList2 = this.createAsList();
        }
        return immutableList2;
    }

    ImmutableList<E> createAsList() {
        return ImmutableList.asImmutableList(this.toArray());
    }

    @Override
    public boolean equals(@NullableDecl Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ImmutableSet && this.isHashCodeFast() && ((ImmutableSet)object).isHashCodeFast() && this.hashCode() != object.hashCode()) {
            return false;
        }
        return Sets.equalsImpl(this, object);
    }

    @Override
    public int hashCode() {
        return Sets.hashCodeImpl(this);
    }

    boolean isHashCodeFast() {
        return false;
    }

    @Override
    public abstract UnmodifiableIterator<E> iterator();

    @Override
    Object writeReplace() {
        return new SerializedForm(this.toArray());
    }

    public static class Builder<E>
    extends ImmutableCollection.ArrayBasedBuilder<E> {
        private int hashCode;
        @NullableDecl
        Object[] hashTable;

        public Builder() {
            super(4);
        }

        Builder(int n2) {
            super(n2);
            this.hashTable = new Object[ImmutableSet.chooseTableSize(n2)];
        }

        private void addDeduping(E e2) {
            int n2 = this.hashTable.length;
            int n3 = e2.hashCode();
            int n4 = Hashing.smear(n3);
            while (true) {
                Object[] objectArray;
                Object object;
                if ((object = (objectArray = this.hashTable)[n4 &= n2 - 1]) == null) {
                    objectArray[n4] = e2;
                    this.hashCode += n3;
                    super.add((Object)e2);
                    return;
                }
                if (object.equals(e2)) {
                    return;
                }
                ++n4;
            }
        }

        @Override
        public Builder<E> add(E e2) {
            Preconditions.checkNotNull(e2);
            if (this.hashTable != null && ImmutableSet.chooseTableSize(this.size) <= this.hashTable.length) {
                this.addDeduping(e2);
                return this;
            }
            this.hashTable = null;
            super.add((Object)e2);
            return this;
        }

        @Override
        public Builder<E> add(E ... EArray) {
            if (this.hashTable != null) {
                int n2 = EArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    this.add((Object)EArray[i2]);
                }
            } else {
                super.add(EArray);
            }
            return this;
        }

        @Override
        public Builder<E> addAll(Iterable<? extends E> object) {
            Preconditions.checkNotNull(object);
            if (this.hashTable != null) {
                object = object.iterator();
                while (object.hasNext()) {
                    this.add(object.next());
                }
            } else {
                super.addAll(object);
            }
            return this;
        }

        @Override
        public Builder<E> addAll(Iterator<? extends E> iterator2) {
            Preconditions.checkNotNull(iterator2);
            while (iterator2.hasNext()) {
                this.add((Object)iterator2.next());
            }
            return this;
        }

        @Override
        public ImmutableSet<E> build() {
            int n2 = this.size;
            if (n2 != 0) {
                if (n2 != 1) {
                    Object object;
                    if (this.hashTable != null && ImmutableSet.chooseTableSize(this.size) == this.hashTable.length) {
                        object = ImmutableSet.shouldTrim(this.size, this.contents.length) ? Arrays.copyOf(this.contents, this.size) : this.contents;
                        n2 = this.hashCode;
                        Object[] objectArray = this.hashTable;
                        object = new RegularImmutableSet((Object[])object, n2, objectArray, objectArray.length - 1, this.size);
                    } else {
                        object = ImmutableSet.construct(this.size, this.contents);
                        this.size = object.size();
                    }
                    this.forceCopy = true;
                    this.hashTable = null;
                    return object;
                }
                return ImmutableSet.of(this.contents[0]);
            }
            return ImmutableSet.of();
        }
    }

    private static class SerializedForm
    implements Serializable {
        private static final long serialVersionUID = 0L;
        final Object[] elements;

        SerializedForm(Object[] objectArray) {
            this.elements = objectArray;
        }

        Object readResolve() {
            return ImmutableSet.copyOf(this.elements);
        }
    }
}

