/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.Cut;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.RegularImmutableSortedSet;
import com.google.common.collect.SortedLists;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public class ImmutableRangeMap<K extends Comparable<?>, V>
implements RangeMap<K, V>,
Serializable {
    private static final ImmutableRangeMap<Comparable<?>, Object> EMPTY = new ImmutableRangeMap(ImmutableList.of(), ImmutableList.of());
    private static final long serialVersionUID = 0L;
    private final transient ImmutableList<Range<K>> ranges;
    private final transient ImmutableList<V> values;

    ImmutableRangeMap(ImmutableList<Range<K>> immutableList, ImmutableList<V> immutableList2) {
        this.ranges = immutableList;
        this.values = immutableList2;
    }

    public static <K extends Comparable<?>, V> Builder<K, V> builder() {
        return new Builder();
    }

    public static <K extends Comparable<?>, V> ImmutableRangeMap<K, V> copyOf(RangeMap<K, ? extends V> object) {
        if (object instanceof ImmutableRangeMap) {
            return (ImmutableRangeMap)((Object)object);
        }
        Map object22 = object.asMapOfRanges();
        object = new ImmutableList.Builder(object22.size());
        ImmutableList.Builder builder = new ImmutableList.Builder(object22.size());
        for (Map.Entry entry : object22.entrySet()) {
            object.add(entry.getKey());
            builder.add(entry.getValue());
        }
        return new ImmutableRangeMap<K, V>(object.build(), builder.build());
    }

    public static <K extends Comparable<?>, V> ImmutableRangeMap<K, V> of() {
        return EMPTY;
    }

    public static <K extends Comparable<?>, V> ImmutableRangeMap<K, V> of(Range<K> range, V v2) {
        return new ImmutableRangeMap<K, V>(ImmutableList.of(range), ImmutableList.of(v2));
    }

    @Override
    public ImmutableMap<Range<K>, V> asDescendingMapOfRanges() {
        if (this.ranges.isEmpty()) {
            return ImmutableMap.of();
        }
        return new ImmutableSortedMap<Range<K>, V>(new RegularImmutableSortedSet<Range<K>>(this.ranges.reverse(), Range.rangeLexOrdering().reverse()), this.values.reverse());
    }

    @Override
    public ImmutableMap<Range<K>, V> asMapOfRanges() {
        if (this.ranges.isEmpty()) {
            return ImmutableMap.of();
        }
        return new ImmutableSortedMap(new RegularImmutableSortedSet(this.ranges, Range.rangeLexOrdering()), this.values);
    }

    @Override
    @Deprecated
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(@NullableDecl Object object) {
        if (object instanceof RangeMap) {
            object = (RangeMap)object;
            return ((ImmutableMap)this.asMapOfRanges()).equals(object.asMapOfRanges());
        }
        return false;
    }

    @Override
    @NullableDecl
    public V get(K k2) {
        int n2 = SortedLists.binarySearch(this.ranges, Range.lowerBoundFn(), Cut.belowValue(k2), SortedLists.KeyPresentBehavior.ANY_PRESENT, SortedLists.KeyAbsentBehavior.NEXT_LOWER);
        V v2 = null;
        if (n2 == -1) {
            return null;
        }
        if (((Range)this.ranges.get(n2)).contains(k2)) {
            v2 = (V)this.values.get(n2);
        }
        return v2;
    }

    @Override
    @NullableDecl
    public Map.Entry<Range<K>, V> getEntry(K k2) {
        int n2 = SortedLists.binarySearch(this.ranges, Range.lowerBoundFn(), Cut.belowValue(k2), SortedLists.KeyPresentBehavior.ANY_PRESENT, SortedLists.KeyAbsentBehavior.NEXT_LOWER);
        Map.Entry entry = null;
        if (n2 == -1) {
            return null;
        }
        Range range = (Range)this.ranges.get(n2);
        if (range.contains(k2)) {
            entry = Maps.immutableEntry(range, this.values.get(n2));
        }
        return entry;
    }

    @Override
    public int hashCode() {
        return ((ImmutableMap)this.asMapOfRanges()).hashCode();
    }

    @Override
    @Deprecated
    public void put(Range<K> range, V v2) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void putAll(RangeMap<K, V> rangeMap) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void putCoalescing(Range<K> range, V v2) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void remove(Range<K> range) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Range<K> span() {
        if (!this.ranges.isEmpty()) {
            Range range = (Range)this.ranges.get(0);
            Serializable serializable = this.ranges;
            serializable = (Range)serializable.get(serializable.size() - 1);
            return Range.create(range.lowerBound, ((Range)serializable).upperBound);
        }
        throw new NoSuchElementException();
    }

    @Override
    public ImmutableRangeMap<K, V> subRangeMap(final Range<K> range) {
        if (Preconditions.checkNotNull(range).isEmpty()) {
            return ImmutableRangeMap.of();
        }
        if (!this.ranges.isEmpty() && !range.encloses(this.span())) {
            int n2;
            int n3 = SortedLists.binarySearch(this.ranges, Range.upperBoundFn(), range.lowerBound, SortedLists.KeyPresentBehavior.FIRST_AFTER, SortedLists.KeyAbsentBehavior.NEXT_HIGHER);
            if (n3 >= (n2 = SortedLists.binarySearch(this.ranges, Range.lowerBoundFn(), range.upperBound, SortedLists.KeyPresentBehavior.ANY_PRESENT, SortedLists.KeyAbsentBehavior.NEXT_HIGHER))) {
                return ImmutableRangeMap.of();
            }
            return new ImmutableRangeMap<K, V>(new ImmutableList<Range<K>>(n2 - n3, n3, range){
                final /* synthetic */ int val$len;
                final /* synthetic */ int val$off;
                final /* synthetic */ Range val$range;
                {
                    this.val$len = n2;
                    this.val$off = n3;
                    this.val$range = range;
                }

                @Override
                public Range<K> get(int n2) {
                    Preconditions.checkElementIndex(n2, this.val$len);
                    if (n2 != 0 && n2 != this.val$len - 1) {
                        return (Range)ImmutableRangeMap.this.ranges.get(n2 + this.val$off);
                    }
                    return ((Range)ImmutableRangeMap.this.ranges.get(n2 + this.val$off)).intersection(this.val$range);
                }

                @Override
                boolean isPartialView() {
                    return true;
                }

                @Override
                public int size() {
                    return this.val$len;
                }
            }, (ImmutableList)this.values.subList(n3, n2)){

                @Override
                public ImmutableRangeMap<K, V> subRangeMap(Range<K> range2) {
                    if (range.isConnected(range2)) {
                        return this.subRangeMap(range2.intersection(range));
                    }
                    return ImmutableRangeMap.of();
                }
            };
        }
        return this;
    }

    @Override
    public String toString() {
        return ((ImmutableMap)this.asMapOfRanges()).toString();
    }

    Object writeReplace() {
        return new SerializedForm(this.asMapOfRanges());
    }

    public static final class Builder<K extends Comparable<?>, V> {
        private final List<Map.Entry<Range<K>, V>> entries = Lists.newArrayList();

        public ImmutableRangeMap<K, V> build() {
            Collections.sort(this.entries, Range.rangeLexOrdering().onKeys());
            Object object = new ImmutableList.Builder(this.entries.size());
            ImmutableList.Builder builder = new ImmutableList.Builder(this.entries.size());
            for (int i2 = 0; i2 < this.entries.size(); ++i2) {
                Range<K> range;
                Range<K> range2 = this.entries.get(i2).getKey();
                if (i2 > 0 && range2.isConnected(range = this.entries.get(i2 - 1).getKey()) && !range2.intersection(range).isEmpty()) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Overlapping ranges: range ");
                    ((StringBuilder)object).append(range);
                    ((StringBuilder)object).append(" overlaps with entry ");
                    ((StringBuilder)object).append(range2);
                    throw new IllegalArgumentException(((StringBuilder)object).toString());
                }
                ((ImmutableList.Builder)object).add(range2);
                builder.add(this.entries.get(i2).getValue());
            }
            return new ImmutableRangeMap(((ImmutableList.Builder)object).build(), builder.build());
        }

        public Builder<K, V> put(Range<K> range, V v2) {
            Preconditions.checkNotNull(range);
            Preconditions.checkNotNull(v2);
            Preconditions.checkArgument(range.isEmpty() ^ true, "Range must not be empty, but was %s", range);
            this.entries.add(Maps.immutableEntry(range, v2));
            return this;
        }

        public Builder<K, V> putAll(RangeMap<K, ? extends V> object) {
            for (Map.Entry entry : object.asMapOfRanges().entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
            return this;
        }
    }

    private static class SerializedForm<K extends Comparable<?>, V>
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private final ImmutableMap<Range<K>, V> mapOfRanges;

        SerializedForm(ImmutableMap<Range<K>, V> immutableMap) {
            this.mapOfRanges = immutableMap;
        }

        Object createRangeMap() {
            Builder builder = new Builder();
            for (Map.Entry entry : this.mapOfRanges.entrySet()) {
                builder.put((Range)entry.getKey(), entry.getValue());
            }
            return builder.build();
        }

        Object readResolve() {
            if (this.mapOfRanges.isEmpty()) {
                return ImmutableRangeMap.of();
            }
            return this.createRangeMap();
        }
    }
}

