/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractMapBasedMultiset;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultisetGwtSerializationDependencies;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.IndexedImmutableSet;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.ObjectCountHashMap;
import com.google.common.collect.ObjectCountLinkedHashMap;
import com.google.common.collect.RegularImmutableMultiset;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.google.errorprone.annotations.concurrent.LazyInit;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.checkerframework.checker.nullness.compatqual.MonotonicNonNullDecl;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public abstract class ImmutableMultiset<E>
extends ImmutableMultisetGwtSerializationDependencies<E>
implements Multiset<E> {
    @LazyInit
    private transient ImmutableList<E> asList;
    @LazyInit
    private transient ImmutableSet<Multiset.Entry<E>> entrySet;

    ImmutableMultiset() {
    }

    public static <E> Builder<E> builder() {
        return new Builder();
    }

    private static <E> ImmutableMultiset<E> copyFromElements(E ... EArray) {
        return ((Builder)new Builder().add((Object[])EArray)).build();
    }

    static <E> ImmutableMultiset<E> copyFromEntries(Collection<? extends Multiset.Entry<? extends E>> object) {
        Builder builder = new Builder(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            Multiset.Entry entry = (Multiset.Entry)object.next();
            builder.addCopies(entry.getElement(), entry.getCount());
        }
        return builder.build();
    }

    public static <E> ImmutableMultiset<E> copyOf(Iterable<? extends E> iterable) {
        Object object;
        if (iterable instanceof ImmutableMultiset && !((ImmutableCollection)(object = (ImmutableMultiset)iterable)).isPartialView()) {
            return object;
        }
        object = new Builder(Multisets.inferDistinctElements(iterable));
        ((Builder)object).addAll((Iterable)iterable);
        return ((Builder)object).build();
    }

    public static <E> ImmutableMultiset<E> copyOf(Iterator<? extends E> iterator2) {
        return ((Builder)new Builder().addAll((Iterator)iterator2)).build();
    }

    public static <E> ImmutableMultiset<E> copyOf(E[] EArray) {
        return ImmutableMultiset.copyFromElements(EArray);
    }

    private ImmutableSet<Multiset.Entry<E>> createEntrySet() {
        EntrySet entrySet = this.isEmpty() ? ImmutableSet.of() : new EntrySet();
        return entrySet;
    }

    public static <E> ImmutableMultiset<E> of() {
        return RegularImmutableMultiset.EMPTY;
    }

    public static <E> ImmutableMultiset<E> of(E e2) {
        return ImmutableMultiset.copyFromElements(e2);
    }

    public static <E> ImmutableMultiset<E> of(E e2, E e3) {
        return ImmutableMultiset.copyFromElements(e2, e3);
    }

    public static <E> ImmutableMultiset<E> of(E e2, E e3, E e4) {
        return ImmutableMultiset.copyFromElements(e2, e3, e4);
    }

    public static <E> ImmutableMultiset<E> of(E e2, E e3, E e4, E e5) {
        return ImmutableMultiset.copyFromElements(e2, e3, e4, e5);
    }

    public static <E> ImmutableMultiset<E> of(E e2, E e3, E e4, E e5, E e6) {
        return ImmutableMultiset.copyFromElements(e2, e3, e4, e5, e6);
    }

    public static <E> ImmutableMultiset<E> of(E e2, E e3, E e4, E e5, E e6, E e7, E ... EArray) {
        return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)new Builder().add((Object)e2)).add((Object)e3)).add((Object)e4)).add((Object)e5)).add((Object)e6)).add((Object)e7)).add((Object[])EArray)).build();
    }

    @Override
    @Deprecated
    public final int add(E e2, int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ImmutableList<E> asList() {
        ImmutableList<E> immutableList;
        ImmutableList<E> immutableList2 = immutableList = this.asList;
        if (immutableList == null) {
            this.asList = immutableList2 = super.asList();
        }
        return immutableList2;
    }

    @Override
    public boolean contains(@NullableDecl Object object) {
        boolean bl = this.count(object) > 0;
        return bl;
    }

    @Override
    int copyIntoArray(Object[] objectArray, int n2) {
        for (Multiset.Entry entry : this.entrySet()) {
            Arrays.fill(objectArray, n2, entry.getCount() + n2, entry.getElement());
            n2 += entry.getCount();
        }
        return n2;
    }

    @Override
    public abstract ImmutableSet<E> elementSet();

    @Override
    public ImmutableSet<Multiset.Entry<E>> entrySet() {
        ImmutableSet<Multiset.Entry<Multiset.Entry<Multiset.Entry<Multiset.Entry<E>>>>> immutableSet;
        ImmutableSet<Multiset.Entry<Multiset.Entry<Multiset.Entry<Multiset.Entry<E>>>>> immutableSet2 = immutableSet = this.entrySet;
        if (immutableSet == null) {
            immutableSet2 = this.createEntrySet();
            this.entrySet = immutableSet2;
        }
        return immutableSet2;
    }

    @Override
    public boolean equals(@NullableDecl Object object) {
        return Multisets.equalsImpl(this, object);
    }

    abstract Multiset.Entry<E> getEntry(int var1);

    @Override
    public int hashCode() {
        return Sets.hashCodeImpl(this.entrySet());
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        return new UnmodifiableIterator<E>(((ImmutableSet)this.entrySet()).iterator()){
            @MonotonicNonNullDecl
            E element;
            int remaining;
            final /* synthetic */ Iterator val$entryIterator;
            {
                this.val$entryIterator = iterator2;
            }

            @Override
            public boolean hasNext() {
                boolean bl = this.remaining > 0 || this.val$entryIterator.hasNext();
                return bl;
            }

            @Override
            public E next() {
                if (this.remaining <= 0) {
                    Multiset.Entry entry = (Multiset.Entry)this.val$entryIterator.next();
                    this.element = entry.getElement();
                    this.remaining = entry.getCount();
                }
                --this.remaining;
                return this.element;
            }
        };
    }

    @Override
    @Deprecated
    public final int remove(Object object, int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final int setCount(E e2, int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final boolean setCount(E e2, int n2, int n3) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return ((AbstractCollection)((Object)this.entrySet())).toString();
    }

    @Override
    abstract Object writeReplace();

    public static class Builder<E>
    extends ImmutableCollection.Builder<E> {
        boolean buildInvoked = false;
        ObjectCountHashMap<E> contents;
        boolean isLinkedHash = false;

        public Builder() {
            this(4);
        }

        Builder(int n2) {
            this.contents = ObjectCountHashMap.createWithExpectedSize(n2);
        }

        Builder(boolean bl) {
            this.contents = null;
        }

        @NullableDecl
        static <T> ObjectCountHashMap<T> tryGetMap(Iterable<T> iterable) {
            if (iterable instanceof RegularImmutableMultiset) {
                return ((RegularImmutableMultiset)iterable).contents;
            }
            if (iterable instanceof AbstractMapBasedMultiset) {
                return ((AbstractMapBasedMultiset)iterable).backingMap;
            }
            return null;
        }

        @Override
        public Builder<E> add(E e2) {
            return this.addCopies(e2, 1);
        }

        @Override
        public Builder<E> add(E ... EArray) {
            super.add(EArray);
            return this;
        }

        @Override
        public Builder<E> addAll(Iterable<? extends E> entry2) {
            if (entry2 instanceof Multiset) {
                Object object = Builder.tryGetMap(entry2 = Multisets.cast(entry2));
                if (object != null) {
                    entry2 = this.contents;
                    ((ObjectCountHashMap)((Object)entry2)).ensureCapacity(Math.max(((ObjectCountHashMap)((Object)entry2)).size(), ((ObjectCountHashMap)object).size()));
                    int n2 = ((ObjectCountHashMap)object).firstIndex();
                    while (n2 >= 0) {
                        this.addCopies(((ObjectCountHashMap)object).getKey(n2), ((ObjectCountHashMap)object).getValue(n2));
                        n2 = ((ObjectCountHashMap)object).nextIndex(n2);
                    }
                } else {
                    object = entry2.entrySet();
                    ObjectCountHashMap<E> objectCountHashMap = this.contents;
                    objectCountHashMap.ensureCapacity(Math.max(objectCountHashMap.size(), object.size()));
                    for (Multiset.Entry entry2 : entry2.entrySet()) {
                        this.addCopies(entry2.getElement(), entry2.getCount());
                    }
                }
            } else {
                super.addAll(entry2);
            }
            return this;
        }

        @Override
        public Builder<E> addAll(Iterator<? extends E> iterator2) {
            super.addAll(iterator2);
            return this;
        }

        public Builder<E> addCopies(E e2, int n2) {
            if (n2 == 0) {
                return this;
            }
            if (this.buildInvoked) {
                this.contents = new ObjectCountHashMap<E>(this.contents);
                this.isLinkedHash = false;
            }
            this.buildInvoked = false;
            Preconditions.checkNotNull(e2);
            ObjectCountHashMap<E> objectCountHashMap = this.contents;
            objectCountHashMap.put(e2, n2 + objectCountHashMap.get(e2));
            return this;
        }

        @Override
        public ImmutableMultiset<E> build() {
            if (this.contents.size() == 0) {
                return ImmutableMultiset.of();
            }
            if (this.isLinkedHash) {
                this.contents = new ObjectCountHashMap<E>(this.contents);
                this.isLinkedHash = false;
            }
            this.buildInvoked = true;
            return new RegularImmutableMultiset<E>(this.contents);
        }

        public Builder<E> setCount(E e2, int n2) {
            if (n2 == 0 && !this.isLinkedHash) {
                this.contents = new ObjectCountLinkedHashMap(this.contents);
                this.isLinkedHash = true;
            } else if (this.buildInvoked) {
                this.contents = new ObjectCountHashMap<E>(this.contents);
                this.isLinkedHash = false;
            }
            this.buildInvoked = false;
            Preconditions.checkNotNull(e2);
            if (n2 == 0) {
                this.contents.remove(e2);
            } else {
                this.contents.put(Preconditions.checkNotNull(e2), n2);
            }
            return this;
        }
    }

    private final class EntrySet
    extends IndexedImmutableSet<Multiset.Entry<E>> {
        private static final long serialVersionUID = 0L;

        private EntrySet() {
        }

        @Override
        public boolean contains(Object object) {
            boolean bl;
            boolean bl2 = object instanceof Multiset.Entry;
            boolean bl3 = bl = false;
            if (bl2) {
                if ((object = (Multiset.Entry)object).getCount() <= 0) {
                    return false;
                }
                bl3 = bl;
                if (ImmutableMultiset.this.count(object.getElement()) == object.getCount()) {
                    bl3 = true;
                }
            }
            return bl3;
        }

        @Override
        Multiset.Entry<E> get(int n2) {
            return ImmutableMultiset.this.getEntry(n2);
        }

        @Override
        public int hashCode() {
            return ImmutableMultiset.this.hashCode();
        }

        @Override
        boolean isPartialView() {
            return ImmutableMultiset.this.isPartialView();
        }

        @Override
        public int size() {
            return ((AbstractCollection)((Object)ImmutableMultiset.this.elementSet())).size();
        }

        @Override
        Object writeReplace() {
            return new EntrySetSerializedForm(ImmutableMultiset.this);
        }
    }

    static class EntrySetSerializedForm<E>
    implements Serializable {
        final ImmutableMultiset<E> multiset;

        EntrySetSerializedForm(ImmutableMultiset<E> immutableMultiset) {
            this.multiset = immutableMultiset;
        }

        Object readResolve() {
            return this.multiset.entrySet();
        }
    }
}

