/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.BaseImmutableMultimap;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.Ordering;
import com.google.common.collect.Platform;
import com.google.common.collect.Serialization;
import com.google.common.collect.UnmodifiableIterator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.compatqual.MonotonicNonNullDecl;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public abstract class ImmutableMultimap<K, V>
extends BaseImmutableMultimap<K, V>
implements Serializable {
    private static final long serialVersionUID = 0L;
    final transient ImmutableMap<K, ? extends ImmutableCollection<V>> map;
    final transient int size;

    ImmutableMultimap(ImmutableMap<K, ? extends ImmutableCollection<V>> immutableMap, int n2) {
        this.map = immutableMap;
        this.size = n2;
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    public static <K, V> ImmutableMultimap<K, V> copyOf(Multimap<? extends K, ? extends V> multimap) {
        ImmutableMultimap immutableMultimap;
        if (multimap instanceof ImmutableMultimap && !(immutableMultimap = (ImmutableMultimap)multimap).isPartialView()) {
            return immutableMultimap;
        }
        return ImmutableListMultimap.copyOf(multimap);
    }

    public static <K, V> ImmutableMultimap<K, V> copyOf(Iterable<? extends Map.Entry<? extends K, ? extends V>> iterable) {
        return ImmutableListMultimap.copyOf(iterable);
    }

    public static <K, V> ImmutableMultimap<K, V> of() {
        return ImmutableListMultimap.of();
    }

    public static <K, V> ImmutableMultimap<K, V> of(K k2, V v2) {
        return ImmutableListMultimap.of(k2, v2);
    }

    public static <K, V> ImmutableMultimap<K, V> of(K k2, V v2, K k3, V v3) {
        return ImmutableListMultimap.of(k2, v2, k3, v3);
    }

    public static <K, V> ImmutableMultimap<K, V> of(K k2, V v2, K k3, V v3, K k4, V v4) {
        return ImmutableListMultimap.of(k2, v2, k3, v3, k4, v4);
    }

    public static <K, V> ImmutableMultimap<K, V> of(K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        return ImmutableListMultimap.of(k2, v2, k3, v3, k4, v4, k5, v5);
    }

    public static <K, V> ImmutableMultimap<K, V> of(K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6) {
        return ImmutableListMultimap.of(k2, v2, k3, v3, k4, v4, k5, v5, k6, v6);
    }

    @Override
    public ImmutableMap<K, Collection<V>> asMap() {
        return this.map;
    }

    @Override
    @Deprecated
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(@NullableDecl Object object) {
        return this.map.containsKey(object);
    }

    @Override
    public boolean containsValue(@NullableDecl Object object) {
        boolean bl = object != null && super.containsValue(object);
        return bl;
    }

    @Override
    Map<K, Collection<V>> createAsMap() {
        throw new AssertionError((Object)"should never be called");
    }

    @Override
    ImmutableCollection<Map.Entry<K, V>> createEntries() {
        return new EntryCollection(this);
    }

    @Override
    Set<K> createKeySet() {
        throw new AssertionError((Object)"unreachable");
    }

    @Override
    ImmutableMultiset<K> createKeys() {
        return new Keys();
    }

    @Override
    ImmutableCollection<V> createValues() {
        return new Values(this);
    }

    @Override
    public ImmutableCollection<Map.Entry<K, V>> entries() {
        return (ImmutableCollection)super.entries();
    }

    @Override
    UnmodifiableIterator<Map.Entry<K, V>> entryIterator() {
        return new UnmodifiableIterator<Map.Entry<K, V>>(){
            final Iterator<? extends Map.Entry<K, ? extends ImmutableCollection<V>>> asMapItr;
            K currentKey;
            Iterator<V> valueItr;
            {
                this.asMapItr = ((ImmutableSet)ImmutableMultimap.this.map.entrySet()).iterator();
                this.currentKey = null;
                this.valueItr = Iterators.emptyIterator();
            }

            @Override
            public boolean hasNext() {
                boolean bl = this.valueItr.hasNext() || this.asMapItr.hasNext();
                return bl;
            }

            @Override
            public Map.Entry<K, V> next() {
                if (!this.valueItr.hasNext()) {
                    Map.Entry entry = this.asMapItr.next();
                    this.currentKey = entry.getKey();
                    this.valueItr = entry.getValue().iterator();
                }
                return Maps.immutableEntry(this.currentKey, this.valueItr.next());
            }
        };
    }

    @Override
    public abstract ImmutableCollection<V> get(K var1);

    public abstract ImmutableMultimap<V, K> inverse();

    boolean isPartialView() {
        return this.map.isPartialView();
    }

    @Override
    public ImmutableSet<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public ImmutableMultiset<K> keys() {
        return (ImmutableMultiset)super.keys();
    }

    @Override
    @Deprecated
    public boolean put(K k2, V v2) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean putAll(Multimap<? extends K, ? extends V> multimap) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean putAll(K k2, Iterable<? extends V> iterable) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean remove(Object object, Object object2) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public ImmutableCollection<V> removeAll(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public ImmutableCollection<V> replaceValues(K k2, Iterable<? extends V> iterable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    UnmodifiableIterator<V> valueIterator() {
        return new UnmodifiableIterator<V>(){
            Iterator<? extends ImmutableCollection<V>> valueCollectionItr;
            Iterator<V> valueItr;
            {
                this.valueCollectionItr = ((ImmutableCollection)ImmutableMultimap.this.map.values()).iterator();
                this.valueItr = Iterators.emptyIterator();
            }

            @Override
            public boolean hasNext() {
                boolean bl = this.valueItr.hasNext() || this.valueCollectionItr.hasNext();
                return bl;
            }

            @Override
            public V next() {
                if (!this.valueItr.hasNext()) {
                    this.valueItr = this.valueCollectionItr.next().iterator();
                }
                return this.valueItr.next();
            }
        };
    }

    @Override
    public ImmutableCollection<V> values() {
        return (ImmutableCollection)super.values();
    }

    public static class Builder<K, V> {
        Map<K, Collection<V>> builderMap = Platform.preservesInsertionOrderOnPutsMap();
        @MonotonicNonNullDecl
        Comparator<? super K> keyComparator;
        @MonotonicNonNullDecl
        Comparator<? super V> valueComparator;

        public ImmutableMultimap<K, V> build() {
            Set<Map.Entry<K, Collection<V>>> set = this.builderMap.entrySet();
            Comparator<? super K> comparator = this.keyComparator;
            Collection<Map.Entry<K, Collection<V>>> collection = set;
            if (comparator != null) {
                collection = Ordering.from(comparator).onKeys().immutableSortedCopy(set);
            }
            return ImmutableListMultimap.fromMapEntries(collection, this.valueComparator);
        }

        Builder<K, V> combine(Builder<K, V> object2) {
            for (Map.Entry<K, Collection<V>> entry : ((Builder)object2).builderMap.entrySet()) {
                this.putAll(entry.getKey(), (Iterable)entry.getValue());
            }
            return this;
        }

        Collection<V> newMutableValueCollection() {
            return new ArrayList();
        }

        public Builder<K, V> orderKeysBy(Comparator<? super K> comparator) {
            this.keyComparator = Preconditions.checkNotNull(comparator);
            return this;
        }

        public Builder<K, V> orderValuesBy(Comparator<? super V> comparator) {
            this.valueComparator = Preconditions.checkNotNull(comparator);
            return this;
        }

        public Builder<K, V> put(K k2, V v2) {
            CollectPreconditions.checkEntryNotNull(k2, v2);
            Object object = this.builderMap.get(k2);
            Collection<V> collection = object;
            if (object == null) {
                object = this.builderMap;
                collection = this.newMutableValueCollection();
                object.put(k2, collection);
            }
            collection.add(v2);
            return this;
        }

        public Builder<K, V> put(Map.Entry<? extends K, ? extends V> entry) {
            return this.put(entry.getKey(), entry.getValue());
        }

        public Builder<K, V> putAll(Multimap<? extends K, ? extends V> object) {
            for (Map.Entry entry : object.asMap().entrySet()) {
                this.putAll(entry.getKey(), entry.getValue());
            }
            return this;
        }

        public Builder<K, V> putAll(Iterable<? extends Map.Entry<? extends K, ? extends V>> object) {
            object = object.iterator();
            while (object.hasNext()) {
                this.put((Map.Entry)object.next());
            }
            return this;
        }

        public Builder<K, V> putAll(K object, Iterable<? extends V> object2) {
            if (object != null) {
                Collection<V> collection = this.builderMap.get(object);
                if (collection != null) {
                    Iterator<V> iterator2 = object2.iterator();
                    while (iterator2.hasNext()) {
                        object2 = iterator2.next();
                        CollectPreconditions.checkEntryNotNull((Object)object, (Object)object2);
                        collection.add(object2);
                    }
                    return this;
                }
                if (!(object2 = object2.iterator()).hasNext()) {
                    return this;
                }
                collection = this.newMutableValueCollection();
                while (object2.hasNext()) {
                    Object e2 = object2.next();
                    CollectPreconditions.checkEntryNotNull((Object)object, e2);
                    collection.add(e2);
                }
                this.builderMap.put(object, collection);
                return this;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("null key in entry: null=");
            ((StringBuilder)object).append(Iterables.toString(object2));
            object = new NullPointerException(((StringBuilder)object).toString());
            throw object;
        }

        public Builder<K, V> putAll(K k2, V ... VArray) {
            return this.putAll(k2, (Iterable<? extends V>)Arrays.asList(VArray));
        }
    }

    private static class EntryCollection<K, V>
    extends ImmutableCollection<Map.Entry<K, V>> {
        private static final long serialVersionUID = 0L;
        final ImmutableMultimap<K, V> multimap;

        EntryCollection(ImmutableMultimap<K, V> immutableMultimap) {
            this.multimap = immutableMultimap;
        }

        @Override
        public boolean contains(Object object) {
            if (object instanceof Map.Entry) {
                object = (Map.Entry)object;
                return this.multimap.containsEntry(object.getKey(), object.getValue());
            }
            return false;
        }

        @Override
        boolean isPartialView() {
            return this.multimap.isPartialView();
        }

        @Override
        public UnmodifiableIterator<Map.Entry<K, V>> iterator() {
            return this.multimap.entryIterator();
        }

        @Override
        public int size() {
            return this.multimap.size();
        }
    }

    static class FieldSettersHolder {
        static final Serialization.FieldSetter<ImmutableMultimap> MAP_FIELD_SETTER = Serialization.getFieldSetter(ImmutableMultimap.class, (String)"map");
        static final Serialization.FieldSetter<ImmutableMultimap> SIZE_FIELD_SETTER = Serialization.getFieldSetter(ImmutableMultimap.class, (String)"size");

        FieldSettersHolder() {
        }
    }

    class Keys
    extends ImmutableMultiset<K> {
        Keys() {
        }

        @Override
        public boolean contains(@NullableDecl Object object) {
            return ImmutableMultimap.this.containsKey(object);
        }

        @Override
        public int count(@NullableDecl Object object) {
            int n2 = (object = (Collection)ImmutableMultimap.this.map.get(object)) == null ? 0 : object.size();
            return n2;
        }

        @Override
        public ImmutableSet<K> elementSet() {
            return ImmutableMultimap.this.keySet();
        }

        @Override
        Multiset.Entry<K> getEntry(int n2) {
            Map.Entry entry = (Map.Entry)((ImmutableSet)ImmutableMultimap.this.map.entrySet()).asList().get(n2);
            return Multisets.immutableEntry(entry.getKey(), ((Collection)entry.getValue()).size());
        }

        @Override
        boolean isPartialView() {
            return true;
        }

        @Override
        public int size() {
            return ImmutableMultimap.this.size();
        }

        @Override
        Object writeReplace() {
            return new KeysSerializedForm(ImmutableMultimap.this);
        }
    }

    private static final class KeysSerializedForm
    implements Serializable {
        final ImmutableMultimap<?, ?> multimap;

        KeysSerializedForm(ImmutableMultimap<?, ?> immutableMultimap) {
            this.multimap = immutableMultimap;
        }

        Object readResolve() {
            return this.multimap.keys();
        }
    }

    private static final class Values<K, V>
    extends ImmutableCollection<V> {
        private static final long serialVersionUID = 0L;
        private final transient ImmutableMultimap<K, V> multimap;

        Values(ImmutableMultimap<K, V> immutableMultimap) {
            this.multimap = immutableMultimap;
        }

        @Override
        public boolean contains(@NullableDecl Object object) {
            return this.multimap.containsValue(object);
        }

        @Override
        int copyIntoArray(Object[] objectArray, int n2) {
            Iterator iterator2 = ((ImmutableCollection)this.multimap.map.values()).iterator();
            while (iterator2.hasNext()) {
                n2 = ((ImmutableCollection)iterator2.next()).copyIntoArray(objectArray, n2);
            }
            return n2;
        }

        @Override
        boolean isPartialView() {
            return true;
        }

        @Override
        public UnmodifiableIterator<V> iterator() {
            return this.multimap.valueIterator();
        }

        @Override
        public int size() {
            return this.multimap.size();
        }
    }
}

