/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.UnmodifiableIterator;
import java.io.Serializable;
import java.util.Map;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

abstract class ImmutableMapEntrySet<K, V>
extends ImmutableSet<Map.Entry<K, V>> {
    ImmutableMapEntrySet() {
    }

    @Override
    public boolean contains(@NullableDecl Object object) {
        boolean bl;
        boolean bl2 = object instanceof Map.Entry;
        boolean bl3 = bl = false;
        if (bl2) {
            object = (Map.Entry)object;
            V v2 = this.map().get(object.getKey());
            bl3 = bl;
            if (v2 != null) {
                bl3 = bl;
                if (v2.equals(object.getValue())) {
                    bl3 = true;
                }
            }
        }
        return bl3;
    }

    @Override
    public int hashCode() {
        return this.map().hashCode();
    }

    @Override
    boolean isHashCodeFast() {
        return this.map().isHashCodeFast();
    }

    @Override
    boolean isPartialView() {
        return this.map().isPartialView();
    }

    abstract ImmutableMap<K, V> map();

    @Override
    public int size() {
        return this.map().size();
    }

    @Override
    Object writeReplace() {
        return new EntrySetSerializedForm<K, V>(this.map());
    }

    private static class EntrySetSerializedForm<K, V>
    implements Serializable {
        private static final long serialVersionUID = 0L;
        final ImmutableMap<K, V> map;

        EntrySetSerializedForm(ImmutableMap<K, V> immutableMap) {
            this.map = immutableMap;
        }

        Object readResolve() {
            return this.map.entrySet();
        }
    }

    static final class RegularEntrySet<K, V>
    extends ImmutableMapEntrySet<K, V> {
        private final transient ImmutableList<Map.Entry<K, V>> entries;
        private final transient ImmutableMap<K, V> map;

        RegularEntrySet(ImmutableMap<K, V> immutableMap, ImmutableList<Map.Entry<K, V>> immutableList) {
            this.map = immutableMap;
            this.entries = immutableList;
        }

        RegularEntrySet(ImmutableMap<K, V> immutableMap, Map.Entry<K, V>[] entryArray) {
            this(immutableMap, ImmutableList.asImmutableList(entryArray));
        }

        @Override
        int copyIntoArray(Object[] objectArray, int n2) {
            return this.entries.copyIntoArray(objectArray, n2);
        }

        @Override
        ImmutableList<Map.Entry<K, V>> createAsList() {
            return this.entries;
        }

        @Override
        public UnmodifiableIterator<Map.Entry<K, V>> iterator() {
            return this.entries.iterator();
        }

        @Override
        ImmutableMap<K, V> map() {
            return this.map;
        }
    }
}

