/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.EmptyImmutableListMultimap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Serialization;
import com.google.errorprone.annotations.concurrent.LazyInit;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public class ImmutableListMultimap<K, V>
extends ImmutableMultimap<K, V>
implements ListMultimap<K, V> {
    private static final long serialVersionUID = 0L;
    @LazyInit
    private transient ImmutableListMultimap<V, K> inverse;

    ImmutableListMultimap(ImmutableMap<K, ImmutableList<V>> immutableMap, int n2) {
        super(immutableMap, n2);
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    public static <K, V> ImmutableListMultimap<K, V> copyOf(Multimap<? extends K, ? extends V> multimap) {
        ImmutableListMultimap immutableListMultimap;
        if (multimap.isEmpty()) {
            return ImmutableListMultimap.of();
        }
        if (multimap instanceof ImmutableListMultimap && !(immutableListMultimap = (ImmutableListMultimap)multimap).isPartialView()) {
            return immutableListMultimap;
        }
        return ImmutableListMultimap.fromMapEntries(multimap.asMap().entrySet(), null);
    }

    public static <K, V> ImmutableListMultimap<K, V> copyOf(Iterable<? extends Map.Entry<? extends K, ? extends V>> iterable) {
        return ((Builder)new Builder().putAll((Iterable)iterable)).build();
    }

    /*
     * WARNING - void declaration
     */
    static <K, V> ImmutableListMultimap<K, V> fromMapEntries(Collection<? extends Map.Entry<? extends K, ? extends Collection<? extends V>>> immutableList2, @NullableDecl Comparator<? super V> comparator) {
        if (immutableList2.isEmpty()) {
            return ImmutableListMultimap.of();
        }
        ImmutableMap.Builder builder = new ImmutableMap.Builder(immutableList2.size());
        int n2 = 0;
        for (Map.Entry entry : immutableList2) {
            void var0_6;
            void var1_7;
            Object k2 = entry.getKey();
            Collection collection = (Collection)entry.getValue();
            if (var1_7 == null) {
                ImmutableList immutableList = ImmutableList.copyOf(collection);
            } else {
                ImmutableList immutableList = ImmutableList.sortedCopyOf(var1_7, collection);
            }
            if (var0_6.isEmpty()) continue;
            builder.put(k2, var0_6);
            n2 += var0_6.size();
        }
        return new ImmutableListMultimap(builder.build(), n2);
    }

    private ImmutableListMultimap<V, K> invert() {
        Object object = ImmutableListMultimap.builder();
        for (Map.Entry entry : this.entries()) {
            ((Builder)object).put(entry.getValue(), entry.getKey());
        }
        object = ((Builder)object).build();
        ((ImmutableListMultimap)object).inverse = this;
        return object;
    }

    public static <K, V> ImmutableListMultimap<K, V> of() {
        return EmptyImmutableListMultimap.INSTANCE;
    }

    public static <K, V> ImmutableListMultimap<K, V> of(K k2, V v2) {
        Builder<K, V> builder = ImmutableListMultimap.builder();
        builder.put((Object)k2, (Object)v2);
        return builder.build();
    }

    public static <K, V> ImmutableListMultimap<K, V> of(K k2, V v2, K k3, V v3) {
        Builder<K, V> builder = ImmutableListMultimap.builder();
        builder.put((Object)k2, (Object)v2);
        builder.put((Object)k3, (Object)v3);
        return builder.build();
    }

    public static <K, V> ImmutableListMultimap<K, V> of(K k2, V v2, K k3, V v3, K k4, V v4) {
        Builder<K, V> builder = ImmutableListMultimap.builder();
        builder.put((Object)k2, (Object)v2);
        builder.put((Object)k3, (Object)v3);
        builder.put((Object)k4, (Object)v4);
        return builder.build();
    }

    public static <K, V> ImmutableListMultimap<K, V> of(K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        Builder<K, V> builder = ImmutableListMultimap.builder();
        builder.put((Object)k2, (Object)v2);
        builder.put((Object)k3, (Object)v3);
        builder.put((Object)k4, (Object)v4);
        builder.put((Object)k5, (Object)v5);
        return builder.build();
    }

    public static <K, V> ImmutableListMultimap<K, V> of(K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6) {
        Builder<K, V> builder = ImmutableListMultimap.builder();
        builder.put((Object)k2, (Object)v2);
        builder.put((Object)k3, (Object)v3);
        builder.put((Object)k4, (Object)v4);
        builder.put((Object)k5, (Object)v5);
        builder.put((Object)k6, (Object)v6);
        return builder.build();
    }

    private void readObject(ObjectInputStream serializable) throws IOException, ClassNotFoundException {
        ((ObjectInputStream)((Object)serializable)).defaultReadObject();
        int n2 = ((ObjectInputStream)((Object)serializable)).readInt();
        if (n2 >= 0) {
            ImmutableMap.Builder<Object, ImmutableCollection> builder = ImmutableMap.builder();
            int n3 = 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object = ((ObjectInputStream)((Object)serializable)).readObject();
                int n4 = ((ObjectInputStream)((Object)serializable)).readInt();
                if (n4 > 0) {
                    ImmutableList.Builder builder2 = ImmutableList.builder();
                    for (int i3 = 0; i3 < n4; ++i3) {
                        builder2.add(((ObjectInputStream)((Object)serializable)).readObject());
                    }
                    builder.put(object, builder2.build());
                    n3 += n4;
                    continue;
                }
                serializable = new StringBuilder();
                ((StringBuilder)serializable).append("Invalid value count ");
                ((StringBuilder)serializable).append(n4);
                throw new InvalidObjectException(((StringBuilder)serializable).toString());
            }
            try {
                serializable = builder.build();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw (InvalidObjectException)new InvalidObjectException(illegalArgumentException.getMessage()).initCause(illegalArgumentException);
            }
            ImmutableMultimap.FieldSettersHolder.MAP_FIELD_SETTER.set((Object)this, serializable);
            ImmutableMultimap.FieldSettersHolder.SIZE_FIELD_SETTER.set((Object)this, n3);
            return;
        }
        serializable = new StringBuilder();
        ((StringBuilder)serializable).append("Invalid key count ");
        ((StringBuilder)serializable).append(n2);
        serializable = new InvalidObjectException(((StringBuilder)serializable).toString());
        throw serializable;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Serialization.writeMultimap((Multimap)this, (ObjectOutputStream)objectOutputStream);
    }

    @Override
    public ImmutableList<V> get(@NullableDecl K object) {
        ImmutableList immutableList = (ImmutableList)this.map.get(object);
        object = immutableList;
        if (immutableList == null) {
            object = ImmutableList.of();
        }
        return object;
    }

    @Override
    public ImmutableListMultimap<V, K> inverse() {
        ImmutableListMultimap<K, V> immutableListMultimap;
        ImmutableListMultimap<K, V> immutableListMultimap2 = immutableListMultimap = this.inverse;
        if (immutableListMultimap == null) {
            immutableListMultimap2 = this.invert();
            this.inverse = immutableListMultimap2;
        }
        return immutableListMultimap2;
    }

    @Override
    @Deprecated
    public ImmutableList<V> removeAll(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public ImmutableList<V> replaceValues(K k2, Iterable<? extends V> iterable) {
        throw new UnsupportedOperationException();
    }

    public static final class Builder<K, V>
    extends ImmutableMultimap.Builder<K, V> {
        @Override
        public ImmutableListMultimap<K, V> build() {
            return (ImmutableListMultimap)super.build();
        }

        @Override
        public Builder<K, V> orderKeysBy(Comparator<? super K> comparator) {
            super.orderKeysBy(comparator);
            return this;
        }

        @Override
        public Builder<K, V> orderValuesBy(Comparator<? super V> comparator) {
            super.orderValuesBy(comparator);
            return this;
        }

        @Override
        public Builder<K, V> put(K k2, V v2) {
            super.put(k2, v2);
            return this;
        }

        @Override
        public Builder<K, V> put(Map.Entry<? extends K, ? extends V> entry) {
            super.put(entry);
            return this;
        }

        @Override
        public Builder<K, V> putAll(Multimap<? extends K, ? extends V> multimap) {
            super.putAll(multimap);
            return this;
        }

        @Override
        public Builder<K, V> putAll(Iterable<? extends Map.Entry<? extends K, ? extends V>> iterable) {
            super.putAll(iterable);
            return this;
        }

        @Override
        public Builder<K, V> putAll(K k2, Iterable<? extends V> iterable) {
            super.putAll(k2, iterable);
            return this;
        }

        @Override
        public Builder<K, V> putAll(K k2, V ... VArray) {
            super.putAll(k2, VArray);
            return this;
        }
    }
}

