/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIndexedListIterator;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.RegularImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.collect.UnmodifiableListIterator;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public abstract class ImmutableList<E>
extends ImmutableCollection<E>
implements List<E>,
RandomAccess {
    private static final UnmodifiableListIterator<Object> EMPTY_ITR = new Itr(RegularImmutableList.EMPTY, 0);

    ImmutableList() {
    }

    static <E> ImmutableList<E> asImmutableList(Object[] objectArray) {
        return ImmutableList.asImmutableList(objectArray, objectArray.length);
    }

    static <E> ImmutableList<E> asImmutableList(Object[] objectArray, int n2) {
        if (n2 == 0) {
            return ImmutableList.of();
        }
        return new RegularImmutableList(objectArray, n2);
    }

    public static <E> Builder<E> builder() {
        return new Builder();
    }

    public static <E> Builder<E> builderWithExpectedSize(int n2) {
        CollectPreconditions.checkNonnegative((int)n2, (String)"expectedSize");
        return new Builder(n2);
    }

    private static <E> ImmutableList<E> construct(Object ... objectArray) {
        return ImmutableList.asImmutableList(ObjectArrays.checkElementsNotNull(objectArray));
    }

    public static <E> ImmutableList<E> copyOf(Iterable<? extends E> iterable) {
        Preconditions.checkNotNull(iterable);
        iterable = iterable instanceof Collection ? ImmutableList.copyOf((Collection)iterable) : ImmutableList.copyOf(iterable.iterator());
        return iterable;
    }

    public static <E> ImmutableList<E> copyOf(Collection<? extends E> collection) {
        if (collection instanceof ImmutableCollection) {
            ImmutableList<E> immutableList = ((ImmutableCollection)collection).asList();
            collection = immutableList;
            if (immutableList.isPartialView()) {
                collection = ImmutableList.asImmutableList(immutableList.toArray());
            }
            return collection;
        }
        return ImmutableList.construct(collection.toArray());
    }

    public static <E> ImmutableList<E> copyOf(Iterator<? extends E> iterator2) {
        if (!iterator2.hasNext()) {
            return ImmutableList.of();
        }
        E e2 = iterator2.next();
        if (!iterator2.hasNext()) {
            return ImmutableList.of(e2);
        }
        return ((Builder)((Builder)new Builder().add((Object)e2)).addAll(iterator2)).build();
    }

    public static <E> ImmutableList<E> copyOf(E[] object) {
        object = ((E[])object).length == 0 ? ImmutableList.of() : ImmutableList.construct((Object[])object.clone());
        return object;
    }

    public static <E> ImmutableList<E> of() {
        return RegularImmutableList.EMPTY;
    }

    public static <E> ImmutableList<E> of(E e2) {
        return ImmutableList.construct(e2);
    }

    public static <E> ImmutableList<E> of(E e2, E e3) {
        return ImmutableList.construct(e2, e3);
    }

    public static <E> ImmutableList<E> of(E e2, E e3, E e4) {
        return ImmutableList.construct(e2, e3, e4);
    }

    public static <E> ImmutableList<E> of(E e2, E e3, E e4, E e5) {
        return ImmutableList.construct(e2, e3, e4, e5);
    }

    public static <E> ImmutableList<E> of(E e2, E e3, E e4, E e5, E e6) {
        return ImmutableList.construct(e2, e3, e4, e5, e6);
    }

    public static <E> ImmutableList<E> of(E e2, E e3, E e4, E e5, E e6, E e7) {
        return ImmutableList.construct(e2, e3, e4, e5, e6, e7);
    }

    public static <E> ImmutableList<E> of(E e2, E e3, E e4, E e5, E e6, E e7, E e8) {
        return ImmutableList.construct(e2, e3, e4, e5, e6, e7, e8);
    }

    public static <E> ImmutableList<E> of(E e2, E e3, E e4, E e5, E e6, E e7, E e8, E e9) {
        return ImmutableList.construct(e2, e3, e4, e5, e6, e7, e8, e9);
    }

    public static <E> ImmutableList<E> of(E e2, E e3, E e4, E e5, E e6, E e7, E e8, E e9, E e10) {
        return ImmutableList.construct(e2, e3, e4, e5, e6, e7, e8, e9, e10);
    }

    public static <E> ImmutableList<E> of(E e2, E e3, E e4, E e5, E e6, E e7, E e8, E e9, E e10, E e11) {
        return ImmutableList.construct(e2, e3, e4, e5, e6, e7, e8, e9, e10, e11);
    }

    public static <E> ImmutableList<E> of(E e2, E e3, E e4, E e5, E e6, E e7, E e8, E e9, E e10, E e11, E e12) {
        return ImmutableList.construct(e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12);
    }

    @SafeVarargs
    public static <E> ImmutableList<E> of(E e2, E e3, E e4, E e5, E e6, E e7, E e8, E e9, E e10, E e11, E e12, E e13, E ... EArray) {
        boolean bl = EArray.length <= 0x7FFFFFF3;
        Preconditions.checkArgument(bl, "the total number of elements must fit in an int");
        Object[] objectArray = new Object[EArray.length + 12];
        objectArray[0] = e2;
        objectArray[1] = e3;
        objectArray[2] = e4;
        objectArray[3] = e5;
        objectArray[4] = e6;
        objectArray[5] = e7;
        objectArray[6] = e8;
        objectArray[7] = e9;
        objectArray[8] = e10;
        objectArray[9] = e11;
        objectArray[10] = e12;
        objectArray[11] = e13;
        System.arraycopy(EArray, 0, objectArray, 12, EArray.length);
        return ImmutableList.construct(objectArray);
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        throw new InvalidObjectException("Use SerializedForm");
    }

    public static <E extends Comparable<? super E>> ImmutableList<E> sortedCopyOf(Iterable<? extends E> objectArray) {
        objectArray = Iterables.toArray(objectArray, new Comparable[0]);
        ObjectArrays.checkElementsNotNull(objectArray);
        Arrays.sort(objectArray);
        return ImmutableList.asImmutableList(objectArray);
    }

    public static <E> ImmutableList<E> sortedCopyOf(Comparator<? super E> comparator, Iterable<? extends E> objectArray) {
        Preconditions.checkNotNull(comparator);
        objectArray = Iterables.toArray(objectArray);
        ObjectArrays.checkElementsNotNull(objectArray);
        Arrays.sort(objectArray, comparator);
        return ImmutableList.asImmutableList(objectArray);
    }

    @Override
    @Deprecated
    public final void add(int n2, E e2) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final boolean addAll(int n2, Collection<? extends E> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final ImmutableList<E> asList() {
        return this;
    }

    @Override
    public boolean contains(@NullableDecl Object object) {
        boolean bl = this.indexOf(object) >= 0;
        return bl;
    }

    @Override
    int copyIntoArray(Object[] objectArray, int n2) {
        int n3 = this.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            objectArray[n2 + i2] = this.get(i2);
        }
        return n2 + n3;
    }

    @Override
    public boolean equals(@NullableDecl Object object) {
        return Lists.equalsImpl(this, object);
    }

    @Override
    public int hashCode() {
        int n2 = this.size();
        int n3 = 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 = ~(~(n3 * 31 + this.get(i2).hashCode()));
        }
        return n3;
    }

    @Override
    public int indexOf(@NullableDecl Object object) {
        int n2 = object == null ? -1 : Lists.indexOfImpl(this, object);
        return n2;
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public int lastIndexOf(@NullableDecl Object object) {
        int n2 = object == null ? -1 : Lists.lastIndexOfImpl(this, object);
        return n2;
    }

    @Override
    public UnmodifiableListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public UnmodifiableListIterator<E> listIterator(int n2) {
        Preconditions.checkPositionIndex(n2, this.size());
        if (this.isEmpty()) {
            return EMPTY_ITR;
        }
        return new Itr(this, n2);
    }

    @Override
    @Deprecated
    public final E remove(int n2) {
        throw new UnsupportedOperationException();
    }

    public ImmutableList<E> reverse() {
        ReverseImmutableList reverseImmutableList = ((AbstractCollection)this).size() <= 1 ? this : new ReverseImmutableList(this);
        return reverseImmutableList;
    }

    @Override
    @Deprecated
    public final E set(int n2, E e2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ImmutableList<E> subList(int n2, int n3) {
        Preconditions.checkPositionIndexes(n2, n3, this.size());
        int n4 = n3 - n2;
        if (n4 == this.size()) {
            return this;
        }
        if (n4 == 0) {
            return ImmutableList.of();
        }
        return this.subListUnchecked(n2, n3);
    }

    ImmutableList<E> subListUnchecked(int n2, int n3) {
        return new SubList(n2, n3 - n2);
    }

    @Override
    Object writeReplace() {
        return new SerializedForm(this.toArray());
    }

    public static final class Builder<E>
    extends ImmutableCollection.ArrayBasedBuilder<E> {
        public Builder() {
            this(4);
        }

        Builder(int n2) {
            super(n2);
        }

        @Override
        public Builder<E> add(E e2) {
            super.add((Object)e2);
            return this;
        }

        @Override
        public Builder<E> add(E ... EArray) {
            super.add(EArray);
            return this;
        }

        @Override
        public Builder<E> addAll(Iterable<? extends E> iterable) {
            super.addAll(iterable);
            return this;
        }

        @Override
        public Builder<E> addAll(Iterator<? extends E> iterator2) {
            super.addAll(iterator2);
            return this;
        }

        @Override
        public ImmutableList<E> build() {
            this.forceCopy = true;
            return ImmutableList.asImmutableList(this.contents, this.size);
        }
    }

    static class Itr<E>
    extends AbstractIndexedListIterator<E> {
        private final ImmutableList<E> list;

        Itr(ImmutableList<E> immutableList, int n2) {
            super(immutableList.size(), n2);
            this.list = immutableList;
        }

        protected E get(int n2) {
            return this.list.get(n2);
        }
    }

    private static class ReverseImmutableList<E>
    extends ImmutableList<E> {
        private final transient ImmutableList<E> forwardList;

        ReverseImmutableList(ImmutableList<E> immutableList) {
            this.forwardList = immutableList;
        }

        private int reverseIndex(int n2) {
            return this.size() - 1 - n2;
        }

        private int reversePosition(int n2) {
            return this.size() - n2;
        }

        @Override
        public boolean contains(@NullableDecl Object object) {
            return this.forwardList.contains(object);
        }

        @Override
        public E get(int n2) {
            Preconditions.checkElementIndex(n2, this.size());
            return this.forwardList.get(this.reverseIndex(n2));
        }

        @Override
        public int indexOf(@NullableDecl Object object) {
            int n2 = this.forwardList.lastIndexOf(object);
            n2 = n2 >= 0 ? this.reverseIndex(n2) : -1;
            return n2;
        }

        @Override
        boolean isPartialView() {
            return this.forwardList.isPartialView();
        }

        @Override
        public int lastIndexOf(@NullableDecl Object object) {
            int n2 = this.forwardList.indexOf(object);
            n2 = n2 >= 0 ? this.reverseIndex(n2) : -1;
            return n2;
        }

        @Override
        public ImmutableList<E> reverse() {
            return this.forwardList;
        }

        @Override
        public int size() {
            return this.forwardList.size();
        }

        @Override
        public ImmutableList<E> subList(int n2, int n3) {
            Preconditions.checkPositionIndexes(n2, n3, this.size());
            return ((ImmutableList)this.forwardList.subList(this.reversePosition(n3), this.reversePosition(n2))).reverse();
        }
    }

    static class SerializedForm
    implements Serializable {
        private static final long serialVersionUID = 0L;
        final Object[] elements;

        SerializedForm(Object[] objectArray) {
            this.elements = objectArray;
        }

        Object readResolve() {
            return ImmutableList.copyOf(this.elements);
        }
    }

    class SubList
    extends ImmutableList<E> {
        final transient int length;
        final transient int offset;

        SubList(int n2, int n3) {
            this.offset = n2;
            this.length = n3;
        }

        @Override
        public E get(int n2) {
            Preconditions.checkElementIndex(n2, this.length);
            return ImmutableList.this.get(n2 + this.offset);
        }

        @Override
        Object[] internalArray() {
            return ImmutableList.this.internalArray();
        }

        @Override
        int internalArrayEnd() {
            return ImmutableList.this.internalArrayStart() + this.offset + this.length;
        }

        @Override
        int internalArrayStart() {
            return ImmutableList.this.internalArrayStart() + this.offset;
        }

        @Override
        boolean isPartialView() {
            return true;
        }

        @Override
        public int size() {
            return this.length;
        }

        @Override
        public ImmutableList<E> subList(int n2, int n3) {
            Preconditions.checkPositionIndexes(n2, n3, this.length);
            ImmutableList immutableList = ImmutableList.this;
            int n4 = this.offset;
            return immutableList.subList(n2 + n4, n3 + n4);
        }
    }
}

