/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.Platform;
import com.google.common.collect.UnmodifiableIterator;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public abstract class ImmutableCollection<E>
extends AbstractCollection<E>
implements Serializable {
    private static final Object[] EMPTY_ARRAY = new Object[0];

    ImmutableCollection() {
    }

    @Override
    @Deprecated
    public final boolean add(E e2) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final boolean addAll(Collection<? extends E> collection) {
        throw new UnsupportedOperationException();
    }

    public ImmutableList<E> asList() {
        ImmutableList immutableList = this.isEmpty() ? ImmutableList.of() : ImmutableList.asImmutableList(this.toArray());
        return immutableList;
    }

    @Override
    @Deprecated
    public final void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public abstract boolean contains(@NullableDecl Object var1);

    int copyIntoArray(Object[] objectArray, int n2) {
        Iterator iterator2 = this.iterator();
        while (iterator2.hasNext()) {
            objectArray[n2] = iterator2.next();
            ++n2;
        }
        return n2;
    }

    Object[] internalArray() {
        return null;
    }

    int internalArrayEnd() {
        throw new UnsupportedOperationException();
    }

    int internalArrayStart() {
        throw new UnsupportedOperationException();
    }

    abstract boolean isPartialView();

    @Override
    public abstract UnmodifiableIterator<E> iterator();

    @Override
    @Deprecated
    public final boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Object[] toArray() {
        return this.toArray(EMPTY_ARRAY);
    }

    @Override
    public final <T> T[] toArray(T[] TArray) {
        Object[] objectArray;
        Preconditions.checkNotNull(TArray);
        int n2 = this.size();
        if (TArray.length < n2) {
            objectArray = this.internalArray();
            if (objectArray != null) {
                return Platform.copy((Object[])objectArray, (int)this.internalArrayStart(), (int)this.internalArrayEnd(), (Object[])TArray);
            }
            objectArray = ObjectArrays.newArray(TArray, n2);
        } else {
            objectArray = TArray;
            if (TArray.length > n2) {
                TArray[n2] = null;
                objectArray = TArray;
            }
        }
        this.copyIntoArray(objectArray, 0);
        return objectArray;
    }

    Object writeReplace() {
        return new ImmutableList.SerializedForm(this.toArray());
    }

    static abstract class ArrayBasedBuilder<E>
    extends Builder<E> {
        Object[] contents;
        boolean forceCopy;
        int size;

        ArrayBasedBuilder(int n2) {
            CollectPreconditions.checkNonnegative((int)n2, (String)"initialCapacity");
            this.contents = new Object[n2];
            this.size = 0;
        }

        private void getReadyToExpandTo(int n2) {
            Object[] objectArray = this.contents;
            if (objectArray.length < n2) {
                this.contents = Arrays.copyOf(objectArray, ArrayBasedBuilder.expandedCapacity(objectArray.length, n2));
                this.forceCopy = false;
            } else if (this.forceCopy) {
                this.contents = (Object[])objectArray.clone();
                this.forceCopy = false;
            }
        }

        @Override
        public ArrayBasedBuilder<E> add(E e2) {
            Preconditions.checkNotNull(e2);
            this.getReadyToExpandTo(this.size + 1);
            Object[] objectArray = this.contents;
            int n2 = this.size;
            this.size = n2 + 1;
            objectArray[n2] = e2;
            return this;
        }

        @Override
        public Builder<E> add(E ... EArray) {
            ObjectArrays.checkElementsNotNull((Object[])EArray);
            this.getReadyToExpandTo(this.size + EArray.length);
            System.arraycopy(EArray, 0, this.contents, this.size, EArray.length);
            this.size += EArray.length;
            return this;
        }

        @Override
        public Builder<E> addAll(Iterable<? extends E> iterable) {
            if (iterable instanceof Collection) {
                Collection collection = (Collection)iterable;
                this.getReadyToExpandTo(this.size + collection.size());
                if (collection instanceof ImmutableCollection) {
                    this.size = ((ImmutableCollection)collection).copyIntoArray(this.contents, this.size);
                    return this;
                }
            }
            super.addAll(iterable);
            return this;
        }
    }

    public static abstract class Builder<E> {
        static final int DEFAULT_INITIAL_CAPACITY = 4;

        Builder() {
        }

        static int expandedCapacity(int n2, int n3) {
            if (n3 >= 0) {
                int n4;
                n2 = n4 = n2 + (n2 >> 1) + 1;
                if (n4 < n3) {
                    n2 = Integer.highestOneBit(n3 - 1) << 1;
                }
                n3 = n2;
                if (n2 < 0) {
                    n3 = Integer.MAX_VALUE;
                }
                return n3;
            }
            throw new AssertionError((Object)"cannot store more than MAX_VALUE elements");
        }

        public abstract Builder<E> add(E var1);

        public Builder<E> add(E ... EArray) {
            int n2 = EArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.add(EArray[i2]);
            }
            return this;
        }

        public Builder<E> addAll(Iterable<? extends E> object) {
            object = object.iterator();
            while (object.hasNext()) {
                this.add((E)object.next());
            }
            return this;
        }

        public Builder<E> addAll(Iterator<? extends E> iterator2) {
            while (iterator2.hasNext()) {
                this.add(iterator2.next());
            }
            return this;
        }

        public abstract ImmutableCollection<E> build();
    }
}

