/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Primitives;
import com.google.errorprone.annotations.Immutable;
import java.io.Serializable;
import java.util.Map;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

@Immutable(containerOf={"B"})
public final class ImmutableClassToInstanceMap<B>
extends ForwardingMap<Class<? extends B>, B>
implements ClassToInstanceMap<B>,
Serializable {
    private static final ImmutableClassToInstanceMap<Object> EMPTY = new ImmutableClassToInstanceMap(ImmutableMap.of());
    private final ImmutableMap<Class<? extends B>, B> delegate;

    private ImmutableClassToInstanceMap(ImmutableMap<Class<? extends B>, B> immutableMap) {
        this.delegate = immutableMap;
    }

    public static <B> Builder<B> builder() {
        return new Builder();
    }

    public static <B, S extends B> ImmutableClassToInstanceMap<B> copyOf(Map<? extends Class<? extends S>, ? extends S> map) {
        if (map instanceof ImmutableClassToInstanceMap) {
            return (ImmutableClassToInstanceMap)map;
        }
        return new Builder().putAll(map).build();
    }

    public static <B> ImmutableClassToInstanceMap<B> of() {
        return EMPTY;
    }

    public static <B, T extends B> ImmutableClassToInstanceMap<B> of(Class<T> clazz, T t2) {
        return new ImmutableClassToInstanceMap<T>(ImmutableMap.of(clazz, t2));
    }

    @Override
    protected Map<Class<? extends B>, B> delegate() {
        return this.delegate;
    }

    @Override
    @NullableDecl
    public <T extends B> T getInstance(Class<T> clazz) {
        return (T)this.delegate.get(Preconditions.checkNotNull(clazz));
    }

    @Override
    @Deprecated
    public <T extends B> T putInstance(Class<T> clazz, T t2) {
        throw new UnsupportedOperationException();
    }

    Object readResolve() {
        ImmutableClassToInstanceMap immutableClassToInstanceMap = this.isEmpty() ? ImmutableClassToInstanceMap.of() : this;
        return immutableClassToInstanceMap;
    }

    public static final class Builder<B> {
        private final ImmutableMap.Builder<Class<? extends B>, B> mapBuilder = ImmutableMap.builder();

        private static <B, T extends B> T cast(Class<T> clazz, B b2) {
            return Primitives.wrap(clazz).cast(b2);
        }

        public ImmutableClassToInstanceMap<B> build() {
            ImmutableMap<Class<B>, B> immutableMap = this.mapBuilder.build();
            if (immutableMap.isEmpty()) {
                return ImmutableClassToInstanceMap.of();
            }
            return new ImmutableClassToInstanceMap(immutableMap);
        }

        public <T extends B> Builder<B> put(Class<T> clazz, T t2) {
            this.mapBuilder.put(clazz, t2);
            return this;
        }

        public <T extends B> Builder<B> putAll(Map<? extends Class<? extends T>, ? extends T> object) {
            for (Map.Entry entry : object.entrySet()) {
                Class clazz = (Class)entry.getKey();
                Object entry2 = entry.getValue();
                this.mapBuilder.put(clazz, Builder.cast(clazz, entry2));
            }
            return this;
        }
    }
}

