/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimapGwtSerializationDependencies;
import com.google.common.collect.Multimap;
import com.google.common.collect.Platform;
import com.google.common.collect.Serialization;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Set;

public final class HashMultimap<K, V>
extends HashMultimapGwtSerializationDependencies<K, V> {
    private static final int DEFAULT_VALUES_PER_KEY = 2;
    private static final long serialVersionUID = 0L;
    transient int expectedValuesPerKey = 2;

    private HashMultimap() {
        this(12, 2);
    }

    private HashMultimap(int n2, int n3) {
        super(Platform.newHashMapWithExpectedSize((int)n2));
        boolean bl = n3 >= 0;
        Preconditions.checkArgument(bl);
        this.expectedValuesPerKey = n3;
    }

    private HashMultimap(Multimap<? extends K, ? extends V> multimap) {
        super(Platform.newHashMapWithExpectedSize((int)multimap.keySet().size()));
        this.putAll(multimap);
    }

    public static <K, V> HashMultimap<K, V> create() {
        return new HashMultimap<K, V>();
    }

    public static <K, V> HashMultimap<K, V> create(int n2, int n3) {
        return new HashMultimap<K, V>(n2, n3);
    }

    public static <K, V> HashMultimap<K, V> create(Multimap<? extends K, ? extends V> multimap) {
        return new HashMultimap<K, V>(multimap);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.expectedValuesPerKey = 2;
        int n2 = Serialization.readCount((ObjectInputStream)objectInputStream);
        this.setMap(Platform.newHashMapWithExpectedSize((int)12));
        Serialization.populateMultimap((Multimap)this, (ObjectInputStream)objectInputStream, (int)n2);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Serialization.writeMultimap((Multimap)this, (ObjectOutputStream)objectOutputStream);
    }

    @Override
    Set<V> createCollection() {
        return Platform.newHashSetWithExpectedSize((int)this.expectedValuesPerKey);
    }
}

