/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractMapEntry;
import com.google.common.collect.BiMap;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.Hashing;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.Serialization;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.checkerframework.checker.nullness.compatqual.MonotonicNonNullDecl;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class HashBiMap<K, V>
extends AbstractMap<K, V>
implements BiMap<K, V>,
Serializable {
    private static final int ABSENT = -1;
    private static final int ENDPOINT = -2;
    private transient Set<Map.Entry<K, V>> entrySet;
    @NullableDecl
    private transient int firstInInsertionOrder;
    private transient int[] hashTableKToV;
    private transient int[] hashTableVToK;
    @MonotonicNonNullDecl
    private transient BiMap<V, K> inverse;
    private transient Set<K> keySet;
    transient K[] keys;
    @NullableDecl
    private transient int lastInInsertionOrder;
    transient int modCount;
    private transient int[] nextInBucketKToV;
    private transient int[] nextInBucketVToK;
    private transient int[] nextInInsertionOrder;
    private transient int[] prevInInsertionOrder;
    transient int size;
    private transient Set<V> valueSet;
    transient V[] values;

    private HashBiMap(int n2) {
        this.init(n2);
    }

    static /* synthetic */ BiMap access$302(HashBiMap hashBiMap, BiMap biMap) {
        hashBiMap.inverse = biMap;
        return biMap;
    }

    private int bucket(int n2) {
        return n2 & this.hashTableKToV.length - 1;
    }

    public static <K, V> HashBiMap<K, V> create() {
        return HashBiMap.create(16);
    }

    public static <K, V> HashBiMap<K, V> create(int n2) {
        return new HashBiMap<K, V>(n2);
    }

    public static <K, V> HashBiMap<K, V> create(Map<? extends K, ? extends V> map) {
        HashBiMap<K, V> hashBiMap = HashBiMap.create(map.size());
        hashBiMap.putAll(map);
        return hashBiMap;
    }

    private static int[] createFilledWithAbsent(int n2) {
        int[] nArray = new int[n2];
        Arrays.fill(nArray, -1);
        return nArray;
    }

    private void deleteFromTableKToV(int n2, int n3) {
        boolean bl = n2 != -1;
        Preconditions.checkArgument(bl);
        n3 = this.bucket(n3);
        int[] nArray = this.hashTableKToV;
        if (nArray[n3] == n2) {
            int[] nArray2 = this.nextInBucketKToV;
            nArray[n3] = nArray2[n2];
            nArray2[n2] = -1;
            return;
        }
        int n4 = nArray[n3];
        n3 = this.nextInBucketKToV[n4];
        while (true) {
            int n5 = n4;
            n4 = n3;
            if (n4 == -1) break;
            if (n4 == n2) {
                int[] nArray3 = this.nextInBucketKToV;
                nArray3[n5] = nArray3[n2];
                nArray3[n2] = -1;
                return;
            }
            n3 = this.nextInBucketKToV[n4];
        }
        Object object = new StringBuilder();
        ((StringBuilder)object).append("Expected to find entry with key ");
        ((StringBuilder)object).append(this.keys[n2]);
        object = new AssertionError((Object)((StringBuilder)object).toString());
        throw object;
    }

    private void deleteFromTableVToK(int n2, int n3) {
        boolean bl = n2 != -1;
        Preconditions.checkArgument(bl);
        n3 = this.bucket(n3);
        Object object = this.hashTableVToK;
        if (object[n3] == n2) {
            int[] nArray = this.nextInBucketVToK;
            object[n3] = nArray[n2];
            nArray[n2] = -1;
            return;
        }
        int n4 = object[n3];
        n3 = this.nextInBucketVToK[n4];
        while (true) {
            int n5 = n4;
            n4 = n3;
            if (n4 == -1) break;
            if (n4 == n2) {
                object = this.nextInBucketVToK;
                object[n5] = object[n2];
                object[n2] = -1;
                return;
            }
            n3 = this.nextInBucketVToK[n4];
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Expected to find entry with value ");
        ((StringBuilder)object).append(this.values[n2]);
        object = new AssertionError((Object)((StringBuilder)object).toString());
        throw object;
    }

    private void ensureCapacity(int n2) {
        int n3;
        int[] nArray = this.nextInBucketKToV;
        if (nArray.length < n2) {
            n3 = ImmutableCollection.Builder.expandedCapacity(nArray.length, n2);
            this.keys = Arrays.copyOf(this.keys, n3);
            this.values = Arrays.copyOf(this.values, n3);
            this.nextInBucketKToV = HashBiMap.expandAndFillWithAbsent(this.nextInBucketKToV, n3);
            this.nextInBucketVToK = HashBiMap.expandAndFillWithAbsent(this.nextInBucketVToK, n3);
            this.prevInInsertionOrder = HashBiMap.expandAndFillWithAbsent(this.prevInInsertionOrder, n3);
            this.nextInInsertionOrder = HashBiMap.expandAndFillWithAbsent(this.nextInInsertionOrder, n3);
        }
        if (this.hashTableKToV.length < n2) {
            n2 = Hashing.closedTableSize(n2, 1.0);
            this.hashTableKToV = HashBiMap.createFilledWithAbsent(n2);
            this.hashTableVToK = HashBiMap.createFilledWithAbsent(n2);
            n2 = 0;
            while (n2 < this.size) {
                n3 = this.bucket(Hashing.smearedHash(this.keys[n2]));
                nArray = this.nextInBucketKToV;
                int[] nArray2 = this.hashTableKToV;
                nArray[n2] = nArray2[n3];
                nArray2[n3] = n2;
                n3 = this.bucket(Hashing.smearedHash(this.values[n2]));
                nArray = this.nextInBucketVToK;
                nArray2 = this.hashTableVToK;
                nArray[n2] = nArray2[n3];
                nArray2[n3] = n2++;
            }
        }
    }

    private static int[] expandAndFillWithAbsent(int[] nArray, int n2) {
        int n3 = nArray.length;
        nArray = Arrays.copyOf(nArray, n2);
        Arrays.fill(nArray, n3, n2, -1);
        return nArray;
    }

    private void insertIntoTableKToV(int n2, int n3) {
        boolean bl = n2 != -1;
        Preconditions.checkArgument(bl);
        n3 = this.bucket(n3);
        int[] nArray = this.nextInBucketKToV;
        int[] nArray2 = this.hashTableKToV;
        nArray[n2] = nArray2[n3];
        nArray2[n3] = n2;
    }

    private void insertIntoTableVToK(int n2, int n3) {
        boolean bl = n2 != -1;
        Preconditions.checkArgument(bl);
        n3 = this.bucket(n3);
        int[] nArray = this.nextInBucketVToK;
        int[] nArray2 = this.hashTableVToK;
        nArray[n2] = nArray2[n3];
        nArray2[n3] = n2;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void moveEntryToIndex(int var1_1, int var2_2) {
        block6: {
            if (var1_1 == var2_2) {
                return;
            }
            var3_3 = this.prevInInsertionOrder[var1_1];
            var4_4 /* !! */  = this.nextInInsertionOrder[var1_1];
            this.setSucceeds(var3_3, var2_2);
            this.setSucceeds(var2_2, var4_4 /* !! */ );
            var5_5 = this.keys;
            var6_6 = var5_5[var1_1];
            var7_7 /* !! */  = this.values;
            var8_8 /* !! */  = var7_7 /* !! */ [var1_1];
            var5_5[var2_2] = var6_6;
            var7_7 /* !! */ [var2_2] = var8_8 /* !! */ ;
            var3_3 = this.bucket(Hashing.smearedHash(var6_6));
            var7_7 /* !! */  = this.hashTableKToV;
            if (var7_7 /* !! */ [var3_3] != var1_1) break block6;
            var7_7 /* !! */ [var3_3] = var2_2;
            ** GOTO lbl24
        }
        var4_4 /* !! */  = (int)var7_7 /* !! */ [var3_3];
        var3_3 = this.nextInBucketKToV[var4_4 /* !! */ ];
        while (true) {
            block7: {
                block8: {
                    if (var3_3 != var1_1) break block7;
                    this.nextInBucketKToV[var4_4 /* !! */ ] = var2_2;
lbl24:
                    // 2 sources

                    var7_7 /* !! */  = this.nextInBucketKToV;
                    var7_7 /* !! */ [var2_2] = var7_7 /* !! */ [var1_1];
                    var7_7 /* !! */ [var1_1] = -1;
                    var3_3 = this.bucket(Hashing.smearedHash(var8_8 /* !! */ ));
                    var8_8 /* !! */  = (V)this.hashTableVToK;
                    if (var8_8 /* !! */ [var3_3] != var1_1) break block8;
                    var8_8 /* !! */ [var3_3] = var2_2;
                    ** GOTO lbl38
                }
                var4_4 /* !! */  = (int)var8_8 /* !! */ [var3_3];
                var3_3 = this.nextInBucketVToK[var4_4 /* !! */ ];
                while (true) {
                    block9: {
                        if (var3_3 != var1_1) break block9;
                        this.nextInBucketVToK[var4_4 /* !! */ ] = var2_2;
lbl38:
                        // 2 sources

                        var8_8 /* !! */  = (V)this.nextInBucketVToK;
                        var8_8 /* !! */ [var2_2] = var8_8 /* !! */ [var1_1];
                        var8_8 /* !! */ [var1_1] = -1;
                        return;
                    }
                    var9_9 = this.nextInBucketVToK[var3_3];
                    var4_4 /* !! */  = var3_3;
                    var3_3 = var9_9;
                }
            }
            var9_9 = this.nextInBucketKToV[var3_3];
            var4_4 /* !! */  = var3_3;
            var3_3 = var9_9;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n2 = Serialization.readCount((ObjectInputStream)objectInputStream);
        this.init(16);
        Serialization.populateMap((Map)this, (ObjectInputStream)objectInputStream, (int)n2);
    }

    private void removeEntry(int n2, int n3, int n4) {
        boolean bl = n2 != -1;
        Preconditions.checkArgument(bl);
        this.deleteFromTableKToV(n2, n3);
        this.deleteFromTableVToK(n2, n4);
        this.setSucceeds(this.prevInInsertionOrder[n2], this.nextInInsertionOrder[n2]);
        this.moveEntryToIndex(this.size - 1, n2);
        K[] KArray = this.keys;
        n2 = this.size;
        KArray[n2 - 1] = null;
        this.values[n2 - 1] = null;
        this.size = n2 - 1;
        ++this.modCount;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void replaceKeyInEntry(int n2, @NullableDecl K k2, boolean bl) {
        int n3;
        boolean bl2 = n2 != -1;
        Preconditions.checkArgument(bl2);
        int n4 = Hashing.smearedHash(k2);
        int n5 = this.findEntryByKey(k2, n4);
        int n6 = this.lastInInsertionOrder;
        if (n5 != -1) {
            if (!bl) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Key already present in map: ");
                stringBuilder.append(k2);
                throw new IllegalArgumentException(stringBuilder.toString());
            }
            int n7 = this.prevInInsertionOrder[n5];
            int n8 = this.nextInInsertionOrder[n5];
            this.removeEntryKeyHashKnown(n5, n4);
            n4 = n8;
            n3 = n2;
            n6 = n7;
            if (n2 == this.size) {
                n3 = n5;
                n4 = n8;
                n6 = n7;
            }
        } else {
            n4 = -2;
            n3 = n2;
        }
        if (n6 == n3) {
            n2 = this.prevInInsertionOrder[n3];
        } else {
            n2 = n6;
            if (n6 == this.size) {
                n2 = n5;
            }
        }
        if (n4 == n3) {
            n5 = this.nextInInsertionOrder[n3];
        } else if (n4 != this.size) {
            n5 = n4;
        }
        this.setSucceeds(this.prevInInsertionOrder[n3], this.nextInInsertionOrder[n3]);
        this.deleteFromTableKToV(n3, Hashing.smearedHash(this.keys[n3]));
        this.keys[n3] = k2;
        this.insertIntoTableKToV(n3, Hashing.smearedHash(k2));
        this.setSucceeds(n2, n3);
        this.setSucceeds(n3, n5);
    }

    private void replaceValueInEntry(int n2, @NullableDecl V v2, boolean bl) {
        boolean bl2 = n2 != -1;
        Preconditions.checkArgument(bl2);
        int n3 = Hashing.smearedHash(v2);
        int n4 = this.findEntryByValue(v2, n3);
        int n5 = n2;
        if (n4 != -1) {
            if (bl) {
                this.removeEntryValueHashKnown(n4, n3);
                n5 = n2;
                if (n2 == this.size) {
                    n5 = n4;
                }
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Value already present in map: ");
                stringBuilder.append(v2);
                throw new IllegalArgumentException(stringBuilder.toString());
            }
        }
        this.deleteFromTableVToK(n5, Hashing.smearedHash(this.values[n5]));
        this.values[n5] = v2;
        this.insertIntoTableVToK(n5, n3);
    }

    private void setSucceeds(int n2, int n3) {
        if (n2 == -2) {
            this.firstInInsertionOrder = n3;
        } else {
            this.nextInInsertionOrder[n2] = n3;
        }
        if (n3 == -2) {
            this.lastInInsertionOrder = n2;
        } else {
            this.prevInInsertionOrder[n3] = n2;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Serialization.writeMap((Map)this, (ObjectOutputStream)objectOutputStream);
    }

    @Override
    public void clear() {
        Arrays.fill(this.keys, 0, this.size, null);
        Arrays.fill(this.values, 0, this.size, null);
        Arrays.fill(this.hashTableKToV, -1);
        Arrays.fill(this.hashTableVToK, -1);
        Arrays.fill(this.nextInBucketKToV, 0, this.size, -1);
        Arrays.fill(this.nextInBucketVToK, 0, this.size, -1);
        Arrays.fill(this.prevInInsertionOrder, 0, this.size, -1);
        Arrays.fill(this.nextInInsertionOrder, 0, this.size, -1);
        this.size = 0;
        this.firstInInsertionOrder = -2;
        this.lastInInsertionOrder = -2;
        ++this.modCount;
    }

    @Override
    public boolean containsKey(@NullableDecl Object object) {
        boolean bl = this.findEntryByKey(object) != -1;
        return bl;
    }

    @Override
    public boolean containsValue(@NullableDecl Object object) {
        boolean bl = this.findEntryByValue(object) != -1;
        return bl;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet entrySet;
        EntrySet entrySet2 = entrySet = this.entrySet;
        if (entrySet == null) {
            this.entrySet = entrySet2 = new EntrySet();
        }
        return entrySet2;
    }

    int findEntry(@NullableDecl Object object, int n2, int[] nArray, int[] nArray2, Object[] objectArray) {
        n2 = nArray[this.bucket(n2)];
        while (n2 != -1) {
            if (Objects.equal(objectArray[n2], object)) {
                return n2;
            }
            n2 = nArray2[n2];
        }
        return -1;
    }

    int findEntryByKey(@NullableDecl Object object) {
        return this.findEntryByKey(object, Hashing.smearedHash(object));
    }

    int findEntryByKey(@NullableDecl Object object, int n2) {
        return this.findEntry(object, n2, this.hashTableKToV, this.nextInBucketKToV, this.keys);
    }

    int findEntryByValue(@NullableDecl Object object) {
        return this.findEntryByValue(object, Hashing.smearedHash(object));
    }

    int findEntryByValue(@NullableDecl Object object, int n2) {
        return this.findEntry(object, n2, this.hashTableVToK, this.nextInBucketVToK, this.values);
    }

    @Override
    @NullableDecl
    public V forcePut(@NullableDecl K k2, @NullableDecl V v2) {
        return this.put(k2, v2, true);
    }

    @Override
    @NullableDecl
    public V get(@NullableDecl Object object) {
        int n2 = this.findEntryByKey(object);
        object = n2 == -1 ? null : this.values[n2];
        return (V)object;
    }

    @NullableDecl
    K getInverse(@NullableDecl Object object) {
        int n2 = this.findEntryByValue(object);
        object = n2 == -1 ? null : this.keys[n2];
        return (K)object;
    }

    void init(int n2) {
        CollectPreconditions.checkNonnegative((int)n2, (String)"expectedSize");
        int n3 = Hashing.closedTableSize(n2, 1.0);
        this.size = 0;
        this.keys = new Object[n2];
        this.values = new Object[n2];
        this.hashTableKToV = HashBiMap.createFilledWithAbsent(n3);
        this.hashTableVToK = HashBiMap.createFilledWithAbsent(n3);
        this.nextInBucketKToV = HashBiMap.createFilledWithAbsent(n2);
        this.nextInBucketVToK = HashBiMap.createFilledWithAbsent(n2);
        this.firstInInsertionOrder = -2;
        this.lastInInsertionOrder = -2;
        this.prevInInsertionOrder = HashBiMap.createFilledWithAbsent(n2);
        this.nextInInsertionOrder = HashBiMap.createFilledWithAbsent(n2);
    }

    @Override
    public BiMap<V, K> inverse() {
        BiMap<K, V> biMap;
        BiMap<K, V> biMap2 = biMap = this.inverse;
        if (biMap == null) {
            biMap2 = new Inverse(this);
            this.inverse = biMap2;
        }
        return biMap2;
    }

    @Override
    public Set<K> keySet() {
        KeySet keySet;
        KeySet keySet2 = keySet = this.keySet;
        if (keySet == null) {
            this.keySet = keySet2 = new KeySet();
        }
        return keySet2;
    }

    @Override
    public V put(@NullableDecl K k2, @NullableDecl V v2) {
        return this.put(k2, v2, false);
    }

    @NullableDecl
    V put(@NullableDecl K object, @NullableDecl V v2, boolean bl) {
        int n2 = Hashing.smearedHash(object);
        int n3 = this.findEntryByKey(object, n2);
        if (n3 != -1) {
            object = this.values[n3];
            if (Objects.equal(object, v2)) {
                return v2;
            }
            this.replaceValueInEntry(n3, v2, bl);
            return (V)object;
        }
        n3 = Hashing.smearedHash(v2);
        int n4 = this.findEntryByValue(v2, n3);
        if (bl) {
            if (n4 != -1) {
                this.removeEntryValueHashKnown(n4, n3);
            }
        } else {
            bl = n4 == -1;
            Preconditions.checkArgument(bl, "Value already present: %s", v2);
        }
        this.ensureCapacity(this.size + 1);
        K[] KArray = this.keys;
        n4 = this.size;
        KArray[n4] = object;
        this.values[n4] = v2;
        this.insertIntoTableKToV(n4, n2);
        this.insertIntoTableVToK(this.size, n3);
        this.setSucceeds(this.lastInInsertionOrder, this.size);
        this.setSucceeds(this.size, -2);
        ++this.size;
        ++this.modCount;
        return null;
    }

    @NullableDecl
    K putInverse(@NullableDecl V object, @NullableDecl K k2, boolean bl) {
        int n2 = Hashing.smearedHash(object);
        int n3 = this.findEntryByValue(object, n2);
        if (n3 != -1) {
            object = this.keys[n3];
            if (Objects.equal(object, k2)) {
                return k2;
            }
            this.replaceKeyInEntry(n3, k2, bl);
            return (K)object;
        }
        n3 = this.lastInInsertionOrder;
        int n4 = Hashing.smearedHash(k2);
        int n5 = this.findEntryByKey(k2, n4);
        if (bl) {
            if (n5 != -1) {
                n3 = this.prevInInsertionOrder[n5];
                this.removeEntryKeyHashKnown(n5, n4);
            }
        } else {
            bl = n5 == -1;
            Preconditions.checkArgument(bl, "Key already present: %s", k2);
        }
        this.ensureCapacity(this.size + 1);
        K[] KArray = this.keys;
        n5 = this.size;
        KArray[n5] = k2;
        this.values[n5] = object;
        this.insertIntoTableKToV(n5, n4);
        this.insertIntoTableVToK(this.size, n2);
        n2 = n3 == -2 ? this.firstInInsertionOrder : this.nextInInsertionOrder[n3];
        this.setSucceeds(n3, this.size);
        this.setSucceeds(this.size, n2);
        ++this.size;
        ++this.modCount;
        return null;
    }

    @Override
    @NullableDecl
    public V remove(@NullableDecl Object object) {
        int n2 = Hashing.smearedHash(object);
        int n3 = this.findEntryByKey(object, n2);
        if (n3 == -1) {
            return null;
        }
        object = this.values[n3];
        this.removeEntryKeyHashKnown(n3, n2);
        return (V)object;
    }

    void removeEntry(int n2) {
        this.removeEntryKeyHashKnown(n2, Hashing.smearedHash(this.keys[n2]));
    }

    void removeEntryKeyHashKnown(int n2, int n3) {
        this.removeEntry(n2, n3, Hashing.smearedHash(this.values[n2]));
    }

    void removeEntryValueHashKnown(int n2, int n3) {
        this.removeEntry(n2, Hashing.smearedHash(this.keys[n2]), n3);
    }

    @NullableDecl
    K removeInverse(@NullableDecl Object object) {
        int n2 = Hashing.smearedHash(object);
        int n3 = this.findEntryByValue(object, n2);
        if (n3 == -1) {
            return null;
        }
        object = this.keys[n3];
        this.removeEntryValueHashKnown(n3, n2);
        return (K)object;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Set<V> values() {
        ValueSet valueSet;
        ValueSet valueSet2 = valueSet = this.valueSet;
        if (valueSet == null) {
            this.valueSet = valueSet2 = new ValueSet();
        }
        return valueSet2;
    }

    final class EntryForKey
    extends AbstractMapEntry<K, V> {
        int index;
        @NullableDecl
        final K key;

        EntryForKey(int n2) {
            this.key = HashBiMap.this.keys[n2];
            this.index = n2;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        @NullableDecl
        public V getValue() {
            this.updateIndex();
            Object v2 = this.index == -1 ? null : (Object)HashBiMap.this.values[this.index];
            return v2;
        }

        @Override
        public V setValue(V v2) {
            this.updateIndex();
            if (this.index == -1) {
                return HashBiMap.this.put(this.key, v2);
            }
            Object v3 = HashBiMap.this.values[this.index];
            if (Objects.equal(v3, v2)) {
                return v2;
            }
            HashBiMap.this.replaceValueInEntry(this.index, v2, false);
            return v3;
        }

        void updateIndex() {
            int n2 = this.index;
            if (n2 == -1 || n2 > HashBiMap.this.size || !Objects.equal(HashBiMap.this.keys[this.index], this.key)) {
                this.index = HashBiMap.this.findEntryByKey(this.key);
            }
        }
    }

    static final class EntryForValue<K, V>
    extends AbstractMapEntry<V, K> {
        final HashBiMap<K, V> biMap;
        int index;
        final V value;

        EntryForValue(HashBiMap<K, V> hashBiMap, int n2) {
            this.biMap = hashBiMap;
            this.value = hashBiMap.values[n2];
            this.index = n2;
        }

        private void updateIndex() {
            int n2 = this.index;
            if (n2 == -1 || n2 > this.biMap.size || !Objects.equal(this.value, this.biMap.values[this.index])) {
                this.index = this.biMap.findEntryByValue(this.value);
            }
        }

        @Override
        public V getKey() {
            return this.value;
        }

        @Override
        public K getValue() {
            this.updateIndex();
            K k2 = this.index == -1 ? null : (K)this.biMap.keys[this.index];
            return k2;
        }

        @Override
        public K setValue(K k2) {
            this.updateIndex();
            if (this.index == -1) {
                return this.biMap.putInverse(this.value, k2, false);
            }
            Object k3 = this.biMap.keys[this.index];
            if (Objects.equal(k3, k2)) {
                return k2;
            }
            ((HashBiMap)this.biMap).replaceKeyInEntry(this.index, k2, false);
            return k3;
        }
    }

    final class EntrySet
    extends View<K, V, Map.Entry<K, V>> {
        EntrySet() {
            super(HashBiMap.this);
        }

        @Override
        public boolean contains(@NullableDecl Object object) {
            boolean bl;
            boolean bl2 = object instanceof Map.Entry;
            boolean bl3 = bl = false;
            if (bl2) {
                Map.Entry entry = (Map.Entry)object;
                object = entry.getKey();
                entry = entry.getValue();
                int n2 = HashBiMap.this.findEntryByKey(object);
                bl3 = bl;
                if (n2 != -1) {
                    bl3 = bl;
                    if (Objects.equal(entry, HashBiMap.this.values[n2])) {
                        bl3 = true;
                    }
                }
            }
            return bl3;
        }

        @Override
        Map.Entry<K, V> forEntry(int n2) {
            return new EntryForKey(n2);
        }

        @Override
        public boolean remove(@NullableDecl Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                object = entry.getKey();
                entry = entry.getValue();
                int n2 = Hashing.smearedHash(object);
                int n3 = HashBiMap.this.findEntryByKey(object, n2);
                if (n3 != -1 && Objects.equal(entry, HashBiMap.this.values[n3])) {
                    HashBiMap.this.removeEntryKeyHashKnown(n3, n2);
                    return true;
                }
            }
            return false;
        }
    }

    static class Inverse<K, V>
    extends AbstractMap<V, K>
    implements BiMap<V, K>,
    Serializable {
        private final HashBiMap<K, V> forward;
        private transient Set<Map.Entry<V, K>> inverseEntrySet;

        Inverse(HashBiMap<K, V> hashBiMap) {
            this.forward = hashBiMap;
        }

        private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
            objectInputStream.defaultReadObject();
            HashBiMap.access$302(this.forward, this);
        }

        @Override
        public void clear() {
            this.forward.clear();
        }

        @Override
        public boolean containsKey(@NullableDecl Object object) {
            return this.forward.containsValue(object);
        }

        @Override
        public boolean containsValue(@NullableDecl Object object) {
            return this.forward.containsKey(object);
        }

        @Override
        public Set<Map.Entry<V, K>> entrySet() {
            Set<Map.Entry<V, K>> set;
            Set<Map.Entry<V, K>> set2 = set = this.inverseEntrySet;
            if (set == null) {
                this.inverseEntrySet = set2 = new InverseEntrySet<K, V>(this.forward);
            }
            return set2;
        }

        @Override
        @NullableDecl
        public K forcePut(@NullableDecl V v2, @NullableDecl K k2) {
            return this.forward.putInverse(v2, k2, true);
        }

        @Override
        @NullableDecl
        public K get(@NullableDecl Object object) {
            return this.forward.getInverse(object);
        }

        @Override
        public BiMap<K, V> inverse() {
            return this.forward;
        }

        @Override
        public Set<V> keySet() {
            return this.forward.values();
        }

        @Override
        @NullableDecl
        public K put(@NullableDecl V v2, @NullableDecl K k2) {
            return this.forward.putInverse(v2, k2, false);
        }

        @Override
        @NullableDecl
        public K remove(@NullableDecl Object object) {
            return this.forward.removeInverse(object);
        }

        @Override
        public int size() {
            return this.forward.size;
        }

        @Override
        public Set<K> values() {
            return this.forward.keySet();
        }
    }

    static class InverseEntrySet<K, V>
    extends View<K, V, Map.Entry<V, K>> {
        InverseEntrySet(HashBiMap<K, V> hashBiMap) {
            super(hashBiMap);
        }

        @Override
        public boolean contains(@NullableDecl Object object) {
            boolean bl;
            boolean bl2 = object instanceof Map.Entry;
            boolean bl3 = bl = false;
            if (bl2) {
                Map.Entry entry = (Map.Entry)object;
                object = entry.getKey();
                entry = entry.getValue();
                int n2 = this.biMap.findEntryByValue(object);
                bl3 = bl;
                if (n2 != -1) {
                    bl3 = bl;
                    if (Objects.equal(this.biMap.keys[n2], entry)) {
                        bl3 = true;
                    }
                }
            }
            return bl3;
        }

        @Override
        Map.Entry<V, K> forEntry(int n2) {
            return new EntryForValue(this.biMap, n2);
        }

        @Override
        public boolean remove(Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                object = entry.getKey();
                entry = entry.getValue();
                int n2 = Hashing.smearedHash(object);
                int n3 = this.biMap.findEntryByValue(object, n2);
                if (n3 != -1 && Objects.equal(this.biMap.keys[n3], entry)) {
                    this.biMap.removeEntryValueHashKnown(n3, n2);
                    return true;
                }
            }
            return false;
        }
    }

    final class KeySet
    extends View<K, V, K> {
        KeySet() {
            super(HashBiMap.this);
        }

        @Override
        public boolean contains(@NullableDecl Object object) {
            return HashBiMap.this.containsKey(object);
        }

        @Override
        K forEntry(int n2) {
            return HashBiMap.this.keys[n2];
        }

        @Override
        public boolean remove(@NullableDecl Object object) {
            int n2 = Hashing.smearedHash(object);
            int n3 = HashBiMap.this.findEntryByKey(object, n2);
            if (n3 != -1) {
                HashBiMap.this.removeEntryKeyHashKnown(n3, n2);
                return true;
            }
            return false;
        }
    }

    final class ValueSet
    extends View<K, V, V> {
        ValueSet() {
            super(HashBiMap.this);
        }

        @Override
        public boolean contains(@NullableDecl Object object) {
            return HashBiMap.this.containsValue(object);
        }

        @Override
        V forEntry(int n2) {
            return HashBiMap.this.values[n2];
        }

        @Override
        public boolean remove(@NullableDecl Object object) {
            int n2 = Hashing.smearedHash(object);
            int n3 = HashBiMap.this.findEntryByValue(object, n2);
            if (n3 != -1) {
                HashBiMap.this.removeEntryValueHashKnown(n3, n2);
                return true;
            }
            return false;
        }
    }

    static abstract class View<K, V, T>
    extends AbstractSet<T> {
        final HashBiMap<K, V> biMap;

        View(HashBiMap<K, V> hashBiMap) {
            this.biMap = hashBiMap;
        }

        @Override
        public void clear() {
            this.biMap.clear();
        }

        abstract T forEntry(int var1);

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                private int expectedModCount;
                private int index;
                private int indexToRemove;
                private int remaining;
                {
                    this.index = View.this.biMap.firstInInsertionOrder;
                    this.indexToRemove = -1;
                    this.expectedModCount = View.this.biMap.modCount;
                    this.remaining = View.this.biMap.size;
                }

                private void checkForComodification() {
                    if (View.this.biMap.modCount == this.expectedModCount) {
                        return;
                    }
                    throw new ConcurrentModificationException();
                }

                @Override
                public boolean hasNext() {
                    this.checkForComodification();
                    boolean bl = this.index != -2 && this.remaining > 0;
                    return bl;
                }

                @Override
                public T next() {
                    if (this.hasNext()) {
                        Object t2 = View.this.forEntry(this.index);
                        this.indexToRemove = this.index;
                        this.index = View.this.biMap.nextInInsertionOrder[this.index];
                        --this.remaining;
                        return t2;
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    this.checkForComodification();
                    boolean bl = this.indexToRemove != -1;
                    CollectPreconditions.checkRemove((boolean)bl);
                    View.this.biMap.removeEntry(this.indexToRemove);
                    if (this.index == View.this.biMap.size) {
                        this.index = this.indexToRemove;
                    }
                    this.indexToRemove = -1;
                    this.expectedModCount = View.this.biMap.modCount;
                }
            };
        }

        @Override
        public int size() {
            return this.biMap.size;
        }
    }
}

