/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.BoundType;
import com.google.common.collect.Ordering;
import com.google.common.collect.Range;
import java.io.Serializable;
import java.util.Comparator;
import org.checkerframework.checker.nullness.compatqual.MonotonicNonNullDecl;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

final class GeneralRange<T>
implements Serializable {
    private final Comparator<? super T> comparator;
    private final boolean hasLowerBound;
    private final boolean hasUpperBound;
    private final BoundType lowerBoundType;
    @NullableDecl
    private final T lowerEndpoint;
    @MonotonicNonNullDecl
    private transient GeneralRange<T> reverse;
    private final BoundType upperBoundType;
    @NullableDecl
    private final T upperEndpoint;

    private GeneralRange(Comparator<? super T> comparator, boolean bl, @NullableDecl T t2, BoundType boundType, boolean bl2, @NullableDecl T t3, BoundType boundType2) {
        this.comparator = Preconditions.checkNotNull(comparator);
        this.hasLowerBound = bl;
        this.hasUpperBound = bl2;
        this.lowerEndpoint = t2;
        this.lowerBoundType = Preconditions.checkNotNull(boundType);
        this.upperEndpoint = t3;
        this.upperBoundType = Preconditions.checkNotNull(boundType2);
        if (bl) {
            comparator.compare(t2, t2);
        }
        if (bl2) {
            comparator.compare(t3, t3);
        }
        if (bl && bl2) {
            int n2 = comparator.compare(t2, t3);
            int n3 = 1;
            bl = n2 <= 0;
            Preconditions.checkArgument(bl, "lowerEndpoint (%s) > upperEndpoint (%s)", t2, t3);
            if (n2 == 0) {
                n2 = boundType != BoundType.OPEN ? 1 : 0;
                if (boundType2 == BoundType.OPEN) {
                    n3 = 0;
                }
                Preconditions.checkArgument((n2 | n3) != 0);
            }
        }
    }

    static <T> GeneralRange<T> all(Comparator<? super T> comparator) {
        return new GeneralRange<Object>(comparator, false, null, BoundType.OPEN, false, null, BoundType.OPEN);
    }

    static <T> GeneralRange<T> downTo(Comparator<? super T> comparator, @NullableDecl T t2, BoundType boundType) {
        return new GeneralRange<Object>((Comparator<Object>)comparator, true, t2, boundType, false, null, BoundType.OPEN);
    }

    static <T extends Comparable> GeneralRange<T> from(Range<T> range) {
        boolean bl = range.hasLowerBound();
        T t2 = null;
        T t3 = bl ? (T)range.lowerEndpoint() : null;
        BoundType boundType = range.hasLowerBound() ? range.lowerBoundType() : BoundType.OPEN;
        if (range.hasUpperBound()) {
            t2 = range.upperEndpoint();
        }
        BoundType boundType2 = range.hasUpperBound() ? range.upperBoundType() : BoundType.OPEN;
        return new GeneralRange<Object>(Ordering.natural(), range.hasLowerBound(), t3, boundType, range.hasUpperBound(), t2, boundType2);
    }

    static <T> GeneralRange<T> range(Comparator<? super T> comparator, @NullableDecl T t2, BoundType boundType, @NullableDecl T t3, BoundType boundType2) {
        return new GeneralRange<T>(comparator, true, t2, boundType, true, t3, boundType2);
    }

    static <T> GeneralRange<T> upTo(Comparator<? super T> comparator, @NullableDecl T t2, BoundType boundType) {
        return new GeneralRange<Object>((Comparator<Object>)comparator, false, null, BoundType.OPEN, true, t2, boundType);
    }

    Comparator<? super T> comparator() {
        return this.comparator;
    }

    boolean contains(@NullableDecl T t2) {
        boolean bl = !this.tooLow(t2) && !this.tooHigh(t2);
        return bl;
    }

    public boolean equals(@NullableDecl Object object) {
        boolean bl;
        boolean bl2 = object instanceof GeneralRange;
        boolean bl3 = bl = false;
        if (bl2) {
            object = (GeneralRange)object;
            bl3 = bl;
            if (this.comparator.equals(((GeneralRange)object).comparator)) {
                bl3 = bl;
                if (this.hasLowerBound == ((GeneralRange)object).hasLowerBound) {
                    bl3 = bl;
                    if (this.hasUpperBound == ((GeneralRange)object).hasUpperBound) {
                        bl3 = bl;
                        if (this.getLowerBoundType().equals((Object)((GeneralRange)object).getLowerBoundType())) {
                            bl3 = bl;
                            if (this.getUpperBoundType().equals((Object)((GeneralRange)object).getUpperBoundType())) {
                                bl3 = bl;
                                if (Objects.equal(this.getLowerEndpoint(), ((GeneralRange)object).getLowerEndpoint())) {
                                    bl3 = bl;
                                    if (Objects.equal(this.getUpperEndpoint(), ((GeneralRange)object).getUpperEndpoint())) {
                                        bl3 = true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return bl3;
    }

    BoundType getLowerBoundType() {
        return this.lowerBoundType;
    }

    T getLowerEndpoint() {
        return this.lowerEndpoint;
    }

    BoundType getUpperBoundType() {
        return this.upperBoundType;
    }

    T getUpperEndpoint() {
        return this.upperEndpoint;
    }

    boolean hasLowerBound() {
        return this.hasLowerBound;
    }

    boolean hasUpperBound() {
        return this.hasUpperBound;
    }

    public int hashCode() {
        return Objects.hashCode(this.comparator, this.getLowerEndpoint(), this.getLowerBoundType(), this.getUpperEndpoint(), this.getUpperBoundType());
    }

    GeneralRange<T> intersect(GeneralRange<T> generalRange) {
        int n2;
        BoundType boundType;
        Object object;
        boolean bl;
        Object object2;
        Object object3;
        boolean bl2;
        block12: {
            boolean bl3;
            block13: {
                BoundType boundType2;
                T t2;
                block11: {
                    block9: {
                        block10: {
                            block8: {
                                Preconditions.checkNotNull(generalRange);
                                Preconditions.checkArgument(this.comparator.equals(generalRange.comparator));
                                bl2 = this.hasLowerBound;
                                object3 = this.getLowerEndpoint();
                                object2 = this.getLowerBoundType();
                                if (this.hasLowerBound()) break block8;
                                bl = generalRange.hasLowerBound;
                                object = generalRange.getLowerEndpoint();
                                boundType = generalRange.getLowerBoundType();
                                break block9;
                            }
                            bl = bl2;
                            object = object3;
                            boundType = object2;
                            if (!generalRange.hasLowerBound()) break block9;
                            n2 = this.comparator.compare(this.getLowerEndpoint(), generalRange.getLowerEndpoint());
                            if (n2 < 0) break block10;
                            bl = bl2;
                            object = object3;
                            boundType = object2;
                            if (n2 != 0) break block9;
                            bl = bl2;
                            object = object3;
                            boundType = object2;
                            if (generalRange.getLowerBoundType() != BoundType.OPEN) break block9;
                        }
                        object = generalRange.getLowerEndpoint();
                        boundType = generalRange.getLowerBoundType();
                        bl = bl2;
                    }
                    bl3 = this.hasUpperBound;
                    t2 = this.getUpperEndpoint();
                    boundType2 = this.getUpperBoundType();
                    if (this.hasUpperBound()) break block11;
                    bl2 = generalRange.hasUpperBound;
                    object2 = generalRange.getUpperEndpoint();
                    object3 = generalRange.getUpperBoundType();
                    break block12;
                }
                bl2 = bl3;
                object2 = t2;
                object3 = boundType2;
                if (!generalRange.hasUpperBound()) break block12;
                n2 = this.comparator.compare(this.getUpperEndpoint(), generalRange.getUpperEndpoint());
                if (n2 > 0) break block13;
                bl2 = bl3;
                object2 = t2;
                object3 = boundType2;
                if (n2 != 0) break block12;
                bl2 = bl3;
                object2 = t2;
                object3 = boundType2;
                if (generalRange.getUpperBoundType() != BoundType.OPEN) break block12;
            }
            object2 = generalRange.getUpperEndpoint();
            object3 = generalRange.getUpperBoundType();
            bl2 = bl3;
        }
        if (bl && bl2 && ((n2 = this.comparator.compare((BoundType)object, (BoundType)object2)) > 0 || n2 == 0 && boundType == BoundType.OPEN && object3 == BoundType.OPEN)) {
            boundType = BoundType.OPEN;
            object = BoundType.CLOSED;
            generalRange = object2;
        } else {
            generalRange = object;
            object = object3;
        }
        return new GeneralRange<BoundType>((Comparator<BoundType>)this.comparator, bl, (BoundType)generalRange, boundType, bl2, (BoundType)object2, (BoundType)object);
    }

    boolean isEmpty() {
        boolean bl = this.hasUpperBound() && this.tooLow(this.getUpperEndpoint()) || this.hasLowerBound() && this.tooHigh(this.getLowerEndpoint());
        return bl;
    }

    GeneralRange<T> reverse() {
        GeneralRange<T> generalRange;
        GeneralRange<Object> generalRange2 = generalRange = this.reverse;
        if (generalRange == null) {
            generalRange2 = new GeneralRange(Ordering.from(this.comparator).reverse(), this.hasUpperBound, this.getUpperEndpoint(), this.getUpperBoundType(), this.hasLowerBound, this.getLowerEndpoint(), this.getLowerBoundType());
            generalRange2.reverse = this;
            this.reverse = generalRange2;
        }
        return generalRange2;
    }

    public String toString() {
        char c2;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.comparator);
        stringBuilder.append(":");
        char c3 = this.lowerBoundType == BoundType.CLOSED ? (c2 = '[') : (c2 = '(');
        stringBuilder.append(c3);
        String string2 = this.hasLowerBound ? this.lowerEndpoint : "-\u221e";
        stringBuilder.append((Object)string2);
        stringBuilder.append(',');
        string2 = this.hasUpperBound ? this.upperEndpoint : "\u221e";
        stringBuilder.append((Object)string2);
        c3 = this.upperBoundType == BoundType.CLOSED ? (c2 = ']') : (c2 = ')');
        stringBuilder.append(c3);
        return stringBuilder.toString();
    }

    boolean tooHigh(@NullableDecl T t2) {
        if (!this.hasUpperBound()) {
            return false;
        }
        T t3 = this.getUpperEndpoint();
        int n2 = this.comparator.compare(t2, t3);
        int n3 = 1;
        int n4 = n2 > 0 ? 1 : 0;
        n2 = n2 == 0 ? 1 : 0;
        if (this.getUpperBoundType() != BoundType.OPEN) {
            n3 = 0;
        }
        return (n2 & n3 | n4) != 0;
    }

    boolean tooLow(@NullableDecl T t2) {
        if (!this.hasLowerBound()) {
            return false;
        }
        T t3 = this.getLowerEndpoint();
        int n2 = this.comparator.compare(t2, t3);
        int n3 = 1;
        int n4 = n2 < 0 ? 1 : 0;
        n2 = n2 == 0 ? 1 : 0;
        if (this.getLowerBoundType() != BoundType.OPEN) {
            n3 = 0;
        }
        return (n2 & n3 | n4) != 0;
    }
}

