/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.ForwardingSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public abstract class ForwardingSortedSet<E>
extends ForwardingSet<E>
implements SortedSet<E> {
    protected ForwardingSortedSet() {
    }

    private int unsafeCompare(@NullableDecl Object object, @NullableDecl Object object2) {
        Comparator<E> comparator = this.comparator();
        int n2 = comparator == null ? ((Comparable)object).compareTo(object2) : comparator.compare(object, object2);
        return n2;
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.delegate().comparator();
    }

    @Override
    protected abstract SortedSet<E> delegate();

    @Override
    public E first() {
        return this.delegate().first();
    }

    @Override
    public SortedSet<E> headSet(E e2) {
        return this.delegate().headSet(e2);
    }

    @Override
    public E last() {
        return this.delegate().last();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean standardContains(@NullableDecl Object object) {
        boolean bl = false;
        try {
            int n2 = this.unsafeCompare(this.tailSet(object).first(), object);
            if (n2 != 0) return bl;
            return true;
        }
        catch (ClassCastException | NullPointerException | NoSuchElementException runtimeException) {
            return bl;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean standardRemove(@NullableDecl Object object) {
        block3: {
            try {
                Iterator iterator2 = this.tailSet(object).iterator();
                if (!iterator2.hasNext() || this.unsafeCompare(iterator2.next(), object) != 0) break block3;
                iterator2.remove();
                return true;
            }
            catch (ClassCastException | NullPointerException runtimeException) {
                return false;
            }
        }
        return false;
    }

    protected SortedSet<E> standardSubSet(E e2, E e3) {
        return this.tailSet(e2).headSet(e3);
    }

    @Override
    public SortedSet<E> subSet(E e2, E e3) {
        return this.delegate().subSet(e2, e3);
    }

    @Override
    public SortedSet<E> tailSet(E e2) {
        return this.delegate().tailSet(e2);
    }
}

