/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.Maps;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public abstract class ForwardingSortedMap<K, V>
extends ForwardingMap<K, V>
implements SortedMap<K, V> {
    protected ForwardingSortedMap() {
    }

    private int unsafeCompare(Object object, Object object2) {
        Comparator<K> comparator = this.comparator();
        if (comparator == null) {
            return ((Comparable)object).compareTo(object2);
        }
        return comparator.compare(object, object2);
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.delegate().comparator();
    }

    @Override
    protected abstract SortedMap<K, V> delegate();

    @Override
    public K firstKey() {
        return this.delegate().firstKey();
    }

    @Override
    public SortedMap<K, V> headMap(K k2) {
        return this.delegate().headMap(k2);
    }

    @Override
    public K lastKey() {
        return this.delegate().lastKey();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean standardContainsKey(@NullableDecl Object object) {
        boolean bl = false;
        try {
            int n2 = this.unsafeCompare(this.tailMap(object).firstKey(), object);
            if (n2 != 0) return bl;
            return true;
        }
        catch (ClassCastException | NullPointerException | NoSuchElementException runtimeException) {
            return bl;
        }
    }

    protected SortedMap<K, V> standardSubMap(K k2, K k3) {
        boolean bl = this.unsafeCompare(k2, k3) <= 0;
        Preconditions.checkArgument(bl, "fromKey must be <= toKey");
        return this.tailMap(k2).headMap(k3);
    }

    @Override
    public SortedMap<K, V> subMap(K k2, K k3) {
        return this.delegate().subMap(k2, k3);
    }

    @Override
    public SortedMap<K, V> tailMap(K k2) {
        return this.delegate().tailMap(k2);
    }

    protected class StandardKeySet
    extends Maps.SortedKeySet<K, V> {
        public StandardKeySet() {
            super(ForwardingSortedMap.this);
        }
    }
}

