/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Objects;
import com.google.common.collect.ForwardingCollection;
import com.google.common.collect.Iterators;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public abstract class ForwardingMultiset<E>
extends ForwardingCollection<E>
implements Multiset<E> {
    protected ForwardingMultiset() {
    }

    @Override
    public int add(E e2, int n2) {
        return this.delegate().add(e2, n2);
    }

    @Override
    public int count(Object object) {
        return this.delegate().count(object);
    }

    @Override
    protected abstract Multiset<E> delegate();

    @Override
    public Set<E> elementSet() {
        return this.delegate().elementSet();
    }

    @Override
    public Set<Multiset.Entry<E>> entrySet() {
        return this.delegate().entrySet();
    }

    @Override
    public boolean equals(@NullableDecl Object object) {
        boolean bl = object == this || this.delegate().equals(object);
        return bl;
    }

    @Override
    public int hashCode() {
        return this.delegate().hashCode();
    }

    @Override
    public int remove(Object object, int n2) {
        return this.delegate().remove(object, n2);
    }

    @Override
    public int setCount(E e2, int n2) {
        return this.delegate().setCount(e2, n2);
    }

    @Override
    public boolean setCount(E e2, int n2, int n3) {
        return this.delegate().setCount(e2, n2, n3);
    }

    protected boolean standardAdd(E e2) {
        this.add(e2, 1);
        return true;
    }

    @Override
    protected boolean standardAddAll(Collection<? extends E> collection) {
        return Multisets.addAllImpl(this, collection);
    }

    @Override
    protected void standardClear() {
        Iterators.clear(this.entrySet().iterator());
    }

    @Override
    protected boolean standardContains(@NullableDecl Object object) {
        boolean bl = this.count(object) > 0;
        return bl;
    }

    protected int standardCount(@NullableDecl Object object) {
        for (Multiset.Entry<E> entry : this.entrySet()) {
            if (!Objects.equal(entry.getElement(), object)) continue;
            return entry.getCount();
        }
        return 0;
    }

    protected boolean standardEquals(@NullableDecl Object object) {
        return Multisets.equalsImpl(this, object);
    }

    protected int standardHashCode() {
        return this.entrySet().hashCode();
    }

    protected Iterator<E> standardIterator() {
        return Multisets.iteratorImpl(this);
    }

    @Override
    protected boolean standardRemove(Object object) {
        boolean bl = true;
        if (this.remove(object, 1) <= 0) {
            bl = false;
        }
        return bl;
    }

    @Override
    protected boolean standardRemoveAll(Collection<?> collection) {
        return Multisets.removeAllImpl(this, collection);
    }

    @Override
    protected boolean standardRetainAll(Collection<?> collection) {
        return Multisets.retainAllImpl(this, collection);
    }

    protected int standardSetCount(E e2, int n2) {
        return Multisets.setCountImpl(this, e2, n2);
    }

    protected boolean standardSetCount(E e2, int n2, int n3) {
        return Multisets.setCountImpl(this, e2, n2, n3);
    }

    protected int standardSize() {
        return Multisets.linearTimeSizeImpl(this);
    }

    @Override
    protected String standardToString() {
        return this.entrySet().toString();
    }

    protected class StandardElementSet
    extends Multisets.ElementSet<E> {
        @Override
        public Iterator<E> iterator() {
            return Multisets.elementIterator(this.multiset().entrySet().iterator());
        }

        @Override
        Multiset<E> multiset() {
            return ForwardingMultiset.this;
        }
    }
}

