/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Objects;
import com.google.common.collect.ForwardingObject;
import java.util.Map;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public abstract class ForwardingMapEntry<K, V>
extends ForwardingObject
implements Map.Entry<K, V> {
    protected ForwardingMapEntry() {
    }

    @Override
    protected abstract Map.Entry<K, V> delegate();

    @Override
    public boolean equals(@NullableDecl Object object) {
        return this.delegate().equals(object);
    }

    @Override
    public K getKey() {
        return this.delegate().getKey();
    }

    @Override
    public V getValue() {
        return this.delegate().getValue();
    }

    @Override
    public int hashCode() {
        return this.delegate().hashCode();
    }

    @Override
    public V setValue(V v2) {
        return this.delegate().setValue(v2);
    }

    protected boolean standardEquals(@NullableDecl Object object) {
        boolean bl;
        boolean bl2 = object instanceof Map.Entry;
        boolean bl3 = bl = false;
        if (bl2) {
            object = (Map.Entry)object;
            bl3 = bl;
            if (Objects.equal(this.getKey(), object.getKey())) {
                bl3 = bl;
                if (Objects.equal(this.getValue(), object.getValue())) {
                    bl3 = true;
                }
            }
        }
        return bl3;
    }

    protected int standardHashCode() {
        K k2 = this.getKey();
        V v2 = this.getValue();
        int n2 = 0;
        int n3 = k2 == null ? 0 : k2.hashCode();
        if (v2 != null) {
            n2 = v2.hashCode();
        }
        return n3 ^ n2;
    }

    protected String standardToString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getKey());
        stringBuilder.append("=");
        stringBuilder.append(this.getValue());
        return stringBuilder.toString();
    }
}

