/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.ForwardingCollection;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public abstract class ForwardingList<E>
extends ForwardingCollection<E>
implements List<E> {
    protected ForwardingList() {
    }

    @Override
    public void add(int n2, E e2) {
        this.delegate().add(n2, e2);
    }

    @Override
    public boolean addAll(int n2, Collection<? extends E> collection) {
        return this.delegate().addAll(n2, collection);
    }

    @Override
    protected abstract List<E> delegate();

    @Override
    public boolean equals(@NullableDecl Object object) {
        boolean bl = object == this || this.delegate().equals(object);
        return bl;
    }

    @Override
    public E get(int n2) {
        return this.delegate().get(n2);
    }

    @Override
    public int hashCode() {
        return this.delegate().hashCode();
    }

    @Override
    public int indexOf(Object object) {
        return this.delegate().indexOf(object);
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.delegate().lastIndexOf(object);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.delegate().listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int n2) {
        return this.delegate().listIterator(n2);
    }

    @Override
    public E remove(int n2) {
        return this.delegate().remove(n2);
    }

    @Override
    public E set(int n2, E e2) {
        return this.delegate().set(n2, e2);
    }

    protected boolean standardAdd(E e2) {
        this.add(this.size(), e2);
        return true;
    }

    protected boolean standardAddAll(int n2, Iterable<? extends E> iterable) {
        return Lists.addAllImpl(this, n2, iterable);
    }

    protected boolean standardEquals(@NullableDecl Object object) {
        return Lists.equalsImpl(this, object);
    }

    protected int standardHashCode() {
        return Lists.hashCodeImpl(this);
    }

    protected int standardIndexOf(@NullableDecl Object object) {
        return Lists.indexOfImpl(this, object);
    }

    protected Iterator<E> standardIterator() {
        return this.listIterator();
    }

    protected int standardLastIndexOf(@NullableDecl Object object) {
        return Lists.lastIndexOfImpl(this, object);
    }

    protected ListIterator<E> standardListIterator() {
        return this.listIterator(0);
    }

    protected ListIterator<E> standardListIterator(int n2) {
        return Lists.listIteratorImpl(this, n2);
    }

    protected List<E> standardSubList(int n2, int n3) {
        return Lists.subListImpl(this, n2, n3);
    }

    @Override
    public List<E> subList(int n2, int n3) {
        return this.delegate().subList(n2, n3);
    }
}

