/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import java.io.Serializable;
import java.util.List;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

final class ExplicitOrdering<T>
extends Ordering<T>
implements Serializable {
    private static final long serialVersionUID = 0L;
    final ImmutableMap<T, Integer> rankMap;

    ExplicitOrdering(ImmutableMap<T, Integer> immutableMap) {
        this.rankMap = immutableMap;
    }

    ExplicitOrdering(List<T> list) {
        this(Maps.indexMap(list));
    }

    private int rank(T t2) {
        Integer n2 = this.rankMap.get(t2);
        if (n2 != null) {
            return n2;
        }
        throw new Ordering.IncomparableValueException(t2);
    }

    @Override
    public int compare(T t2, T t3) {
        return this.rank(t2) - this.rank(t3);
    }

    @Override
    public boolean equals(@NullableDecl Object object) {
        if (object instanceof ExplicitOrdering) {
            object = (ExplicitOrdering)object;
            return this.rankMap.equals(((ExplicitOrdering)object).rankMap);
        }
        return false;
    }

    public int hashCode() {
        return this.rankMap.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Ordering.explicit(");
        stringBuilder.append(this.rankMap.keySet());
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

