/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractMultiset;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.Serialization;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class EnumMultiset<E extends Enum<E>>
extends AbstractMultiset<E>
implements Serializable {
    private static final long serialVersionUID = 0L;
    private transient int[] counts;
    private transient int distinctElements;
    private transient E[] enumConstants;
    private transient long size;
    private transient Class<E> type;

    private EnumMultiset(Class<E> clazz) {
        this.type = clazz;
        Preconditions.checkArgument(clazz.isEnum());
        this.enumConstants = (Enum[])clazz.getEnumConstants();
        this.counts = new int[this.enumConstants.length];
    }

    static /* synthetic */ int access$210(EnumMultiset enumMultiset) {
        int n2 = enumMultiset.distinctElements;
        enumMultiset.distinctElements = n2 - 1;
        return n2;
    }

    static /* synthetic */ long access$302(EnumMultiset enumMultiset, long l2) {
        enumMultiset.size = l2;
        return l2;
    }

    public static <E extends Enum<E>> EnumMultiset<E> create(Class<E> clazz) {
        return new EnumMultiset<E>(clazz);
    }

    public static <E extends Enum<E>> EnumMultiset<E> create(Iterable<E> iterable) {
        Object object = iterable.iterator();
        Preconditions.checkArgument(object.hasNext(), "EnumMultiset constructor passed empty Iterable");
        object = new EnumMultiset(((Enum)object.next()).getDeclaringClass());
        Iterables.addAll(object, iterable);
        return object;
    }

    public static <E extends Enum<E>> EnumMultiset<E> create(Iterable<E> iterable, Class<E> serializable) {
        serializable = EnumMultiset.create(serializable);
        Iterables.addAll(serializable, iterable);
        return serializable;
    }

    private boolean isActuallyE(@NullableDecl Object EArray) {
        boolean bl;
        boolean bl2 = EArray instanceof Enum;
        boolean bl3 = bl = false;
        if (bl2) {
            Enum enum_ = (Enum)EArray;
            int n2 = enum_.ordinal();
            EArray = this.enumConstants;
            bl3 = bl;
            if (n2 < EArray.length) {
                bl3 = bl;
                if (EArray[n2] == enum_) {
                    bl3 = true;
                }
            }
        }
        return bl3;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.type = (Class)objectInputStream.readObject();
        this.enumConstants = (Enum[])this.type.getEnumConstants();
        this.counts = new int[this.enumConstants.length];
        Serialization.populateMultiset((Multiset)this, (ObjectInputStream)objectInputStream);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.type);
        Serialization.writeMultiset((Multiset)this, (ObjectOutputStream)objectOutputStream);
    }

    @Override
    public int add(E e2, int n2) {
        this.checkIsE(e2);
        CollectPreconditions.checkNonnegative((int)n2, (String)"occurrences");
        if (n2 == 0) {
            return this.count(e2);
        }
        int n3 = ((Enum)e2).ordinal();
        int n4 = this.counts[n3];
        long l2 = n4;
        long l3 = n2;
        boolean bl = (l2 += l3) <= Integer.MAX_VALUE;
        Preconditions.checkArgument(bl, "too many occurrences: %s", l2);
        this.counts[n3] = (int)l2;
        if (n4 == 0) {
            ++this.distinctElements;
        }
        this.size += l3;
        return n4;
    }

    void checkIsE(@NullableDecl Object object) {
        Preconditions.checkNotNull(object);
        if (this.isActuallyE(object)) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Expected an ");
        stringBuilder.append(this.type);
        stringBuilder.append(" but got ");
        stringBuilder.append(object);
        throw new ClassCastException(stringBuilder.toString());
    }

    @Override
    public void clear() {
        Arrays.fill(this.counts, 0);
        this.size = 0L;
        this.distinctElements = 0;
    }

    @Override
    public int count(@NullableDecl Object object) {
        if (object != null && this.isActuallyE(object)) {
            object = (Enum)object;
            return this.counts[((Enum)object).ordinal()];
        }
        return 0;
    }

    @Override
    int distinctElements() {
        return this.distinctElements;
    }

    @Override
    Iterator<E> elementIterator() {
        return new Itr<E>(){

            @Override
            E output(int n2) {
                return EnumMultiset.this.enumConstants[n2];
            }
        };
    }

    @Override
    Iterator<Multiset.Entry<E>> entryIterator() {
        return new Itr<Multiset.Entry<E>>(){

            @Override
            Multiset.Entry<E> output(final int n2) {
                return new Multisets.AbstractEntry<E>(){

                    @Override
                    public int getCount() {
                        return EnumMultiset.this.counts[n2];
                    }

                    @Override
                    public E getElement() {
                        return EnumMultiset.this.enumConstants[n2];
                    }
                };
            }
        };
    }

    @Override
    public Iterator<E> iterator() {
        return Multisets.iteratorImpl(this);
    }

    @Override
    public int remove(@NullableDecl Object object, int n2) {
        if (object != null && this.isActuallyE(object)) {
            Enum enum_ = (Enum)object;
            CollectPreconditions.checkNonnegative((int)n2, (String)"occurrences");
            if (n2 == 0) {
                return this.count(object);
            }
            object = this.counts;
            int n3 = enum_.ordinal();
            Object object2 = object[n3];
            if (object2 == false) {
                return 0;
            }
            if (object2 <= n2) {
                object[n3] = false;
                --this.distinctElements;
                this.size -= (long)object2;
            } else {
                object[n3] = object2 - n2;
                this.size -= (long)n2;
            }
            return (int)object2;
        }
        return 0;
    }

    @Override
    public int setCount(E object, int n2) {
        this.checkIsE(object);
        CollectPreconditions.checkNonnegative((int)n2, (String)"count");
        int n3 = ((Enum)object).ordinal();
        object = this.counts;
        E e2 = object[n3];
        object[n3] = n2;
        this.size += (long)(n2 - e2);
        if (e2 == false && n2 > 0) {
            ++this.distinctElements;
        } else if (e2 > 0 && n2 == 0) {
            --this.distinctElements;
        }
        return (int)e2;
    }

    @Override
    public int size() {
        return Ints.saturatedCast(this.size);
    }

    abstract class Itr<T>
    implements Iterator<T> {
        int index = 0;
        int toRemove = -1;

        Itr() {
        }

        @Override
        public boolean hasNext() {
            while (this.index < EnumMultiset.this.enumConstants.length) {
                int n2;
                int[] nArray = EnumMultiset.this.counts;
                if (nArray[n2 = this.index] > 0) {
                    return true;
                }
                this.index = n2 + 1;
            }
            return false;
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                int n2;
                T t2 = this.output(this.index);
                this.toRemove = n2 = this.index;
                this.index = n2 + 1;
                return t2;
            }
            throw new NoSuchElementException();
        }

        abstract T output(int var1);

        @Override
        public void remove() {
            boolean bl = this.toRemove >= 0;
            CollectPreconditions.checkRemove((boolean)bl);
            if (EnumMultiset.this.counts[this.toRemove] > 0) {
                EnumMultiset.access$210(EnumMultiset.this);
                EnumMultiset enumMultiset = EnumMultiset.this;
                EnumMultiset.access$302(enumMultiset, enumMultiset.size - (long)EnumMultiset.this.counts[this.toRemove]);
                ((EnumMultiset)EnumMultiset.this).counts[this.toRemove] = 0;
            }
            this.toRemove = -1;
        }
    }
}

