/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractBiMap;
import com.google.common.collect.EnumBiMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Serialization;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class EnumHashBiMap<K extends Enum<K>, V>
extends AbstractBiMap<K, V> {
    private static final long serialVersionUID = 0L;
    private transient Class<K> keyType;

    private EnumHashBiMap(Class<K> clazz) {
        super(new EnumMap(clazz), Maps.newHashMapWithExpectedSize(((Enum[])clazz.getEnumConstants()).length));
        this.keyType = clazz;
    }

    public static <K extends Enum<K>, V> EnumHashBiMap<K, V> create(Class<K> clazz) {
        return new EnumHashBiMap<K, V>(clazz);
    }

    public static <K extends Enum<K>, V> EnumHashBiMap<K, V> create(Map<K, ? extends V> map) {
        EnumHashBiMap<K, V> enumHashBiMap = EnumHashBiMap.create(EnumBiMap.inferKeyType(map));
        enumHashBiMap.putAll((Map)map);
        return enumHashBiMap;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.keyType = (Class)objectInputStream.readObject();
        this.setDelegates(new EnumMap(this.keyType), new HashMap(((Enum[])this.keyType.getEnumConstants()).length * 3 / 2));
        Serialization.populateMap((Map)this, (ObjectInputStream)objectInputStream);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.keyType);
        Serialization.writeMap((Map)this, (ObjectOutputStream)objectOutputStream);
    }

    @Override
    K checkKey(K k2) {
        return (K)((Enum)Preconditions.checkNotNull(k2));
    }

    @Override
    public V forcePut(K k2, @NullableDecl V v2) {
        return super.forcePut(k2, v2);
    }

    public Class<K> keyType() {
        return this.keyType;
    }

    @Override
    public V put(K k2, @NullableDecl V v2) {
        return super.put(k2, v2);
    }
}

