/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.BoundType;
import com.google.common.collect.ForwardingMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.Ordering;
import com.google.common.collect.SortedMultiset;
import com.google.common.collect.SortedMultisets;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.Set;
import org.checkerframework.checker.nullness.compatqual.MonotonicNonNullDecl;

abstract class DescendingMultiset<E>
extends ForwardingMultiset<E>
implements SortedMultiset<E> {
    @MonotonicNonNullDecl
    private transient Comparator<? super E> comparator;
    @MonotonicNonNullDecl
    private transient NavigableSet<E> elementSet;
    @MonotonicNonNullDecl
    private transient Set<Multiset.Entry<E>> entrySet;

    DescendingMultiset() {
    }

    @Override
    public Comparator<? super E> comparator() {
        Comparator<E> comparator;
        Comparator<E> comparator2 = comparator = this.comparator;
        if (comparator == null) {
            comparator2 = Ordering.from(this.forwardMultiset().comparator()).reverse();
            this.comparator = comparator2;
        }
        return comparator2;
    }

    Set<Multiset.Entry<E>> createEntrySet() {
        return new 1EntrySetImpl();
    }

    @Override
    protected Multiset<E> delegate() {
        return this.forwardMultiset();
    }

    @Override
    public SortedMultiset<E> descendingMultiset() {
        return this.forwardMultiset();
    }

    @Override
    public NavigableSet<E> elementSet() {
        NavigableSet<E> navigableSet;
        NavigableSet<E> navigableSet2 = navigableSet = this.elementSet;
        if (navigableSet == null) {
            this.elementSet = navigableSet2 = new SortedMultisets.NavigableElementSet(this);
        }
        return navigableSet2;
    }

    abstract Iterator<Multiset.Entry<E>> entryIterator();

    @Override
    public Set<Multiset.Entry<E>> entrySet() {
        Set<Multiset.Entry<Multiset.Entry<Multiset.Entry<Multiset.Entry<E>>>>> set;
        Set<Multiset.Entry<Multiset.Entry<Multiset.Entry<Multiset.Entry<E>>>>> set2 = set = this.entrySet;
        if (set == null) {
            set2 = this.createEntrySet();
            this.entrySet = set2;
        }
        return set2;
    }

    @Override
    public Multiset.Entry<E> firstEntry() {
        return this.forwardMultiset().lastEntry();
    }

    abstract SortedMultiset<E> forwardMultiset();

    @Override
    public SortedMultiset<E> headMultiset(E e2, BoundType boundType) {
        return this.forwardMultiset().tailMultiset(e2, boundType).descendingMultiset();
    }

    @Override
    public Iterator<E> iterator() {
        return Multisets.iteratorImpl(this);
    }

    @Override
    public Multiset.Entry<E> lastEntry() {
        return this.forwardMultiset().firstEntry();
    }

    @Override
    public Multiset.Entry<E> pollFirstEntry() {
        return this.forwardMultiset().pollLastEntry();
    }

    @Override
    public Multiset.Entry<E> pollLastEntry() {
        return this.forwardMultiset().pollFirstEntry();
    }

    @Override
    public SortedMultiset<E> subMultiset(E e2, BoundType boundType, E e3, BoundType boundType2) {
        return this.forwardMultiset().subMultiset(e3, boundType2, e2, boundType).descendingMultiset();
    }

    @Override
    public SortedMultiset<E> tailMultiset(E e2, BoundType boundType) {
        return this.forwardMultiset().headMultiset(e2, boundType).descendingMultiset();
    }

    @Override
    public Object[] toArray() {
        return this.standardToArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.standardToArray(TArray);
    }

    @Override
    public String toString() {
        return this.entrySet().toString();
    }

    class 1EntrySetImpl
    extends Multisets.EntrySet<E> {
        1EntrySetImpl() {
        }

        @Override
        public Iterator<Multiset.Entry<E>> iterator() {
            return DescendingMultiset.this.entryIterator();
        }

        @Override
        Multiset<E> multiset() {
            return DescendingMultiset.this;
        }

        @Override
        public int size() {
            return DescendingMultiset.this.forwardMultiset().entrySet().size();
        }
    }
}

