/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Maps;
import com.google.common.collect.RegularImmutableTable;
import com.google.common.collect.Table;
import com.google.common.collect.UnmodifiableIterator;
import com.google.errorprone.annotations.Immutable;
import java.util.AbstractCollection;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

@Immutable(containerOf={"R", "C", "V"})
final class DenseImmutableTable<R, C, V>
extends RegularImmutableTable<R, C, V> {
    private final int[] cellColumnIndices;
    private final int[] cellRowIndices;
    private final int[] columnCounts;
    private final ImmutableMap<C, Integer> columnKeyToIndex;
    private final ImmutableMap<C, ImmutableMap<R, V>> columnMap;
    private final int[] rowCounts;
    private final ImmutableMap<R, Integer> rowKeyToIndex;
    private final ImmutableMap<R, ImmutableMap<C, V>> rowMap;
    private final V[][] values;

    DenseImmutableTable(ImmutableList<Table.Cell<R, C, V>> immutableList, ImmutableSet<R> object, ImmutableSet<C> object2) {
        this.values = new Object[((AbstractCollection)object).size()][((AbstractCollection)object2).size()];
        this.rowKeyToIndex = Maps.indexMap(object);
        this.columnKeyToIndex = Maps.indexMap(object2);
        this.rowCounts = new int[this.rowKeyToIndex.size()];
        this.columnCounts = new int[this.columnKeyToIndex.size()];
        object2 = new int[immutableList.size()];
        object = new int[immutableList.size()];
        for (int i2 = 0; i2 < immutableList.size(); ++i2) {
            Object object3 = (Table.Cell)immutableList.get(i2);
            Object r2 = object3.getRowKey();
            Object c2 = object3.getColumnKey();
            int n2 = this.rowKeyToIndex.get(r2);
            int n3 = this.columnKeyToIndex.get(c2);
            this.checkNoDuplicate(r2, c2, this.values[n2][n3], object3.getValue());
            this.values[n2][n3] = object3.getValue();
            object3 = this.rowCounts;
            object3[n2] = object3[n2] + true;
            object3 = this.columnCounts;
            object3[n3] = object3[n3] + true;
            object2[i2] = n2;
            object[i2] = n3;
        }
        this.cellRowIndices = (int[])object2;
        this.cellColumnIndices = (int[])object;
        this.rowMap = new RowMap();
        this.columnMap = new ColumnMap();
    }

    @Override
    public ImmutableMap<C, Map<R, V>> columnMap() {
        return ImmutableMap.copyOf(this.columnMap);
    }

    @Override
    ImmutableTable.SerializedForm createSerializedForm() {
        return ImmutableTable.SerializedForm.create(this, this.cellRowIndices, this.cellColumnIndices);
    }

    @Override
    public V get(@NullableDecl Object object, @NullableDecl Object object2) {
        object = this.rowKeyToIndex.get(object);
        object2 = this.columnKeyToIndex.get(object2);
        object = object != null && object2 != null ? this.values[(Integer)object][(Integer)object2] : null;
        return (V)object;
    }

    @Override
    Table.Cell<R, C, V> getCell(int n2) {
        int n3 = this.cellRowIndices[n2];
        n2 = this.cellColumnIndices[n2];
        return DenseImmutableTable.cellOf(((ImmutableSet)this.rowKeySet()).asList().get(n3), ((ImmutableSet)this.columnKeySet()).asList().get(n2), this.values[n3][n2]);
    }

    @Override
    V getValue(int n2) {
        return this.values[this.cellRowIndices[n2]][this.cellColumnIndices[n2]];
    }

    @Override
    public ImmutableMap<R, Map<C, V>> rowMap() {
        return ImmutableMap.copyOf(this.rowMap);
    }

    @Override
    public int size() {
        return this.cellRowIndices.length;
    }

    private final class Column
    extends ImmutableArrayMap<R, V> {
        private final int columnIndex;

        Column(int n2) {
            super(DenseImmutableTable.this.columnCounts[n2]);
            this.columnIndex = n2;
        }

        @Override
        V getValue(int n2) {
            return DenseImmutableTable.this.values[n2][this.columnIndex];
        }

        @Override
        boolean isPartialView() {
            return true;
        }

        @Override
        ImmutableMap<R, Integer> keyToIndex() {
            return DenseImmutableTable.this.rowKeyToIndex;
        }
    }

    private final class ColumnMap
    extends ImmutableArrayMap<C, ImmutableMap<R, V>> {
        private ColumnMap() {
            super(DenseImmutableTable.this.columnCounts.length);
        }

        @Override
        ImmutableMap<R, V> getValue(int n2) {
            return new Column(n2);
        }

        @Override
        boolean isPartialView() {
            return false;
        }

        @Override
        ImmutableMap<C, Integer> keyToIndex() {
            return DenseImmutableTable.this.columnKeyToIndex;
        }
    }

    private static abstract class ImmutableArrayMap<K, V>
    extends ImmutableMap.IteratorBasedImmutableMap<K, V> {
        private final int size;

        ImmutableArrayMap(int n2) {
            this.size = n2;
        }

        private boolean isFull() {
            boolean bl = this.size == this.keyToIndex().size();
            return bl;
        }

        @Override
        ImmutableSet<K> createKeySet() {
            Set<Object> set = this.isFull() ? this.keyToIndex().keySet() : super.createKeySet();
            return set;
        }

        @Override
        UnmodifiableIterator<Map.Entry<K, V>> entryIterator() {
            return new AbstractIterator<Map.Entry<K, V>>(){
                private int index = -1;
                private final int maxIndex = ImmutableArrayMap.this.keyToIndex().size();

                @Override
                protected Map.Entry<K, V> computeNext() {
                    int n2 = this.index;
                    while ((n2 = (this.index = n2 + 1)) < this.maxIndex) {
                        Object v2 = ImmutableArrayMap.this.getValue(n2);
                        if (v2 != null) {
                            return Maps.immutableEntry(ImmutableArrayMap.this.getKey(this.index), v2);
                        }
                        n2 = this.index;
                    }
                    return (Map.Entry)this.endOfData();
                }
            };
        }

        @Override
        public V get(@NullableDecl Object object) {
            object = this.keyToIndex().get(object);
            object = object == null ? null : this.getValue((Integer)object);
            return (V)object;
        }

        K getKey(int n2) {
            return (K)((ImmutableSet)this.keyToIndex().keySet()).asList().get(n2);
        }

        @NullableDecl
        abstract V getValue(int var1);

        abstract ImmutableMap<K, Integer> keyToIndex();

        @Override
        public int size() {
            return this.size;
        }
    }

    private final class Row
    extends ImmutableArrayMap<C, V> {
        private final int rowIndex;

        Row(int n2) {
            super(DenseImmutableTable.this.rowCounts[n2]);
            this.rowIndex = n2;
        }

        @Override
        V getValue(int n2) {
            return DenseImmutableTable.this.values[this.rowIndex][n2];
        }

        @Override
        boolean isPartialView() {
            return true;
        }

        @Override
        ImmutableMap<C, Integer> keyToIndex() {
            return DenseImmutableTable.this.columnKeyToIndex;
        }
    }

    private final class RowMap
    extends ImmutableArrayMap<R, ImmutableMap<C, V>> {
        private RowMap() {
            super(DenseImmutableTable.this.rowCounts.length);
        }

        @Override
        ImmutableMap<C, V> getValue(int n2) {
            return new Row(n2);
        }

        @Override
        boolean isPartialView() {
            return false;
        }

        @Override
        ImmutableMap<R, Integer> keyToIndex() {
            return DenseImmutableTable.this.rowKeyToIndex;
        }
    }
}

