/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.BoundType;
import com.google.common.collect.DescendingImmutableSortedSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.EmptyContiguousSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Ordering;
import com.google.common.collect.Range;
import com.google.common.collect.RegularContiguousSet;
import java.util.NoSuchElementException;

public abstract class ContiguousSet<C extends Comparable>
extends ImmutableSortedSet<C> {
    final DiscreteDomain<C> domain;

    ContiguousSet(DiscreteDomain<C> discreteDomain) {
        super(Ordering.natural());
        this.domain = discreteDomain;
    }

    @Deprecated
    public static <E> ImmutableSortedSet.Builder<E> builder() {
        throw new UnsupportedOperationException();
    }

    public static ContiguousSet<Integer> closed(int n2, int n3) {
        return ContiguousSet.create(Range.closed(n2, n3), DiscreteDomain.integers());
    }

    public static ContiguousSet<Long> closed(long l2, long l3) {
        return ContiguousSet.create(Range.closed(l2, l3), DiscreteDomain.longs());
    }

    public static ContiguousSet<Integer> closedOpen(int n2, int n3) {
        return ContiguousSet.create(Range.closedOpen(n2, n3), DiscreteDomain.integers());
    }

    public static ContiguousSet<Long> closedOpen(long l2, long l3) {
        return ContiguousSet.create(Range.closedOpen(l2, l3), DiscreteDomain.longs());
    }

    public static <C extends Comparable> ContiguousSet<C> create(Range<C> serializable, DiscreteDomain<C> discreteDomain) {
        Range<Comparable> range;
        block3: {
            Range<Object> range2;
            Preconditions.checkNotNull(serializable);
            Preconditions.checkNotNull(discreteDomain);
            try {
                range2 = !serializable.hasLowerBound() ? serializable.intersection(Range.atLeast(discreteDomain.minValue())) : serializable;
                range = range2;
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new IllegalArgumentException(noSuchElementException);
            }
            if (serializable.hasUpperBound()) break block3;
            range = range2.intersection(Range.atMost(discreteDomain.maxValue()));
        }
        boolean bl = range.isEmpty() || Range.compareOrThrow(serializable.lowerBound.leastValueAbove(discreteDomain), serializable.upperBound.greatestValueBelow(discreteDomain)) > 0;
        serializable = bl ? new EmptyContiguousSet<C>(discreteDomain) : new RegularContiguousSet<C>(range, discreteDomain);
        return serializable;
    }

    @Override
    ImmutableSortedSet<C> createDescendingSet() {
        return new DescendingImmutableSortedSet(this);
    }

    @Override
    public ContiguousSet<C> headSet(C c2) {
        return this.headSetImpl((C)((Comparable)Preconditions.checkNotNull(c2)), false);
    }

    @Override
    public ContiguousSet<C> headSet(C c2, boolean bl) {
        return this.headSetImpl((C)((Comparable)Preconditions.checkNotNull(c2)), bl);
    }

    @Override
    abstract ContiguousSet<C> headSetImpl(C var1, boolean var2);

    public abstract ContiguousSet<C> intersection(ContiguousSet<C> var1);

    public abstract Range<C> range();

    public abstract Range<C> range(BoundType var1, BoundType var2);

    @Override
    public ContiguousSet<C> subSet(C c2, C c3) {
        Preconditions.checkNotNull(c2);
        Preconditions.checkNotNull(c3);
        boolean bl = this.comparator().compare(c2, c3) <= 0;
        Preconditions.checkArgument(bl);
        return this.subSetImpl(c2, true, c3, false);
    }

    @Override
    public ContiguousSet<C> subSet(C c2, boolean bl, C c3, boolean bl2) {
        Preconditions.checkNotNull(c2);
        Preconditions.checkNotNull(c3);
        boolean bl3 = this.comparator().compare(c2, c3) <= 0;
        Preconditions.checkArgument(bl3);
        return this.subSetImpl(c2, bl, c3, bl2);
    }

    @Override
    abstract ContiguousSet<C> subSetImpl(C var1, boolean var2, C var3, boolean var4);

    @Override
    public ContiguousSet<C> tailSet(C c2) {
        return this.tailSetImpl((C)((Comparable)Preconditions.checkNotNull(c2)), true);
    }

    @Override
    public ContiguousSet<C> tailSet(C c2, boolean bl) {
        return this.tailSetImpl((C)((Comparable)Preconditions.checkNotNull(c2)), bl);
    }

    @Override
    abstract ContiguousSet<C> tailSetImpl(C var1, boolean var2);

    @Override
    public String toString() {
        return this.range().toString();
    }
}

