/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.AbstractMultiset;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ForwardingIterator;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.Serialization;
import com.google.common.math.IntMath;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class ConcurrentHashMultiset<E>
extends AbstractMultiset<E>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final transient ConcurrentMap<E, AtomicInteger> countMap;

    ConcurrentHashMultiset(ConcurrentMap<E, AtomicInteger> concurrentMap) {
        Preconditions.checkArgument(concurrentMap.isEmpty(), "the backing map (%s) must be empty", concurrentMap);
        this.countMap = concurrentMap;
    }

    public static <E> ConcurrentHashMultiset<E> create() {
        return new ConcurrentHashMultiset(new ConcurrentHashMap());
    }

    public static <E> ConcurrentHashMultiset<E> create(Iterable<? extends E> iterable) {
        ConcurrentHashMultiset<E> concurrentHashMultiset = ConcurrentHashMultiset.create();
        Iterables.addAll(concurrentHashMultiset, iterable);
        return concurrentHashMultiset;
    }

    public static <E> ConcurrentHashMultiset<E> create(ConcurrentMap<E, AtomicInteger> concurrentMap) {
        return new ConcurrentHashMultiset<E>(concurrentMap);
    }

    private void readObject(ObjectInputStream object) throws IOException, ClassNotFoundException {
        ((ObjectInputStream)object).defaultReadObject();
        object = (ConcurrentMap)((ObjectInputStream)object).readObject();
        FieldSettersHolder.COUNT_MAP_FIELD_SETTER.set((Object)this, object);
    }

    private List<E> snapshot() {
        ArrayList arrayList = Lists.newArrayListWithExpectedSize(this.size());
        for (Multiset.Entry entry : this.entrySet()) {
            Object e2 = entry.getElement();
            for (int i2 = entry.getCount(); i2 > 0; --i2) {
                arrayList.add(e2);
            }
        }
        return arrayList;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.countMap);
    }

    @Override
    public int add(E e2, int n2) {
        AtomicInteger atomicInteger;
        AtomicInteger atomicInteger2;
        Preconditions.checkNotNull(e2);
        if (n2 == 0) {
            return this.count(e2);
        }
        CollectPreconditions.checkPositive((int)n2, (String)"occurences");
        do {
            int n3;
            atomicInteger = atomicInteger2 = Maps.safeGet(this.countMap, e2);
            if (atomicInteger2 == null) {
                atomicInteger = atomicInteger2 = this.countMap.putIfAbsent(e2, new AtomicInteger(n2));
                if (atomicInteger2 == null) {
                    return 0;
                }
            }
            while ((n3 = atomicInteger.get()) != 0) {
                try {
                    boolean bl = atomicInteger.compareAndSet(n3, IntMath.checkedAdd((int)n3, (int)n2));
                    if (!bl) continue;
                    return n3;
                }
                catch (ArithmeticException arithmeticException) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Overflow adding ");
                    stringBuilder.append(n2);
                    stringBuilder.append(" occurrences to a count of ");
                    stringBuilder.append(n3);
                    throw new IllegalArgumentException(stringBuilder.toString());
                }
            }
        } while (this.countMap.putIfAbsent(e2, atomicInteger2 = new AtomicInteger(n2)) != null && !this.countMap.replace(e2, atomicInteger, atomicInteger2));
        return 0;
    }

    @Override
    public void clear() {
        this.countMap.clear();
    }

    @Override
    public int count(@NullableDecl Object object) {
        int n2 = (object = Maps.safeGet(this.countMap, object)) == null ? 0 : ((AtomicInteger)object).get();
        return n2;
    }

    @Override
    Set<E> createElementSet() {
        return new ForwardingSet<E>(this.countMap.keySet()){
            final /* synthetic */ Set val$delegate;
            {
                this.val$delegate = set;
            }

            @Override
            public boolean contains(@NullableDecl Object object) {
                boolean bl = object != null && Collections2.safeContains(this.val$delegate, object);
                return bl;
            }

            @Override
            public boolean containsAll(Collection<?> collection) {
                return this.standardContainsAll(collection);
            }

            @Override
            protected Set<E> delegate() {
                return this.val$delegate;
            }

            @Override
            public boolean remove(Object object) {
                boolean bl = object != null && Collections2.safeRemove(this.val$delegate, object);
                return bl;
            }

            @Override
            public boolean removeAll(Collection<?> collection) {
                return this.standardRemoveAll(collection);
            }
        };
    }

    @Override
    @Deprecated
    public Set<Multiset.Entry<E>> createEntrySet() {
        return new EntrySet();
    }

    @Override
    int distinctElements() {
        return this.countMap.size();
    }

    @Override
    Iterator<E> elementIterator() {
        throw new AssertionError((Object)"should never be called");
    }

    @Override
    Iterator<Multiset.Entry<E>> entryIterator() {
        return new ForwardingIterator<Multiset.Entry<E>>(new AbstractIterator<Multiset.Entry<E>>(){
            private final Iterator<Map.Entry<E, AtomicInteger>> mapEntries;
            {
                this.mapEntries = ConcurrentHashMultiset.this.countMap.entrySet().iterator();
            }

            @Override
            protected Multiset.Entry<E> computeNext() {
                Map.Entry entry;
                int n2;
                do {
                    if (this.mapEntries.hasNext()) continue;
                    return (Multiset.Entry)this.endOfData();
                } while ((n2 = (entry = this.mapEntries.next()).getValue().get()) == 0);
                return Multisets.immutableEntry(entry.getKey(), n2);
            }
        }){
            @NullableDecl
            private Multiset.Entry<E> last;
            final /* synthetic */ Iterator val$readOnlyIterator;
            {
                this.val$readOnlyIterator = iterator2;
            }

            @Override
            protected Iterator<Multiset.Entry<E>> delegate() {
                return this.val$readOnlyIterator;
            }

            @Override
            public Multiset.Entry<E> next() {
                this.last = (Multiset.Entry)super.next();
                return this.last;
            }

            @Override
            public void remove() {
                boolean bl = this.last != null;
                CollectPreconditions.checkRemove((boolean)bl);
                ConcurrentHashMultiset.this.setCount(this.last.getElement(), 0);
                this.last = null;
            }
        };
    }

    @Override
    public boolean isEmpty() {
        return this.countMap.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return Multisets.iteratorImpl(this);
    }

    @Override
    public int remove(@NullableDecl Object object, int n2) {
        int n3;
        if (n2 == 0) {
            return this.count(object);
        }
        CollectPreconditions.checkPositive((int)n2, (String)"occurences");
        AtomicInteger atomicInteger = Maps.safeGet(this.countMap, object);
        if (atomicInteger == null) {
            return 0;
        }
        while ((n3 = atomicInteger.get()) != 0) {
            int n4 = Math.max(0, n3 - n2);
            if (!atomicInteger.compareAndSet(n3, n4)) continue;
            if (n4 == 0) {
                this.countMap.remove(object, atomicInteger);
            }
            return n3;
        }
        return 0;
    }

    public boolean removeExactly(@NullableDecl Object object, int n2) {
        int n3;
        int n4;
        if (n2 == 0) {
            return true;
        }
        CollectPreconditions.checkPositive((int)n2, (String)"occurences");
        AtomicInteger atomicInteger = Maps.safeGet(this.countMap, object);
        if (atomicInteger == null) {
            return false;
        }
        do {
            if ((n4 = atomicInteger.get()) >= n2) continue;
            return false;
        } while (!atomicInteger.compareAndSet(n4, n3 = n4 - n2));
        if (n3 == 0) {
            this.countMap.remove(object, atomicInteger);
        }
        return true;
    }

    @Override
    public int setCount(E e2, int n2) {
        int n3;
        AtomicInteger atomicInteger;
        Preconditions.checkNotNull(e2);
        CollectPreconditions.checkNonnegative((int)n2, (String)"count");
        block0: while (true) {
            AtomicInteger atomicInteger2;
            atomicInteger = atomicInteger2 = Maps.safeGet(this.countMap, e2);
            if (atomicInteger2 == null) {
                if (n2 == 0) {
                    return 0;
                }
                atomicInteger = atomicInteger2 = this.countMap.putIfAbsent(e2, new AtomicInteger(n2));
                if (atomicInteger2 == null) {
                    return 0;
                }
            }
            do {
                if ((n3 = atomicInteger.get()) != 0) continue;
                if (n2 == 0) {
                    return 0;
                }
                atomicInteger2 = new AtomicInteger(n2);
                if (this.countMap.putIfAbsent(e2, atomicInteger2) != null && !this.countMap.replace(e2, atomicInteger, atomicInteger2)) continue block0;
                return 0;
            } while (!atomicInteger.compareAndSet(n3, n2));
            break;
        }
        if (n2 == 0) {
            this.countMap.remove(e2, atomicInteger);
        }
        return n3;
    }

    @Override
    public boolean setCount(E e2, int n2, int n3) {
        block10: {
            int n4;
            AtomicInteger atomicInteger;
            block11: {
                boolean bl;
                block13: {
                    block12: {
                        Preconditions.checkNotNull(e2);
                        CollectPreconditions.checkNonnegative((int)n2, (String)"oldCount");
                        CollectPreconditions.checkNonnegative((int)n3, (String)"newCount");
                        atomicInteger = Maps.safeGet(this.countMap, e2);
                        boolean bl2 = false;
                        bl = false;
                        if (atomicInteger == null) {
                            if (n2 != 0) {
                                return false;
                            }
                            if (n3 == 0) {
                                return true;
                            }
                            if (this.countMap.putIfAbsent(e2, new AtomicInteger(n3)) == null) {
                                bl = true;
                            }
                            return bl;
                        }
                        n4 = atomicInteger.get();
                        if (n4 != n2) break block10;
                        if (n4 != 0) break block11;
                        if (n3 == 0) {
                            this.countMap.remove(e2, atomicInteger);
                            return true;
                        }
                        AtomicInteger atomicInteger2 = new AtomicInteger(n3);
                        if (this.countMap.putIfAbsent(e2, atomicInteger2) == null) break block12;
                        bl = bl2;
                        if (!this.countMap.replace(e2, atomicInteger, atomicInteger2)) break block13;
                    }
                    bl = true;
                }
                return bl;
            }
            if (atomicInteger.compareAndSet(n4, n3)) {
                if (n3 == 0) {
                    this.countMap.remove(e2, atomicInteger);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public int size() {
        Iterator iterator2 = this.countMap.values().iterator();
        long l2 = 0L;
        while (iterator2.hasNext()) {
            l2 += (long)((AtomicInteger)iterator2.next()).get();
        }
        return Ints.saturatedCast(l2);
    }

    @Override
    public Object[] toArray() {
        return this.snapshot().toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.snapshot().toArray(TArray);
    }

    private class EntrySet
    extends AbstractMultiset.EntrySet {
        private EntrySet() {
        }

        private List<Multiset.Entry<E>> snapshot() {
            ArrayList arrayList = Lists.newArrayListWithExpectedSize(this.size());
            Iterators.addAll(arrayList, this.iterator());
            return arrayList;
        }

        @Override
        ConcurrentHashMultiset<E> multiset() {
            return ConcurrentHashMultiset.this;
        }

        @Override
        public Object[] toArray() {
            return this.snapshot().toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return this.snapshot().toArray(TArray);
        }
    }

    private static class FieldSettersHolder {
        static final Serialization.FieldSetter<ConcurrentHashMultiset> COUNT_MAP_FIELD_SETTER = Serialization.getFieldSetter(ConcurrentHashMultiset.class, (String)"countMap");

        private FieldSettersHolder() {
        }
    }
}

