/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.CompactHashSet;
import com.google.common.collect.ObjectArrays;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.checkerframework.checker.nullness.compatqual.MonotonicNonNullDecl;

class CompactLinkedHashSet<E>
extends CompactHashSet<E> {
    private static final int ENDPOINT = -2;
    private transient int firstEntry;
    private transient int lastEntry;
    @MonotonicNonNullDecl
    private transient int[] predecessor;
    @MonotonicNonNullDecl
    private transient int[] successor;

    CompactLinkedHashSet() {
    }

    CompactLinkedHashSet(int n2) {
        super(n2);
    }

    public static <E> CompactLinkedHashSet<E> create() {
        return new CompactLinkedHashSet<E>();
    }

    public static <E> CompactLinkedHashSet<E> create(Collection<? extends E> collection) {
        CompactLinkedHashSet<E> compactLinkedHashSet = CompactLinkedHashSet.createWithExpectedSize(collection.size());
        compactLinkedHashSet.addAll(collection);
        return compactLinkedHashSet;
    }

    public static <E> CompactLinkedHashSet<E> create(E ... EArray) {
        CompactLinkedHashSet<E> compactLinkedHashSet = CompactLinkedHashSet.createWithExpectedSize(EArray.length);
        Collections.addAll(compactLinkedHashSet, EArray);
        return compactLinkedHashSet;
    }

    public static <E> CompactLinkedHashSet<E> createWithExpectedSize(int n2) {
        return new CompactLinkedHashSet<E>(n2);
    }

    private void succeeds(int n2, int n3) {
        if (n2 == -2) {
            this.firstEntry = n3;
        } else {
            this.successor[n2] = n3;
        }
        if (n3 == -2) {
            this.lastEntry = n2;
        } else {
            this.predecessor[n3] = n2;
        }
    }

    @Override
    int adjustAfterRemove(int n2, int n3) {
        int n4 = n2;
        if (n2 == this.size()) {
            n4 = n3;
        }
        return n4;
    }

    @Override
    public void clear() {
        super.clear();
        this.firstEntry = -2;
        this.lastEntry = -2;
        Arrays.fill(this.predecessor, -1);
        Arrays.fill(this.successor, -1);
    }

    @Override
    int firstEntryIndex() {
        return this.firstEntry;
    }

    @Override
    int getSuccessor(int n2) {
        return this.successor[n2];
    }

    @Override
    void init(int n2, float f2) {
        super.init(n2, f2);
        this.predecessor = new int[n2];
        this.successor = new int[n2];
        Arrays.fill(this.predecessor, -1);
        Arrays.fill(this.successor, -1);
        this.firstEntry = -2;
        this.lastEntry = -2;
    }

    @Override
    void insertEntry(int n2, E e2, int n3) {
        super.insertEntry(n2, e2, n3);
        this.succeeds(this.lastEntry, n2);
        this.succeeds(n2, -2);
    }

    @Override
    void moveEntry(int n2) {
        int n3 = this.size() - 1;
        super.moveEntry(n2);
        this.succeeds(this.predecessor[n2], this.successor[n2]);
        if (n3 != n2) {
            this.succeeds(this.predecessor[n3], n2);
            this.succeeds(n2, this.successor[n3]);
        }
        this.predecessor[n3] = -1;
        this.successor[n3] = -1;
    }

    @Override
    void resizeEntries(int n2) {
        super.resizeEntries(n2);
        int[] nArray = this.predecessor;
        int n3 = nArray.length;
        this.predecessor = Arrays.copyOf(nArray, n2);
        this.successor = Arrays.copyOf(this.successor, n2);
        if (n3 < n2) {
            Arrays.fill(this.predecessor, n3, n2, -1);
            Arrays.fill(this.successor, n3, n2, -1);
        }
    }

    @Override
    public Object[] toArray() {
        return ObjectArrays.toArrayImpl(this);
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return ObjectArrays.toArrayImpl(this, TArray);
    }
}

