/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.CompactHashMap;
import java.util.Arrays;
import org.checkerframework.checker.nullness.compatqual.MonotonicNonNullDecl;

class CompactLinkedHashMap<K, V>
extends CompactHashMap<K, V> {
    private static final int ENDPOINT = -2;
    private final boolean accessOrder;
    private transient int firstEntry;
    private transient int lastEntry;
    @MonotonicNonNullDecl
    transient long[] links;

    CompactLinkedHashMap() {
        this(3);
    }

    CompactLinkedHashMap(int n2) {
        this(n2, 1.0f, false);
    }

    CompactLinkedHashMap(int n2, float f2, boolean bl) {
        super(n2, f2);
        this.accessOrder = bl;
    }

    public static <K, V> CompactLinkedHashMap<K, V> create() {
        return new CompactLinkedHashMap<K, V>();
    }

    public static <K, V> CompactLinkedHashMap<K, V> createWithExpectedSize(int n2) {
        return new CompactLinkedHashMap<K, V>(n2);
    }

    private int getPredecessor(int n2) {
        return (int)(this.links[n2] >>> 32);
    }

    private void setPredecessor(int n2, int n3) {
        long[] lArray = this.links;
        lArray[n2] = lArray[n2] & 0xFFFFFFFFL | (long)n3 << 32;
    }

    private void setSucceeds(int n2, int n3) {
        if (n2 == -2) {
            this.firstEntry = n3;
        } else {
            this.setSuccessor(n2, n3);
        }
        if (n3 == -2) {
            this.lastEntry = n2;
        } else {
            this.setPredecessor(n3, n2);
        }
    }

    private void setSuccessor(int n2, int n3) {
        long[] lArray = this.links;
        lArray[n2] = lArray[n2] & 0xFFFFFFFF00000000L | (long)n3 & 0xFFFFFFFFL;
    }

    @Override
    void accessEntry(int n2) {
        if (this.accessOrder) {
            this.setSucceeds(this.getPredecessor(n2), this.getSuccessor(n2));
            this.setSucceeds(this.lastEntry, n2);
            this.setSucceeds(n2, -2);
            ++this.modCount;
        }
    }

    @Override
    int adjustAfterRemove(int n2, int n3) {
        int n4 = n2;
        if (n2 >= this.size()) {
            n4 = n3;
        }
        return n4;
    }

    @Override
    public void clear() {
        super.clear();
        this.firstEntry = -2;
        this.lastEntry = -2;
    }

    @Override
    int firstEntryIndex() {
        return this.firstEntry;
    }

    @Override
    int getSuccessor(int n2) {
        return (int)this.links[n2];
    }

    @Override
    void init(int n2, float f2) {
        super.init(n2, f2);
        this.firstEntry = -2;
        this.lastEntry = -2;
        this.links = new long[n2];
        Arrays.fill(this.links, -1L);
    }

    @Override
    void insertEntry(int n2, K k2, V v2, int n3) {
        super.insertEntry(n2, k2, v2, n3);
        this.setSucceeds(this.lastEntry, n2);
        this.setSucceeds(n2, -2);
    }

    @Override
    void moveLastEntry(int n2) {
        int n3 = this.size() - 1;
        this.setSucceeds(this.getPredecessor(n2), this.getSuccessor(n2));
        if (n2 < n3) {
            this.setSucceeds(this.getPredecessor(n3), n2);
            this.setSucceeds(n2, this.getSuccessor(n3));
        }
        super.moveLastEntry(n2);
    }

    @Override
    void resizeEntries(int n2) {
        super.resizeEntries(n2);
        this.links = Arrays.copyOf(this.links, n2);
    }
}

