/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.Hashing;
import com.google.common.collect.ObjectArrays;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.checkerframework.checker.nullness.compatqual.MonotonicNonNullDecl;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

class CompactHashSet<E>
extends AbstractSet<E>
implements Serializable {
    private static final float DEFAULT_LOAD_FACTOR = 1.0f;
    private static final int DEFAULT_SIZE = 3;
    private static final long HASH_MASK = -4294967296L;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final long NEXT_MASK = 0xFFFFFFFFL;
    static final int UNSET = -1;
    @MonotonicNonNullDecl
    transient Object[] elements;
    @MonotonicNonNullDecl
    private transient long[] entries;
    transient float loadFactor;
    transient int modCount;
    private transient int size;
    @MonotonicNonNullDecl
    private transient int[] table;
    private transient int threshold;

    CompactHashSet() {
        this.init(3, 1.0f);
    }

    CompactHashSet(int n2) {
        this.init(n2, 1.0f);
    }

    public static <E> CompactHashSet<E> create() {
        return new CompactHashSet<E>();
    }

    public static <E> CompactHashSet<E> create(Collection<? extends E> collection) {
        CompactHashSet<E> compactHashSet = CompactHashSet.createWithExpectedSize(collection.size());
        compactHashSet.addAll(collection);
        return compactHashSet;
    }

    public static <E> CompactHashSet<E> create(E ... EArray) {
        CompactHashSet<E> compactHashSet = CompactHashSet.createWithExpectedSize(EArray.length);
        Collections.addAll(compactHashSet, EArray);
        return compactHashSet;
    }

    public static <E> CompactHashSet<E> createWithExpectedSize(int n2) {
        return new CompactHashSet<E>(n2);
    }

    private static int getHash(long l2) {
        return (int)(l2 >>> 32);
    }

    private static int getNext(long l2) {
        return (int)l2;
    }

    private int hashTableMask() {
        return this.table.length - 1;
    }

    private static long[] newEntries(int n2) {
        long[] lArray = new long[n2];
        Arrays.fill(lArray, -1L);
        return lArray;
    }

    private static int[] newTable(int n2) {
        int[] nArray = new int[n2];
        Arrays.fill(nArray, -1);
        return nArray;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init(3, 1.0f);
        int n2 = objectInputStream.readInt();
        while (--n2 >= 0) {
            this.add(objectInputStream.readObject());
        }
    }

    private boolean remove(Object object, int n2) {
        int n3 = this.hashTableMask() & n2;
        int n4 = this.table[n3];
        if (n4 == -1) {
            return false;
        }
        int n5 = -1;
        while (true) {
            if (CompactHashSet.getHash(this.entries[n4]) == n2 && Objects.equal(object, this.elements[n4])) {
                if (n5 == -1) {
                    this.table[n3] = CompactHashSet.getNext(this.entries[n4]);
                } else {
                    object = this.entries;
                    object[n5] = CompactHashSet.swapNext((long)object[n5], CompactHashSet.getNext((long)object[n4]));
                }
                this.moveEntry(n4);
                --this.size;
                ++this.modCount;
                return true;
            }
            int n6 = CompactHashSet.getNext(this.entries[n4]);
            if (n6 == -1) {
                return false;
            }
            n5 = n4;
            n4 = n6;
        }
    }

    private void resizeMeMaybe(int n2) {
        int n3 = this.entries.length;
        if (n2 > n3) {
            int n4;
            n2 = n4 = Math.max(1, n3 >>> 1) + n3;
            if (n4 < 0) {
                n2 = Integer.MAX_VALUE;
            }
            if (n2 != n3) {
                this.resizeEntries(n2);
            }
        }
    }

    private void resizeTable(int n2) {
        if (this.table.length >= 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        int n3 = (int)((float)n2 * this.loadFactor);
        int[] nArray = CompactHashSet.newTable(n2);
        long[] lArray = this.entries;
        int n4 = nArray.length;
        for (n2 = 0; n2 < this.size; ++n2) {
            int n5 = CompactHashSet.getHash(lArray[n2]);
            int n6 = n5 & n4 - 1;
            int n7 = nArray[n6];
            nArray[n6] = n2;
            lArray[n2] = (long)n5 << 32 | 0xFFFFFFFFL & (long)n7;
        }
        this.threshold = n3 + 1;
        this.table = nArray;
    }

    private static long swapNext(long l2, int n2) {
        return l2 & 0xFFFFFFFF00000000L | (long)n2 & 0xFFFFFFFFL;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size);
        Iterator<E> iterator2 = this.iterator();
        while (iterator2.hasNext()) {
            objectOutputStream.writeObject(iterator2.next());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean add(@NullableDecl E e2) {
        int n2;
        long[] lArray = this.entries;
        Object[] objectArray = this.elements;
        int n3 = Hashing.smearedHash(e2);
        int n4 = this.hashTableMask() & n3;
        int n5 = this.size;
        int[] nArray = this.table;
        int n6 = n2 = nArray[n4];
        if (n2 == -1) {
            nArray[n4] = n5;
        } else {
            while (true) {
                long l2;
                if (CompactHashSet.getHash(l2 = lArray[n6]) == n3 && Objects.equal(e2, objectArray[n6])) {
                    return false;
                }
                n2 = CompactHashSet.getNext(l2);
                if (n2 == -1) {
                    lArray[n6] = CompactHashSet.swapNext(l2, n5);
                    break;
                }
                n6 = n2;
            }
        }
        if (n5 == Integer.MAX_VALUE) {
            throw new IllegalStateException("Cannot contain more than Integer.MAX_VALUE elements!");
        }
        n6 = n5 + 1;
        this.resizeMeMaybe(n6);
        this.insertEntry(n5, e2, n3);
        this.size = n6;
        if (n5 >= this.threshold) {
            this.resizeTable(this.table.length * 2);
        }
        ++this.modCount;
        return true;
    }

    int adjustAfterRemove(int n2, int n3) {
        return n2 - 1;
    }

    @Override
    public void clear() {
        ++this.modCount;
        Arrays.fill(this.elements, 0, this.size, null);
        Arrays.fill(this.table, -1);
        Arrays.fill(this.entries, -1L);
        this.size = 0;
    }

    @Override
    public boolean contains(@NullableDecl Object object) {
        int n2 = Hashing.smearedHash(object);
        int n3 = this.table[this.hashTableMask() & n2];
        while (n3 != -1) {
            long l2 = this.entries[n3];
            if (CompactHashSet.getHash(l2) == n2 && Objects.equal(object, this.elements[n3])) {
                return true;
            }
            n3 = CompactHashSet.getNext(l2);
        }
        return false;
    }

    int firstEntryIndex() {
        int n2 = this.isEmpty() ? -1 : 0;
        return n2;
    }

    int getSuccessor(int n2) {
        if (++n2 >= this.size) {
            n2 = -1;
        }
        return n2;
    }

    void init(int n2, float f2) {
        boolean bl = false;
        boolean bl2 = n2 >= 0;
        Preconditions.checkArgument(bl2, "Initial capacity must be non-negative");
        bl2 = bl;
        if (f2 > 0.0f) {
            bl2 = true;
        }
        Preconditions.checkArgument(bl2, "Illegal load factor");
        int n3 = Hashing.closedTableSize(n2, f2);
        this.table = CompactHashSet.newTable(n3);
        this.loadFactor = f2;
        this.elements = new Object[n2];
        this.entries = CompactHashSet.newEntries(n2);
        this.threshold = Math.max(1, (int)((float)n3 * f2));
    }

    void insertEntry(int n2, E e2, int n3) {
        this.entries[n2] = (long)n3 << 32 | 0xFFFFFFFFL;
        this.elements[n2] = e2;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.size == 0;
        return bl;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            int expectedModCount;
            int index;
            int indexToRemove;
            {
                this.expectedModCount = CompactHashSet.this.modCount;
                this.index = CompactHashSet.this.firstEntryIndex();
                this.indexToRemove = -1;
            }

            private void checkForConcurrentModification() {
                if (CompactHashSet.this.modCount == this.expectedModCount) {
                    return;
                }
                throw new ConcurrentModificationException();
            }

            @Override
            public boolean hasNext() {
                boolean bl = this.index >= 0;
                return bl;
            }

            @Override
            public E next() {
                this.checkForConcurrentModification();
                if (this.hasNext()) {
                    this.indexToRemove = this.index;
                    Object object = CompactHashSet.this.elements;
                    int n2 = this.index;
                    object = object[n2];
                    this.index = CompactHashSet.this.getSuccessor(n2);
                    return object;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                this.checkForConcurrentModification();
                boolean bl = this.indexToRemove >= 0;
                CollectPreconditions.checkRemove((boolean)bl);
                ++this.expectedModCount;
                CompactHashSet compactHashSet = CompactHashSet.this;
                compactHashSet.remove(compactHashSet.elements[this.indexToRemove], CompactHashSet.getHash(CompactHashSet.this.entries[this.indexToRemove]));
                this.index = CompactHashSet.this.adjustAfterRemove(this.index, this.indexToRemove);
                this.indexToRemove = -1;
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void moveEntry(int n2) {
        int n3 = this.size() - 1;
        if (n2 < n3) {
            int n4;
            long l2;
            Object[] objectArray = this.elements;
            objectArray[n2] = objectArray[n3];
            objectArray[n3] = null;
            long[] lArray = this.entries;
            lArray[n2] = l2 = lArray[n3];
            lArray[n3] = -1L;
            int n5 = CompactHashSet.getHash(l2) & this.hashTableMask();
            int[] nArray = this.table;
            int n6 = n4 = nArray[n5];
            if (n4 == n3) {
                nArray[n5] = n2;
                return;
            }
            while (true) {
                int n7;
                if ((n7 = CompactHashSet.getNext(l2 = this.entries[n6])) == n3) {
                    this.entries[n6] = CompactHashSet.swapNext(l2, n2);
                    return;
                }
                n6 = n7;
            }
        }
        this.elements[n2] = null;
        this.entries[n2] = -1L;
    }

    @Override
    public boolean remove(@NullableDecl Object object) {
        return this.remove(object, Hashing.smearedHash(object));
    }

    void resizeEntries(int n2) {
        this.elements = Arrays.copyOf(this.elements, n2);
        long[] lArray = this.entries;
        int n3 = lArray.length;
        lArray = Arrays.copyOf(lArray, n2);
        if (n2 > n3) {
            Arrays.fill(lArray, n3, n2, -1L);
        }
        this.entries = lArray;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.elements, this.size);
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return ObjectArrays.toArrayImpl(this.elements, 0, this.size, TArray);
    }

    public void trimToSize() {
        int n2;
        int n3 = this.size;
        if (n3 < this.entries.length) {
            this.resizeEntries(n3);
        }
        int n4 = n2 = Math.max(1, Integer.highestOneBit((int)((float)n3 / this.loadFactor)));
        if (n2 < 0x40000000) {
            double d2 = n3;
            double d3 = n2;
            Double.isNaN(d2);
            Double.isNaN(d3);
            n4 = n2;
            if (d2 / d3 > (double)this.loadFactor) {
                n4 = n2 << 1;
            }
        }
        if (n4 < this.table.length) {
            this.resizeTable(n4);
        }
    }
}

