/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractMapEntry;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.Hashing;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.checkerframework.checker.nullness.compatqual.MonotonicNonNullDecl;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

class CompactHashMap<K, V>
extends AbstractMap<K, V>
implements Serializable {
    static final float DEFAULT_LOAD_FACTOR = 1.0f;
    static final int DEFAULT_SIZE = 3;
    private static final long HASH_MASK = -4294967296L;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final long NEXT_MASK = 0xFFFFFFFFL;
    static final int UNSET = -1;
    @MonotonicNonNullDecl
    transient long[] entries;
    @MonotonicNonNullDecl
    private transient Set<Map.Entry<K, V>> entrySetView;
    @MonotonicNonNullDecl
    private transient Set<K> keySetView;
    @MonotonicNonNullDecl
    transient Object[] keys;
    transient float loadFactor;
    transient int modCount;
    private transient int size;
    @MonotonicNonNullDecl
    private transient int[] table;
    private transient int threshold;
    @MonotonicNonNullDecl
    transient Object[] values;
    @MonotonicNonNullDecl
    private transient Collection<V> valuesView;

    CompactHashMap() {
        this.init(3, 1.0f);
    }

    CompactHashMap(int n2) {
        this(n2, 1.0f);
    }

    CompactHashMap(int n2, float f2) {
        this.init(n2, f2);
    }

    public static <K, V> CompactHashMap<K, V> create() {
        return new CompactHashMap<K, V>();
    }

    public static <K, V> CompactHashMap<K, V> createWithExpectedSize(int n2) {
        return new CompactHashMap<K, V>(n2);
    }

    private static int getHash(long l2) {
        return (int)(l2 >>> 32);
    }

    private static int getNext(long l2) {
        return (int)l2;
    }

    private int hashTableMask() {
        return this.table.length - 1;
    }

    private int indexOf(@NullableDecl Object object) {
        int n2 = Hashing.smearedHash(object);
        int n3 = this.table[this.hashTableMask() & n2];
        while (n3 != -1) {
            long l2 = this.entries[n3];
            if (CompactHashMap.getHash(l2) == n2 && Objects.equal(object, this.keys[n3])) {
                return n3;
            }
            n3 = CompactHashMap.getNext(l2);
        }
        return -1;
    }

    private static long[] newEntries(int n2) {
        long[] lArray = new long[n2];
        Arrays.fill(lArray, -1L);
        return lArray;
    }

    private static int[] newTable(int n2) {
        int[] nArray = new int[n2];
        Arrays.fill(nArray, -1);
        return nArray;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init(3, 1.0f);
        int n2 = objectInputStream.readInt();
        while (--n2 >= 0) {
            this.put(objectInputStream.readObject(), objectInputStream.readObject());
        }
    }

    @NullableDecl
    private V remove(@NullableDecl Object object, int n2) {
        int n3 = this.hashTableMask() & n2;
        int n4 = this.table[n3];
        if (n4 == -1) {
            return null;
        }
        int n5 = -1;
        while (true) {
            if (CompactHashMap.getHash(this.entries[n4]) == n2 && Objects.equal(object, this.keys[n4])) {
                Object object2 = this.values[n4];
                if (n5 == -1) {
                    this.table[n3] = CompactHashMap.getNext(this.entries[n4]);
                } else {
                    object = this.entries;
                    object[n5] = CompactHashMap.swapNext((long)object[n5], CompactHashMap.getNext((long)object[n4]));
                }
                this.moveLastEntry(n4);
                --this.size;
                ++this.modCount;
                return (V)object2;
            }
            int n6 = CompactHashMap.getNext(this.entries[n4]);
            if (n6 == -1) {
                return null;
            }
            n5 = n4;
            n4 = n6;
        }
    }

    private V removeEntry(int n2) {
        return this.remove(this.keys[n2], CompactHashMap.getHash(this.entries[n2]));
    }

    private void resizeMeMaybe(int n2) {
        int n3 = this.entries.length;
        if (n2 > n3) {
            int n4;
            n2 = n4 = Math.max(1, n3 >>> 1) + n3;
            if (n4 < 0) {
                n2 = Integer.MAX_VALUE;
            }
            if (n2 != n3) {
                this.resizeEntries(n2);
            }
        }
    }

    private void resizeTable(int n2) {
        if (this.table.length >= 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        int n3 = (int)((float)n2 * this.loadFactor);
        int[] nArray = CompactHashMap.newTable(n2);
        long[] lArray = this.entries;
        int n4 = nArray.length;
        for (n2 = 0; n2 < this.size; ++n2) {
            int n5 = CompactHashMap.getHash(lArray[n2]);
            int n6 = n5 & n4 - 1;
            int n7 = nArray[n6];
            nArray[n6] = n2;
            lArray[n2] = (long)n5 << 32 | 0xFFFFFFFFL & (long)n7;
        }
        this.threshold = n3 + 1;
        this.table = nArray;
    }

    private static long swapNext(long l2, int n2) {
        return l2 & 0xFFFFFFFF00000000L | (long)n2 & 0xFFFFFFFFL;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size);
        for (int i2 = 0; i2 < this.size; ++i2) {
            objectOutputStream.writeObject(this.keys[i2]);
            objectOutputStream.writeObject(this.values[i2]);
        }
    }

    void accessEntry(int n2) {
    }

    int adjustAfterRemove(int n2, int n3) {
        return n2 - 1;
    }

    @Override
    public void clear() {
        ++this.modCount;
        Arrays.fill(this.keys, 0, this.size, null);
        Arrays.fill(this.values, 0, this.size, null);
        Arrays.fill(this.table, -1);
        Arrays.fill(this.entries, -1L);
        this.size = 0;
    }

    @Override
    public boolean containsKey(@NullableDecl Object object) {
        boolean bl = this.indexOf(object) != -1;
        return bl;
    }

    @Override
    public boolean containsValue(@NullableDecl Object object) {
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (!Objects.equal(object, this.values[i2])) continue;
            return true;
        }
        return false;
    }

    Set<Map.Entry<K, V>> createEntrySet() {
        return new EntrySetView();
    }

    Set<K> createKeySet() {
        return new KeySetView();
    }

    Collection<V> createValues() {
        return new ValuesView();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<K, V>> set;
        Set<Map.Entry<K, V>> set2 = set = this.entrySetView;
        if (set == null) {
            this.entrySetView = set2 = this.createEntrySet();
        }
        return set2;
    }

    Iterator<Map.Entry<K, V>> entrySetIterator() {
        return new Itr<Map.Entry<K, V>>(){

            @Override
            Map.Entry<K, V> getOutput(int n2) {
                return new MapEntry(n2);
            }
        };
    }

    int firstEntryIndex() {
        int n2 = this.isEmpty() ? -1 : 0;
        return n2;
    }

    @Override
    public V get(@NullableDecl Object object) {
        int n2 = this.indexOf(object);
        this.accessEntry(n2);
        object = n2 == -1 ? null : this.values[n2];
        return (V)object;
    }

    int getSuccessor(int n2) {
        if (++n2 >= this.size) {
            n2 = -1;
        }
        return n2;
    }

    void init(int n2, float f2) {
        boolean bl = false;
        boolean bl2 = n2 >= 0;
        Preconditions.checkArgument(bl2, "Initial capacity must be non-negative");
        bl2 = bl;
        if (f2 > 0.0f) {
            bl2 = true;
        }
        Preconditions.checkArgument(bl2, "Illegal load factor");
        int n3 = Hashing.closedTableSize(n2, f2);
        this.table = CompactHashMap.newTable(n3);
        this.loadFactor = f2;
        this.keys = new Object[n2];
        this.values = new Object[n2];
        this.entries = CompactHashMap.newEntries(n2);
        this.threshold = Math.max(1, (int)((float)n3 * f2));
    }

    void insertEntry(int n2, @NullableDecl K k2, @NullableDecl V v2, int n3) {
        this.entries[n2] = (long)n3 << 32 | 0xFFFFFFFFL;
        this.keys[n2] = k2;
        this.values[n2] = v2;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.size == 0;
        return bl;
    }

    @Override
    public Set<K> keySet() {
        Set<K> set;
        Set<K> set2 = set = this.keySetView;
        if (set == null) {
            this.keySetView = set2 = this.createKeySet();
        }
        return set2;
    }

    Iterator<K> keySetIterator() {
        return new Itr<K>(){

            @Override
            K getOutput(int n2) {
                return CompactHashMap.this.keys[n2];
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void moveLastEntry(int n2) {
        int n3 = this.size() - 1;
        if (n2 < n3) {
            int n4;
            long l2;
            Object[] objectArray = this.keys;
            objectArray[n2] = objectArray[n3];
            Object[] objectArray2 = this.values;
            objectArray2[n2] = objectArray2[n3];
            objectArray[n3] = null;
            objectArray2[n3] = null;
            long[] lArray = this.entries;
            lArray[n2] = l2 = lArray[n3];
            lArray[n3] = -1L;
            int n5 = CompactHashMap.getHash(l2) & this.hashTableMask();
            int[] nArray = this.table;
            int n6 = n4 = nArray[n5];
            if (n4 == n3) {
                nArray[n5] = n2;
                return;
            }
            while (true) {
                int n7;
                if ((n7 = CompactHashMap.getNext(l2 = this.entries[n6])) == n3) {
                    this.entries[n6] = CompactHashMap.swapNext(l2, n2);
                    return;
                }
                n6 = n7;
            }
        }
        this.keys[n2] = null;
        this.values[n2] = null;
        this.entries[n2] = -1L;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    @NullableDecl
    public V put(@NullableDecl K object, @NullableDecl V v2) {
        void var2_3;
        int n2;
        long[] lArray = this.entries;
        Object[] objectArray = this.keys;
        Object[] objectArray2 = this.values;
        int n3 = Hashing.smearedHash(object);
        int n4 = this.hashTableMask() & n3;
        int n5 = this.size;
        int[] nArray = this.table;
        int n6 = n2 = nArray[n4];
        if (n2 == -1) {
            nArray[n4] = n5;
        } else {
            while (true) {
                long l2;
                if (CompactHashMap.getHash(l2 = lArray[n6]) == n3 && Objects.equal(object, objectArray[n6])) {
                    Object object2 = objectArray2[n6];
                    objectArray2[n6] = var2_3;
                    this.accessEntry(n6);
                    return (V)object2;
                }
                n2 = CompactHashMap.getNext(l2);
                if (n2 == -1) {
                    lArray[n6] = CompactHashMap.swapNext(l2, n5);
                    break;
                }
                n6 = n2;
            }
        }
        if (n5 == Integer.MAX_VALUE) {
            throw new IllegalStateException("Cannot contain more than Integer.MAX_VALUE elements!");
        }
        n6 = n5 + 1;
        this.resizeMeMaybe(n6);
        this.insertEntry(n5, object, var2_3, n3);
        this.size = n6;
        if (n5 >= this.threshold) {
            this.resizeTable(this.table.length * 2);
        }
        ++this.modCount;
        return null;
    }

    @Override
    @NullableDecl
    public V remove(@NullableDecl Object object) {
        return this.remove(object, Hashing.smearedHash(object));
    }

    void resizeEntries(int n2) {
        this.keys = Arrays.copyOf(this.keys, n2);
        this.values = Arrays.copyOf(this.values, n2);
        long[] lArray = this.entries;
        int n3 = lArray.length;
        lArray = Arrays.copyOf(lArray, n2);
        if (n2 > n3) {
            Arrays.fill(lArray, n3, n2, -1L);
        }
        this.entries = lArray;
    }

    @Override
    public int size() {
        return this.size;
    }

    public void trimToSize() {
        int n2;
        int n3 = this.size;
        if (n3 < this.entries.length) {
            this.resizeEntries(n3);
        }
        int n4 = n2 = Math.max(1, Integer.highestOneBit((int)((float)n3 / this.loadFactor)));
        if (n2 < 0x40000000) {
            double d2 = n3;
            double d3 = n2;
            Double.isNaN(d2);
            Double.isNaN(d3);
            n4 = n2;
            if (d2 / d3 > (double)this.loadFactor) {
                n4 = n2 << 1;
            }
        }
        if (n4 < this.table.length) {
            this.resizeTable(n4);
        }
    }

    @Override
    public Collection<V> values() {
        Collection<V> collection;
        Collection<V> collection2 = collection = this.valuesView;
        if (collection == null) {
            this.valuesView = collection2 = this.createValues();
        }
        return collection2;
    }

    Iterator<V> valuesIterator() {
        return new Itr<V>(){

            @Override
            V getOutput(int n2) {
                return CompactHashMap.this.values[n2];
            }
        };
    }

    class EntrySetView
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySetView() {
        }

        @Override
        public void clear() {
            CompactHashMap.this.clear();
        }

        @Override
        public boolean contains(@NullableDecl Object object) {
            boolean bl;
            boolean bl2 = object instanceof Map.Entry;
            boolean bl3 = bl = false;
            if (bl2) {
                object = (Map.Entry)object;
                int n2 = CompactHashMap.this.indexOf(object.getKey());
                bl3 = bl;
                if (n2 != -1) {
                    bl3 = bl;
                    if (Objects.equal(CompactHashMap.this.values[n2], object.getValue())) {
                        bl3 = true;
                    }
                }
            }
            return bl3;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return CompactHashMap.this.entrySetIterator();
        }

        @Override
        public boolean remove(@NullableDecl Object object) {
            int n2;
            if (object instanceof Map.Entry && (n2 = CompactHashMap.this.indexOf((object = (Map.Entry)object).getKey())) != -1 && Objects.equal(CompactHashMap.this.values[n2], object.getValue())) {
                CompactHashMap.this.removeEntry(n2);
                return true;
            }
            return false;
        }

        @Override
        public int size() {
            return CompactHashMap.this.size;
        }
    }

    private abstract class Itr<T>
    implements Iterator<T> {
        int currentIndex;
        int expectedModCount;
        int indexToRemove;

        private Itr() {
            this.expectedModCount = CompactHashMap.this.modCount;
            this.currentIndex = CompactHashMap.this.firstEntryIndex();
            this.indexToRemove = -1;
        }

        private void checkForConcurrentModification() {
            if (CompactHashMap.this.modCount == this.expectedModCount) {
                return;
            }
            throw new ConcurrentModificationException();
        }

        abstract T getOutput(int var1);

        @Override
        public boolean hasNext() {
            boolean bl = this.currentIndex >= 0;
            return bl;
        }

        @Override
        public T next() {
            this.checkForConcurrentModification();
            if (this.hasNext()) {
                int n2;
                this.indexToRemove = n2 = this.currentIndex;
                T t2 = this.getOutput(n2);
                this.currentIndex = CompactHashMap.this.getSuccessor(this.currentIndex);
                return t2;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            this.checkForConcurrentModification();
            boolean bl = this.indexToRemove >= 0;
            CollectPreconditions.checkRemove((boolean)bl);
            ++this.expectedModCount;
            CompactHashMap.this.removeEntry(this.indexToRemove);
            this.currentIndex = CompactHashMap.this.adjustAfterRemove(this.currentIndex, this.indexToRemove);
            this.indexToRemove = -1;
        }
    }

    class KeySetView
    extends AbstractSet<K> {
        KeySetView() {
        }

        @Override
        public void clear() {
            CompactHashMap.this.clear();
        }

        @Override
        public boolean contains(Object object) {
            return CompactHashMap.this.containsKey(object);
        }

        @Override
        public Iterator<K> iterator() {
            return CompactHashMap.this.keySetIterator();
        }

        @Override
        public boolean remove(@NullableDecl Object object) {
            int n2 = CompactHashMap.this.indexOf(object);
            if (n2 == -1) {
                return false;
            }
            CompactHashMap.this.removeEntry(n2);
            return true;
        }

        @Override
        public int size() {
            return CompactHashMap.this.size;
        }
    }

    final class MapEntry
    extends AbstractMapEntry<K, V> {
        @NullableDecl
        private final K key;
        private int lastKnownIndex;

        MapEntry(int n2) {
            this.key = CompactHashMap.this.keys[n2];
            this.lastKnownIndex = n2;
        }

        private void updateLastKnownIndex() {
            int n2 = this.lastKnownIndex;
            if (n2 == -1 || n2 >= CompactHashMap.this.size() || !Objects.equal(this.key, CompactHashMap.this.keys[this.lastKnownIndex])) {
                this.lastKnownIndex = CompactHashMap.this.indexOf(this.key);
            }
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            this.updateLastKnownIndex();
            Object object = this.lastKnownIndex == -1 ? null : CompactHashMap.this.values[this.lastKnownIndex];
            return object;
        }

        @Override
        public V setValue(V v2) {
            this.updateLastKnownIndex();
            if (this.lastKnownIndex == -1) {
                CompactHashMap.this.put(this.key, v2);
                return null;
            }
            Object object = CompactHashMap.this.values[this.lastKnownIndex];
            CompactHashMap.this.values[this.lastKnownIndex] = v2;
            return object;
        }
    }

    class ValuesView
    extends AbstractCollection<V> {
        ValuesView() {
        }

        @Override
        public void clear() {
            CompactHashMap.this.clear();
        }

        @Override
        public Iterator<V> iterator() {
            return CompactHashMap.this.valuesIterator();
        }

        @Override
        public int size() {
            return CompactHashMap.this.size;
        }
    }
}

