/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.ObjectCountHashMap;
import com.google.common.collect.Ordering;
import com.google.common.math.IntMath;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class Collections2 {
    private Collections2() {
    }

    static <T> Collection<T> cast(Iterable<T> iterable) {
        return (Collection)iterable;
    }

    static boolean containsAllImpl(Collection<?> collection, Collection<?> object) {
        object = object.iterator();
        while (object.hasNext()) {
            if (collection.contains(object.next())) continue;
            return false;
        }
        return true;
    }

    private static <E> ObjectCountHashMap<E> counts(Collection<E> object) {
        ObjectCountHashMap objectCountHashMap = new ObjectCountHashMap();
        object = object.iterator();
        while (object.hasNext()) {
            Object e2 = object.next();
            objectCountHashMap.put(e2, objectCountHashMap.get(e2) + 1);
        }
        return objectCountHashMap;
    }

    public static <E> Collection<E> filter(Collection<E> collection, Predicate<? super E> predicate) {
        if (collection instanceof FilteredCollection) {
            return ((FilteredCollection)collection).createCombined(predicate);
        }
        return new FilteredCollection<E>(Preconditions.checkNotNull(collection), Preconditions.checkNotNull(predicate));
    }

    private static boolean isPermutation(List<?> list, List<?> list2) {
        if (list.size() != list2.size()) {
            return false;
        }
        ObjectCountHashMap<?> objectCountHashMap = Collections2.counts(list);
        ObjectCountHashMap<?> objectCountHashMap2 = Collections2.counts(list2);
        if (list.size() != list2.size()) {
            return false;
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (objectCountHashMap.getValue(i2) == objectCountHashMap2.get(objectCountHashMap.getKey(i2))) continue;
            return false;
        }
        return true;
    }

    static StringBuilder newStringBuilderForCollection(int n2) {
        CollectPreconditions.checkNonnegative((int)n2, (String)"size");
        return new StringBuilder((int)Math.min((long)n2 * 8L, 0x40000000L));
    }

    public static <E extends Comparable<? super E>> Collection<List<E>> orderedPermutations(Iterable<E> iterable) {
        return Collections2.orderedPermutations(iterable, Ordering.natural());
    }

    public static <E> Collection<List<E>> orderedPermutations(Iterable<E> iterable, Comparator<? super E> comparator) {
        return new OrderedPermutationCollection<E>(iterable, comparator);
    }

    public static <E> Collection<List<E>> permutations(Collection<E> collection) {
        return new PermutationCollection<E>(ImmutableList.copyOf(collection));
    }

    static boolean safeContains(Collection<?> collection, @NullableDecl Object object) {
        Preconditions.checkNotNull(collection);
        try {
            boolean bl = collection.contains(object);
            return bl;
        }
        catch (ClassCastException | NullPointerException runtimeException) {
            return false;
        }
    }

    static boolean safeRemove(Collection<?> collection, @NullableDecl Object object) {
        Preconditions.checkNotNull(collection);
        try {
            boolean bl = collection.remove(object);
            return bl;
        }
        catch (ClassCastException | NullPointerException runtimeException) {
            return false;
        }
    }

    static String toStringImpl(Collection<?> collection) {
        StringBuilder stringBuilder = Collections2.newStringBuilderForCollection(collection.size());
        stringBuilder.append('[');
        Iterator<?> iterator2 = collection.iterator();
        boolean bl = true;
        while (iterator2.hasNext()) {
            Object obj = iterator2.next();
            if (!bl) {
                stringBuilder.append(", ");
            }
            bl = false;
            if (obj == collection) {
                stringBuilder.append("(this Collection)");
                continue;
            }
            stringBuilder.append(obj);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static <F, T> Collection<T> transform(Collection<F> collection, Function<? super F, T> function) {
        return new TransformedCollection<F, T>(collection, function);
    }

    static class FilteredCollection<E>
    extends AbstractCollection<E> {
        final Predicate<? super E> predicate;
        final Collection<E> unfiltered;

        FilteredCollection(Collection<E> collection, Predicate<? super E> predicate) {
            this.unfiltered = collection;
            this.predicate = predicate;
        }

        @Override
        public boolean add(E e2) {
            Preconditions.checkArgument(this.predicate.apply(e2));
            return this.unfiltered.add(e2);
        }

        @Override
        public boolean addAll(Collection<? extends E> collection) {
            for (E e2 : collection) {
                Preconditions.checkArgument(this.predicate.apply(e2));
            }
            return this.unfiltered.addAll(collection);
        }

        @Override
        public void clear() {
            Iterables.removeIf(this.unfiltered, this.predicate);
        }

        @Override
        public boolean contains(@NullableDecl Object object) {
            if (Collections2.safeContains(this.unfiltered, object)) {
                return this.predicate.apply(object);
            }
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return Collections2.containsAllImpl(this, collection);
        }

        FilteredCollection<E> createCombined(Predicate<? super E> predicate) {
            return new FilteredCollection<E>(this.unfiltered, Predicates.and(this.predicate, predicate));
        }

        @Override
        public boolean isEmpty() {
            return Iterables.any(this.unfiltered, this.predicate) ^ true;
        }

        @Override
        public Iterator<E> iterator() {
            return Iterators.filter(this.unfiltered.iterator(), this.predicate);
        }

        @Override
        public boolean remove(Object object) {
            boolean bl = this.contains(object) && this.unfiltered.remove(object);
            return bl;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            Iterator<E> iterator2 = this.unfiltered.iterator();
            boolean bl = false;
            while (iterator2.hasNext()) {
                E e2 = iterator2.next();
                if (!this.predicate.apply(e2) || !collection.contains(e2)) continue;
                iterator2.remove();
                bl = true;
            }
            return bl;
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            Iterator<E> iterator2 = this.unfiltered.iterator();
            boolean bl = false;
            while (iterator2.hasNext()) {
                E e2 = iterator2.next();
                if (!this.predicate.apply(e2) || collection.contains(e2)) continue;
                iterator2.remove();
                bl = true;
            }
            return bl;
        }

        @Override
        public int size() {
            Iterator<E> iterator2 = this.unfiltered.iterator();
            int n2 = 0;
            while (iterator2.hasNext()) {
                E e2 = iterator2.next();
                if (!this.predicate.apply(e2)) continue;
                ++n2;
            }
            return n2;
        }

        @Override
        public Object[] toArray() {
            return Lists.newArrayList(this.iterator()).toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return Lists.newArrayList(this.iterator()).toArray(TArray);
        }
    }

    private static final class OrderedPermutationCollection<E>
    extends AbstractCollection<List<E>> {
        final Comparator<? super E> comparator;
        final ImmutableList<E> inputList;
        final int size;

        OrderedPermutationCollection(Iterable<E> iterable, Comparator<? super E> comparator) {
            this.inputList = ImmutableList.sortedCopyOf(comparator, iterable);
            this.comparator = comparator;
            this.size = OrderedPermutationCollection.calculateSize(this.inputList, comparator);
        }

        private static <E> int calculateSize(List<E> list, Comparator<? super E> comparator) {
            int n2;
            int n3 = 1;
            int n4 = 1;
            for (n2 = 1; n2 < list.size(); ++n2) {
                int n5 = n3;
                int n6 = n4;
                if (comparator.compare(list.get(n2 - 1), list.get(n2)) < 0) {
                    n4 = IntMath.saturatedMultiply((int)n3, (int)IntMath.binomial((int)n2, (int)n4));
                    n6 = 0;
                    n5 = n4;
                    if (n4 == Integer.MAX_VALUE) {
                        return Integer.MAX_VALUE;
                    }
                }
                n4 = n6 + 1;
                n3 = n5;
            }
            return IntMath.saturatedMultiply((int)n3, (int)IntMath.binomial((int)n2, (int)n4));
        }

        @Override
        public boolean contains(@NullableDecl Object object) {
            if (object instanceof List) {
                object = (List)object;
                return Collections2.isPermutation(this.inputList, (List)object);
            }
            return false;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Iterator<List<E>> iterator() {
            return new OrderedPermutationIterator<E>(this.inputList, this.comparator);
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("orderedPermutationCollection(");
            stringBuilder.append(this.inputList);
            stringBuilder.append(")");
            return stringBuilder.toString();
        }
    }

    private static final class OrderedPermutationIterator<E>
    extends AbstractIterator<List<E>> {
        final Comparator<? super E> comparator;
        @NullableDecl
        List<E> nextPermutation;

        OrderedPermutationIterator(List<E> list, Comparator<? super E> comparator) {
            this.nextPermutation = Lists.newArrayList(list);
            this.comparator = comparator;
        }

        void calculateNextPermutation() {
            int n2 = this.findNextJ();
            if (n2 == -1) {
                this.nextPermutation = null;
                return;
            }
            int n3 = this.findNextL(n2);
            Collections.swap(this.nextPermutation, n2, n3);
            n3 = this.nextPermutation.size();
            Collections.reverse(this.nextPermutation.subList(n2 + 1, n3));
        }

        @Override
        protected List<E> computeNext() {
            List<E> list = this.nextPermutation;
            if (list == null) {
                return (List)this.endOfData();
            }
            list = ImmutableList.copyOf(list);
            this.calculateNextPermutation();
            return list;
        }

        int findNextJ() {
            for (int i2 = this.nextPermutation.size() - 2; i2 >= 0; --i2) {
                if (this.comparator.compare(this.nextPermutation.get(i2), this.nextPermutation.get(i2 + 1)) >= 0) continue;
                return i2;
            }
            return -1;
        }

        int findNextL(int n2) {
            Object object = this.nextPermutation.get(n2);
            for (int i2 = this.nextPermutation.size() - 1; i2 > n2; --i2) {
                if (this.comparator.compare(object, this.nextPermutation.get(i2)) >= 0) continue;
                return i2;
            }
            object = new AssertionError((Object)"this statement should be unreachable");
            throw object;
        }
    }

    private static final class PermutationCollection<E>
    extends AbstractCollection<List<E>> {
        final ImmutableList<E> inputList;

        PermutationCollection(ImmutableList<E> immutableList) {
            this.inputList = immutableList;
        }

        @Override
        public boolean contains(@NullableDecl Object object) {
            if (object instanceof List) {
                object = (List)object;
                return Collections2.isPermutation(this.inputList, (List)object);
            }
            return false;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Iterator<List<E>> iterator() {
            return new PermutationIterator<E>(this.inputList);
        }

        @Override
        public int size() {
            return IntMath.factorial((int)this.inputList.size());
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("permutations(");
            stringBuilder.append(this.inputList);
            stringBuilder.append(")");
            return stringBuilder.toString();
        }
    }

    private static class PermutationIterator<E>
    extends AbstractIterator<List<E>> {
        final int[] c;
        int j;
        final List<E> list;
        final int[] o;

        PermutationIterator(List<E> list) {
            this.list = new ArrayList<E>(list);
            int n2 = list.size();
            this.c = new int[n2];
            this.o = new int[n2];
            Arrays.fill(this.c, 0);
            Arrays.fill(this.o, 1);
            this.j = Integer.MAX_VALUE;
        }

        void calculateNextPermutation() {
            block4: {
                int n2;
                int[] nArray;
                int n3;
                this.j = this.list.size() - 1;
                if (this.j == -1) {
                    return;
                }
                int n4 = 0;
                while (true) {
                    if ((n3 = (nArray = this.c)[n2 = this.j] + this.o[n2]) < 0) {
                        this.switchDirection();
                        continue;
                    }
                    if (n3 != n2 + 1) break;
                    if (n2 != 0) {
                        ++n4;
                        this.switchDirection();
                        continue;
                    }
                    break block4;
                    break;
                }
                Collections.swap(this.list, n2 - nArray[n2] + n4, n2 - n3 + n4);
                this.c[this.j] = n3;
            }
        }

        @Override
        protected List<E> computeNext() {
            if (this.j <= 0) {
                return (List)this.endOfData();
            }
            ImmutableList<E> immutableList = ImmutableList.copyOf(this.list);
            this.calculateNextPermutation();
            return immutableList;
        }

        void switchDirection() {
            int[] nArray = this.o;
            int n2 = this.j;
            nArray[n2] = -nArray[n2];
            this.j = n2 - 1;
        }
    }

    static class TransformedCollection<F, T>
    extends AbstractCollection<T> {
        final Collection<F> fromCollection;
        final Function<? super F, ? extends T> function;

        TransformedCollection(Collection<F> collection, Function<? super F, ? extends T> function) {
            this.fromCollection = Preconditions.checkNotNull(collection);
            this.function = Preconditions.checkNotNull(function);
        }

        @Override
        public void clear() {
            this.fromCollection.clear();
        }

        @Override
        public boolean isEmpty() {
            return this.fromCollection.isEmpty();
        }

        @Override
        public Iterator<T> iterator() {
            return Iterators.transform(this.fromCollection.iterator(), this.function);
        }

        @Override
        public int size() {
            return this.fromCollection.size();
        }
    }
}

