/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.math.IntMath;
import java.util.AbstractList;
import java.util.List;
import java.util.RandomAccess;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

final class CartesianList<E>
extends AbstractList<List<E>>
implements RandomAccess {
    private final transient ImmutableList<List<E>> axes;
    private final transient int[] axesSizeProduct;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    CartesianList(ImmutableList<List<E>> immutableList) {
        this.axes = immutableList;
        int[] nArray = new int[immutableList.size() + 1];
        nArray[immutableList.size()] = 1;
        try {
            int n2 = immutableList.size() - 1;
            while (true) {
                if (n2 < 0) {
                    this.axesSizeProduct = nArray;
                    return;
                }
                nArray[n2] = IntMath.checkedMultiply((int)nArray[n2 + 1], (int)((List)immutableList.get(n2)).size());
                --n2;
            }
        }
        catch (ArithmeticException arithmeticException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Cartesian product too large; must have size at most Integer.MAX_VALUE");
            throw illegalArgumentException;
        }
    }

    static <E> List<List<E>> create(List<? extends List<? extends E>> object) {
        ImmutableList.Builder builder = new ImmutableList.Builder(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            ImmutableList immutableList = ImmutableList.copyOf((List)object.next());
            if (immutableList.isEmpty()) {
                return ImmutableList.of();
            }
            builder.add(immutableList);
        }
        return new CartesianList<E>(builder.build());
    }

    private int getAxisIndexForProductIndex(int n2, int n3) {
        return n2 / this.axesSizeProduct[n3 + 1] % ((List)this.axes.get(n3)).size();
    }

    @Override
    public boolean contains(@NullableDecl Object object) {
        boolean bl = this.indexOf(object) != -1;
        return bl;
    }

    @Override
    public ImmutableList<E> get(final int n2) {
        Preconditions.checkElementIndex(n2, this.size());
        return new ImmutableList<E>(){

            @Override
            public E get(int n22) {
                Preconditions.checkElementIndex(n22, this.size());
                int n3 = CartesianList.this.getAxisIndexForProductIndex(n2, n22);
                return ((List)CartesianList.this.axes.get(n22)).get(n3);
            }

            @Override
            boolean isPartialView() {
                return true;
            }

            @Override
            public int size() {
                return CartesianList.this.axes.size();
            }
        };
    }

    @Override
    public int indexOf(Object listIterator) {
        if (!(listIterator instanceof List)) {
            return -1;
        }
        if ((listIterator = (List)((Object)listIterator)).size() != this.axes.size()) {
            return -1;
        }
        listIterator = listIterator.listIterator();
        int n2 = 0;
        while (listIterator.hasNext()) {
            int n3 = listIterator.nextIndex();
            int n4 = ((List)this.axes.get(n3)).indexOf(listIterator.next());
            if (n4 == -1) {
                return -1;
            }
            n2 += n4 * this.axesSizeProduct[n3 + 1];
        }
        return n2;
    }

    @Override
    public int size() {
        return this.axesSizeProduct[0];
    }
}

