/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIndexedListIterator;
import com.google.common.collect.AbstractMapEntry;
import com.google.common.collect.AbstractTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.compatqual.MonotonicNonNullDecl;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class ArrayTable<R, C, V>
extends AbstractTable<R, C, V>
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final V[][] array;
    private final ImmutableMap<C, Integer> columnKeyToIndex;
    private final ImmutableList<C> columnList;
    @MonotonicNonNullDecl
    private transient ColumnMap columnMap;
    private final ImmutableMap<R, Integer> rowKeyToIndex;
    private final ImmutableList<R> rowList;
    @MonotonicNonNullDecl
    private transient RowMap rowMap;

    private ArrayTable(ArrayTable<R, C, V> arrayTable) {
        this.rowList = arrayTable.rowList;
        this.columnList = arrayTable.columnList;
        this.rowKeyToIndex = arrayTable.rowKeyToIndex;
        this.columnKeyToIndex = arrayTable.columnKeyToIndex;
        Object[][] objectArray = new Object[this.rowList.size()][this.columnList.size()];
        this.array = objectArray;
        for (int i2 = 0; i2 < this.rowList.size(); ++i2) {
            V[][] VArray = arrayTable.array;
            System.arraycopy(VArray[i2], 0, objectArray[i2], 0, VArray[i2].length);
        }
    }

    private ArrayTable(Table<R, C, V> table) {
        this(table.rowKeySet(), table.columnKeySet());
        this.putAll(table);
    }

    private ArrayTable(Iterable<? extends R> iterable, Iterable<? extends C> iterable2) {
        this.rowList = ImmutableList.copyOf(iterable);
        this.columnList = ImmutableList.copyOf(iterable2);
        boolean bl = this.rowList.isEmpty() == this.columnList.isEmpty();
        Preconditions.checkArgument(bl);
        this.rowKeyToIndex = Maps.indexMap(this.rowList);
        this.columnKeyToIndex = Maps.indexMap(this.columnList);
        this.array = new Object[this.rowList.size()][this.columnList.size()];
        this.eraseAll();
    }

    public static <R, C, V> ArrayTable<R, C, V> create(Table<R, C, V> table) {
        table = table instanceof ArrayTable ? new ArrayTable<R, C, V>((ArrayTable)table) : new ArrayTable<R, C, V>(table);
        return table;
    }

    public static <R, C, V> ArrayTable<R, C, V> create(Iterable<? extends R> iterable, Iterable<? extends C> iterable2) {
        return new ArrayTable<R, C, V>(iterable, iterable2);
    }

    private Table.Cell<R, C, V> getCell(final int n2) {
        return new Tables.AbstractCell<R, C, V>(){
            final int columnIndex;
            final int rowIndex;
            {
                this.rowIndex = n2 / ArrayTable.this.columnList.size();
                this.columnIndex = n2 % ArrayTable.this.columnList.size();
            }

            @Override
            public C getColumnKey() {
                return ArrayTable.this.columnList.get(this.columnIndex);
            }

            @Override
            public R getRowKey() {
                return ArrayTable.this.rowList.get(this.rowIndex);
            }

            @Override
            public V getValue() {
                return ArrayTable.this.at(this.rowIndex, this.columnIndex);
            }
        };
    }

    private V getValue(int n2) {
        return this.at(n2 / this.columnList.size(), n2 % this.columnList.size());
    }

    public V at(int n2, int n3) {
        Preconditions.checkElementIndex(n2, this.rowList.size());
        Preconditions.checkElementIndex(n3, this.columnList.size());
        return this.array[n2][n3];
    }

    @Override
    Iterator<Table.Cell<R, C, V>> cellIterator() {
        return new AbstractIndexedListIterator<Table.Cell<R, C, V>>(this.size()){

            protected Table.Cell<R, C, V> get(int n2) {
                return ArrayTable.this.getCell(n2);
            }
        };
    }

    @Override
    public Set<Table.Cell<R, C, V>> cellSet() {
        return super.cellSet();
    }

    @Override
    @Deprecated
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<R, V> column(C object) {
        Preconditions.checkNotNull(object);
        object = this.columnKeyToIndex.get(object);
        object = object == null ? ImmutableMap.of() : new Column((Integer)object);
        return object;
    }

    public ImmutableList<C> columnKeyList() {
        return this.columnList;
    }

    @Override
    public ImmutableSet<C> columnKeySet() {
        return this.columnKeyToIndex.keySet();
    }

    @Override
    public Map<C, Map<R, V>> columnMap() {
        ColumnMap columnMap;
        ColumnMap columnMap2 = columnMap = this.columnMap;
        if (columnMap == null) {
            this.columnMap = columnMap2 = new ColumnMap();
        }
        return columnMap2;
    }

    @Override
    public boolean contains(@NullableDecl Object object, @NullableDecl Object object2) {
        boolean bl = this.containsRow(object) && this.containsColumn(object2);
        return bl;
    }

    @Override
    public boolean containsColumn(@NullableDecl Object object) {
        return this.columnKeyToIndex.containsKey(object);
    }

    @Override
    public boolean containsRow(@NullableDecl Object object) {
        return this.rowKeyToIndex.containsKey(object);
    }

    @Override
    public boolean containsValue(@NullableDecl Object object) {
        for (V[] VArray : this.array) {
            int n2 = VArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!Objects.equal(object, VArray[i2])) continue;
                return true;
            }
        }
        return false;
    }

    public V erase(@NullableDecl Object object, @NullableDecl Object object2) {
        object = this.rowKeyToIndex.get(object);
        object2 = this.columnKeyToIndex.get(object2);
        if (object != null && object2 != null) {
            return this.set((Integer)object, (Integer)object2, null);
        }
        return null;
    }

    public void eraseAll() {
        V[][] VArray = this.array;
        int n2 = VArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Arrays.fill(VArray[i2], null);
        }
    }

    @Override
    public V get(@NullableDecl Object object, @NullableDecl Object object2) {
        object = this.rowKeyToIndex.get(object);
        object2 = this.columnKeyToIndex.get(object2);
        object = object != null && object2 != null ? this.at((Integer)object, (Integer)object2) : null;
        return (V)object;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.rowList.isEmpty() || this.columnList.isEmpty();
        return bl;
    }

    @Override
    public V put(R object, C c2, @NullableDecl V v2) {
        Preconditions.checkNotNull(object);
        Preconditions.checkNotNull(c2);
        Integer n2 = this.rowKeyToIndex.get(object);
        boolean bl = true;
        boolean bl2 = n2 != null;
        Preconditions.checkArgument(bl2, "Row %s not in %s", object, this.rowList);
        object = this.columnKeyToIndex.get(c2);
        bl2 = object != null ? bl : false;
        Preconditions.checkArgument(bl2, "Column %s not in %s", c2, this.columnList);
        return this.set(n2, (Integer)object, v2);
    }

    @Override
    public void putAll(Table<? extends R, ? extends C, ? extends V> table) {
        super.putAll(table);
    }

    @Override
    @Deprecated
    public V remove(Object object, Object object2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<C, V> row(R object) {
        Preconditions.checkNotNull(object);
        object = this.rowKeyToIndex.get(object);
        object = object == null ? ImmutableMap.of() : new Row((Integer)object);
        return object;
    }

    public ImmutableList<R> rowKeyList() {
        return this.rowList;
    }

    @Override
    public ImmutableSet<R> rowKeySet() {
        return this.rowKeyToIndex.keySet();
    }

    @Override
    public Map<R, Map<C, V>> rowMap() {
        RowMap rowMap;
        RowMap rowMap2 = rowMap = this.rowMap;
        if (rowMap == null) {
            this.rowMap = rowMap2 = new RowMap();
        }
        return rowMap2;
    }

    public V set(int n2, int n3, @NullableDecl V v2) {
        Preconditions.checkElementIndex(n2, this.rowList.size());
        Preconditions.checkElementIndex(n3, this.columnList.size());
        V[][] VArray = this.array;
        V v3 = VArray[n2][n3];
        VArray[n2][n3] = v2;
        return v3;
    }

    @Override
    public int size() {
        return this.rowList.size() * this.columnList.size();
    }

    public V[][] toArray(Class<V> objectArray) {
        objectArray = (Object[][])Array.newInstance(objectArray, new int[]{this.rowList.size(), this.columnList.size()});
        for (int i2 = 0; i2 < this.rowList.size(); ++i2) {
            V[][] VArray = this.array;
            System.arraycopy(VArray[i2], 0, objectArray[i2], 0, VArray[i2].length);
        }
        return objectArray;
    }

    @Override
    public Collection<V> values() {
        return super.values();
    }

    @Override
    Iterator<V> valuesIterator() {
        return new AbstractIndexedListIterator<V>(this.size()){

            protected V get(int n2) {
                return ArrayTable.this.getValue(n2);
            }
        };
    }

    private static abstract class ArrayMap<K, V>
    extends Maps.IteratorBasedAbstractMap<K, V> {
        private final ImmutableMap<K, Integer> keyIndex;

        private ArrayMap(ImmutableMap<K, Integer> immutableMap) {
            this.keyIndex = immutableMap;
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsKey(@NullableDecl Object object) {
            return this.keyIndex.containsKey(object);
        }

        @Override
        Iterator<Map.Entry<K, V>> entryIterator() {
            return new AbstractIndexedListIterator<Map.Entry<K, V>>(this.size()){

                protected Map.Entry<K, V> get(int n2) {
                    return ArrayMap.this.getEntry(n2);
                }
            };
        }

        @Override
        public V get(@NullableDecl Object object) {
            if ((object = this.keyIndex.get(object)) == null) {
                return null;
            }
            return this.getValue((Integer)object);
        }

        Map.Entry<K, V> getEntry(final int n2) {
            Preconditions.checkElementIndex(n2, this.size());
            return new AbstractMapEntry<K, V>(){

                @Override
                public K getKey() {
                    return ArrayMap.this.getKey(n2);
                }

                @Override
                public V getValue() {
                    return ArrayMap.this.getValue(n2);
                }

                @Override
                public V setValue(V v2) {
                    return ArrayMap.this.setValue(n2, v2);
                }
            };
        }

        K getKey(int n2) {
            return (K)((ImmutableSet)this.keyIndex.keySet()).asList().get(n2);
        }

        abstract String getKeyRole();

        @NullableDecl
        abstract V getValue(int var1);

        @Override
        public boolean isEmpty() {
            return this.keyIndex.isEmpty();
        }

        @Override
        public Set<K> keySet() {
            return this.keyIndex.keySet();
        }

        @Override
        public V put(K k2, V object) {
            Integer n2 = this.keyIndex.get(k2);
            if (n2 != null) {
                return this.setValue(n2, object);
            }
            object = new StringBuilder();
            ((StringBuilder)object).append(this.getKeyRole());
            ((StringBuilder)object).append(" ");
            ((StringBuilder)object).append(k2);
            ((StringBuilder)object).append(" not in ");
            ((StringBuilder)object).append(this.keyIndex.keySet());
            throw new IllegalArgumentException(((StringBuilder)object).toString());
        }

        @Override
        public V remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @NullableDecl
        abstract V setValue(int var1, V var2);

        @Override
        public int size() {
            return this.keyIndex.size();
        }
    }

    private class Column
    extends ArrayMap<R, V> {
        final int columnIndex;

        Column(int n2) {
            super(ArrayTable.this.rowKeyToIndex);
            this.columnIndex = n2;
        }

        @Override
        String getKeyRole() {
            return "Row";
        }

        @Override
        V getValue(int n2) {
            return ArrayTable.this.at(n2, this.columnIndex);
        }

        @Override
        V setValue(int n2, V v2) {
            return ArrayTable.this.set(n2, this.columnIndex, v2);
        }
    }

    private class ColumnMap
    extends ArrayMap<C, Map<R, V>> {
        private ColumnMap() {
            super(ArrayTable.this.columnKeyToIndex);
        }

        @Override
        String getKeyRole() {
            return "Column";
        }

        @Override
        Map<R, V> getValue(int n2) {
            return new Column(n2);
        }

        @Override
        public Map<R, V> put(C c2, Map<R, V> map) {
            throw new UnsupportedOperationException();
        }

        @Override
        Map<R, V> setValue(int n2, Map<R, V> map) {
            throw new UnsupportedOperationException();
        }
    }

    private class Row
    extends ArrayMap<C, V> {
        final int rowIndex;

        Row(int n2) {
            super(ArrayTable.this.columnKeyToIndex);
            this.rowIndex = n2;
        }

        @Override
        String getKeyRole() {
            return "Column";
        }

        @Override
        V getValue(int n2) {
            return ArrayTable.this.at(this.rowIndex, n2);
        }

        @Override
        V setValue(int n2, V v2) {
            return ArrayTable.this.set(this.rowIndex, n2, v2);
        }
    }

    private class RowMap
    extends ArrayMap<R, Map<C, V>> {
        private RowMap() {
            super(ArrayTable.this.rowKeyToIndex);
        }

        @Override
        String getKeyRole() {
            return "Row";
        }

        @Override
        Map<C, V> getValue(int n2) {
            return new Row(n2);
        }

        @Override
        public Map<C, V> put(R r2, Map<C, V> map) {
            throw new UnsupportedOperationException();
        }

        @Override
        Map<C, V> setValue(int n2, Map<C, V> map) {
            throw new UnsupportedOperationException();
        }
    }
}

