/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.ArrayListMultimapGwtSerializationDependencies;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.CompactHashMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Platform;
import com.google.common.collect.Serialization;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class ArrayListMultimap<K, V>
extends ArrayListMultimapGwtSerializationDependencies<K, V> {
    private static final int DEFAULT_VALUES_PER_KEY = 3;
    private static final long serialVersionUID = 0L;
    transient int expectedValuesPerKey;

    private ArrayListMultimap() {
        this(12, 3);
    }

    private ArrayListMultimap(int n2, int n3) {
        super(Platform.newHashMapWithExpectedSize((int)n2));
        CollectPreconditions.checkNonnegative((int)n3, (String)"expectedValuesPerKey");
        this.expectedValuesPerKey = n3;
    }

    private ArrayListMultimap(Multimap<? extends K, ? extends V> multimap) {
        int n2 = multimap.keySet().size();
        int n3 = multimap instanceof ArrayListMultimap ? ((ArrayListMultimap)multimap).expectedValuesPerKey : 3;
        this(n2, n3);
        this.putAll((Multimap)multimap);
    }

    public static <K, V> ArrayListMultimap<K, V> create() {
        return new ArrayListMultimap<K, V>();
    }

    public static <K, V> ArrayListMultimap<K, V> create(int n2, int n3) {
        return new ArrayListMultimap<K, V>(n2, n3);
    }

    public static <K, V> ArrayListMultimap<K, V> create(Multimap<? extends K, ? extends V> multimap) {
        return new ArrayListMultimap<K, V>(multimap);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.expectedValuesPerKey = 3;
        int n2 = Serialization.readCount((ObjectInputStream)objectInputStream);
        this.setMap(CompactHashMap.create());
        Serialization.populateMultimap((Multimap)this, (ObjectInputStream)objectInputStream, (int)n2);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Serialization.writeMultimap((Multimap)this, (ObjectOutputStream)objectOutputStream);
    }

    @Override
    List<V> createCollection() {
        return new ArrayList(this.expectedValuesPerKey);
    }

    @Deprecated
    public void trimToSize() {
        Iterator iterator2 = this.backingMap().values().iterator();
        while (iterator2.hasNext()) {
            ((ArrayList)iterator2.next()).trimToSize();
        }
    }
}

