/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.Collections2;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.google.common.collect.TransformedIterator;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.compatqual.MonotonicNonNullDecl;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

abstract class AbstractTable<R, C, V>
implements Table<R, C, V> {
    @MonotonicNonNullDecl
    private transient Set<Table.Cell<R, C, V>> cellSet;
    @MonotonicNonNullDecl
    private transient Collection<V> values;

    AbstractTable() {
    }

    abstract Iterator<Table.Cell<R, C, V>> cellIterator();

    @Override
    public Set<Table.Cell<R, C, V>> cellSet() {
        Set<Table.Cell<R, C, V>> set;
        Set<Table.Cell<R, C, V>> set2 = set = this.cellSet;
        if (set == null) {
            this.cellSet = set2 = this.createCellSet();
        }
        return set2;
    }

    @Override
    public void clear() {
        Iterators.clear(this.cellSet().iterator());
    }

    @Override
    public Set<C> columnKeySet() {
        return this.columnMap().keySet();
    }

    @Override
    public boolean contains(@NullableDecl Object map, @NullableDecl Object object) {
        map = Maps.safeGet(this.rowMap(), map);
        boolean bl = map != null && Maps.safeContainsKey(map, object);
        return bl;
    }

    @Override
    public boolean containsColumn(@NullableDecl Object object) {
        return Maps.safeContainsKey(this.columnMap(), object);
    }

    @Override
    public boolean containsRow(@NullableDecl Object object) {
        return Maps.safeContainsKey(this.rowMap(), object);
    }

    @Override
    public boolean containsValue(@NullableDecl Object object) {
        Iterator iterator2 = this.rowMap().values().iterator();
        while (iterator2.hasNext()) {
            if (!iterator2.next().containsValue(object)) continue;
            return true;
        }
        return false;
    }

    Set<Table.Cell<R, C, V>> createCellSet() {
        return new CellSet();
    }

    Collection<V> createValues() {
        return new Values();
    }

    @Override
    public boolean equals(@NullableDecl Object object) {
        return Tables.equalsImpl(this, object);
    }

    @Override
    public V get(@NullableDecl Object map, @NullableDecl Object object) {
        map = Maps.safeGet(this.rowMap(), map);
        map = map == null ? null : Maps.safeGet(map, object);
        return (V)map;
    }

    @Override
    public int hashCode() {
        return this.cellSet().hashCode();
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.size() == 0;
        return bl;
    }

    @Override
    public V put(R r2, C c2, V v2) {
        return this.row(r2).put(c2, v2);
    }

    @Override
    public void putAll(Table<? extends R, ? extends C, ? extends V> object) {
        for (Table.Cell cell : object.cellSet()) {
            this.put(cell.getRowKey(), cell.getColumnKey(), cell.getValue());
        }
    }

    @Override
    public V remove(@NullableDecl Object map, @NullableDecl Object object) {
        map = Maps.safeGet(this.rowMap(), map);
        map = map == null ? null : Maps.safeRemove(map, object);
        return (V)map;
    }

    @Override
    public Set<R> rowKeySet() {
        return this.rowMap().keySet();
    }

    public String toString() {
        return this.rowMap().toString();
    }

    @Override
    public Collection<V> values() {
        Collection<V> collection;
        Collection<V> collection2 = collection = this.values;
        if (collection == null) {
            this.values = collection2 = this.createValues();
        }
        return collection2;
    }

    Iterator<V> valuesIterator() {
        return new TransformedIterator<Table.Cell<R, C, V>, V>(this.cellSet().iterator()){

            V transform(Table.Cell<R, C, V> cell) {
                return cell.getValue();
            }
        };
    }

    class CellSet
    extends AbstractSet<Table.Cell<R, C, V>> {
        CellSet() {
        }

        @Override
        public void clear() {
            AbstractTable.this.clear();
        }

        @Override
        public boolean contains(Object object) {
            boolean bl;
            boolean bl2 = object instanceof Table.Cell;
            boolean bl3 = bl = false;
            if (bl2) {
                object = (Table.Cell)object;
                Map map = Maps.safeGet(AbstractTable.this.rowMap(), object.getRowKey());
                bl3 = bl;
                if (map != null) {
                    bl3 = bl;
                    if (Collections2.safeContains(map.entrySet(), Maps.immutableEntry(object.getColumnKey(), object.getValue()))) {
                        bl3 = true;
                    }
                }
            }
            return bl3;
        }

        @Override
        public Iterator<Table.Cell<R, C, V>> iterator() {
            return AbstractTable.this.cellIterator();
        }

        @Override
        public boolean remove(@NullableDecl Object object) {
            boolean bl;
            boolean bl2 = object instanceof Table.Cell;
            boolean bl3 = bl = false;
            if (bl2) {
                object = (Table.Cell)object;
                Map map = Maps.safeGet(AbstractTable.this.rowMap(), object.getRowKey());
                bl3 = bl;
                if (map != null) {
                    bl3 = bl;
                    if (Collections2.safeRemove(map.entrySet(), Maps.immutableEntry(object.getColumnKey(), object.getValue()))) {
                        bl3 = true;
                    }
                }
            }
            return bl3;
        }

        @Override
        public int size() {
            return AbstractTable.this.size();
        }
    }

    class Values
    extends AbstractCollection<V> {
        Values() {
        }

        @Override
        public void clear() {
            AbstractTable.this.clear();
        }

        @Override
        public boolean contains(Object object) {
            return AbstractTable.this.containsValue(object);
        }

        @Override
        public Iterator<V> iterator() {
            return AbstractTable.this.valuesIterator();
        }

        @Override
        public int size() {
            return AbstractTable.this.size();
        }
    }
}

