/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

abstract class AbstractRangeSet<C extends Comparable>
implements RangeSet<C> {
    AbstractRangeSet() {
    }

    @Override
    public void add(Range<C> range) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addAll(RangeSet<C> rangeSet) {
        this.addAll(rangeSet.asRanges());
    }

    @Override
    public void addAll(Iterable<Range<C>> object) {
        object = object.iterator();
        while (object.hasNext()) {
            this.add((Range)object.next());
        }
    }

    @Override
    public void clear() {
        this.remove(Range.all());
    }

    @Override
    public boolean contains(C c2) {
        boolean bl = this.rangeContaining(c2) != null;
        return bl;
    }

    @Override
    public abstract boolean encloses(Range<C> var1);

    @Override
    public boolean enclosesAll(RangeSet<C> rangeSet) {
        return this.enclosesAll(rangeSet.asRanges());
    }

    @Override
    public boolean enclosesAll(Iterable<Range<C>> object) {
        object = object.iterator();
        while (object.hasNext()) {
            if (this.encloses((Range)object.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(@NullableDecl Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof RangeSet) {
            object = (RangeSet)object;
            return this.asRanges().equals(object.asRanges());
        }
        return false;
    }

    @Override
    public final int hashCode() {
        return this.asRanges().hashCode();
    }

    @Override
    public boolean intersects(Range<C> range) {
        return this.subRangeSet(range).isEmpty() ^ true;
    }

    @Override
    public boolean isEmpty() {
        return this.asRanges().isEmpty();
    }

    @Override
    public abstract Range<C> rangeContaining(C var1);

    @Override
    public void remove(Range<C> range) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeAll(RangeSet<C> rangeSet) {
        this.removeAll(rangeSet.asRanges());
    }

    @Override
    public void removeAll(Iterable<Range<C>> object) {
        object = object.iterator();
        while (object.hasNext()) {
            this.remove((Range)object.next());
        }
    }

    @Override
    public final String toString() {
        return this.asRanges().toString();
    }
}

