/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

abstract class AbstractNavigableMap<K, V>
extends Maps.IteratorBasedAbstractMap<K, V>
implements NavigableMap<K, V> {
    AbstractNavigableMap() {
    }

    @Override
    @NullableDecl
    public Map.Entry<K, V> ceilingEntry(K k2) {
        return this.tailMap(k2, true).firstEntry();
    }

    @Override
    public K ceilingKey(K k2) {
        return Maps.keyOrNull(this.ceilingEntry(k2));
    }

    abstract Iterator<Map.Entry<K, V>> descendingEntryIterator();

    @Override
    public NavigableSet<K> descendingKeySet() {
        return this.descendingMap().navigableKeySet();
    }

    @Override
    public NavigableMap<K, V> descendingMap() {
        return new DescendingMap();
    }

    @Override
    @NullableDecl
    public Map.Entry<K, V> firstEntry() {
        return Iterators.getNext(this.entryIterator(), null);
    }

    @Override
    public K firstKey() {
        Map.Entry<K, V> entry = this.firstEntry();
        if (entry != null) {
            return entry.getKey();
        }
        throw new NoSuchElementException();
    }

    @Override
    @NullableDecl
    public Map.Entry<K, V> floorEntry(K k2) {
        return this.headMap(k2, true).lastEntry();
    }

    @Override
    public K floorKey(K k2) {
        return Maps.keyOrNull(this.floorEntry(k2));
    }

    @Override
    @NullableDecl
    public abstract V get(@NullableDecl Object var1);

    @Override
    public SortedMap<K, V> headMap(K k2) {
        return this.headMap(k2, false);
    }

    @Override
    @NullableDecl
    public Map.Entry<K, V> higherEntry(K k2) {
        return this.tailMap(k2, false).firstEntry();
    }

    @Override
    public K higherKey(K k2) {
        return Maps.keyOrNull(this.higherEntry(k2));
    }

    @Override
    public Set<K> keySet() {
        return this.navigableKeySet();
    }

    @Override
    @NullableDecl
    public Map.Entry<K, V> lastEntry() {
        return Iterators.getNext(this.descendingEntryIterator(), null);
    }

    @Override
    public K lastKey() {
        Map.Entry<K, V> entry = this.lastEntry();
        if (entry != null) {
            return entry.getKey();
        }
        throw new NoSuchElementException();
    }

    @Override
    @NullableDecl
    public Map.Entry<K, V> lowerEntry(K k2) {
        return this.headMap(k2, false).lastEntry();
    }

    @Override
    public K lowerKey(K k2) {
        return Maps.keyOrNull(this.lowerEntry(k2));
    }

    @Override
    public NavigableSet<K> navigableKeySet() {
        return new Maps.NavigableKeySet(this);
    }

    @Override
    @NullableDecl
    public Map.Entry<K, V> pollFirstEntry() {
        return Iterators.pollNext(this.entryIterator());
    }

    @Override
    @NullableDecl
    public Map.Entry<K, V> pollLastEntry() {
        return Iterators.pollNext(this.descendingEntryIterator());
    }

    @Override
    public SortedMap<K, V> subMap(K k2, K k3) {
        return this.subMap(k2, true, k3, false);
    }

    @Override
    public SortedMap<K, V> tailMap(K k2) {
        return this.tailMap(k2, true);
    }

    private final class DescendingMap
    extends Maps.DescendingMap<K, V> {
        private DescendingMap() {
        }

        @Override
        Iterator<Map.Entry<K, V>> entryIterator() {
            return AbstractNavigableMap.this.descendingEntryIterator();
        }

        @Override
        NavigableMap<K, V> forward() {
            return AbstractNavigableMap.this;
        }
    }
}

