/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.checkerframework.checker.nullness.compatqual.MonotonicNonNullDecl;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

abstract class AbstractMultiset<E>
extends AbstractCollection<E>
implements Multiset<E> {
    @MonotonicNonNullDecl
    private transient Set<E> elementSet;
    @MonotonicNonNullDecl
    private transient Set<Multiset.Entry<E>> entrySet;

    AbstractMultiset() {
    }

    @Override
    public int add(@NullableDecl E e2, int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean add(@NullableDecl E e2) {
        this.add(e2, 1);
        return true;
    }

    @Override
    public final boolean addAll(Collection<? extends E> collection) {
        return Multisets.addAllImpl(this, collection);
    }

    @Override
    public abstract void clear();

    @Override
    public boolean contains(@NullableDecl Object object) {
        boolean bl = this.count(object) > 0;
        return bl;
    }

    Set<E> createElementSet() {
        return new ElementSet();
    }

    Set<Multiset.Entry<E>> createEntrySet() {
        return new EntrySet();
    }

    abstract int distinctElements();

    abstract Iterator<E> elementIterator();

    @Override
    public Set<E> elementSet() {
        Set<E> set;
        Set<E> set2 = set = this.elementSet;
        if (set == null) {
            this.elementSet = set2 = this.createElementSet();
        }
        return set2;
    }

    abstract Iterator<Multiset.Entry<E>> entryIterator();

    @Override
    public Set<Multiset.Entry<E>> entrySet() {
        Set<Multiset.Entry<Multiset.Entry<Multiset.Entry<Multiset.Entry<E>>>>> set;
        Set<Multiset.Entry<Multiset.Entry<Multiset.Entry<Multiset.Entry<E>>>>> set2 = set = this.entrySet;
        if (set == null) {
            set2 = this.createEntrySet();
            this.entrySet = set2;
        }
        return set2;
    }

    @Override
    public final boolean equals(@NullableDecl Object object) {
        return Multisets.equalsImpl(this, object);
    }

    @Override
    public final int hashCode() {
        return this.entrySet().hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.entrySet().isEmpty();
    }

    @Override
    public int remove(@NullableDecl Object object, int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean remove(@NullableDecl Object object) {
        boolean bl = true;
        if (this.remove(object, 1) <= 0) {
            bl = false;
        }
        return bl;
    }

    @Override
    public final boolean removeAll(Collection<?> collection) {
        return Multisets.removeAllImpl(this, collection);
    }

    @Override
    public final boolean retainAll(Collection<?> collection) {
        return Multisets.retainAllImpl(this, collection);
    }

    @Override
    public int setCount(@NullableDecl E e2, int n2) {
        return Multisets.setCountImpl(this, e2, n2);
    }

    @Override
    public boolean setCount(@NullableDecl E e2, int n2, int n3) {
        return Multisets.setCountImpl(this, e2, n2, n3);
    }

    @Override
    public final String toString() {
        return this.entrySet().toString();
    }

    class ElementSet
    extends Multisets.ElementSet<E> {
        ElementSet() {
        }

        @Override
        public Iterator<E> iterator() {
            return AbstractMultiset.this.elementIterator();
        }

        @Override
        Multiset<E> multiset() {
            return AbstractMultiset.this;
        }
    }

    class EntrySet
    extends Multisets.EntrySet<E> {
        EntrySet() {
        }

        @Override
        public Iterator<Multiset.Entry<E>> iterator() {
            return AbstractMultiset.this.entryIterator();
        }

        @Override
        Multiset<E> multiset() {
            return AbstractMultiset.this;
        }

        @Override
        public int size() {
            return AbstractMultiset.this.distinctElements();
        }
    }
}

