/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractMultiset;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.ObjectCountHashMap;
import com.google.common.collect.Serialization;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

abstract class AbstractMapBasedMultiset<E>
extends AbstractMultiset<E>
implements Serializable {
    private static final long serialVersionUID = 0L;
    transient ObjectCountHashMap<E> backingMap;
    transient long size;

    AbstractMapBasedMultiset(int n2) {
        this.init(n2);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n2 = Serialization.readCount((ObjectInputStream)objectInputStream);
        this.init(3);
        Serialization.populateMultiset((Multiset)this, (ObjectInputStream)objectInputStream, (int)n2);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Serialization.writeMultiset((Multiset)this, (ObjectOutputStream)objectOutputStream);
    }

    @Override
    public final int add(@NullableDecl E e2, int n2) {
        if (n2 == 0) {
            return this.count(e2);
        }
        boolean bl = true;
        boolean bl2 = n2 > 0;
        Preconditions.checkArgument(bl2, "occurrences cannot be negative: %s", n2);
        int n3 = this.backingMap.indexOf(e2);
        if (n3 == -1) {
            this.backingMap.put(e2, n2);
            this.size += (long)n2;
            return 0;
        }
        int n4 = this.backingMap.getValue(n3);
        long l2 = n4;
        long l3 = n2;
        bl2 = (l2 += l3) <= Integer.MAX_VALUE ? bl : false;
        Preconditions.checkArgument(bl2, "too many occurrences: %s", l2);
        this.backingMap.setValue(n3, (int)l2);
        this.size += l3;
        return n4;
    }

    void addTo(Multiset<? super E> multiset) {
        Preconditions.checkNotNull(multiset);
        int n2 = this.backingMap.firstIndex();
        while (n2 >= 0) {
            multiset.add(this.backingMap.getKey(n2), this.backingMap.getValue(n2));
            n2 = this.backingMap.nextIndex(n2);
        }
    }

    @Override
    public final void clear() {
        this.backingMap.clear();
        this.size = 0L;
    }

    @Override
    public final int count(@NullableDecl Object object) {
        return this.backingMap.get(object);
    }

    @Override
    final int distinctElements() {
        return this.backingMap.size();
    }

    @Override
    final Iterator<E> elementIterator() {
        return new Itr<E>(){

            @Override
            E result(int n2) {
                return AbstractMapBasedMultiset.this.backingMap.getKey(n2);
            }
        };
    }

    @Override
    final Iterator<Multiset.Entry<E>> entryIterator() {
        return new Itr<Multiset.Entry<E>>(){

            @Override
            Multiset.Entry<E> result(int n2) {
                return AbstractMapBasedMultiset.this.backingMap.getEntry(n2);
            }
        };
    }

    abstract void init(int var1);

    @Override
    public final Iterator<E> iterator() {
        return Multisets.iteratorImpl(this);
    }

    @Override
    public final int remove(@NullableDecl Object object, int n2) {
        if (n2 == 0) {
            return this.count(object);
        }
        boolean bl = n2 > 0;
        Preconditions.checkArgument(bl, "occurrences cannot be negative: %s", n2);
        int n3 = this.backingMap.indexOf(object);
        if (n3 == -1) {
            return 0;
        }
        int n4 = this.backingMap.getValue(n3);
        if (n4 > n2) {
            this.backingMap.setValue(n3, n4 - n2);
        } else {
            this.backingMap.removeEntry(n3);
            n2 = n4;
        }
        this.size -= (long)n2;
        return n4;
    }

    @Override
    public final int setCount(@NullableDecl E e2, int n2) {
        CollectPreconditions.checkNonnegative((int)n2, (String)"count");
        ObjectCountHashMap<E> objectCountHashMap = this.backingMap;
        int n3 = n2 == 0 ? objectCountHashMap.remove(e2) : objectCountHashMap.put(e2, n2);
        this.size += (long)(n2 - n3);
        return n3;
    }

    @Override
    public final boolean setCount(@NullableDecl E e2, int n2, int n3) {
        CollectPreconditions.checkNonnegative((int)n2, (String)"oldCount");
        CollectPreconditions.checkNonnegative((int)n3, (String)"newCount");
        int n4 = this.backingMap.indexOf(e2);
        if (n4 == -1) {
            if (n2 != 0) {
                return false;
            }
            if (n3 > 0) {
                this.backingMap.put(e2, n3);
                this.size += (long)n3;
            }
            return true;
        }
        if (this.backingMap.getValue(n4) != n2) {
            return false;
        }
        if (n3 == 0) {
            this.backingMap.removeEntry(n4);
            this.size -= (long)n2;
        } else {
            this.backingMap.setValue(n4, n3);
            this.size += (long)(n3 - n2);
        }
        return true;
    }

    @Override
    public final int size() {
        return Ints.saturatedCast(this.size);
    }

    abstract class Itr<T>
    implements Iterator<T> {
        int entryIndex;
        int expectedModCount;
        int toRemove;

        Itr() {
            this.entryIndex = AbstractMapBasedMultiset.this.backingMap.firstIndex();
            this.toRemove = -1;
            this.expectedModCount = AbstractMapBasedMultiset.this.backingMap.modCount;
        }

        private void checkForConcurrentModification() {
            if (AbstractMapBasedMultiset.this.backingMap.modCount == this.expectedModCount) {
                return;
            }
            throw new ConcurrentModificationException();
        }

        @Override
        public boolean hasNext() {
            this.checkForConcurrentModification();
            boolean bl = this.entryIndex >= 0;
            return bl;
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                T t2 = this.result(this.entryIndex);
                this.toRemove = this.entryIndex;
                this.entryIndex = AbstractMapBasedMultiset.this.backingMap.nextIndex(this.entryIndex);
                return t2;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            this.checkForConcurrentModification();
            boolean bl = this.toRemove != -1;
            CollectPreconditions.checkRemove((boolean)bl);
            AbstractMapBasedMultiset abstractMapBasedMultiset = AbstractMapBasedMultiset.this;
            abstractMapBasedMultiset.size -= (long)AbstractMapBasedMultiset.this.backingMap.removeEntry(this.toRemove);
            this.entryIndex = AbstractMapBasedMultiset.this.backingMap.nextIndexAfterRemove(this.entryIndex, this.toRemove);
            this.toRemove = -1;
            this.expectedModCount = AbstractMapBasedMultiset.this.backingMap.modCount;
        }

        abstract T result(int var1);
    }
}

