/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractMultimap;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Multiset;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import org.checkerframework.checker.nullness.compatqual.MonotonicNonNullDecl;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

abstract class AbstractMapBasedMultimap<K, V>
extends AbstractMultimap<K, V>
implements Serializable {
    private static final long serialVersionUID = 2447537837011683357L;
    private transient Map<K, Collection<V>> map;
    private transient int totalSize;

    protected AbstractMapBasedMultimap(Map<K, Collection<V>> map) {
        Preconditions.checkArgument(map.isEmpty());
        this.map = map;
    }

    static /* synthetic */ int access$202(AbstractMapBasedMultimap abstractMapBasedMultimap, int n2) {
        abstractMapBasedMultimap.totalSize = n2;
        return n2;
    }

    static /* synthetic */ int access$208(AbstractMapBasedMultimap abstractMapBasedMultimap) {
        int n2 = abstractMapBasedMultimap.totalSize;
        abstractMapBasedMultimap.totalSize = n2 + 1;
        return n2;
    }

    static /* synthetic */ int access$210(AbstractMapBasedMultimap abstractMapBasedMultimap) {
        int n2 = abstractMapBasedMultimap.totalSize;
        abstractMapBasedMultimap.totalSize = n2 - 1;
        return n2;
    }

    private Collection<V> getOrCreateCollection(@NullableDecl K k2) {
        Collection<V> collection;
        Collection<V> collection2 = collection = this.map.get(k2);
        if (collection == null) {
            collection2 = this.createCollection(k2);
            this.map.put(k2, collection2);
        }
        return collection2;
    }

    private static <E> Iterator<E> iteratorOrListIterator(Collection<E> iterator2) {
        iterator2 = iterator2 instanceof List ? ((List)((Object)iterator2)).listIterator() : iterator2.iterator();
        return iterator2;
    }

    private void removeValuesForKey(Object collection) {
        if ((collection = Maps.safeRemove(this.map, collection)) != null) {
            int n2 = collection.size();
            collection.clear();
            this.totalSize -= n2;
        }
    }

    Map<K, Collection<V>> backingMap() {
        return this.map;
    }

    @Override
    public void clear() {
        Iterator<Collection<V>> iterator2 = this.map.values().iterator();
        while (iterator2.hasNext()) {
            iterator2.next().clear();
        }
        this.map.clear();
        this.totalSize = 0;
    }

    @Override
    public boolean containsKey(@NullableDecl Object object) {
        return this.map.containsKey(object);
    }

    @Override
    Map<K, Collection<V>> createAsMap() {
        return new AsMap(this.map);
    }

    abstract Collection<V> createCollection();

    Collection<V> createCollection(@NullableDecl K k2) {
        return this.createCollection();
    }

    @Override
    Collection<Map.Entry<K, V>> createEntries() {
        if (this instanceof SetMultimap) {
            return new AbstractMultimap.EntrySet();
        }
        return new AbstractMultimap.Entries();
    }

    @Override
    Set<K> createKeySet() {
        return new KeySet(this.map);
    }

    @Override
    Multiset<K> createKeys() {
        return new Multimaps.Keys(this);
    }

    final Map<K, Collection<V>> createMaybeNavigableAsMap() {
        Map<K, Collection<V>> map = this.map;
        if (map instanceof NavigableMap) {
            return new NavigableAsMap((NavigableMap)map);
        }
        if (map instanceof SortedMap) {
            return new SortedAsMap((SortedMap)map);
        }
        return new AsMap(map);
    }

    final Set<K> createMaybeNavigableKeySet() {
        Map<K, Collection<V>> map = this.map;
        if (map instanceof NavigableMap) {
            return new NavigableKeySet((NavigableMap)map);
        }
        if (map instanceof SortedMap) {
            return new SortedKeySet((SortedMap)map);
        }
        return new KeySet(map);
    }

    Collection<V> createUnmodifiableEmptyCollection() {
        return this.unmodifiableCollectionSubclass(this.createCollection());
    }

    @Override
    Collection<V> createValues() {
        return new AbstractMultimap.Values();
    }

    @Override
    public Collection<Map.Entry<K, V>> entries() {
        return super.entries();
    }

    @Override
    Iterator<Map.Entry<K, V>> entryIterator() {
        return new Itr<Map.Entry<K, V>>(){

            @Override
            Map.Entry<K, V> output(K k2, V v2) {
                return Maps.immutableEntry(k2, v2);
            }
        };
    }

    @Override
    public Collection<V> get(@NullableDecl K k2) {
        Collection<V> collection;
        Collection<V> collection2 = collection = this.map.get(k2);
        if (collection == null) {
            collection2 = this.createCollection(k2);
        }
        return this.wrapCollection(k2, collection2);
    }

    @Override
    public boolean put(@NullableDecl K k2, @NullableDecl V v2) {
        Collection<V> collection = this.map.get(k2);
        if (collection == null) {
            collection = this.createCollection(k2);
            if (collection.add(v2)) {
                ++this.totalSize;
                this.map.put(k2, collection);
                return true;
            }
            throw new AssertionError((Object)"New Collection violated the Collection spec");
        }
        if (collection.add(v2)) {
            ++this.totalSize;
            return true;
        }
        return false;
    }

    @Override
    public Collection<V> removeAll(@NullableDecl Object collection) {
        Collection<V> collection2 = this.map.remove(collection);
        if (collection2 == null) {
            return this.createUnmodifiableEmptyCollection();
        }
        collection = this.createCollection();
        collection.addAll(collection2);
        this.totalSize -= collection2.size();
        collection2.clear();
        return this.unmodifiableCollectionSubclass(collection);
    }

    @Override
    public Collection<V> replaceValues(@NullableDecl K object, Iterable<? extends V> object2) {
        if (!(object2 = object2.iterator()).hasNext()) {
            return this.removeAll(object);
        }
        object = this.getOrCreateCollection(object);
        Collection<V> collection = this.createCollection();
        collection.addAll((Collection<V>)object);
        this.totalSize -= object.size();
        object.clear();
        while (object2.hasNext()) {
            if (!object.add(object2.next())) continue;
            ++this.totalSize;
        }
        return this.unmodifiableCollectionSubclass(collection);
    }

    final void setMap(Map<K, Collection<V>> object2) {
        this.map = object2;
        this.totalSize = 0;
        for (Collection collection : object2.values()) {
            Preconditions.checkArgument(collection.isEmpty() ^ true);
            this.totalSize += collection.size();
        }
    }

    @Override
    public int size() {
        return this.totalSize;
    }

    <E> Collection<E> unmodifiableCollectionSubclass(Collection<E> collection) {
        return Collections.unmodifiableCollection(collection);
    }

    @Override
    Iterator<V> valueIterator() {
        return new Itr<V>(){

            @Override
            V output(K k2, V v2) {
                return v2;
            }
        };
    }

    @Override
    public Collection<V> values() {
        return super.values();
    }

    Collection<V> wrapCollection(@NullableDecl K k2, Collection<V> collection) {
        return new WrappedCollection(k2, collection, null);
    }

    final List<V> wrapList(@NullableDecl K object, List<V> list, @NullableDecl WrappedCollection wrappedCollection) {
        object = list instanceof RandomAccess ? new RandomAccessWrappedList(object, list, wrappedCollection) : new WrappedList(object, list, wrappedCollection);
        return object;
    }

    private class AsMap
    extends Maps.ViewCachingAbstractMap<K, Collection<V>> {
        final transient Map<K, Collection<V>> submap;

        AsMap(Map<K, Collection<V>> map) {
            this.submap = map;
        }

        @Override
        public void clear() {
            if (this.submap == AbstractMapBasedMultimap.this.map) {
                AbstractMapBasedMultimap.this.clear();
            } else {
                Iterators.clear(new AsMapIterator());
            }
        }

        @Override
        public boolean containsKey(Object object) {
            return Maps.safeContainsKey(this.submap, object);
        }

        @Override
        protected Set<Map.Entry<K, Collection<V>>> createEntrySet() {
            return new AsMapEntries();
        }

        @Override
        public boolean equals(@NullableDecl Object object) {
            boolean bl = this == object || this.submap.equals(object);
            return bl;
        }

        @Override
        public Collection<V> get(Object object) {
            Collection collection = Maps.safeGet(this.submap, object);
            if (collection == null) {
                return null;
            }
            return AbstractMapBasedMultimap.this.wrapCollection(object, collection);
        }

        @Override
        public int hashCode() {
            return this.submap.hashCode();
        }

        @Override
        public Set<K> keySet() {
            return AbstractMapBasedMultimap.this.keySet();
        }

        @Override
        public Collection<V> remove(Object object) {
            Collection collection = this.submap.remove(object);
            if (collection == null) {
                return null;
            }
            Collection collection2 = AbstractMapBasedMultimap.this.createCollection();
            collection2.addAll(collection);
            object = AbstractMapBasedMultimap.this;
            AbstractMapBasedMultimap.access$202((AbstractMapBasedMultimap)object, ((AbstractMapBasedMultimap)object).totalSize - collection.size());
            collection.clear();
            return collection2;
        }

        @Override
        public int size() {
            return this.submap.size();
        }

        @Override
        public String toString() {
            return this.submap.toString();
        }

        Map.Entry<K, Collection<V>> wrapEntry(Map.Entry<K, Collection<V>> entry) {
            Object k2 = entry.getKey();
            return Maps.immutableEntry(k2, AbstractMapBasedMultimap.this.wrapCollection(k2, entry.getValue()));
        }

        class AsMapEntries
        extends Maps.EntrySet<K, Collection<V>> {
            AsMapEntries() {
            }

            @Override
            public boolean contains(Object object) {
                return Collections2.safeContains(AsMap.this.submap.entrySet(), object);
            }

            @Override
            public Iterator<Map.Entry<K, Collection<V>>> iterator() {
                return new AsMapIterator();
            }

            @Override
            Map<K, Collection<V>> map() {
                return AsMap.this;
            }

            @Override
            public boolean remove(Object object) {
                if (!this.contains(object)) {
                    return false;
                }
                object = (Map.Entry)object;
                AbstractMapBasedMultimap.this.removeValuesForKey(object.getKey());
                return true;
            }
        }

        class AsMapIterator
        implements Iterator<Map.Entry<K, Collection<V>>> {
            @NullableDecl
            Collection<V> collection;
            final Iterator<Map.Entry<K, Collection<V>>> delegateIterator;

            AsMapIterator() {
                this.delegateIterator = AsMap.this.submap.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.delegateIterator.hasNext();
            }

            @Override
            public Map.Entry<K, Collection<V>> next() {
                Map.Entry entry = this.delegateIterator.next();
                this.collection = entry.getValue();
                return AsMap.this.wrapEntry(entry);
            }

            @Override
            public void remove() {
                boolean bl = this.collection != null;
                CollectPreconditions.checkRemove((boolean)bl);
                this.delegateIterator.remove();
                AbstractMapBasedMultimap.access$202(AbstractMapBasedMultimap.this, AbstractMapBasedMultimap.this.totalSize - this.collection.size());
                this.collection.clear();
                this.collection = null;
            }
        }
    }

    private abstract class Itr<T>
    implements Iterator<T> {
        @MonotonicNonNullDecl
        Collection<V> collection;
        @NullableDecl
        K key;
        final Iterator<Map.Entry<K, Collection<V>>> keyIterator;
        Iterator<V> valueIterator;

        Itr() {
            this.keyIterator = AbstractMapBasedMultimap.this.map.entrySet().iterator();
            this.key = null;
            this.collection = null;
            this.valueIterator = Iterators.emptyModifiableIterator();
        }

        @Override
        public boolean hasNext() {
            boolean bl = this.keyIterator.hasNext() || this.valueIterator.hasNext();
            return bl;
        }

        @Override
        public T next() {
            if (!this.valueIterator.hasNext()) {
                Map.Entry entry = this.keyIterator.next();
                this.key = entry.getKey();
                this.collection = entry.getValue();
                this.valueIterator = this.collection.iterator();
            }
            return this.output(this.key, this.valueIterator.next());
        }

        abstract T output(K var1, V var2);

        @Override
        public void remove() {
            this.valueIterator.remove();
            if (this.collection.isEmpty()) {
                this.keyIterator.remove();
            }
            AbstractMapBasedMultimap.access$210(AbstractMapBasedMultimap.this);
        }
    }

    private class KeySet
    extends Maps.KeySet<K, Collection<V>> {
        KeySet(Map<K, Collection<V>> map) {
            super(map);
        }

        @Override
        public void clear() {
            Iterators.clear(this.iterator());
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return this.map().keySet().containsAll(collection);
        }

        @Override
        public boolean equals(@NullableDecl Object object) {
            boolean bl = this == object || this.map().keySet().equals(object);
            return bl;
        }

        @Override
        public int hashCode() {
            return this.map().keySet().hashCode();
        }

        @Override
        public Iterator<K> iterator() {
            return new Iterator<K>(this.map().entrySet().iterator()){
                @NullableDecl
                Map.Entry<K, Collection<V>> entry;
                final /* synthetic */ Iterator val$entryIterator;
                {
                    this.val$entryIterator = iterator2;
                }

                @Override
                public boolean hasNext() {
                    return this.val$entryIterator.hasNext();
                }

                @Override
                public K next() {
                    this.entry = (Map.Entry)this.val$entryIterator.next();
                    return this.entry.getKey();
                }

                @Override
                public void remove() {
                    boolean bl = this.entry != null;
                    CollectPreconditions.checkRemove((boolean)bl);
                    Collection collection = this.entry.getValue();
                    this.val$entryIterator.remove();
                    AbstractMapBasedMultimap.access$202(AbstractMapBasedMultimap.this, AbstractMapBasedMultimap.this.totalSize - collection.size());
                    collection.clear();
                    this.entry = null;
                }
            };
        }

        @Override
        public boolean remove(Object object) {
            int n2;
            object = (Collection)this.map().remove(object);
            boolean bl = false;
            if (object != null) {
                n2 = object.size();
                object.clear();
                object = AbstractMapBasedMultimap.this;
                AbstractMapBasedMultimap.access$202((AbstractMapBasedMultimap)object, ((AbstractMapBasedMultimap)object).totalSize - n2);
            } else {
                n2 = 0;
            }
            if (n2 > 0) {
                bl = true;
            }
            return bl;
        }
    }

    class NavigableAsMap
    extends SortedAsMap
    implements NavigableMap<K, Collection<V>> {
        NavigableAsMap(NavigableMap<K, Collection<V>> navigableMap) {
            super(navigableMap);
        }

        @Override
        public Map.Entry<K, Collection<V>> ceilingEntry(K object) {
            object = this.sortedMap().ceilingEntry(object);
            object = object == null ? null : this.wrapEntry(object);
            return object;
        }

        @Override
        public K ceilingKey(K k2) {
            return this.sortedMap().ceilingKey(k2);
        }

        @Override
        NavigableSet<K> createKeySet() {
            return new NavigableKeySet(this.sortedMap());
        }

        @Override
        public NavigableSet<K> descendingKeySet() {
            return this.descendingMap().navigableKeySet();
        }

        @Override
        public NavigableMap<K, Collection<V>> descendingMap() {
            return new NavigableAsMap(this.sortedMap().descendingMap());
        }

        @Override
        public Map.Entry<K, Collection<V>> firstEntry() {
            Map.Entry entry = this.sortedMap().firstEntry();
            entry = entry == null ? null : this.wrapEntry(entry);
            return entry;
        }

        @Override
        public Map.Entry<K, Collection<V>> floorEntry(K object) {
            object = this.sortedMap().floorEntry(object);
            object = object == null ? null : this.wrapEntry(object);
            return object;
        }

        @Override
        public K floorKey(K k2) {
            return this.sortedMap().floorKey(k2);
        }

        @Override
        public NavigableMap<K, Collection<V>> headMap(K k2) {
            return this.headMap(k2, false);
        }

        @Override
        public NavigableMap<K, Collection<V>> headMap(K k2, boolean bl) {
            return new NavigableAsMap(this.sortedMap().headMap(k2, bl));
        }

        @Override
        public Map.Entry<K, Collection<V>> higherEntry(K object) {
            object = this.sortedMap().higherEntry(object);
            object = object == null ? null : this.wrapEntry(object);
            return object;
        }

        @Override
        public K higherKey(K k2) {
            return this.sortedMap().higherKey(k2);
        }

        @Override
        public NavigableSet<K> keySet() {
            return (NavigableSet)super.keySet();
        }

        @Override
        public Map.Entry<K, Collection<V>> lastEntry() {
            Map.Entry entry = this.sortedMap().lastEntry();
            entry = entry == null ? null : this.wrapEntry(entry);
            return entry;
        }

        @Override
        public Map.Entry<K, Collection<V>> lowerEntry(K object) {
            object = this.sortedMap().lowerEntry(object);
            object = object == null ? null : this.wrapEntry(object);
            return object;
        }

        @Override
        public K lowerKey(K k2) {
            return this.sortedMap().lowerKey(k2);
        }

        @Override
        public NavigableSet<K> navigableKeySet() {
            return this.keySet();
        }

        Map.Entry<K, Collection<V>> pollAsMapEntry(Iterator<Map.Entry<K, Collection<V>>> iterator2) {
            if (!iterator2.hasNext()) {
                return null;
            }
            Map.Entry entry = iterator2.next();
            Collection collection = AbstractMapBasedMultimap.this.createCollection();
            collection.addAll(entry.getValue());
            iterator2.remove();
            return Maps.immutableEntry(entry.getKey(), AbstractMapBasedMultimap.this.unmodifiableCollectionSubclass(collection));
        }

        @Override
        public Map.Entry<K, Collection<V>> pollFirstEntry() {
            return this.pollAsMapEntry(this.entrySet().iterator());
        }

        @Override
        public Map.Entry<K, Collection<V>> pollLastEntry() {
            return this.pollAsMapEntry(this.descendingMap().entrySet().iterator());
        }

        NavigableMap<K, Collection<V>> sortedMap() {
            return (NavigableMap)super.sortedMap();
        }

        @Override
        public NavigableMap<K, Collection<V>> subMap(K k2, K k3) {
            return this.subMap(k2, true, k3, false);
        }

        @Override
        public NavigableMap<K, Collection<V>> subMap(K k2, boolean bl, K k3, boolean bl2) {
            return new NavigableAsMap(this.sortedMap().subMap(k2, bl, k3, bl2));
        }

        @Override
        public NavigableMap<K, Collection<V>> tailMap(K k2) {
            return this.tailMap(k2, true);
        }

        @Override
        public NavigableMap<K, Collection<V>> tailMap(K k2, boolean bl) {
            return new NavigableAsMap(this.sortedMap().tailMap(k2, bl));
        }
    }

    class NavigableKeySet
    extends SortedKeySet
    implements NavigableSet<K> {
        NavigableKeySet(NavigableMap<K, Collection<V>> navigableMap) {
            super(navigableMap);
        }

        @Override
        public K ceiling(K k2) {
            return this.sortedMap().ceilingKey(k2);
        }

        @Override
        public Iterator<K> descendingIterator() {
            return this.descendingSet().iterator();
        }

        @Override
        public NavigableSet<K> descendingSet() {
            return new NavigableKeySet(this.sortedMap().descendingMap());
        }

        @Override
        public K floor(K k2) {
            return this.sortedMap().floorKey(k2);
        }

        @Override
        public NavigableSet<K> headSet(K k2) {
            return this.headSet((K)k2, false);
        }

        @Override
        public NavigableSet<K> headSet(K k2, boolean bl) {
            return new NavigableKeySet(this.sortedMap().headMap(k2, bl));
        }

        @Override
        public K higher(K k2) {
            return this.sortedMap().higherKey(k2);
        }

        @Override
        public K lower(K k2) {
            return this.sortedMap().lowerKey(k2);
        }

        @Override
        public K pollFirst() {
            return Iterators.pollNext(this.iterator());
        }

        @Override
        public K pollLast() {
            return Iterators.pollNext(this.descendingIterator());
        }

        NavigableMap<K, Collection<V>> sortedMap() {
            return (NavigableMap)super.sortedMap();
        }

        @Override
        public NavigableSet<K> subSet(K k2, K k3) {
            return this.subSet((K)k2, true, (K)k3, false);
        }

        @Override
        public NavigableSet<K> subSet(K k2, boolean bl, K k3, boolean bl2) {
            return new NavigableKeySet(this.sortedMap().subMap(k2, bl, k3, bl2));
        }

        @Override
        public NavigableSet<K> tailSet(K k2) {
            return this.tailSet((K)k2, true);
        }

        @Override
        public NavigableSet<K> tailSet(K k2, boolean bl) {
            return new NavigableKeySet(this.sortedMap().tailMap(k2, bl));
        }
    }

    private class RandomAccessWrappedList
    extends WrappedList
    implements RandomAccess {
        RandomAccessWrappedList(K k2, @NullableDecl List<V> list, WrappedCollection wrappedCollection) {
            super(k2, list, wrappedCollection);
        }
    }

    private class SortedAsMap
    extends AsMap
    implements SortedMap<K, Collection<V>> {
        @MonotonicNonNullDecl
        SortedSet<K> sortedKeySet;

        SortedAsMap(SortedMap<K, Collection<V>> sortedMap) {
            super(sortedMap);
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.sortedMap().comparator();
        }

        @Override
        SortedSet<K> createKeySet() {
            return new SortedKeySet(this.sortedMap());
        }

        @Override
        public K firstKey() {
            return this.sortedMap().firstKey();
        }

        @Override
        public SortedMap<K, Collection<V>> headMap(K k2) {
            return new SortedAsMap(this.sortedMap().headMap(k2));
        }

        @Override
        public SortedSet<K> keySet() {
            SortedSet sortedSet;
            Set<Object> set = sortedSet = this.sortedKeySet;
            if (sortedSet == null) {
                this.sortedKeySet = set = this.createKeySet();
            }
            return set;
        }

        @Override
        public K lastKey() {
            return this.sortedMap().lastKey();
        }

        SortedMap<K, Collection<V>> sortedMap() {
            return (SortedMap)this.submap;
        }

        @Override
        public SortedMap<K, Collection<V>> subMap(K k2, K k3) {
            return new SortedAsMap(this.sortedMap().subMap(k2, k3));
        }

        @Override
        public SortedMap<K, Collection<V>> tailMap(K k2) {
            return new SortedAsMap(this.sortedMap().tailMap(k2));
        }
    }

    private class SortedKeySet
    extends KeySet
    implements SortedSet<K> {
        SortedKeySet(SortedMap<K, Collection<V>> sortedMap) {
            super(sortedMap);
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.sortedMap().comparator();
        }

        @Override
        public K first() {
            return this.sortedMap().firstKey();
        }

        @Override
        public SortedSet<K> headSet(K k2) {
            return new SortedKeySet(this.sortedMap().headMap(k2));
        }

        @Override
        public K last() {
            return this.sortedMap().lastKey();
        }

        SortedMap<K, Collection<V>> sortedMap() {
            return (SortedMap)super.map();
        }

        @Override
        public SortedSet<K> subSet(K k2, K k3) {
            return new SortedKeySet(this.sortedMap().subMap(k2, k3));
        }

        @Override
        public SortedSet<K> tailSet(K k2) {
            return new SortedKeySet(this.sortedMap().tailMap(k2));
        }
    }

    class WrappedCollection
    extends AbstractCollection<V> {
        @NullableDecl
        final WrappedCollection ancestor;
        @NullableDecl
        final Collection<V> ancestorDelegate;
        Collection<V> delegate;
        @NullableDecl
        final K key;

        WrappedCollection(K k2, @NullableDecl Collection<V> collection, WrappedCollection wrappedCollection) {
            this.key = k2;
            this.delegate = collection;
            this.ancestor = wrappedCollection;
            AbstractMapBasedMultimap.this = wrappedCollection == null ? null : wrappedCollection.getDelegate();
            this.ancestorDelegate = AbstractMapBasedMultimap.this;
        }

        @Override
        public boolean add(V v2) {
            this.refreshIfEmpty();
            boolean bl = this.delegate.isEmpty();
            boolean bl2 = this.delegate.add(v2);
            if (bl2) {
                AbstractMapBasedMultimap.access$208(AbstractMapBasedMultimap.this);
                if (bl) {
                    this.addToMap();
                }
            }
            return bl2;
        }

        @Override
        public boolean addAll(Collection<? extends V> object) {
            if (object.isEmpty()) {
                return false;
            }
            int n2 = this.size();
            boolean bl = this.delegate.addAll((Collection)object);
            if (bl) {
                int n3 = this.delegate.size();
                object = AbstractMapBasedMultimap.this;
                AbstractMapBasedMultimap.access$202((AbstractMapBasedMultimap)object, ((AbstractMapBasedMultimap)object).totalSize + (n3 - n2));
                if (n2 == 0) {
                    this.addToMap();
                }
            }
            return bl;
        }

        void addToMap() {
            WrappedCollection wrappedCollection = this.ancestor;
            if (wrappedCollection != null) {
                wrappedCollection.addToMap();
            } else {
                AbstractMapBasedMultimap.this.map.put(this.key, this.delegate);
            }
        }

        @Override
        public void clear() {
            int n2 = this.size();
            if (n2 == 0) {
                return;
            }
            this.delegate.clear();
            AbstractMapBasedMultimap abstractMapBasedMultimap = AbstractMapBasedMultimap.this;
            AbstractMapBasedMultimap.access$202(abstractMapBasedMultimap, abstractMapBasedMultimap.totalSize - n2);
            this.removeIfEmpty();
        }

        @Override
        public boolean contains(Object object) {
            this.refreshIfEmpty();
            return this.delegate.contains(object);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            this.refreshIfEmpty();
            return this.delegate.containsAll(collection);
        }

        @Override
        public boolean equals(@NullableDecl Object object) {
            if (object == this) {
                return true;
            }
            this.refreshIfEmpty();
            return this.delegate.equals(object);
        }

        WrappedCollection getAncestor() {
            return this.ancestor;
        }

        Collection<V> getDelegate() {
            return this.delegate;
        }

        K getKey() {
            return this.key;
        }

        @Override
        public int hashCode() {
            this.refreshIfEmpty();
            return this.delegate.hashCode();
        }

        @Override
        public Iterator<V> iterator() {
            this.refreshIfEmpty();
            return new WrappedIterator();
        }

        void refreshIfEmpty() {
            Collection collection = this.ancestor;
            if (collection != null) {
                collection.refreshIfEmpty();
                if (this.ancestor.getDelegate() != this.ancestorDelegate) {
                    throw new ConcurrentModificationException();
                }
            } else if (this.delegate.isEmpty() && (collection = (Collection)AbstractMapBasedMultimap.this.map.get(this.key)) != null) {
                this.delegate = collection;
            }
        }

        @Override
        public boolean remove(Object object) {
            this.refreshIfEmpty();
            boolean bl = this.delegate.remove(object);
            if (bl) {
                AbstractMapBasedMultimap.access$210(AbstractMapBasedMultimap.this);
                this.removeIfEmpty();
            }
            return bl;
        }

        @Override
        public boolean removeAll(Collection<?> object) {
            if (object.isEmpty()) {
                return false;
            }
            int n2 = this.size();
            boolean bl = this.delegate.removeAll((Collection<?>)object);
            if (bl) {
                int n3 = this.delegate.size();
                object = AbstractMapBasedMultimap.this;
                AbstractMapBasedMultimap.access$202((AbstractMapBasedMultimap)object, ((AbstractMapBasedMultimap)object).totalSize + (n3 - n2));
                this.removeIfEmpty();
            }
            return bl;
        }

        void removeIfEmpty() {
            WrappedCollection wrappedCollection = this.ancestor;
            if (wrappedCollection != null) {
                wrappedCollection.removeIfEmpty();
            } else if (this.delegate.isEmpty()) {
                AbstractMapBasedMultimap.this.map.remove(this.key);
            }
        }

        @Override
        public boolean retainAll(Collection<?> object) {
            Preconditions.checkNotNull(object);
            int n2 = this.size();
            boolean bl = this.delegate.retainAll((Collection<?>)object);
            if (bl) {
                int n3 = this.delegate.size();
                object = AbstractMapBasedMultimap.this;
                AbstractMapBasedMultimap.access$202((AbstractMapBasedMultimap)object, ((AbstractMapBasedMultimap)object).totalSize + (n3 - n2));
                this.removeIfEmpty();
            }
            return bl;
        }

        @Override
        public int size() {
            this.refreshIfEmpty();
            return this.delegate.size();
        }

        @Override
        public String toString() {
            this.refreshIfEmpty();
            return this.delegate.toString();
        }

        class WrappedIterator
        implements Iterator<V> {
            final Iterator<V> delegateIterator;
            final Collection<V> originalDelegate;

            WrappedIterator() {
                this.originalDelegate = WrappedCollection.this.delegate;
                this.delegateIterator = AbstractMapBasedMultimap.iteratorOrListIterator(WrappedCollection.this.delegate);
            }

            WrappedIterator(Iterator<V> iterator2) {
                this.originalDelegate = WrappedCollection.this.delegate;
                this.delegateIterator = iterator2;
            }

            Iterator<V> getDelegateIterator() {
                this.validateIterator();
                return this.delegateIterator;
            }

            @Override
            public boolean hasNext() {
                this.validateIterator();
                return this.delegateIterator.hasNext();
            }

            @Override
            public V next() {
                this.validateIterator();
                return this.delegateIterator.next();
            }

            @Override
            public void remove() {
                this.delegateIterator.remove();
                AbstractMapBasedMultimap.access$210(AbstractMapBasedMultimap.this);
                WrappedCollection.this.removeIfEmpty();
            }

            void validateIterator() {
                WrappedCollection.this.refreshIfEmpty();
                if (WrappedCollection.this.delegate == this.originalDelegate) {
                    return;
                }
                throw new ConcurrentModificationException();
            }
        }
    }

    class WrappedList
    extends WrappedCollection
    implements List<V> {
        WrappedList(K k2, @NullableDecl List<V> list, WrappedCollection wrappedCollection) {
            super(k2, list, wrappedCollection);
        }

        @Override
        public void add(int n2, V v2) {
            this.refreshIfEmpty();
            boolean bl = this.getDelegate().isEmpty();
            this.getListDelegate().add(n2, v2);
            AbstractMapBasedMultimap.access$208(AbstractMapBasedMultimap.this);
            if (bl) {
                this.addToMap();
            }
        }

        @Override
        public boolean addAll(int n2, Collection<? extends V> object) {
            if (object.isEmpty()) {
                return false;
            }
            int n3 = this.size();
            boolean bl = this.getListDelegate().addAll(n2, (Collection)object);
            if (bl) {
                n2 = this.getDelegate().size();
                object = AbstractMapBasedMultimap.this;
                AbstractMapBasedMultimap.access$202((AbstractMapBasedMultimap)object, ((AbstractMapBasedMultimap)object).totalSize + (n2 - n3));
                if (n3 == 0) {
                    this.addToMap();
                }
            }
            return bl;
        }

        @Override
        public V get(int n2) {
            this.refreshIfEmpty();
            return this.getListDelegate().get(n2);
        }

        List<V> getListDelegate() {
            return (List)this.getDelegate();
        }

        @Override
        public int indexOf(Object object) {
            this.refreshIfEmpty();
            return this.getListDelegate().indexOf(object);
        }

        @Override
        public int lastIndexOf(Object object) {
            this.refreshIfEmpty();
            return this.getListDelegate().lastIndexOf(object);
        }

        @Override
        public ListIterator<V> listIterator() {
            this.refreshIfEmpty();
            return new WrappedListIterator();
        }

        @Override
        public ListIterator<V> listIterator(int n2) {
            this.refreshIfEmpty();
            return new WrappedListIterator(n2);
        }

        @Override
        public V remove(int n2) {
            this.refreshIfEmpty();
            Object v2 = this.getListDelegate().remove(n2);
            AbstractMapBasedMultimap.access$210(AbstractMapBasedMultimap.this);
            this.removeIfEmpty();
            return v2;
        }

        @Override
        public V set(int n2, V v2) {
            this.refreshIfEmpty();
            return this.getListDelegate().set(n2, v2);
        }

        @Override
        public List<V> subList(int n2, int n3) {
            this.refreshIfEmpty();
            AbstractMapBasedMultimap abstractMapBasedMultimap = AbstractMapBasedMultimap.this;
            Object k2 = this.getKey();
            List list = this.getListDelegate().subList(n2, n3);
            WrappedCollection wrappedCollection = this.getAncestor() == null ? this : this.getAncestor();
            return abstractMapBasedMultimap.wrapList(k2, list, wrappedCollection);
        }

        /*
         * Signature claims super is com.google.common.collect.AbstractMapBasedMultimap$WrappedCollection.WrappedIterator, not com.google.common.collect.AbstractMapBasedMultimap$WrappedCollection$WrappedIterator - discarding signature.
         */
        private class WrappedListIterator
        extends WrappedCollection.WrappedIterator
        implements ListIterator {
            WrappedListIterator() {
            }

            public WrappedListIterator(int n2) {
                super(WrappedList.this.getListDelegate().listIterator(n2));
            }

            private ListIterator<V> getDelegateListIterator() {
                return (ListIterator)this.getDelegateIterator();
            }

            public void add(V v2) {
                boolean bl = WrappedList.this.isEmpty();
                this.getDelegateListIterator().add(v2);
                AbstractMapBasedMultimap.access$208(AbstractMapBasedMultimap.this);
                if (bl) {
                    WrappedList.this.addToMap();
                }
            }

            @Override
            public boolean hasPrevious() {
                return this.getDelegateListIterator().hasPrevious();
            }

            @Override
            public int nextIndex() {
                return this.getDelegateListIterator().nextIndex();
            }

            public V previous() {
                return this.getDelegateListIterator().previous();
            }

            @Override
            public int previousIndex() {
                return this.getDelegateListIterator().previousIndex();
            }

            public void set(V v2) {
                this.getDelegateListIterator().set(v2);
            }
        }
    }

    class WrappedNavigableSet
    extends WrappedSortedSet
    implements NavigableSet<V> {
        WrappedNavigableSet(K k2, @NullableDecl NavigableSet<V> navigableSet, WrappedCollection wrappedCollection) {
            super(k2, navigableSet, wrappedCollection);
        }

        private NavigableSet<V> wrap(NavigableSet<V> navigableSet) {
            AbstractMapBasedMultimap abstractMapBasedMultimap = AbstractMapBasedMultimap.this;
            Object object = this.key;
            WrappedCollection wrappedCollection = this.getAncestor() == null ? this : this.getAncestor();
            return abstractMapBasedMultimap.new WrappedNavigableSet(object, navigableSet, wrappedCollection);
        }

        @Override
        public V ceiling(V v2) {
            return this.getSortedSetDelegate().ceiling(v2);
        }

        @Override
        public Iterator<V> descendingIterator() {
            return new WrappedCollection.WrappedIterator(this.getSortedSetDelegate().descendingIterator());
        }

        @Override
        public NavigableSet<V> descendingSet() {
            return this.wrap(this.getSortedSetDelegate().descendingSet());
        }

        @Override
        public V floor(V v2) {
            return this.getSortedSetDelegate().floor(v2);
        }

        NavigableSet<V> getSortedSetDelegate() {
            return (NavigableSet)super.getSortedSetDelegate();
        }

        @Override
        public NavigableSet<V> headSet(V v2, boolean bl) {
            return this.wrap(this.getSortedSetDelegate().headSet(v2, bl));
        }

        @Override
        public V higher(V v2) {
            return this.getSortedSetDelegate().higher(v2);
        }

        @Override
        public V lower(V v2) {
            return this.getSortedSetDelegate().lower(v2);
        }

        @Override
        public V pollFirst() {
            return Iterators.pollNext(this.iterator());
        }

        @Override
        public V pollLast() {
            return Iterators.pollNext(this.descendingIterator());
        }

        @Override
        public NavigableSet<V> subSet(V v2, boolean bl, V v3, boolean bl2) {
            return this.wrap(this.getSortedSetDelegate().subSet(v2, bl, v3, bl2));
        }

        @Override
        public NavigableSet<V> tailSet(V v2, boolean bl) {
            return this.wrap(this.getSortedSetDelegate().tailSet(v2, bl));
        }
    }

    class WrappedSet
    extends WrappedCollection
    implements Set<V> {
        WrappedSet(K k2, Set<V> set) {
            super(k2, set, null);
        }

        @Override
        public boolean removeAll(Collection<?> object) {
            if (object.isEmpty()) {
                return false;
            }
            int n2 = this.size();
            boolean bl = Sets.removeAllImpl((Set)this.delegate, object);
            if (bl) {
                int n3 = this.delegate.size();
                object = AbstractMapBasedMultimap.this;
                AbstractMapBasedMultimap.access$202((AbstractMapBasedMultimap)object, ((AbstractMapBasedMultimap)object).totalSize + (n3 - n2));
                this.removeIfEmpty();
            }
            return bl;
        }
    }

    class WrappedSortedSet
    extends WrappedCollection
    implements SortedSet<V> {
        WrappedSortedSet(K k2, @NullableDecl SortedSet<V> sortedSet, WrappedCollection wrappedCollection) {
            super(k2, sortedSet, wrappedCollection);
        }

        @Override
        public Comparator<? super V> comparator() {
            return this.getSortedSetDelegate().comparator();
        }

        @Override
        public V first() {
            this.refreshIfEmpty();
            return this.getSortedSetDelegate().first();
        }

        SortedSet<V> getSortedSetDelegate() {
            return (SortedSet)this.getDelegate();
        }

        @Override
        public SortedSet<V> headSet(V object) {
            this.refreshIfEmpty();
            AbstractMapBasedMultimap abstractMapBasedMultimap = AbstractMapBasedMultimap.this;
            Object k2 = this.getKey();
            SortedSet sortedSet = this.getSortedSetDelegate().headSet(object);
            object = this.getAncestor() == null ? this : this.getAncestor();
            return abstractMapBasedMultimap.new WrappedSortedSet(k2, sortedSet, (WrappedCollection)object);
        }

        @Override
        public V last() {
            this.refreshIfEmpty();
            return this.getSortedSetDelegate().last();
        }

        @Override
        public SortedSet<V> subSet(V object, V object2) {
            this.refreshIfEmpty();
            AbstractMapBasedMultimap abstractMapBasedMultimap = AbstractMapBasedMultimap.this;
            Object k2 = this.getKey();
            object2 = this.getSortedSetDelegate().subSet(object, object2);
            object = this.getAncestor() == null ? this : this.getAncestor();
            return abstractMapBasedMultimap.new WrappedSortedSet(k2, object2, (WrappedCollection)object);
        }

        @Override
        public SortedSet<V> tailSet(V object) {
            this.refreshIfEmpty();
            AbstractMapBasedMultimap abstractMapBasedMultimap = AbstractMapBasedMultimap.this;
            Object k2 = this.getKey();
            SortedSet sortedSet = this.getSortedSetDelegate().tailSet(object);
            object = this.getAncestor() == null ? this : this.getAncestor();
            return abstractMapBasedMultimap.new WrappedSortedSet(k2, sortedSet, (WrappedCollection)object);
        }
    }
}

