/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.cache;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Random;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;
import sun.misc.Unsafe;

abstract class Striped64
extends Number {
    static final int NCPU;
    private static final Unsafe UNSAFE;
    private static final long baseOffset;
    private static final long busyOffset;
    static final Random rng;
    static final ThreadLocal<int[]> threadHashCode;
    volatile transient long base;
    volatile transient int busy;
    @NullableDecl
    volatile transient Cell[] cells;

    static {
        threadHashCode = new ThreadLocal();
        rng = new Random();
        NCPU = Runtime.getRuntime().availableProcessors();
        try {
            UNSAFE = Striped64.getUnsafe();
            baseOffset = UNSAFE.objectFieldOffset(Striped64.class.getDeclaredField("base"));
            busyOffset = UNSAFE.objectFieldOffset(Striped64.class.getDeclaredField("busy"));
            return;
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }

    Striped64() {
    }

    private static Unsafe getUnsafe() {
        try {
            Unsafe unsafe = Unsafe.getUnsafe();
            return unsafe;
        }
        catch (SecurityException securityException) {
            try {
                PrivilegedExceptionAction<Unsafe> privilegedExceptionAction = new PrivilegedExceptionAction<Unsafe>(){

                    @Override
                    public Unsafe run() throws Exception {
                        for (Field field : Unsafe.class.getDeclaredFields()) {
                            field.setAccessible(true);
                            Object object = field.get(null);
                            if (!Unsafe.class.isInstance(object)) continue;
                            return (Unsafe)Unsafe.class.cast(object);
                        }
                        NoSuchFieldError noSuchFieldError = new NoSuchFieldError("the Unsafe");
                        throw noSuchFieldError;
                    }
                };
                privilegedExceptionAction = AccessController.doPrivileged(privilegedExceptionAction);
                return privilegedExceptionAction;
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw new RuntimeException("Could not initialize intrinsics", privilegedActionException.getCause());
            }
        }
    }

    final boolean casBase(long l2, long l3) {
        return UNSAFE.compareAndSwapLong(this, baseOffset, l2, l3);
    }

    final boolean casBusy() {
        return UNSAFE.compareAndSwapInt(this, busyOffset, 0, 1);
    }

    abstract long fn(long var1, long var3);

    final void internalReset(long l2) {
        Cell[] cellArray = this.cells;
        this.base = l2;
        if (cellArray != null) {
            for (Cell cell : cellArray) {
                if (cell == null) continue;
                cell.value = l2;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    final void retryUpdate(long var1_1, int[] var3_2, boolean var4_6) {
        if (var3_2 == null) {
            var5_7 = Striped64.threadHashCode;
            var3_2 = new int[1];
            var5_7.set((int[])var3_2);
            var7_9 = var6_8 = Striped64.rng.nextInt();
            if (var6_8 == 0) {
                var7_9 = 1;
            }
            var3_2[0] = var7_9;
        } else {
            var7_9 = var3_2[0];
        }
        block10: while (true) {
            var8_10 = 0;
            var6_8 = var7_9;
            while (true) {
                block29: {
                    block26: {
                        block30: {
                            block31: {
                                if ((var5_7 = this.cells) == null || (var9_11 = var5_7.length) <= 0) break block29;
                                var10_12 = var5_7[var9_11 - 1 & var6_8];
                                if (var10_12 != null) break block30;
                                if (this.busy != 0) break block31;
                                var10_12 = new Cell(var1_1);
                                if (this.busy != 0 || !this.casBusy()) break block31;
                                try {
                                    var5_7 = this.cells;
                                    if (var5_7 == null) ** GOTO lbl-1000
                                }
                                catch (Throwable var3_3) {
                                    this.busy = 0;
                                    throw var3_3;
                                }
                                var7_9 = var5_7.length;
                                if (var7_9 > 0 && var5_7[var7_9 = var7_9 - 1 & var6_8] == null) {
                                    var5_7[var7_9] = var10_12;
                                    var7_9 = 1;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    var7_9 = 0;
                                }
                                this.busy = 0;
                                if (var7_9 == 0) continue;
                                break block10;
                            }
                            while (true) {
                                var7_9 = 0;
                                var11_13 = var4_6;
                                break block26;
                                break;
                            }
                        }
                        if (!var4_6) {
                            var11_13 = true;
                            var7_9 = var8_10;
                        } else {
                            var12_14 = var10_12.value;
                            if (var10_12.cas(var12_14, this.fn(var12_14, var1_1))) break block10;
                            if (var9_11 >= Striped64.NCPU || this.cells != var5_7) ** continue;
                            if (var8_10 == 0) {
                                var7_9 = 1;
                                var11_13 = var4_6;
                            } else {
                                var11_13 = var4_6;
                                var7_9 = var8_10;
                                if (this.busy == 0) {
                                    var11_13 = var4_6;
                                    var7_9 = var8_10;
                                    if (this.casBusy()) {
                                        block27: {
                                            if (this.cells != var5_7) break block27;
                                            var10_12 = new Cell[var9_11 << 1];
                                            for (var7_9 = 0; var7_9 < var9_11; ++var7_9) {
                                                var10_12[var7_9] = var5_7[var7_9];
                                            }
                                            try {
                                                this.cells = var10_12;
                                            }
                                            catch (Throwable var3_4) {
                                                throw var3_4;
                                            }
                                            finally {
                                                this.busy = 0;
                                            }
                                        }
                                        var7_9 = var6_8;
                                        continue block10;
                                    }
                                }
                            }
                        }
                    }
                    var6_8 ^= var6_8 << 13;
                    var6_8 ^= var6_8 >>> 17;
                    var6_8 ^= var6_8 << 5;
                    var3_2[0] = var6_8;
                    var4_6 = var11_13;
                    var8_10 = var7_9;
                    continue;
                }
                if (this.busy == 0 && this.cells == var5_7 && this.casBusy()) {
                    block28: {
                        try {
                            if (this.cells != var5_7) break block28;
                            var5_7 = new Cell[2];
                            var10_12 = new Cell(var1_1);
                            var5_7[var6_8 & 1] = var10_12;
                        }
                        catch (Throwable var3_5) {
                            this.busy = 0;
                            throw var3_5;
                        }
                        this.cells = var5_7;
                        var7_9 = 1;
                    }
                    var7_9 = 0;
                    this.busy = 0;
                    if (var7_9 == 0) continue;
                    break block10;
                }
                var12_14 = this.base;
                if (this.casBase(var12_14, this.fn(var12_14, var1_1))) break block10;
            }
            break;
        }
    }

    static final class Cell {
        private static final Unsafe UNSAFE;
        private static final long valueOffset;
        volatile long p0;
        volatile long p1;
        volatile long p2;
        volatile long p3;
        volatile long p4;
        volatile long p5;
        volatile long p6;
        volatile long q0;
        volatile long q1;
        volatile long q2;
        volatile long q3;
        volatile long q4;
        volatile long q5;
        volatile long q6;
        volatile long value;

        static {
            try {
                UNSAFE = Striped64.getUnsafe();
                valueOffset = UNSAFE.objectFieldOffset(Cell.class.getDeclaredField("value"));
                return;
            }
            catch (Exception exception) {
                throw new Error(exception);
            }
        }

        Cell(long l2) {
            this.value = l2;
        }

        final boolean cas(long l2, long l3) {
            return UNSAFE.compareAndSwapLong(this, valueOffset, l2, l3);
        }
    }
}

