/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.cache;

import com.google.common.base.Equivalence;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.google.common.cache.AbstractCache;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.CacheStats;
import com.google.common.cache.ForwardingCache;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.ReferenceEntry;
import com.google.common.cache.RemovalCause;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.cache.Weigher;
import com.google.common.collect.AbstractSequentialIterator;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ExecutionError;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractQueue;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.compatqual.MonotonicNonNullDecl;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

class LocalCache<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V> {
    static final int CONTAINS_VALUE_RETRIES = 3;
    static final Queue<?> DISCARDING_QUEUE;
    static final int DRAIN_MAX = 16;
    static final int DRAIN_THRESHOLD = 63;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final int MAX_SEGMENTS = 65536;
    static final ValueReference<Object, Object> UNSET;
    static final Logger logger;
    final int concurrencyLevel;
    @NullableDecl
    final CacheLoader<? super K, V> defaultLoader;
    final EntryFactory entryFactory;
    @MonotonicNonNullDecl
    Set<Map.Entry<K, V>> entrySet;
    final long expireAfterAccessNanos;
    final long expireAfterWriteNanos;
    final AbstractCache.StatsCounter globalStatsCounter;
    final Equivalence<Object> keyEquivalence;
    @MonotonicNonNullDecl
    Set<K> keySet;
    final Strength keyStrength;
    final long maxWeight;
    final long refreshNanos;
    final RemovalListener<K, V> removalListener;
    final Queue<RemovalNotification<K, V>> removalNotificationQueue;
    final int segmentMask;
    final int segmentShift;
    final Segment<K, V>[] segments;
    final Ticker ticker;
    final Equivalence<Object> valueEquivalence;
    final Strength valueStrength;
    @MonotonicNonNullDecl
    Collection<V> values;
    final Weigher<K, V> weigher;

    static {
        logger = Logger.getLogger(LocalCache.class.getName());
        UNSET = new ValueReference<Object, Object>(){

            @Override
            public ValueReference<Object, Object> copyFor(ReferenceQueue<Object> referenceQueue, @NullableDecl Object object, ReferenceEntry<Object, Object> referenceEntry) {
                return this;
            }

            @Override
            public Object get() {
                return null;
            }

            @Override
            public ReferenceEntry<Object, Object> getEntry() {
                return null;
            }

            @Override
            public int getWeight() {
                return 0;
            }

            @Override
            public boolean isActive() {
                return false;
            }

            @Override
            public boolean isLoading() {
                return false;
            }

            @Override
            public void notifyNewValue(Object object) {
            }

            @Override
            public Object waitForValue() {
                return null;
            }
        };
        DISCARDING_QUEUE = new AbstractQueue<Object>(){

            @Override
            public Iterator<Object> iterator() {
                return ImmutableSet.of().iterator();
            }

            @Override
            public boolean offer(Object object) {
                return true;
            }

            @Override
            public Object peek() {
                return null;
            }

            @Override
            public Object poll() {
                return null;
            }

            @Override
            public int size() {
                return 0;
            }
        };
    }

    LocalCache(CacheBuilder<? super K, ? super V> cacheBuilder, @NullableDecl CacheLoader<? super K, V> segmentArray) {
        int n2;
        this.concurrencyLevel = Math.min(cacheBuilder.getConcurrencyLevel(), 65536);
        this.keyStrength = cacheBuilder.getKeyStrength();
        this.valueStrength = cacheBuilder.getValueStrength();
        this.keyEquivalence = cacheBuilder.getKeyEquivalence();
        this.valueEquivalence = cacheBuilder.getValueEquivalence();
        this.maxWeight = cacheBuilder.getMaximumWeight();
        this.weigher = cacheBuilder.getWeigher();
        this.expireAfterAccessNanos = cacheBuilder.getExpireAfterAccessNanos();
        this.expireAfterWriteNanos = cacheBuilder.getExpireAfterWriteNanos();
        this.refreshNanos = cacheBuilder.getRefreshNanos();
        this.removalListener = cacheBuilder.getRemovalListener();
        Queue queue = this.removalListener == CacheBuilder.NullListener.INSTANCE ? LocalCache.discardingQueue() : new ConcurrentLinkedQueue();
        this.removalNotificationQueue = queue;
        this.ticker = cacheBuilder.getTicker(this.recordsTime());
        this.entryFactory = EntryFactory.getFactory(this.keyStrength, this.usesAccessEntries(), this.usesWriteEntries());
        this.globalStatsCounter = cacheBuilder.getStatsCounterSupplier().get();
        this.defaultLoader = segmentArray;
        int n3 = n2 = Math.min(cacheBuilder.getInitialCapacity(), 0x40000000);
        if (this.evictsBySize()) {
            n3 = n2;
            if (!this.customWeigher()) {
                n3 = (int)Math.min((long)n2, this.maxWeight);
            }
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = 1;
        int n7 = 0;
        for (n2 = 1; !(n2 >= this.concurrencyLevel || this.evictsBySize() && (long)(n2 * 20) > this.maxWeight); n2 <<= 1) {
            ++n7;
        }
        this.segmentShift = 32 - n7;
        this.segmentMask = n2 - 1;
        this.segments = this.newSegmentArray(n2);
        int n8 = n3 / n2;
        n7 = n6;
        int n9 = n8;
        if (n8 * n2 < n3) {
            n9 = n8 + 1;
            n7 = n6;
        }
        while (n7 < n9) {
            n7 <<= 1;
        }
        if (this.evictsBySize()) {
            long l2 = this.maxWeight;
            long l3 = n2;
            long l4 = l2 / l3 + 1L;
            for (n3 = n5; n3 < this.segments.length; ++n3) {
                long l5 = l4;
                if ((long)n3 == l2 % l3) {
                    l5 = l4 - 1L;
                }
                this.segments[n3] = this.createSegment(n7, l5, cacheBuilder.getStatsCounterSupplier().get());
                l4 = l5;
            }
        } else {
            for (n3 = n4; n3 < (segmentArray = this.segments).length; ++n3) {
                segmentArray[n3] = this.createSegment(n7, -1L, cacheBuilder.getStatsCounterSupplier().get());
            }
        }
    }

    static <K, V> void connectAccessOrder(ReferenceEntry<K, V> referenceEntry, ReferenceEntry<K, V> referenceEntry2) {
        referenceEntry.setNextInAccessQueue(referenceEntry2);
        referenceEntry2.setPreviousInAccessQueue(referenceEntry);
    }

    static <K, V> void connectWriteOrder(ReferenceEntry<K, V> referenceEntry, ReferenceEntry<K, V> referenceEntry2) {
        referenceEntry.setNextInWriteQueue(referenceEntry2);
        referenceEntry2.setPreviousInWriteQueue(referenceEntry);
    }

    static <E> Queue<E> discardingQueue() {
        return DISCARDING_QUEUE;
    }

    static <K, V> ReferenceEntry<K, V> nullEntry() {
        return NullEntry.INSTANCE;
    }

    static <K, V> void nullifyAccessOrder(ReferenceEntry<K, V> referenceEntry) {
        ReferenceEntry<K, V> referenceEntry2 = LocalCache.nullEntry();
        referenceEntry.setNextInAccessQueue(referenceEntry2);
        referenceEntry.setPreviousInAccessQueue(referenceEntry2);
    }

    static <K, V> void nullifyWriteOrder(ReferenceEntry<K, V> referenceEntry) {
        ReferenceEntry<K, V> referenceEntry2 = LocalCache.nullEntry();
        referenceEntry.setNextInWriteQueue(referenceEntry2);
        referenceEntry.setPreviousInWriteQueue(referenceEntry2);
    }

    static int rehash(int n2) {
        n2 += n2 << 15 ^ 0xFFFFCD7D;
        n2 ^= n2 >>> 10;
        n2 += n2 << 3;
        n2 ^= n2 >>> 6;
        n2 += (n2 << 2) + (n2 << 14);
        return n2 ^ n2 >>> 16;
    }

    private static <E> ArrayList<E> toArrayList(Collection<E> collection) {
        ArrayList arrayList = new ArrayList(collection.size());
        Iterators.addAll(arrayList, collection.iterator());
        return arrayList;
    }

    static <K, V> ValueReference<K, V> unset() {
        return UNSET;
    }

    public void cleanUp() {
        Segment<K, V>[] segmentArray = this.segments;
        int n2 = segmentArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            segmentArray[i2].cleanUp();
        }
    }

    @Override
    public void clear() {
        Segment<K, V>[] segmentArray = this.segments;
        int n2 = segmentArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            segmentArray[i2].clear();
        }
    }

    @Override
    public boolean containsKey(@NullableDecl Object object) {
        if (object == null) {
            return false;
        }
        int n2 = this.hash(object);
        return this.segmentFor(n2).containsKey(object, n2);
    }

    @Override
    public boolean containsValue(@NullableDecl Object object) {
        if (object == null) {
            return false;
        }
        long l2 = this.ticker.read();
        Segment<K, V>[] segmentArray = this.segments;
        long l3 = -1L;
        for (int i2 = 0; i2 < 3; ++i2) {
            int n2 = segmentArray.length;
            long l4 = 0L;
            for (int i3 = 0; i3 < n2; ++i3) {
                Segment segment = segmentArray[i3];
                int n3 = segment.count;
                AtomicReferenceArray atomicReferenceArray = segment.table;
                for (n3 = 0; n3 < atomicReferenceArray.length(); ++n3) {
                    for (ReferenceEntry referenceEntry = atomicReferenceArray.get(n3); referenceEntry != null; referenceEntry = referenceEntry.getNext()) {
                        V v2 = segment.getLiveValue(referenceEntry, l2);
                        if (v2 == null || !this.valueEquivalence.equivalent(object, v2)) continue;
                        return true;
                    }
                }
                l4 += (long)segment.modCount;
            }
            if (l4 == l3) break;
            l3 = l4;
        }
        return false;
    }

    ReferenceEntry<K, V> copyEntry(ReferenceEntry<K, V> referenceEntry, ReferenceEntry<K, V> referenceEntry2) {
        return this.segmentFor(referenceEntry.getHash()).copyEntry(referenceEntry, referenceEntry2);
    }

    Segment<K, V> createSegment(int n2, long l2, AbstractCache.StatsCounter statsCounter) {
        return new Segment(this, n2, l2, statsCounter);
    }

    boolean customWeigher() {
        boolean bl = this.weigher != CacheBuilder.OneWeigher.INSTANCE;
        return bl;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet entrySet = this.entrySet;
        if (entrySet == null) {
            this.entrySet = entrySet = new EntrySet(this);
        }
        return entrySet;
    }

    boolean evictsBySize() {
        boolean bl = this.maxWeight >= 0L;
        return bl;
    }

    boolean expires() {
        boolean bl = this.expiresAfterWrite() || this.expiresAfterAccess();
        return bl;
    }

    boolean expiresAfterAccess() {
        boolean bl = this.expireAfterAccessNanos > 0L;
        return bl;
    }

    boolean expiresAfterWrite() {
        boolean bl = this.expireAfterWriteNanos > 0L;
        return bl;
    }

    @Override
    @NullableDecl
    public V get(@NullableDecl Object object) {
        if (object == null) {
            return null;
        }
        int n2 = this.hash(object);
        return this.segmentFor(n2).get(object, n2);
    }

    V get(K k2, CacheLoader<? super K, V> cacheLoader) throws ExecutionException {
        int n2 = this.hash(Preconditions.checkNotNull(k2));
        return this.segmentFor(n2).get((K)k2, n2, cacheLoader);
    }

    /*
     * Loose catch block
     */
    ImmutableMap<K, V> getAll(Iterable<? extends K> object) throws ExecutionException {
        int n2;
        int n3;
        int n4;
        LinkedHashMap<Object, Iterable<Object>> linkedHashMap;
        block25: {
            Object object2;
            linkedHashMap = Maps.newLinkedHashMap();
            Object object3 = Sets.newLinkedHashSet();
            CacheLoader.InvalidCacheLoadException invalidCacheLoadException = object.iterator();
            n4 = 0;
            int n5 = 0;
            while (invalidCacheLoadException.hasNext()) {
                object2 = invalidCacheLoadException.next();
                object = this.get(object2);
                if (linkedHashMap.containsKey(object2)) continue;
                linkedHashMap.put(object2, (Iterable<Object>)object);
                if (object == null) {
                    ++n5;
                    object3.add(object2);
                    continue;
                }
                ++n4;
            }
            n3 = n5;
            boolean bl = object3.isEmpty();
            n2 = n5;
            if (bl) break block25;
            n3 = n5;
            object2 = this.loadAll((Set<? extends K>)object3, this.defaultLoader);
            n3 = n5;
            Iterator iterator2 = object3.iterator();
            while (true) {
                n2 = n5;
                n3 = n5;
                if (!iterator2.hasNext()) break block25;
                n3 = n5;
                object = iterator2.next();
                n3 = n5;
                invalidCacheLoadException = object2.get(object);
                if (invalidCacheLoadException == null) break;
                n3 = n5;
                linkedHashMap.put(object, (Iterable<Object>)invalidCacheLoadException);
                continue;
                break;
            }
            n3 = n5;
            n3 = n5;
            n3 = n5;
            object2 = new StringBuilder();
            n3 = n5;
            ((StringBuilder)object2).append("loadAll failed to return a value for ");
            n3 = n5;
            ((StringBuilder)object2).append(object);
            n3 = n5;
            invalidCacheLoadException = new CacheLoader.InvalidCacheLoadException(((StringBuilder)object2).toString());
            n3 = n5;
            try {
                throw invalidCacheLoadException;
            }
            catch (CacheLoader.UnsupportedLoadingOperationException unsupportedLoadingOperationException) {
                n3 = n5;
                object3 = object3.iterator();
                while (true) {
                    n2 = n5;
                    n3 = n5;
                    if (!object3.hasNext()) break;
                    n3 = n5--;
                    object = object3.next();
                    n3 = n5;
                    linkedHashMap.put(object, (Iterable<Object>)this.get(object, this.defaultLoader));
                    continue;
                    break;
                }
            }
        }
        n3 = n2;
        object = ImmutableMap.copyOf(linkedHashMap);
        {
            catch (Throwable throwable) {
                this.globalStatsCounter.recordHits(n4);
                this.globalStatsCounter.recordMisses(n3);
                throw throwable;
            }
        }
        this.globalStatsCounter.recordHits(n4);
        this.globalStatsCounter.recordMisses(n2);
        return object;
    }

    ImmutableMap<K, V> getAllPresent(Iterable<?> object) {
        LinkedHashMap linkedHashMap = Maps.newLinkedHashMap();
        object = object.iterator();
        int n2 = 0;
        int n3 = 0;
        while (object.hasNext()) {
            Object e2 = object.next();
            V v2 = this.get(e2);
            if (v2 == null) {
                ++n3;
                continue;
            }
            linkedHashMap.put(e2, v2);
            ++n2;
        }
        this.globalStatsCounter.recordHits(n2);
        this.globalStatsCounter.recordMisses(n3);
        return ImmutableMap.copyOf(linkedHashMap);
    }

    ReferenceEntry<K, V> getEntry(@NullableDecl Object object) {
        if (object == null) {
            return null;
        }
        int n2 = this.hash(object);
        return this.segmentFor(n2).getEntry(object, n2);
    }

    @NullableDecl
    public V getIfPresent(Object object) {
        int n2 = this.hash(Preconditions.checkNotNull(object));
        if ((object = this.segmentFor(n2).get(object, n2)) == null) {
            this.globalStatsCounter.recordMisses(1);
        } else {
            this.globalStatsCounter.recordHits(1);
        }
        return (V)object;
    }

    @NullableDecl
    V getLiveValue(ReferenceEntry<K, V> referenceEntry, long l2) {
        if (referenceEntry.getKey() == null) {
            return null;
        }
        V v2 = referenceEntry.getValueReference().get();
        if (v2 == null) {
            return null;
        }
        if (this.isExpired(referenceEntry, l2)) {
            return null;
        }
        return v2;
    }

    @Override
    @NullableDecl
    public V getOrDefault(@NullableDecl Object object, @NullableDecl V v2) {
        if ((object = this.get(object)) == null) {
            object = v2;
        }
        return (V)object;
    }

    V getOrLoad(K k2) throws ExecutionException {
        return this.get(k2, this.defaultLoader);
    }

    int hash(@NullableDecl Object object) {
        return LocalCache.rehash(this.keyEquivalence.hash(object));
    }

    void invalidateAll(Iterable<?> object) {
        object = object.iterator();
        while (object.hasNext()) {
            this.remove(object.next());
        }
    }

    @Override
    public boolean isEmpty() {
        int n2;
        Segment<K, V>[] segmentArray = this.segments;
        long l2 = 0L;
        for (n2 = 0; n2 < segmentArray.length; ++n2) {
            if (segmentArray[n2].count != 0) {
                return false;
            }
            l2 += (long)segmentArray[n2].modCount;
        }
        if (l2 != 0L) {
            for (n2 = 0; n2 < segmentArray.length; ++n2) {
                if (segmentArray[n2].count != 0) {
                    return false;
                }
                l2 -= (long)segmentArray[n2].modCount;
            }
            if (l2 != 0L) {
                return false;
            }
        }
        return true;
    }

    boolean isExpired(ReferenceEntry<K, V> referenceEntry, long l2) {
        Preconditions.checkNotNull(referenceEntry);
        if (this.expiresAfterAccess() && l2 - referenceEntry.getAccessTime() >= this.expireAfterAccessNanos) {
            return true;
        }
        return this.expiresAfterWrite() && l2 - referenceEntry.getWriteTime() >= this.expireAfterWriteNanos;
    }

    boolean isLive(ReferenceEntry<K, V> referenceEntry, long l2) {
        boolean bl = this.segmentFor(referenceEntry.getHash()).getLiveValue(referenceEntry, l2) != null;
        return bl;
    }

    @Override
    public Set<K> keySet() {
        KeySet keySet = this.keySet;
        if (keySet == null) {
            this.keySet = keySet = new KeySet(this);
        }
        return keySet;
    }

    /*
     * Exception decompiling
     */
    @NullableDecl
    Map<K, V> loadAll(Set<? extends K> var1_1, CacheLoader<? super K, V> var2_7) throws ExecutionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [6 : 252->263)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    long longSize() {
        Segment<K, V>[] segmentArray = this.segments;
        long l2 = 0L;
        for (int i2 = 0; i2 < segmentArray.length; ++i2) {
            l2 += (long)Math.max(0, segmentArray[i2].count);
        }
        return l2;
    }

    ReferenceEntry<K, V> newEntry(K object, int n2, @NullableDecl ReferenceEntry<K, V> referenceEntry) {
        Segment<K, V> segment = this.segmentFor(n2);
        segment.lock();
        try {
            object = segment.newEntry(object, n2, referenceEntry);
            return object;
        }
        finally {
            segment.unlock();
        }
    }

    final Segment<K, V>[] newSegmentArray(int n2) {
        return new Segment[n2];
    }

    ValueReference<K, V> newValueReference(ReferenceEntry<K, V> referenceEntry, V v2, int n2) {
        int n3 = referenceEntry.getHash();
        return this.valueStrength.referenceValue(this.segmentFor(n3), referenceEntry, Preconditions.checkNotNull(v2), n2);
    }

    void processPendingNotifications() {
        RemovalNotification<K, V> removalNotification;
        while ((removalNotification = this.removalNotificationQueue.poll()) != null) {
            try {
                this.removalListener.onRemoval(removalNotification);
            }
            catch (Throwable throwable) {
                logger.log(Level.WARNING, "Exception thrown by removal listener", throwable);
            }
        }
    }

    @Override
    public V put(K k2, V v2) {
        Preconditions.checkNotNull(k2);
        Preconditions.checkNotNull(v2);
        int n2 = this.hash(k2);
        return this.segmentFor(n2).put(k2, n2, v2, false);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> object2) {
        for (Map.Entry entry : object2.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V putIfAbsent(K k2, V v2) {
        Preconditions.checkNotNull(k2);
        Preconditions.checkNotNull(v2);
        int n2 = this.hash(k2);
        return this.segmentFor(n2).put(k2, n2, v2, true);
    }

    void reclaimKey(ReferenceEntry<K, V> referenceEntry) {
        int n2 = referenceEntry.getHash();
        this.segmentFor(n2).reclaimKey(referenceEntry, n2);
    }

    void reclaimValue(ValueReference<K, V> valueReference) {
        ReferenceEntry<K, V> referenceEntry = valueReference.getEntry();
        int n2 = referenceEntry.getHash();
        this.segmentFor(n2).reclaimValue(referenceEntry.getKey(), n2, valueReference);
    }

    boolean recordsAccess() {
        return this.expiresAfterAccess();
    }

    boolean recordsTime() {
        boolean bl = this.recordsWrite() || this.recordsAccess();
        return bl;
    }

    boolean recordsWrite() {
        boolean bl = this.expiresAfterWrite() || this.refreshes();
        return bl;
    }

    void refresh(K k2) {
        int n2 = this.hash(Preconditions.checkNotNull(k2));
        this.segmentFor(n2).refresh((K)k2, n2, this.defaultLoader, false);
    }

    boolean refreshes() {
        boolean bl = this.refreshNanos > 0L;
        return bl;
    }

    @Override
    public V remove(@NullableDecl Object object) {
        if (object == null) {
            return null;
        }
        int n2 = this.hash(object);
        return this.segmentFor(n2).remove(object, n2);
    }

    @Override
    public boolean remove(@NullableDecl Object object, @NullableDecl Object object2) {
        if (object != null && object2 != null) {
            int n2 = this.hash(object);
            return this.segmentFor(n2).remove(object, n2, object2);
        }
        return false;
    }

    @Override
    public V replace(K k2, V v2) {
        Preconditions.checkNotNull(k2);
        Preconditions.checkNotNull(v2);
        int n2 = this.hash(k2);
        return this.segmentFor(n2).replace(k2, n2, v2);
    }

    @Override
    public boolean replace(K k2, @NullableDecl V v2, V v3) {
        Preconditions.checkNotNull(k2);
        Preconditions.checkNotNull(v3);
        if (v2 == null) {
            return false;
        }
        int n2 = this.hash(k2);
        return this.segmentFor(n2).replace(k2, n2, v2, v3);
    }

    Segment<K, V> segmentFor(int n2) {
        return this.segments[n2 >>> this.segmentShift & this.segmentMask];
    }

    @Override
    public int size() {
        return Ints.saturatedCast(this.longSize());
    }

    boolean usesAccessEntries() {
        boolean bl = this.usesAccessQueue() || this.recordsAccess();
        return bl;
    }

    boolean usesAccessQueue() {
        boolean bl = this.expiresAfterAccess() || this.evictsBySize();
        return bl;
    }

    boolean usesKeyReferences() {
        boolean bl = this.keyStrength != Strength.STRONG;
        return bl;
    }

    boolean usesValueReferences() {
        boolean bl = this.valueStrength != Strength.STRONG;
        return bl;
    }

    boolean usesWriteEntries() {
        boolean bl = this.usesWriteQueue() || this.recordsWrite();
        return bl;
    }

    boolean usesWriteQueue() {
        return this.expiresAfterWrite();
    }

    @Override
    public Collection<V> values() {
        Values values = this.values;
        if (values == null) {
            this.values = values = new Values(this);
        }
        return values;
    }

    abstract class AbstractCacheSet<T>
    extends AbstractSet<T> {
        final ConcurrentMap<?, ?> map;

        AbstractCacheSet(ConcurrentMap<?, ?> concurrentMap) {
            this.map = concurrentMap;
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public Object[] toArray() {
            return LocalCache.toArrayList(this).toArray();
        }

        @Override
        public <E> E[] toArray(E[] EArray) {
            return LocalCache.toArrayList(this).toArray(EArray);
        }
    }

    static abstract class AbstractReferenceEntry<K, V>
    implements ReferenceEntry<K, V> {
        AbstractReferenceEntry() {
        }

        @Override
        public long getAccessTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public K getKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getNext() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getNextInAccessQueue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getNextInWriteQueue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getPreviousInAccessQueue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getPreviousInWriteQueue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ValueReference<K, V> getValueReference() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getWriteTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setAccessTime(long l2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setNextInAccessQueue(ReferenceEntry<K, V> referenceEntry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setNextInWriteQueue(ReferenceEntry<K, V> referenceEntry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPreviousInAccessQueue(ReferenceEntry<K, V> referenceEntry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPreviousInWriteQueue(ReferenceEntry<K, V> referenceEntry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setValueReference(ValueReference<K, V> valueReference) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setWriteTime(long l2) {
            throw new UnsupportedOperationException();
        }
    }

    static final class AccessQueue<K, V>
    extends AbstractQueue<ReferenceEntry<K, V>> {
        final ReferenceEntry<K, V> head = new AbstractReferenceEntry<K, V>(){
            ReferenceEntry<K, V> nextAccess = this;
            ReferenceEntry<K, V> previousAccess = this;

            @Override
            public long getAccessTime() {
                return Long.MAX_VALUE;
            }

            @Override
            public ReferenceEntry<K, V> getNextInAccessQueue() {
                return this.nextAccess;
            }

            @Override
            public ReferenceEntry<K, V> getPreviousInAccessQueue() {
                return this.previousAccess;
            }

            @Override
            public void setAccessTime(long l2) {
            }

            @Override
            public void setNextInAccessQueue(ReferenceEntry<K, V> referenceEntry) {
                this.nextAccess = referenceEntry;
            }

            @Override
            public void setPreviousInAccessQueue(ReferenceEntry<K, V> referenceEntry) {
                this.previousAccess = referenceEntry;
            }
        };

        AccessQueue() {
        }

        @Override
        public void clear() {
            ReferenceEntry<K, V> referenceEntry;
            ReferenceEntry<K, V> referenceEntry2 = this.head.getNextInAccessQueue();
            while (referenceEntry2 != (referenceEntry = this.head)) {
                referenceEntry = referenceEntry2.getNextInAccessQueue();
                LocalCache.nullifyAccessOrder(referenceEntry2);
                referenceEntry2 = referenceEntry;
            }
            referenceEntry.setNextInAccessQueue(referenceEntry);
            referenceEntry2 = this.head;
            referenceEntry2.setPreviousInAccessQueue(referenceEntry2);
        }

        @Override
        public boolean contains(Object object) {
            boolean bl = ((ReferenceEntry)object).getNextInAccessQueue() != NullEntry.INSTANCE;
            return bl;
        }

        @Override
        public boolean isEmpty() {
            boolean bl = this.head.getNextInAccessQueue() == this.head;
            return bl;
        }

        @Override
        public Iterator<ReferenceEntry<K, V>> iterator() {
            return new AbstractSequentialIterator<ReferenceEntry<K, V>>((ReferenceEntry)this.peek()){

                @Override
                protected ReferenceEntry<K, V> computeNext(ReferenceEntry<K, V> referenceEntry) {
                    ReferenceEntry referenceEntry2 = referenceEntry.getNextInAccessQueue();
                    referenceEntry = referenceEntry2;
                    if (referenceEntry2 == AccessQueue.this.head) {
                        referenceEntry = null;
                    }
                    return referenceEntry;
                }
            };
        }

        @Override
        public boolean offer(ReferenceEntry<K, V> referenceEntry) {
            LocalCache.connectAccessOrder(referenceEntry.getPreviousInAccessQueue(), referenceEntry.getNextInAccessQueue());
            LocalCache.connectAccessOrder(this.head.getPreviousInAccessQueue(), referenceEntry);
            LocalCache.connectAccessOrder(referenceEntry, this.head);
            return true;
        }

        @Override
        public ReferenceEntry<K, V> peek() {
            ReferenceEntry<K, V> referenceEntry;
            ReferenceEntry<K, V> referenceEntry2 = referenceEntry = this.head.getNextInAccessQueue();
            if (referenceEntry == this.head) {
                referenceEntry2 = null;
            }
            return referenceEntry2;
        }

        @Override
        public ReferenceEntry<K, V> poll() {
            ReferenceEntry<K, V> referenceEntry = this.head.getNextInAccessQueue();
            if (referenceEntry == this.head) {
                return null;
            }
            this.remove(referenceEntry);
            return referenceEntry;
        }

        @Override
        public boolean remove(Object referenceEntry) {
            ReferenceEntry referenceEntry2 = referenceEntry;
            referenceEntry = referenceEntry2.getPreviousInAccessQueue();
            ReferenceEntry referenceEntry3 = referenceEntry2.getNextInAccessQueue();
            LocalCache.connectAccessOrder(referenceEntry, referenceEntry3);
            LocalCache.nullifyAccessOrder(referenceEntry2);
            boolean bl = referenceEntry3 != NullEntry.INSTANCE;
            return bl;
        }

        @Override
        public int size() {
            int n2 = 0;
            for (ReferenceEntry<K, V> referenceEntry = this.head.getNextInAccessQueue(); referenceEntry != this.head; referenceEntry = referenceEntry.getNextInAccessQueue()) {
                ++n2;
            }
            return n2;
        }
    }

    static abstract class EntryFactory
    extends Enum<EntryFactory> {
        private static final /* synthetic */ EntryFactory[] $VALUES;
        static final int ACCESS_MASK = 1;
        public static final /* enum */ EntryFactory STRONG = new EntryFactory(){

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K k2, int n2, @NullableDecl ReferenceEntry<K, V> referenceEntry) {
                return new StrongEntry<K, V>(k2, n2, referenceEntry);
            }
        };
        public static final /* enum */ EntryFactory STRONG_ACCESS = new EntryFactory(){

            @Override
            <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> object, ReferenceEntry<K, V> referenceEntry, ReferenceEntry<K, V> referenceEntry2) {
                object = super.copyEntry(object, referenceEntry, referenceEntry2);
                this.copyAccessEntry(referenceEntry, object);
                return object;
            }

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K k2, int n2, @NullableDecl ReferenceEntry<K, V> referenceEntry) {
                return new StrongAccessEntry<K, V>(k2, n2, referenceEntry);
            }
        };
        public static final /* enum */ EntryFactory STRONG_ACCESS_WRITE;
        public static final /* enum */ EntryFactory STRONG_WRITE;
        public static final /* enum */ EntryFactory WEAK;
        public static final /* enum */ EntryFactory WEAK_ACCESS;
        public static final /* enum */ EntryFactory WEAK_ACCESS_WRITE;
        static final int WEAK_MASK = 4;
        public static final /* enum */ EntryFactory WEAK_WRITE;
        static final int WRITE_MASK = 2;
        static final EntryFactory[] factories;

        static {
            STRONG_WRITE = new EntryFactory(){

                @Override
                <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> object, ReferenceEntry<K, V> referenceEntry, ReferenceEntry<K, V> referenceEntry2) {
                    object = super.copyEntry(object, referenceEntry, referenceEntry2);
                    this.copyWriteEntry(referenceEntry, object);
                    return object;
                }

                @Override
                <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K k2, int n2, @NullableDecl ReferenceEntry<K, V> referenceEntry) {
                    return new StrongWriteEntry<K, V>(k2, n2, referenceEntry);
                }
            };
            STRONG_ACCESS_WRITE = new EntryFactory(){

                @Override
                <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> object, ReferenceEntry<K, V> referenceEntry, ReferenceEntry<K, V> referenceEntry2) {
                    object = super.copyEntry(object, referenceEntry, referenceEntry2);
                    this.copyAccessEntry(referenceEntry, object);
                    this.copyWriteEntry(referenceEntry, object);
                    return object;
                }

                @Override
                <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K k2, int n2, @NullableDecl ReferenceEntry<K, V> referenceEntry) {
                    return new StrongAccessWriteEntry<K, V>(k2, n2, referenceEntry);
                }
            };
            WEAK = new EntryFactory(){

                @Override
                <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K k2, int n2, @NullableDecl ReferenceEntry<K, V> referenceEntry) {
                    return new WeakEntry(segment.keyReferenceQueue, k2, n2, referenceEntry);
                }
            };
            WEAK_ACCESS = new EntryFactory(){

                @Override
                <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> object, ReferenceEntry<K, V> referenceEntry, ReferenceEntry<K, V> referenceEntry2) {
                    object = super.copyEntry(object, referenceEntry, referenceEntry2);
                    this.copyAccessEntry(referenceEntry, object);
                    return object;
                }

                @Override
                <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K k2, int n2, @NullableDecl ReferenceEntry<K, V> referenceEntry) {
                    return new WeakAccessEntry(segment.keyReferenceQueue, k2, n2, referenceEntry);
                }
            };
            WEAK_WRITE = new EntryFactory(){

                @Override
                <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> object, ReferenceEntry<K, V> referenceEntry, ReferenceEntry<K, V> referenceEntry2) {
                    object = super.copyEntry(object, referenceEntry, referenceEntry2);
                    this.copyWriteEntry(referenceEntry, object);
                    return object;
                }

                @Override
                <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K k2, int n2, @NullableDecl ReferenceEntry<K, V> referenceEntry) {
                    return new WeakWriteEntry(segment.keyReferenceQueue, k2, n2, referenceEntry);
                }
            };
            WEAK_ACCESS_WRITE = new EntryFactory(){

                @Override
                <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> object, ReferenceEntry<K, V> referenceEntry, ReferenceEntry<K, V> referenceEntry2) {
                    object = super.copyEntry(object, referenceEntry, referenceEntry2);
                    this.copyAccessEntry(referenceEntry, object);
                    this.copyWriteEntry(referenceEntry, object);
                    return object;
                }

                @Override
                <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K k2, int n2, @NullableDecl ReferenceEntry<K, V> referenceEntry) {
                    return new WeakAccessWriteEntry(segment.keyReferenceQueue, k2, n2, referenceEntry);
                }
            };
            EntryFactory entryFactory = STRONG;
            EntryFactory entryFactory2 = STRONG_ACCESS;
            EntryFactory entryFactory3 = STRONG_WRITE;
            EntryFactory entryFactory4 = STRONG_ACCESS_WRITE;
            EntryFactory entryFactory5 = WEAK;
            EntryFactory entryFactory6 = WEAK_ACCESS;
            EntryFactory entryFactory7 = WEAK_WRITE;
            EntryFactory entryFactory8 = WEAK_ACCESS_WRITE;
            $VALUES = new EntryFactory[]{entryFactory, entryFactory2, entryFactory3, entryFactory4, entryFactory5, entryFactory6, entryFactory7, entryFactory8};
            factories = new EntryFactory[]{entryFactory, entryFactory2, entryFactory3, entryFactory4, entryFactory5, entryFactory6, entryFactory7, entryFactory8};
        }

        static EntryFactory getFactory(Strength strength, boolean bl, boolean bl2) {
            Strength strength2 = Strength.WEAK;
            int n2 = 0;
            int n3 = strength == strength2 ? 4 : 0;
            if (bl2) {
                n2 = 2;
            }
            return factories[n3 | bl | n2];
        }

        public static EntryFactory valueOf(String string2) {
            return Enum.valueOf(EntryFactory.class, string2);
        }

        public static EntryFactory[] values() {
            return (EntryFactory[])$VALUES.clone();
        }

        <K, V> void copyAccessEntry(ReferenceEntry<K, V> referenceEntry, ReferenceEntry<K, V> referenceEntry2) {
            referenceEntry2.setAccessTime(referenceEntry.getAccessTime());
            LocalCache.connectAccessOrder(referenceEntry.getPreviousInAccessQueue(), referenceEntry2);
            LocalCache.connectAccessOrder(referenceEntry2, referenceEntry.getNextInAccessQueue());
            LocalCache.nullifyAccessOrder(referenceEntry);
        }

        <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> segment, ReferenceEntry<K, V> referenceEntry, ReferenceEntry<K, V> referenceEntry2) {
            return this.newEntry(segment, referenceEntry.getKey(), referenceEntry.getHash(), referenceEntry2);
        }

        <K, V> void copyWriteEntry(ReferenceEntry<K, V> referenceEntry, ReferenceEntry<K, V> referenceEntry2) {
            referenceEntry2.setWriteTime(referenceEntry.getWriteTime());
            LocalCache.connectWriteOrder(referenceEntry.getPreviousInWriteQueue(), referenceEntry2);
            LocalCache.connectWriteOrder(referenceEntry2, referenceEntry.getNextInWriteQueue());
            LocalCache.nullifyWriteOrder(referenceEntry);
        }

        abstract <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> var1, K var2, int var3, @NullableDecl ReferenceEntry<K, V> var4);
    }

    final class EntryIterator
    extends HashIterator<Map.Entry<K, V>> {
        EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    final class EntrySet
    extends AbstractCacheSet<Map.Entry<K, V>> {
        EntrySet(ConcurrentMap<?, ?> concurrentMap) {
            super(concurrentMap);
        }

        @Override
        public boolean contains(Object object) {
            boolean bl = object instanceof Map.Entry;
            boolean bl2 = false;
            if (!bl) {
                return false;
            }
            Object object2 = (object = (Map.Entry)object).getKey();
            if (object2 == null) {
                return false;
            }
            object2 = LocalCache.this.get(object2);
            bl = bl2;
            if (object2 != null) {
                bl = bl2;
                if (LocalCache.this.valueEquivalence.equivalent(object.getValue(), object2)) {
                    bl = true;
                }
            }
            return bl;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean remove(Object object) {
            boolean bl = object instanceof Map.Entry;
            boolean bl2 = false;
            if (!bl) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            object = entry.getKey();
            bl = bl2;
            if (object != null) {
                bl = bl2;
                if (LocalCache.this.remove(object, entry.getValue())) {
                    bl = true;
                }
            }
            return bl;
        }
    }

    abstract class HashIterator<T>
    implements Iterator<T> {
        @MonotonicNonNullDecl
        Segment<K, V> currentSegment;
        @MonotonicNonNullDecl
        AtomicReferenceArray<ReferenceEntry<K, V>> currentTable;
        @NullableDecl
        WriteThroughEntry lastReturned;
        @NullableDecl
        ReferenceEntry<K, V> nextEntry;
        @NullableDecl
        WriteThroughEntry nextExternal;
        int nextSegmentIndex;
        int nextTableIndex;

        HashIterator() {
            this.nextSegmentIndex = LocalCache.this.segments.length - 1;
            this.nextTableIndex = -1;
            this.advance();
        }

        final void advance() {
            this.nextExternal = null;
            if (this.nextInChain()) {
                return;
            }
            if (this.nextInTable()) {
                return;
            }
            while (this.nextSegmentIndex >= 0) {
                Segment<K, V>[] segmentArray = LocalCache.this.segments;
                int n2 = this.nextSegmentIndex;
                this.nextSegmentIndex = n2 - 1;
                this.currentSegment = segmentArray[n2];
                if (this.currentSegment.count == 0) continue;
                this.currentTable = this.currentSegment.table;
                this.nextTableIndex = this.currentTable.length() - 1;
                if (!this.nextInTable()) continue;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        boolean advanceTo(ReferenceEntry<K, V> referenceEntry) {
            try {
                boolean bl;
                long l2 = LocalCache.this.ticker.read();
                Object k2 = referenceEntry.getKey();
                Object v2 = LocalCache.this.getLiveValue(referenceEntry, l2);
                if (v2 != null) {
                    WriteThroughEntry writeThroughEntry;
                    this.nextExternal = writeThroughEntry = new WriteThroughEntry(k2, v2);
                    bl = true;
                    return bl;
                } else {
                    bl = false;
                }
                return bl;
            }
            finally {
                this.currentSegment.postReadCleanup();
            }
        }

        @Override
        public boolean hasNext() {
            boolean bl = this.nextExternal != null;
            return bl;
        }

        @Override
        public abstract T next();

        WriteThroughEntry nextEntry() {
            WriteThroughEntry writeThroughEntry = this.nextExternal;
            if (writeThroughEntry != null) {
                this.lastReturned = writeThroughEntry;
                this.advance();
                return this.lastReturned;
            }
            throw new NoSuchElementException();
        }

        boolean nextInChain() {
            ReferenceEntry referenceEntry = this.nextEntry;
            if (referenceEntry != null) {
                while (true) {
                    this.nextEntry = referenceEntry.getNext();
                    referenceEntry = this.nextEntry;
                    if (referenceEntry == null) break;
                    if (this.advanceTo(referenceEntry)) {
                        return true;
                    }
                    referenceEntry = this.nextEntry;
                }
            }
            return false;
        }

        boolean nextInTable() {
            int n2;
            while ((n2 = this.nextTableIndex) >= 0) {
                Object object = this.currentTable;
                this.nextTableIndex = n2 - 1;
                this.nextEntry = object = ((AtomicReferenceArray)object).get(n2);
                if (object == null || !this.advanceTo(this.nextEntry) && !this.nextInChain()) continue;
                return true;
            }
            return false;
        }

        @Override
        public void remove() {
            boolean bl = this.lastReturned != null;
            Preconditions.checkState(bl);
            LocalCache.this.remove(this.lastReturned.getKey());
            this.lastReturned = null;
        }
    }

    final class KeyIterator
    extends HashIterator<K> {
        KeyIterator() {
        }

        @Override
        public K next() {
            return this.nextEntry().getKey();
        }
    }

    final class KeySet
    extends AbstractCacheSet<K> {
        KeySet(ConcurrentMap<?, ?> concurrentMap) {
            super(concurrentMap);
        }

        @Override
        public boolean contains(Object object) {
            return this.map.containsKey(object);
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public boolean remove(Object object) {
            boolean bl = this.map.remove(object) != null;
            return bl;
        }
    }

    static final class LoadingSerializationProxy<K, V>
    extends ManualSerializationProxy<K, V>
    implements LoadingCache<K, V>,
    Serializable {
        private static final long serialVersionUID = 1L;
        @MonotonicNonNullDecl
        transient LoadingCache<K, V> autoDelegate;

        LoadingSerializationProxy(LocalCache<K, V> localCache) {
            super(localCache);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            this.autoDelegate = this.recreateCacheBuilder().build(this.loader);
        }

        private Object readResolve() {
            return this.autoDelegate;
        }

        @Override
        public final V apply(K k2) {
            return this.autoDelegate.apply(k2);
        }

        @Override
        public V get(K k2) throws ExecutionException {
            return this.autoDelegate.get(k2);
        }

        @Override
        public ImmutableMap<K, V> getAll(Iterable<? extends K> iterable) throws ExecutionException {
            return this.autoDelegate.getAll(iterable);
        }

        @Override
        public V getUnchecked(K k2) {
            return this.autoDelegate.getUnchecked(k2);
        }

        @Override
        public void refresh(K k2) {
            this.autoDelegate.refresh(k2);
        }
    }

    static class LoadingValueReference<K, V>
    implements ValueReference<K, V> {
        final SettableFuture<V> futureValue = SettableFuture.create();
        volatile ValueReference<K, V> oldValue;
        final Stopwatch stopwatch = Stopwatch.createUnstarted();

        public LoadingValueReference() {
            this(LocalCache.unset());
        }

        public LoadingValueReference(ValueReference<K, V> valueReference) {
            this.oldValue = valueReference;
        }

        private ListenableFuture<V> fullyFailedFuture(Throwable throwable) {
            return Futures.immediateFailedFuture(throwable);
        }

        @Override
        public ValueReference<K, V> copyFor(ReferenceQueue<V> referenceQueue, @NullableDecl V v2, ReferenceEntry<K, V> referenceEntry) {
            return this;
        }

        public long elapsedNanos() {
            return this.stopwatch.elapsed(TimeUnit.NANOSECONDS);
        }

        @Override
        public V get() {
            return this.oldValue.get();
        }

        @Override
        public ReferenceEntry<K, V> getEntry() {
            return null;
        }

        public ValueReference<K, V> getOldValue() {
            return this.oldValue;
        }

        @Override
        public int getWeight() {
            return this.oldValue.getWeight();
        }

        @Override
        public boolean isActive() {
            return this.oldValue.isActive();
        }

        @Override
        public boolean isLoading() {
            return true;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public ListenableFuture<V> loadFuture(K object, CacheLoader<? super K, V> object2) {
            try {
                void var2_11;
                this.stopwatch.start();
                V v2 = this.oldValue.get();
                if (v2 == null) {
                    void var1_5;
                    Object object3 = var2_11.load(object);
                    if (this.set(object3)) {
                        SettableFuture<V> settableFuture = this.futureValue;
                        return var1_5;
                    }
                    ListenableFuture<Object> listenableFuture = Futures.immediateFuture(object3);
                    return var1_5;
                }
                ListenableFuture listenableFuture = var2_11.reload(object, v2);
                if (listenableFuture == null) {
                    return Futures.immediateFuture(null);
                }
                Function function = new Function<V, V>(){

                    @Override
                    public V apply(V v2) {
                        LoadingValueReference.this.set(v2);
                        return v2;
                    }
                };
                return Futures.transform(listenableFuture, function, MoreExecutors.directExecutor());
            }
            catch (Throwable throwable) {
                void var1_10;
                if (this.setException(throwable)) {
                    SettableFuture<V> settableFuture = this.futureValue;
                } else {
                    ListenableFuture<V> listenableFuture = this.fullyFailedFuture(throwable);
                }
                if (!(throwable instanceof InterruptedException)) return var1_10;
                Thread.currentThread().interrupt();
                return var1_10;
            }
        }

        @Override
        public void notifyNewValue(@NullableDecl V v2) {
            if (v2 != null) {
                this.set(v2);
            } else {
                this.oldValue = LocalCache.unset();
            }
        }

        public boolean set(@NullableDecl V v2) {
            return this.futureValue.set(v2);
        }

        public boolean setException(Throwable throwable) {
            return this.futureValue.setException(throwable);
        }

        @Override
        public V waitForValue() throws ExecutionException {
            return (V)Uninterruptibles.getUninterruptibly(this.futureValue);
        }
    }

    static class LocalLoadingCache<K, V>
    extends LocalManualCache<K, V>
    implements LoadingCache<K, V> {
        private static final long serialVersionUID = 1L;

        LocalLoadingCache(CacheBuilder<? super K, ? super V> cacheBuilder, CacheLoader<? super K, V> cacheLoader) {
            super(new LocalCache<K, V>(cacheBuilder, Preconditions.checkNotNull(cacheLoader)));
        }

        @Override
        public final V apply(K k2) {
            return this.getUnchecked(k2);
        }

        @Override
        public V get(K k2) throws ExecutionException {
            return this.localCache.getOrLoad(k2);
        }

        @Override
        public ImmutableMap<K, V> getAll(Iterable<? extends K> iterable) throws ExecutionException {
            return this.localCache.getAll(iterable);
        }

        @Override
        public V getUnchecked(K object) {
            try {
                object = this.get(object);
            }
            catch (ExecutionException executionException) {
                throw new UncheckedExecutionException(executionException.getCause());
            }
            return (V)object;
        }

        @Override
        public void refresh(K k2) {
            this.localCache.refresh(k2);
        }

        @Override
        Object writeReplace() {
            return new LoadingSerializationProxy(this.localCache);
        }
    }

    static class LocalManualCache<K, V>
    implements Cache<K, V>,
    Serializable {
        private static final long serialVersionUID = 1L;
        final LocalCache<K, V> localCache;

        LocalManualCache(CacheBuilder<? super K, ? super V> cacheBuilder) {
            this(new LocalCache<K, V>(cacheBuilder, null));
        }

        private LocalManualCache(LocalCache<K, V> localCache) {
            this.localCache = localCache;
        }

        @Override
        public ConcurrentMap<K, V> asMap() {
            return this.localCache;
        }

        @Override
        public void cleanUp() {
            this.localCache.cleanUp();
        }

        @Override
        public V get(K k2, final Callable<? extends V> callable) throws ExecutionException {
            Preconditions.checkNotNull(callable);
            return this.localCache.get(k2, new CacheLoader<Object, V>(){

                public V load(Object object) throws Exception {
                    return callable.call();
                }
            });
        }

        @Override
        public ImmutableMap<K, V> getAllPresent(Iterable<?> iterable) {
            return this.localCache.getAllPresent(iterable);
        }

        @Override
        @NullableDecl
        public V getIfPresent(Object object) {
            return this.localCache.getIfPresent(object);
        }

        @Override
        public void invalidate(Object object) {
            Preconditions.checkNotNull(object);
            this.localCache.remove(object);
        }

        @Override
        public void invalidateAll() {
            this.localCache.clear();
        }

        @Override
        public void invalidateAll(Iterable<?> iterable) {
            this.localCache.invalidateAll(iterable);
        }

        @Override
        public void put(K k2, V v2) {
            this.localCache.put(k2, v2);
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            this.localCache.putAll(map);
        }

        @Override
        public long size() {
            return this.localCache.longSize();
        }

        @Override
        public CacheStats stats() {
            AbstractCache.SimpleStatsCounter simpleStatsCounter = new AbstractCache.SimpleStatsCounter();
            simpleStatsCounter.incrementBy(this.localCache.globalStatsCounter);
            Segment<K, V>[] segmentArray = this.localCache.segments;
            int n2 = segmentArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                simpleStatsCounter.incrementBy(segmentArray[i2].statsCounter);
            }
            return simpleStatsCounter.snapshot();
        }

        Object writeReplace() {
            return new ManualSerializationProxy<K, V>(this.localCache);
        }
    }

    static class ManualSerializationProxy<K, V>
    extends ForwardingCache<K, V>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final int concurrencyLevel;
        @MonotonicNonNullDecl
        transient Cache<K, V> delegate;
        final long expireAfterAccessNanos;
        final long expireAfterWriteNanos;
        final Equivalence<Object> keyEquivalence;
        final Strength keyStrength;
        final CacheLoader<? super K, V> loader;
        final long maxWeight;
        final RemovalListener<? super K, ? super V> removalListener;
        @NullableDecl
        final Ticker ticker;
        final Equivalence<Object> valueEquivalence;
        final Strength valueStrength;
        final Weigher<K, V> weigher;

        private ManualSerializationProxy(Strength strength, Strength strength2, Equivalence<Object> equivalence, Equivalence<Object> equivalence2, long l2, long l3, long l4, Weigher<K, V> weigher, int n2, RemovalListener<? super K, ? super V> removalListener, Ticker ticker, CacheLoader<? super K, V> cacheLoader) {
            block3: {
                block2: {
                    this.keyStrength = strength;
                    this.valueStrength = strength2;
                    this.keyEquivalence = equivalence;
                    this.valueEquivalence = equivalence2;
                    this.expireAfterWriteNanos = l2;
                    this.expireAfterAccessNanos = l3;
                    this.maxWeight = l4;
                    this.weigher = weigher;
                    this.concurrencyLevel = n2;
                    this.removalListener = removalListener;
                    if (ticker == Ticker.systemTicker()) break block2;
                    strength = ticker;
                    if (ticker != CacheBuilder.NULL_TICKER) break block3;
                }
                strength = null;
            }
            this.ticker = strength;
            this.loader = cacheLoader;
        }

        ManualSerializationProxy(LocalCache<K, V> localCache) {
            this(localCache.keyStrength, localCache.valueStrength, localCache.keyEquivalence, localCache.valueEquivalence, localCache.expireAfterWriteNanos, localCache.expireAfterAccessNanos, localCache.maxWeight, localCache.weigher, localCache.concurrencyLevel, localCache.removalListener, localCache.ticker, localCache.defaultLoader);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            this.delegate = this.recreateCacheBuilder().build();
        }

        private Object readResolve() {
            return this.delegate;
        }

        @Override
        protected Cache<K, V> delegate() {
            return this.delegate;
        }

        CacheBuilder<K, V> recreateCacheBuilder() {
            Ticker ticker;
            CacheBuilder<K, V> cacheBuilder = CacheBuilder.newBuilder().setKeyStrength(this.keyStrength).setValueStrength(this.valueStrength).keyEquivalence(this.keyEquivalence).valueEquivalence(this.valueEquivalence).concurrencyLevel(this.concurrencyLevel).removalListener(this.removalListener);
            cacheBuilder.strictParsing = false;
            long l2 = this.expireAfterWriteNanos;
            if (l2 > 0L) {
                cacheBuilder.expireAfterWrite(l2, TimeUnit.NANOSECONDS);
            }
            if ((l2 = this.expireAfterAccessNanos) > 0L) {
                cacheBuilder.expireAfterAccess(l2, TimeUnit.NANOSECONDS);
            }
            if (this.weigher != CacheBuilder.OneWeigher.INSTANCE) {
                cacheBuilder.weigher(this.weigher);
                l2 = this.maxWeight;
                if (l2 != -1L) {
                    cacheBuilder.maximumWeight(l2);
                }
            } else {
                l2 = this.maxWeight;
                if (l2 != -1L) {
                    cacheBuilder.maximumSize(l2);
                }
            }
            if ((ticker = this.ticker) != null) {
                cacheBuilder.ticker(ticker);
            }
            return cacheBuilder;
        }
    }

    private static enum NullEntry implements ReferenceEntry<Object, Object>
    {
        INSTANCE;


        @Override
        public long getAccessTime() {
            return 0L;
        }

        @Override
        public int getHash() {
            return 0;
        }

        @Override
        public Object getKey() {
            return null;
        }

        @Override
        public ReferenceEntry<Object, Object> getNext() {
            return null;
        }

        @Override
        public ReferenceEntry<Object, Object> getNextInAccessQueue() {
            return this;
        }

        @Override
        public ReferenceEntry<Object, Object> getNextInWriteQueue() {
            return this;
        }

        @Override
        public ReferenceEntry<Object, Object> getPreviousInAccessQueue() {
            return this;
        }

        @Override
        public ReferenceEntry<Object, Object> getPreviousInWriteQueue() {
            return this;
        }

        @Override
        public ValueReference<Object, Object> getValueReference() {
            return null;
        }

        @Override
        public long getWriteTime() {
            return 0L;
        }

        @Override
        public void setAccessTime(long l2) {
        }

        @Override
        public void setNextInAccessQueue(ReferenceEntry<Object, Object> referenceEntry) {
        }

        @Override
        public void setNextInWriteQueue(ReferenceEntry<Object, Object> referenceEntry) {
        }

        @Override
        public void setPreviousInAccessQueue(ReferenceEntry<Object, Object> referenceEntry) {
        }

        @Override
        public void setPreviousInWriteQueue(ReferenceEntry<Object, Object> referenceEntry) {
        }

        @Override
        public void setValueReference(ValueReference<Object, Object> valueReference) {
        }

        @Override
        public void setWriteTime(long l2) {
        }
    }

    static class Segment<K, V>
    extends ReentrantLock {
        final Queue<ReferenceEntry<K, V>> accessQueue;
        volatile int count;
        @NullableDecl
        final ReferenceQueue<K> keyReferenceQueue;
        final LocalCache<K, V> map;
        final long maxSegmentWeight;
        int modCount;
        final AtomicInteger readCount = new AtomicInteger();
        final Queue<ReferenceEntry<K, V>> recencyQueue;
        final AbstractCache.StatsCounter statsCounter;
        @MonotonicNonNullDecl
        volatile AtomicReferenceArray<ReferenceEntry<K, V>> table;
        int threshold;
        long totalWeight;
        @NullableDecl
        final ReferenceQueue<V> valueReferenceQueue;
        final Queue<ReferenceEntry<K, V>> writeQueue;

        Segment(LocalCache<K, V> queue, int n2, long l2, AbstractCache.StatsCounter object) {
            this.map = queue;
            this.maxSegmentWeight = l2;
            this.statsCounter = Preconditions.checkNotNull(object);
            this.initTable(this.newEntryArray(n2));
            boolean bl = ((LocalCache)((Object)queue)).usesKeyReferences();
            Object var7_6 = null;
            object = bl ? new ReferenceQueue() : null;
            this.keyReferenceQueue = object;
            object = var7_6;
            if (((LocalCache)((Object)queue)).usesValueReferences()) {
                object = new ReferenceQueue();
            }
            this.valueReferenceQueue = object;
            object = ((LocalCache)((Object)queue)).usesAccessQueue() ? new ConcurrentLinkedQueue() : LocalCache.discardingQueue();
            this.recencyQueue = object;
            object = ((LocalCache)((Object)queue)).usesWriteQueue() ? new WriteQueue() : LocalCache.discardingQueue();
            this.writeQueue = object;
            queue = ((LocalCache)((Object)queue)).usesAccessQueue() ? new AccessQueue() : LocalCache.discardingQueue();
            this.accessQueue = queue;
        }

        void cleanUp() {
            this.runLockedCleanup(this.map.ticker.read());
            this.runUnlockedCleanup();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void clear() {
            if (this.count == 0) return;
            this.lock();
            this.preWriteCleanup(this.map.ticker.read());
            AtomicReferenceArray<ReferenceEntry<K, V>> atomicReferenceArray = this.table;
            int n2 = 0;
            while (true) {
                if (n2 >= atomicReferenceArray.length()) break;
                for (ReferenceEntry<K, V> referenceEntry = atomicReferenceArray.get(n2); referenceEntry != null; referenceEntry = referenceEntry.getNext()) {
                    if (!referenceEntry.getValueReference().isActive()) continue;
                    K k2 = referenceEntry.getKey();
                    V v2 = referenceEntry.getValueReference().get();
                    RemovalCause removalCause = k2 != null && v2 != null ? RemovalCause.EXPLICIT : RemovalCause.COLLECTED;
                    this.enqueueNotification(k2, referenceEntry.getHash(), v2, referenceEntry.getValueReference().getWeight(), removalCause);
                }
                ++n2;
            }
            for (n2 = 0; n2 < atomicReferenceArray.length(); ++n2) {
                atomicReferenceArray.set(n2, null);
            }
            this.clearReferenceQueues();
            this.writeQueue.clear();
            this.accessQueue.clear();
            this.readCount.set(0);
            ++this.modCount;
            this.count = 0;
            return;
        }

        void clearKeyReferenceQueue() {
            while (this.keyReferenceQueue.poll() != null) {
            }
        }

        void clearReferenceQueues() {
            if (this.map.usesKeyReferences()) {
                this.clearKeyReferenceQueue();
            }
            if (this.map.usesValueReferences()) {
                this.clearValueReferenceQueue();
            }
        }

        void clearValueReferenceQueue() {
            while (this.valueReferenceQueue.poll() != null) {
            }
        }

        boolean containsKey(Object referenceEntry, int n2) {
            block5: {
                boolean bl;
                block6: {
                    try {
                        int n3 = this.count;
                        bl = false;
                        if (n3 == 0) break block5;
                    }
                    catch (Throwable throwable) {
                        this.postReadCleanup();
                        throw throwable;
                    }
                    referenceEntry = this.getLiveEntry(referenceEntry, n2, this.map.ticker.read());
                    if (referenceEntry != null) break block6;
                    this.postReadCleanup();
                    return false;
                }
                referenceEntry = referenceEntry.getValueReference().get();
                if (referenceEntry != null) {
                    bl = true;
                }
                this.postReadCleanup();
                return bl;
            }
            this.postReadCleanup();
            return false;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        boolean containsValue(Object object) {
            try {
                if (this.count == 0) return false;
                long l2 = this.map.ticker.read();
                AtomicReferenceArray<ReferenceEntry<K, V>> atomicReferenceArray = this.table;
                int n2 = atomicReferenceArray.length();
                for (int i2 = 0; i2 < n2; ++i2) {
                    for (ReferenceEntry<K, V> referenceEntry = atomicReferenceArray.get(i2); referenceEntry != null; referenceEntry = referenceEntry.getNext()) {
                        boolean bl;
                        V v2 = this.getLiveValue(referenceEntry, l2);
                        if (v2 == null || !(bl = this.map.valueEquivalence.equivalent(object, v2))) continue;
                        this.postReadCleanup();
                        return true;
                    }
                }
                return false;
            }
            finally {
                this.postReadCleanup();
            }
        }

        ReferenceEntry<K, V> copyEntry(ReferenceEntry<K, V> referenceEntry, ReferenceEntry<K, V> referenceEntry2) {
            if (referenceEntry.getKey() == null) {
                return null;
            }
            ValueReference<K, V> valueReference = referenceEntry.getValueReference();
            V v2 = valueReference.get();
            if (v2 == null && valueReference.isActive()) {
                return null;
            }
            referenceEntry = this.map.entryFactory.copyEntry(this, referenceEntry, referenceEntry2);
            referenceEntry.setValueReference(valueReference.copyFor(this.valueReferenceQueue, v2, referenceEntry));
            return referenceEntry;
        }

        void drainKeyReferenceQueue() {
            Object object;
            int n2 = 0;
            while ((object = this.keyReferenceQueue.poll()) != null) {
                int n3;
                object = (ReferenceEntry)object;
                this.map.reclaimKey((ReferenceEntry<K, V>)object);
                n2 = n3 = n2 + 1;
                if (n3 != 16) continue;
            }
        }

        void drainRecencyQueue() {
            ReferenceEntry<K, V> referenceEntry;
            while ((referenceEntry = this.recencyQueue.poll()) != null) {
                if (!this.accessQueue.contains(referenceEntry)) continue;
                this.accessQueue.add(referenceEntry);
            }
        }

        void drainReferenceQueues() {
            if (this.map.usesKeyReferences()) {
                this.drainKeyReferenceQueue();
            }
            if (this.map.usesValueReferences()) {
                this.drainValueReferenceQueue();
            }
        }

        void drainValueReferenceQueue() {
            Object object;
            int n2 = 0;
            while ((object = this.valueReferenceQueue.poll()) != null) {
                int n3;
                object = (ValueReference)object;
                this.map.reclaimValue((ValueReference<K, V>)object);
                n2 = n3 = n2 + 1;
                if (n3 != 16) continue;
            }
        }

        void enqueueNotification(@NullableDecl K object, int n2, @NullableDecl V v2, int n3, RemovalCause removalCause) {
            this.totalWeight -= (long)n3;
            if (removalCause.wasEvicted()) {
                this.statsCounter.recordEviction();
            }
            if (this.map.removalNotificationQueue != DISCARDING_QUEUE) {
                object = RemovalNotification.create(object, v2, removalCause);
                this.map.removalNotificationQueue.offer(object);
            }
        }

        void evictEntries(ReferenceEntry<K, V> referenceEntry) {
            if (!this.map.evictsBySize()) {
                return;
            }
            this.drainRecencyQueue();
            if ((long)referenceEntry.getValueReference().getWeight() > this.maxSegmentWeight && !this.removeEntry(referenceEntry, referenceEntry.getHash(), RemovalCause.SIZE)) {
                throw new AssertionError();
            }
            while (this.totalWeight > this.maxSegmentWeight) {
                referenceEntry = this.getNextEvictable();
                if (!this.removeEntry(referenceEntry, referenceEntry.getHash(), RemovalCause.SIZE)) {
                    throw new AssertionError();
                }
            }
        }

        void expand() {
            AtomicReferenceArray<ReferenceEntry<K, V>> atomicReferenceArray = this.table;
            int n2 = atomicReferenceArray.length();
            if (n2 >= 0x40000000) {
                return;
            }
            int n3 = this.count;
            AtomicReferenceArray<ReferenceEntry<K, V>> atomicReferenceArray2 = this.newEntryArray(n2 << 1);
            this.threshold = atomicReferenceArray2.length() * 3 / 4;
            int n4 = atomicReferenceArray2.length() - 1;
            for (int i2 = 0; i2 < n2; ++i2) {
                ReferenceEntry<K, V> referenceEntry = atomicReferenceArray.get(i2);
                int n5 = n3;
                if (referenceEntry != null) {
                    ReferenceEntry<K, V> referenceEntry2;
                    int n6 = referenceEntry.getHash() & n4;
                    if (referenceEntry2 == null) {
                        atomicReferenceArray2.set(n6, referenceEntry);
                        n5 = n3;
                    } else {
                        ReferenceEntry<K, V> referenceEntry3 = referenceEntry;
                        for (referenceEntry2 = referenceEntry.getNext(); referenceEntry2 != null; referenceEntry2 = referenceEntry2.getNext()) {
                            int n7 = referenceEntry2.getHash() & n4;
                            n5 = n6;
                            if (n7 != n6) {
                                referenceEntry3 = referenceEntry2;
                                n5 = n7;
                            }
                            n6 = n5;
                        }
                        atomicReferenceArray2.set(n6, referenceEntry3);
                        while (true) {
                            n5 = n3;
                            if (referenceEntry == referenceEntry3) break;
                            n5 = referenceEntry.getHash() & n4;
                            referenceEntry2 = this.copyEntry(referenceEntry, atomicReferenceArray2.get(n5));
                            if (referenceEntry2 != null) {
                                atomicReferenceArray2.set(n5, referenceEntry2);
                            } else {
                                this.removeCollectedEntry(referenceEntry);
                                --n3;
                            }
                            referenceEntry = referenceEntry.getNext();
                        }
                    }
                }
                n3 = n5;
            }
            this.table = atomicReferenceArray2;
            this.count = n3;
        }

        void expireEntries(long l2) {
            ReferenceEntry<K, V> referenceEntry;
            this.drainRecencyQueue();
            while ((referenceEntry = this.writeQueue.peek()) != null && this.map.isExpired(referenceEntry, l2)) {
                if (!this.removeEntry(referenceEntry, referenceEntry.getHash(), RemovalCause.EXPIRED)) {
                    throw new AssertionError();
                }
            }
            while ((referenceEntry = this.accessQueue.peek()) != null && this.map.isExpired(referenceEntry, l2)) {
                if (!this.removeEntry(referenceEntry, referenceEntry.getHash(), RemovalCause.EXPIRED)) {
                    throw new AssertionError();
                }
            }
        }

        @NullableDecl
        V get(Object object, int n2) {
            block7: {
                ReferenceEntry<K, V> referenceEntry;
                long l2;
                block8: {
                    if (this.count == 0) break block7;
                    l2 = this.map.ticker.read();
                    referenceEntry = this.getLiveEntry(object, n2, l2);
                    if (referenceEntry != null) break block8;
                    this.postReadCleanup();
                    return null;
                }
                object = referenceEntry.getValueReference().get();
                if (object != null) {
                    this.recordRead(referenceEntry, l2);
                    object = this.scheduleRefresh(referenceEntry, referenceEntry.getKey(), n2, object, l2, this.map.defaultLoader);
                    return (V)object;
                }
                this.tryDrainReferenceQueues();
            }
            return null;
            finally {
                this.postReadCleanup();
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        V get(K object, int n2, CacheLoader<? super K, V> cacheLoader) throws ExecutionException {
            Throwable throwable222222;
            block10: {
                block8: {
                    Object object2;
                    ReferenceEntry<K, V> referenceEntry;
                    block9: {
                        Preconditions.checkNotNull(object);
                        Preconditions.checkNotNull(cacheLoader);
                        if (this.count == 0 || (referenceEntry = this.getEntry(object, n2)) == null) break block8;
                        long l2 = this.map.ticker.read();
                        object2 = this.getLiveValue(referenceEntry, l2);
                        if (object2 == null) break block9;
                        this.recordRead(referenceEntry, l2);
                        this.statsCounter.recordHits(1);
                        object = this.scheduleRefresh(referenceEntry, object, n2, object2, l2, cacheLoader);
                        this.postReadCleanup();
                        return (V)object;
                    }
                    object2 = referenceEntry.getValueReference();
                    if (!object2.isLoading()) break block8;
                    object = this.waitForLoadingValue(referenceEntry, object, (ValueReference<K, V>)object2);
                    this.postReadCleanup();
                    return (V)object;
                }
                object = this.lockedGetOrLoad(object, n2, cacheLoader);
                this.postReadCleanup();
                return (V)object;
                {
                    catch (Throwable throwable222222) {
                        break block10;
                    }
                    catch (ExecutionException executionException) {}
                    {
                        object = executionException.getCause();
                        if (object instanceof Error) {
                            ExecutionError executionError = new ExecutionError((Error)object);
                            throw executionError;
                        }
                        if (object instanceof RuntimeException) {
                            UncheckedExecutionException uncheckedExecutionException = new UncheckedExecutionException((Throwable)object);
                            throw uncheckedExecutionException;
                        }
                        throw executionException;
                    }
                }
            }
            this.postReadCleanup();
            throw throwable222222;
        }

        /*
         * Loose catch block
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        V getAndRecordStats(K k2, int n2, LoadingValueReference<K, V> loadingValueReference, ListenableFuture<V> object) throws ExecutionException {
            void var5_8;
            block8: {
                block6: {
                    block7: {
                        object = Uninterruptibles.getUninterruptibly((Future)object);
                        if (object == null) break block6;
                        try {
                            this.statsCounter.recordLoadSuccess(loadingValueReference.elapsedNanos());
                            this.storeLoadedValue(k2, n2, loadingValueReference, object);
                            if (object != null) break block7;
                        }
                        catch (Throwable throwable) {}
                        this.statsCounter.recordLoadException(loadingValueReference.elapsedNanos());
                        this.removeLoadingValue(k2, n2, loadingValueReference);
                    }
                    return (V)object;
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("CacheLoader returned null for key ");
                stringBuilder.append(k2);
                stringBuilder.append(".");
                CacheLoader.InvalidCacheLoadException invalidCacheLoadException = new CacheLoader.InvalidCacheLoadException(stringBuilder.toString());
                throw invalidCacheLoadException;
                break block8;
                catch (Throwable throwable) {
                    object = null;
                }
            }
            if (object == null) {
                this.statsCounter.recordLoadException(loadingValueReference.elapsedNanos());
                this.removeLoadingValue(k2, n2, loadingValueReference);
            }
            throw var5_8;
        }

        @NullableDecl
        ReferenceEntry<K, V> getEntry(Object object, int n2) {
            for (ReferenceEntry<K, V> referenceEntry = this.getFirst(n2); referenceEntry != null; referenceEntry = referenceEntry.getNext()) {
                if (referenceEntry.getHash() != n2) continue;
                K k2 = referenceEntry.getKey();
                if (k2 == null) {
                    this.tryDrainReferenceQueues();
                    continue;
                }
                if (!this.map.keyEquivalence.equivalent(object, k2)) continue;
                return referenceEntry;
            }
            return null;
        }

        ReferenceEntry<K, V> getFirst(int n2) {
            AtomicReferenceArray<ReferenceEntry<K, V>> atomicReferenceArray = this.table;
            return atomicReferenceArray.get(n2 & atomicReferenceArray.length() - 1);
        }

        @NullableDecl
        ReferenceEntry<K, V> getLiveEntry(Object referenceEntry, int n2, long l2) {
            if ((referenceEntry = this.getEntry(referenceEntry, n2)) == null) {
                return null;
            }
            if (this.map.isExpired(referenceEntry, l2)) {
                this.tryExpireEntries(l2);
                return null;
            }
            return referenceEntry;
        }

        V getLiveValue(ReferenceEntry<K, V> referenceEntry, long l2) {
            if (referenceEntry.getKey() == null) {
                this.tryDrainReferenceQueues();
                return null;
            }
            V v2 = referenceEntry.getValueReference().get();
            if (v2 == null) {
                this.tryDrainReferenceQueues();
                return null;
            }
            if (this.map.isExpired(referenceEntry, l2)) {
                this.tryExpireEntries(l2);
                return null;
            }
            return v2;
        }

        ReferenceEntry<K, V> getNextEvictable() {
            for (ReferenceEntry referenceEntry : this.accessQueue) {
                if (referenceEntry.getValueReference().getWeight() <= 0) continue;
                return referenceEntry;
            }
            AssertionError assertionError = new AssertionError();
            throw assertionError;
        }

        void initTable(AtomicReferenceArray<ReferenceEntry<K, V>> atomicReferenceArray) {
            int n2;
            this.threshold = atomicReferenceArray.length() * 3 / 4;
            if (!this.map.customWeigher() && (long)(n2 = this.threshold) == this.maxSegmentWeight) {
                this.threshold = n2 + 1;
            }
            this.table = atomicReferenceArray;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @NullableDecl
        LoadingValueReference<K, V> insertLoadingValueReference(K object, int n2, boolean bl) {
            this.lock();
            try {
                Object object2;
                long l2 = this.map.ticker.read();
                this.preWriteCleanup(l2);
                AtomicReferenceArray<ReferenceEntry<K, V>> atomicReferenceArray = this.table;
                int n3 = atomicReferenceArray.length() - 1 & n2;
                LoadingValueReference loadingValueReference = atomicReferenceArray.get(n3);
                for (object2 = loadingValueReference; object2 != null; object2 = object2.getNext()) {
                    K k2 = object2.getKey();
                    if (object2.getHash() != n2 || k2 == null || !this.map.keyEquivalence.equivalent(object, k2)) continue;
                    object = object2.getValueReference();
                    if (object.isLoading()) return null;
                    if (bl && l2 - object2.getWriteTime() < this.map.refreshNanos) {
                        return null;
                    } else {
                        ++this.modCount;
                        loadingValueReference = new LoadingValueReference(object);
                        object2.setValueReference(loadingValueReference);
                        return loadingValueReference;
                    }
                }
                ++this.modCount;
                object2 = new LoadingValueReference();
                object = this.newEntry((K)object, n2, (ReferenceEntry<K, V>)((Object)loadingValueReference));
                object.setValueReference(object2);
                atomicReferenceArray.set(n3, (ReferenceEntry<K, V>)object);
                return object2;
            }
            finally {
                this.unlock();
                this.postWriteCleanup();
            }
        }

        ListenableFuture<V> loadAsync(final K k2, final int n2, final LoadingValueReference<K, V> loadingValueReference, CacheLoader<? super K, V> object) {
            object = loadingValueReference.loadFuture((K)k2, (CacheLoader<? super K, V>)object);
            object.addListener(new Runnable((ListenableFuture)object){
                final /* synthetic */ ListenableFuture val$loadingFuture;
                {
                    this.val$loadingFuture = listenableFuture;
                }

                @Override
                public void run() {
                    try {
                        Segment.this.getAndRecordStats(k2, n2, loadingValueReference, this.val$loadingFuture);
                    }
                    catch (Throwable throwable) {
                        logger.log(Level.WARNING, "Exception thrown during refresh", throwable);
                        loadingValueReference.setException(throwable);
                    }
                }
            }, MoreExecutors.directExecutor());
            return object;
        }

        V loadSync(K k2, int n2, LoadingValueReference<K, V> loadingValueReference, CacheLoader<? super K, V> cacheLoader) throws ExecutionException {
            return this.getAndRecordStats(k2, n2, loadingValueReference, loadingValueReference.loadFuture((K)k2, cacheLoader));
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        V lockedGetOrLoad(K object, int n2, CacheLoader<? super K, V> cacheLoader) throws ExecutionException {
            ReferenceEntry referenceEntry;
            Object object2;
            LoadingValueReference loadingValueReference;
            ReferenceEntry referenceEntry2;
            ReferenceEntry referenceEntry3;
            int n3;
            AtomicReferenceArray<ReferenceEntry<K, V>> atomicReferenceArray;
            int n4;
            block20: {
                block21: {
                    this.lock();
                    long l2 = this.map.ticker.read();
                    this.preWriteCleanup(l2);
                    n4 = this.count;
                    atomicReferenceArray = this.table;
                    n3 = n2 & atomicReferenceArray.length() - 1;
                    referenceEntry2 = referenceEntry3 = atomicReferenceArray.get(n3);
                    while (true) {
                        loadingValueReference = null;
                        if (referenceEntry2 == null) break;
                        K k2 = referenceEntry2.getKey();
                        if (referenceEntry2.getHash() == n2 && k2 != null && this.map.keyEquivalence.equivalent(object, k2)) {
                            object2 = referenceEntry2.getValueReference();
                            if (object2.isLoading()) {
                                n4 = 0;
                                referenceEntry = object2;
                                break block20;
                            }
                            referenceEntry = object2.get();
                            if (referenceEntry == null) {
                                this.enqueueNotification(k2, n2, referenceEntry, object2.getWeight(), RemovalCause.COLLECTED);
                            } else {
                                if (!this.map.isExpired(referenceEntry2, l2)) {
                                    this.recordLockedRead(referenceEntry2, l2);
                                    this.statsCounter.recordHits(1);
                                    return (V)referenceEntry;
                                }
                                this.enqueueNotification(k2, n2, referenceEntry, object2.getWeight(), RemovalCause.EXPIRED);
                            }
                            this.writeQueue.remove(referenceEntry2);
                            this.accessQueue.remove(referenceEntry2);
                            this.count = n4 - 1;
                            break block21;
                        }
                        referenceEntry2 = referenceEntry2.getNext();
                    }
                    object2 = null;
                }
                n4 = 1;
                referenceEntry = object2;
            }
            object2 = referenceEntry2;
            if (n4 != 0) {
                loadingValueReference = new LoadingValueReference();
                if (referenceEntry2 == null) {
                    object2 = this.newEntry(object, n2, referenceEntry3);
                    object2.setValueReference(loadingValueReference);
                    atomicReferenceArray.set(n3, (ReferenceEntry<K, V>)object2);
                } else {
                    referenceEntry2.setValueReference(loadingValueReference);
                    object2 = referenceEntry2;
                }
            }
            if (n4 == 0) return this.waitForLoadingValue((ReferenceEntry<K, V>)object2, object, (ValueReference<K, V>)((Object)referenceEntry));
            object = this.loadSync(object, n2, loadingValueReference, cacheLoader);
            // MONITOREXIT : object2
            this.statsCounter.recordMisses(1);
            return (V)object;
            finally {
                this.unlock();
                this.postWriteCleanup();
            }
        }

        ReferenceEntry<K, V> newEntry(K k2, int n2, @NullableDecl ReferenceEntry<K, V> referenceEntry) {
            return this.map.entryFactory.newEntry(this, Preconditions.checkNotNull(k2), n2, referenceEntry);
        }

        AtomicReferenceArray<ReferenceEntry<K, V>> newEntryArray(int n2) {
            return new AtomicReferenceArray<ReferenceEntry<K, V>>(n2);
        }

        void postReadCleanup() {
            if ((this.readCount.incrementAndGet() & 0x3F) == 0) {
                this.cleanUp();
            }
        }

        void postWriteCleanup() {
            this.runUnlockedCleanup();
        }

        void preWriteCleanup(long l2) {
            this.runLockedCleanup(l2);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @NullableDecl
        V put(K k2, int n2, V v2, boolean bl) {
            this.lock();
            try {
                ReferenceEntry<K, V> referenceEntry;
                ReferenceEntry<K, V> referenceEntry2;
                int n3;
                long l2 = this.map.ticker.read();
                this.preWriteCleanup(l2);
                if (this.count + 1 > this.threshold) {
                    this.expand();
                    n3 = this.count;
                }
                ValueReference<K, V> valueReference = this.table;
                n3 = n2 & ((AtomicReferenceArray)((Object)valueReference)).length() - 1;
                for (referenceEntry2 = referenceEntry = ((AtomicReferenceArray)((Object)valueReference)).get(n3); referenceEntry2 != null; referenceEntry2 = referenceEntry2.getNext()) {
                    K k3 = referenceEntry2.getKey();
                    if (referenceEntry2.getHash() != n2 || k3 == null || !this.map.keyEquivalence.equivalent(k2, k3)) continue;
                    valueReference = referenceEntry2.getValueReference();
                    referenceEntry = valueReference.get();
                    if (referenceEntry == null) {
                        ++this.modCount;
                        if (valueReference.isActive()) {
                            this.enqueueNotification(k2, n2, referenceEntry, valueReference.getWeight(), RemovalCause.COLLECTED);
                            this.setValue(referenceEntry2, k2, v2, l2);
                            n2 = this.count;
                        } else {
                            this.setValue(referenceEntry2, k2, v2, l2);
                            n2 = this.count + 1;
                        }
                        this.count = n2;
                        this.evictEntries(referenceEntry2);
                        return null;
                    }
                    if (bl) {
                        this.recordLockedRead(referenceEntry2, l2);
                        return (V)referenceEntry;
                    } else {
                        ++this.modCount;
                        this.enqueueNotification(k2, n2, referenceEntry, valueReference.getWeight(), RemovalCause.REPLACED);
                        this.setValue(referenceEntry2, k2, v2, l2);
                        this.evictEntries(referenceEntry2);
                    }
                    return (V)referenceEntry;
                }
                ++this.modCount;
                referenceEntry2 = this.newEntry(k2, n2, referenceEntry);
                this.setValue(referenceEntry2, k2, v2, l2);
                ((AtomicReferenceArray)((Object)valueReference)).set(n3, referenceEntry2);
                ++this.count;
                this.evictEntries(referenceEntry2);
                return null;
            }
            finally {
                this.unlock();
                this.postWriteCleanup();
            }
        }

        boolean reclaimKey(ReferenceEntry<K, V> referenceEntry, int n2) {
            ReferenceEntry<K, V> referenceEntry2;
            AtomicReferenceArray<ReferenceEntry<K, V>> atomicReferenceArray;
            int n3;
            this.lock();
            try {
                n3 = this.count;
                atomicReferenceArray = this.table;
                n3 = atomicReferenceArray.length() - 1 & n2;
            }
            catch (Throwable throwable) {
                this.unlock();
                this.postWriteCleanup();
                throw throwable;
            }
            for (ReferenceEntry<K, V> referenceEntry3 = referenceEntry2 = atomicReferenceArray.get(n3); referenceEntry3 != null; referenceEntry3 = referenceEntry3.getNext()) {
                if (referenceEntry3 == referenceEntry) {
                    ++this.modCount;
                    referenceEntry = this.removeValueFromChain(referenceEntry2, referenceEntry3, referenceEntry3.getKey(), n2, referenceEntry3.getValueReference().get(), referenceEntry3.getValueReference(), RemovalCause.COLLECTED);
                    n2 = this.count;
                    atomicReferenceArray.set(n3, referenceEntry);
                    this.count = n2 - 1;
                    this.unlock();
                    this.postWriteCleanup();
                    return true;
                }
                continue;
            }
            this.unlock();
            this.postWriteCleanup();
            return false;
        }

        boolean reclaimValue(K object, int n2, ValueReference<K, V> valueReference) {
            ReferenceEntry<K, V> referenceEntry;
            AtomicReferenceArray<ReferenceEntry<K, V>> atomicReferenceArray;
            int n3;
            this.lock();
            try {
                n3 = this.count;
                atomicReferenceArray = this.table;
                n3 = atomicReferenceArray.length() - 1 & n2;
            }
            catch (Throwable throwable) {
                block11: {
                    this.unlock();
                    if (this.isHeldByCurrentThread()) break block11;
                    this.postWriteCleanup();
                }
                throw throwable;
            }
            for (ReferenceEntry<K, V> referenceEntry2 = referenceEntry = atomicReferenceArray.get(n3); referenceEntry2 != null; referenceEntry2 = referenceEntry2.getNext()) {
                block9: {
                    block10: {
                        K k2 = referenceEntry2.getKey();
                        if (referenceEntry2.getHash() != n2 || k2 == null) break block9;
                        if (!this.map.keyEquivalence.equivalent(object, k2)) break block9;
                        if (referenceEntry2.getValueReference() != valueReference) break block10;
                        ++this.modCount;
                        object = this.removeValueFromChain(referenceEntry, referenceEntry2, k2, n2, valueReference.get(), valueReference, RemovalCause.COLLECTED);
                        n2 = this.count;
                        atomicReferenceArray.set(n3, (ReferenceEntry<K, V>)object);
                        this.count = n2 - 1;
                        this.unlock();
                        if (!this.isHeldByCurrentThread()) {
                            this.postWriteCleanup();
                        }
                        return true;
                    }
                    this.unlock();
                    if (!this.isHeldByCurrentThread()) {
                        this.postWriteCleanup();
                    }
                    return false;
                }
                continue;
            }
            this.unlock();
            if (!this.isHeldByCurrentThread()) {
                this.postWriteCleanup();
            }
            return false;
        }

        void recordLockedRead(ReferenceEntry<K, V> referenceEntry, long l2) {
            if (this.map.recordsAccess()) {
                referenceEntry.setAccessTime(l2);
            }
            this.accessQueue.add(referenceEntry);
        }

        void recordRead(ReferenceEntry<K, V> referenceEntry, long l2) {
            if (this.map.recordsAccess()) {
                referenceEntry.setAccessTime(l2);
            }
            this.recencyQueue.add(referenceEntry);
        }

        void recordWrite(ReferenceEntry<K, V> referenceEntry, int n2, long l2) {
            this.drainRecencyQueue();
            this.totalWeight += (long)n2;
            if (this.map.recordsAccess()) {
                referenceEntry.setAccessTime(l2);
            }
            if (this.map.recordsWrite()) {
                referenceEntry.setWriteTime(l2);
            }
            this.accessQueue.add(referenceEntry);
            this.writeQueue.add(referenceEntry);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @NullableDecl
        V refresh(K object, int n2, CacheLoader<? super K, V> cacheLoader, boolean bl) {
            LoadingValueReference<Object, V> loadingValueReference = this.insertLoadingValueReference(object, n2, bl);
            if (loadingValueReference == null) {
                return null;
            }
            if (!(object = this.loadAsync(object, n2, loadingValueReference, cacheLoader)).isDone()) return null;
            try {
                object = Uninterruptibles.getUninterruptibly((Future)object);
                return (V)object;
            }
            catch (Throwable throwable) {
                return null;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @NullableDecl
        V remove(Object object, int n2) {
            this.lock();
            try {
                ReferenceEntry<K, V> referenceEntry;
                this.preWriteCleanup(this.map.ticker.read());
                int n3 = this.count;
                AtomicReferenceArray<ReferenceEntry<K, V>> atomicReferenceArray = this.table;
                n3 = atomicReferenceArray.length() - 1 & n2;
                ReferenceEntry<K, V> referenceEntry2 = referenceEntry = atomicReferenceArray.get(n3);
                while (true) {
                    block8: {
                        block7: {
                            V v2;
                            ValueReference<K, V> valueReference;
                            K k2;
                            block10: {
                                block9: {
                                    if (referenceEntry2 == null) break block7;
                                    k2 = referenceEntry2.getKey();
                                    if (referenceEntry2.getHash() != n2 || k2 == null || !this.map.keyEquivalence.equivalent(object, k2)) break block8;
                                    valueReference = referenceEntry2.getValueReference();
                                    v2 = valueReference.get();
                                    if (v2 == null) break block9;
                                    object = RemovalCause.EXPLICIT;
                                    break block10;
                                }
                                if (!valueReference.isActive()) break block7;
                                object = RemovalCause.COLLECTED;
                            }
                            ++this.modCount;
                            object = this.removeValueFromChain(referenceEntry, referenceEntry2, k2, n2, v2, valueReference, (RemovalCause)object);
                            n2 = this.count;
                            atomicReferenceArray.set(n3, (ReferenceEntry<K, V>)object);
                            this.count = n2 - 1;
                            return v2;
                        }
                        return null;
                    }
                    referenceEntry2 = referenceEntry2.getNext();
                }
            }
            finally {
                this.unlock();
                this.postWriteCleanup();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        boolean remove(Object object, int n2, Object object2) {
            this.lock();
            try {
                ReferenceEntry<K, V> referenceEntry;
                this.preWriteCleanup(this.map.ticker.read());
                int n3 = this.count;
                AtomicReferenceArray<ReferenceEntry<K, V>> atomicReferenceArray = this.table;
                n3 = atomicReferenceArray.length();
                boolean bl = true;
                n3 = n3 - 1 & n2;
                ReferenceEntry<K, V> referenceEntry2 = referenceEntry = atomicReferenceArray.get(n3);
                while (true) {
                    if (referenceEntry2 == null) return false;
                    K k2 = referenceEntry2.getKey();
                    if (referenceEntry2.getHash() == n2 && k2 != null && this.map.keyEquivalence.equivalent(object, k2)) {
                        ValueReference<K, V> valueReference = referenceEntry2.getValueReference();
                        V v2 = valueReference.get();
                        if (this.map.valueEquivalence.equivalent(object2, v2)) {
                            object = RemovalCause.EXPLICIT;
                        } else {
                            if (v2 != null || !valueReference.isActive()) return false;
                            object = RemovalCause.COLLECTED;
                        }
                        ++this.modCount;
                        object2 = this.removeValueFromChain(referenceEntry, referenceEntry2, k2, n2, v2, valueReference, (RemovalCause)object);
                        n2 = this.count;
                        atomicReferenceArray.set(n3, (ReferenceEntry<K, V>)object2);
                        this.count = n2 - 1;
                        object2 = RemovalCause.EXPLICIT;
                        if (object == object2) {
                            return bl;
                        } else {
                            bl = false;
                        }
                        return bl;
                    }
                    referenceEntry2 = referenceEntry2.getNext();
                }
            }
            finally {
                this.unlock();
                this.postWriteCleanup();
            }
        }

        void removeCollectedEntry(ReferenceEntry<K, V> referenceEntry) {
            this.enqueueNotification(referenceEntry.getKey(), referenceEntry.getHash(), referenceEntry.getValueReference().get(), referenceEntry.getValueReference().getWeight(), RemovalCause.COLLECTED);
            this.writeQueue.remove(referenceEntry);
            this.accessQueue.remove(referenceEntry);
        }

        boolean removeEntry(ReferenceEntry<K, V> referenceEntry, int n2, RemovalCause removalCause) {
            ReferenceEntry<K, V> referenceEntry2;
            int n3 = this.count;
            AtomicReferenceArray<ReferenceEntry<K, V>> atomicReferenceArray = this.table;
            n3 = atomicReferenceArray.length() - 1 & n2;
            for (ReferenceEntry<K, V> referenceEntry3 = referenceEntry2 = atomicReferenceArray.get(n3); referenceEntry3 != null; referenceEntry3 = referenceEntry3.getNext()) {
                if (referenceEntry3 != referenceEntry) continue;
                ++this.modCount;
                referenceEntry = this.removeValueFromChain(referenceEntry2, referenceEntry3, referenceEntry3.getKey(), n2, referenceEntry3.getValueReference().get(), referenceEntry3.getValueReference(), removalCause);
                n2 = this.count;
                atomicReferenceArray.set(n3, referenceEntry);
                this.count = n2 - 1;
                return true;
            }
            return false;
        }

        @NullableDecl
        ReferenceEntry<K, V> removeEntryFromChain(ReferenceEntry<K, V> referenceEntry, ReferenceEntry<K, V> referenceEntry2) {
            int n2 = this.count;
            ReferenceEntry<K, V> referenceEntry3 = referenceEntry2.getNext();
            while (referenceEntry != referenceEntry2) {
                ReferenceEntry<K, V> referenceEntry4 = this.copyEntry(referenceEntry, referenceEntry3);
                if (referenceEntry4 != null) {
                    referenceEntry3 = referenceEntry4;
                } else {
                    this.removeCollectedEntry(referenceEntry);
                    --n2;
                }
                referenceEntry = referenceEntry.getNext();
            }
            this.count = n2;
            return referenceEntry3;
        }

        boolean removeLoadingValue(K k2, int n2, LoadingValueReference<K, V> loadingValueReference) {
            ReferenceEntry<K, V> referenceEntry;
            ReferenceEntry<K, V> referenceEntry2;
            int n3;
            AtomicReferenceArray<ReferenceEntry<K, V>> atomicReferenceArray;
            this.lock();
            try {
                atomicReferenceArray = this.table;
                n3 = atomicReferenceArray.length() - 1 & n2;
                referenceEntry = referenceEntry2 = atomicReferenceArray.get(n3);
            }
            catch (Throwable throwable) {
                this.unlock();
                this.postWriteCleanup();
                throw throwable;
            }
            while (true) {
                block8: {
                    block9: {
                        if (referenceEntry != null) {
                            block10: {
                                K k3 = referenceEntry.getKey();
                                if (referenceEntry.getHash() != n2 || k3 == null) break block8;
                                if (!this.map.keyEquivalence.equivalent(k2, k3)) break block8;
                                if (referenceEntry.getValueReference() != loadingValueReference) break block9;
                                if (loadingValueReference.isActive()) {
                                    referenceEntry.setValueReference(loadingValueReference.getOldValue());
                                    break block10;
                                }
                                atomicReferenceArray.set(n3, this.removeEntryFromChain(referenceEntry2, referenceEntry));
                            }
                            this.unlock();
                            this.postWriteCleanup();
                            return true;
                        }
                    }
                    this.unlock();
                    this.postWriteCleanup();
                    return false;
                }
                referenceEntry = referenceEntry.getNext();
                continue;
                break;
            }
        }

        @NullableDecl
        ReferenceEntry<K, V> removeValueFromChain(ReferenceEntry<K, V> referenceEntry, ReferenceEntry<K, V> referenceEntry2, @NullableDecl K k2, int n2, V v2, ValueReference<K, V> valueReference, RemovalCause removalCause) {
            this.enqueueNotification(k2, n2, v2, valueReference.getWeight(), removalCause);
            this.writeQueue.remove(referenceEntry2);
            this.accessQueue.remove(referenceEntry2);
            if (valueReference.isLoading()) {
                valueReference.notifyNewValue(null);
                return referenceEntry;
            }
            return this.removeEntryFromChain(referenceEntry, referenceEntry2);
        }

        @NullableDecl
        V replace(K object, int n2, V v2) {
            V v3;
            ReferenceEntry<K, V> referenceEntry;
            ReferenceEntry<K, V> referenceEntry2;
            int n3;
            AtomicReferenceArray<ReferenceEntry<K, V>> atomicReferenceArray;
            long l2;
            this.lock();
            try {
                l2 = this.map.ticker.read();
                this.preWriteCleanup(l2);
                atomicReferenceArray = this.table;
                n3 = n2 & atomicReferenceArray.length() - 1;
                referenceEntry = referenceEntry2 = atomicReferenceArray.get(n3);
            }
            catch (Throwable throwable) {
                this.unlock();
                this.postWriteCleanup();
                throw throwable;
            }
            while (true) {
                ValueReference<K, V> valueReference;
                block10: {
                    block11: {
                        if (referenceEntry != null) {
                            K k2 = referenceEntry.getKey();
                            if (referenceEntry.getHash() != n2 || k2 == null) break block9;
                            if (!this.map.keyEquivalence.equivalent(object, k2)) break block9;
                            valueReference = referenceEntry.getValueReference();
                            v3 = valueReference.get();
                            if (v3 != null) break block10;
                            if (!valueReference.isActive()) break block11;
                            int n4 = this.count;
                            ++this.modCount;
                            object = this.removeValueFromChain(referenceEntry2, referenceEntry, k2, n2, v3, valueReference, RemovalCause.COLLECTED);
                            n2 = this.count;
                            atomicReferenceArray.set(n3, (ReferenceEntry<K, V>)object);
                            this.count = n2 - 1;
                        }
                    }
                    this.unlock();
                    this.postWriteCleanup();
                    return null;
                }
                ++this.modCount;
                this.enqueueNotification(object, n2, v3, valueReference.getWeight(), RemovalCause.REPLACED);
                this.setValue(referenceEntry, object, v2, l2);
                this.evictEntries(referenceEntry);
                break;
            }
            {
                block9: {
                    this.unlock();
                    this.postWriteCleanup();
                    return v3;
                }
                referenceEntry = referenceEntry.getNext();
                continue;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        boolean replace(K object, int n2, V v2, V v3) {
            this.lock();
            try {
                ReferenceEntry<K, V> referenceEntry;
                int n3;
                long l2 = this.map.ticker.read();
                this.preWriteCleanup(l2);
                AtomicReferenceArray<ReferenceEntry<K, V>> atomicReferenceArray = this.table;
                int n4 = n3 & atomicReferenceArray.length() - 1;
                ReferenceEntry<K, V> referenceEntry2 = referenceEntry = atomicReferenceArray.get(n4);
                while (true) {
                    if (referenceEntry2 == null) return false;
                    K k2 = referenceEntry2.getKey();
                    if (referenceEntry2.getHash() == n3 && k2 != null && this.map.keyEquivalence.equivalent(object, k2)) {
                        void var3_5;
                        ValueReference<K, V> valueReference = referenceEntry2.getValueReference();
                        V v4 = valueReference.get();
                        if (v4 == null) {
                            if (!valueReference.isActive()) return false;
                            int n5 = this.count;
                            ++this.modCount;
                            ReferenceEntry<K, V> referenceEntry3 = this.removeValueFromChain(referenceEntry, referenceEntry2, k2, n3, v4, valueReference, RemovalCause.COLLECTED);
                            n3 = this.count;
                            atomicReferenceArray.set(n4, referenceEntry3);
                            this.count = n3 - 1;
                            return false;
                        }
                        if (this.map.valueEquivalence.equivalent(var3_5, v4)) {
                            void var4_6;
                            ++this.modCount;
                            this.enqueueNotification(object, n3, v4, valueReference.getWeight(), RemovalCause.REPLACED);
                            this.setValue(referenceEntry2, object, var4_6, l2);
                            this.evictEntries(referenceEntry2);
                            return true;
                        }
                        this.recordLockedRead(referenceEntry2, l2);
                        return false;
                    }
                    referenceEntry2 = referenceEntry2.getNext();
                }
            }
            finally {
                this.unlock();
                this.postWriteCleanup();
            }
        }

        void runLockedCleanup(long l2) {
            if (this.tryLock()) {
                try {
                    this.drainReferenceQueues();
                    this.expireEntries(l2);
                    this.readCount.set(0);
                }
                finally {
                    this.unlock();
                }
            }
        }

        void runUnlockedCleanup() {
            if (!this.isHeldByCurrentThread()) {
                this.map.processPendingNotifications();
            }
        }

        V scheduleRefresh(ReferenceEntry<K, V> referenceEntry, K k2, int n2, V v2, long l2, CacheLoader<? super K, V> cacheLoader) {
            if (this.map.refreshes() && l2 - referenceEntry.getWriteTime() > this.map.refreshNanos && !referenceEntry.getValueReference().isLoading() && (referenceEntry = this.refresh(k2, n2, cacheLoader, true)) != null) {
                return (V)referenceEntry;
            }
            return v2;
        }

        void setValue(ReferenceEntry<K, V> referenceEntry, K k2, V v2, long l2) {
            ValueReference<K, V> valueReference = referenceEntry.getValueReference();
            int n2 = this.map.weigher.weigh(k2, v2);
            boolean bl = n2 >= 0;
            Preconditions.checkState(bl, "Weights must be non-negative");
            referenceEntry.setValueReference(this.map.valueStrength.referenceValue(this, referenceEntry, v2, n2));
            this.recordWrite(referenceEntry, n2, l2);
            valueReference.notifyNewValue(v2);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        boolean storeLoadedValue(K k2, int n2, LoadingValueReference<K, V> referenceEntry, V v2) {
            this.lock();
            try {
                int n3;
                long l2 = this.map.ticker.read();
                this.preWriteCleanup(l2);
                int n4 = n3 = this.count + 1;
                if (n3 > this.threshold) {
                    this.expand();
                    n4 = this.count + 1;
                }
                AtomicReferenceArray<ReferenceEntry<K, V>> atomicReferenceArray = this.table;
                n3 = n2 & atomicReferenceArray.length() - 1;
                Object object = atomicReferenceArray.get(n3);
                for (ReferenceEntry<K, V> referenceEntry2 = object; referenceEntry2 != null; referenceEntry2 = referenceEntry2.getNext()) {
                    K k3 = referenceEntry2.getKey();
                    if (referenceEntry2.getHash() != n2 || k3 == null || !this.map.keyEquivalence.equivalent(k2, k3)) continue;
                    object = referenceEntry2.getValueReference();
                    atomicReferenceArray = object.get();
                    if (referenceEntry != object && (atomicReferenceArray != null || object == UNSET)) {
                        this.enqueueNotification(k2, n2, v2, 0, RemovalCause.REPLACED);
                        return false;
                    }
                    ++this.modCount;
                    n3 = n4;
                    if (((LoadingValueReference)((Object)referenceEntry)).isActive()) {
                        object = atomicReferenceArray == null ? RemovalCause.COLLECTED : RemovalCause.REPLACED;
                        this.enqueueNotification(k2, n2, atomicReferenceArray, ((LoadingValueReference)((Object)referenceEntry)).getWeight(), (RemovalCause)object);
                        n3 = n4 - 1;
                    }
                    this.setValue(referenceEntry2, k2, v2, l2);
                    this.count = n3;
                    this.evictEntries(referenceEntry2);
                    return true;
                }
                ++this.modCount;
                referenceEntry = this.newEntry(k2, n2, (ReferenceEntry<K, V>)object);
                this.setValue(referenceEntry, k2, v2, l2);
                atomicReferenceArray.set(n3, referenceEntry);
                this.count = n4;
                this.evictEntries(referenceEntry);
                return true;
            }
            finally {
                this.unlock();
                this.postWriteCleanup();
            }
        }

        void tryDrainReferenceQueues() {
            if (this.tryLock()) {
                try {
                    this.drainReferenceQueues();
                }
                finally {
                    this.unlock();
                }
            }
        }

        void tryExpireEntries(long l2) {
            if (this.tryLock()) {
                try {
                    this.expireEntries(l2);
                }
                finally {
                    this.unlock();
                }
            }
        }

        V waitForLoadingValue(ReferenceEntry<K, V> object, K k2, ValueReference<K, V> invalidCacheLoadException) throws ExecutionException {
            if (invalidCacheLoadException.isLoading()) {
                Preconditions.checkState(Thread.holdsLock(object) ^ true, "Recursive load of: %s", k2);
                try {
                    invalidCacheLoadException = invalidCacheLoadException.waitForValue();
                    if (invalidCacheLoadException != null) {
                        this.recordRead((ReferenceEntry<K, V>)object, this.map.ticker.read());
                        return (V)invalidCacheLoadException;
                    }
                    object = new StringBuilder();
                    ((StringBuilder)object).append("CacheLoader returned null for key ");
                    ((StringBuilder)object).append(k2);
                    ((StringBuilder)object).append(".");
                    invalidCacheLoadException = new CacheLoader.InvalidCacheLoadException(((StringBuilder)object).toString());
                    throw invalidCacheLoadException;
                }
                finally {
                    this.statsCounter.recordMisses(1);
                }
            }
            throw new AssertionError();
        }
    }

    static class SoftValueReference<K, V>
    extends SoftReference<V>
    implements ValueReference<K, V> {
        final ReferenceEntry<K, V> entry;

        SoftValueReference(ReferenceQueue<V> referenceQueue, V v2, ReferenceEntry<K, V> referenceEntry) {
            super(v2, referenceQueue);
            this.entry = referenceEntry;
        }

        @Override
        public ValueReference<K, V> copyFor(ReferenceQueue<V> referenceQueue, V v2, ReferenceEntry<K, V> referenceEntry) {
            return new SoftValueReference<K, V>(referenceQueue, v2, referenceEntry);
        }

        @Override
        public ReferenceEntry<K, V> getEntry() {
            return this.entry;
        }

        @Override
        public int getWeight() {
            return 1;
        }

        @Override
        public boolean isActive() {
            return true;
        }

        @Override
        public boolean isLoading() {
            return false;
        }

        @Override
        public void notifyNewValue(V v2) {
        }

        @Override
        public V waitForValue() {
            return (V)this.get();
        }
    }

    static enum Strength {
        STRONG{

            @Override
            Equivalence<Object> defaultEquivalence() {
                return Equivalence.equals();
            }

            @Override
            <K, V> ValueReference<K, V> referenceValue(Segment<K, V> strongValueReference, ReferenceEntry<K, V> referenceEntry, V v2, int n2) {
                strongValueReference = n2 == 1 ? new StrongValueReference(v2) : new WeightedStrongValueReference(v2, n2);
                return strongValueReference;
            }
        }
        ,
        SOFT{

            @Override
            Equivalence<Object> defaultEquivalence() {
                return Equivalence.identity();
            }

            @Override
            <K, V> ValueReference<K, V> referenceValue(Segment<K, V> softValueReference, ReferenceEntry<K, V> referenceEntry, V v2, int n2) {
                softValueReference = n2 == 1 ? new SoftValueReference(((Segment)((Object)softValueReference)).valueReferenceQueue, v2, referenceEntry) : new WeightedSoftValueReference(((Segment)((Object)softValueReference)).valueReferenceQueue, v2, referenceEntry, n2);
                return softValueReference;
            }
        }
        ,
        WEAK{

            @Override
            Equivalence<Object> defaultEquivalence() {
                return Equivalence.identity();
            }

            @Override
            <K, V> ValueReference<K, V> referenceValue(Segment<K, V> weakValueReference, ReferenceEntry<K, V> referenceEntry, V v2, int n2) {
                weakValueReference = n2 == 1 ? new WeakValueReference(((Segment)((Object)weakValueReference)).valueReferenceQueue, v2, referenceEntry) : new WeightedWeakValueReference(((Segment)((Object)weakValueReference)).valueReferenceQueue, v2, referenceEntry, n2);
                return weakValueReference;
            }
        };


        abstract Equivalence<Object> defaultEquivalence();

        abstract <K, V> ValueReference<K, V> referenceValue(Segment<K, V> var1, ReferenceEntry<K, V> var2, V var3, int var4);
    }

    static final class StrongAccessEntry<K, V>
    extends StrongEntry<K, V> {
        volatile long accessTime = Long.MAX_VALUE;
        ReferenceEntry<K, V> nextAccess = LocalCache.nullEntry();
        ReferenceEntry<K, V> previousAccess = LocalCache.nullEntry();

        StrongAccessEntry(K k2, int n2, @NullableDecl ReferenceEntry<K, V> referenceEntry) {
            super(k2, n2, referenceEntry);
        }

        @Override
        public long getAccessTime() {
            return this.accessTime;
        }

        @Override
        public ReferenceEntry<K, V> getNextInAccessQueue() {
            return this.nextAccess;
        }

        @Override
        public ReferenceEntry<K, V> getPreviousInAccessQueue() {
            return this.previousAccess;
        }

        @Override
        public void setAccessTime(long l2) {
            this.accessTime = l2;
        }

        @Override
        public void setNextInAccessQueue(ReferenceEntry<K, V> referenceEntry) {
            this.nextAccess = referenceEntry;
        }

        @Override
        public void setPreviousInAccessQueue(ReferenceEntry<K, V> referenceEntry) {
            this.previousAccess = referenceEntry;
        }
    }

    static final class StrongAccessWriteEntry<K, V>
    extends StrongEntry<K, V> {
        volatile long accessTime = Long.MAX_VALUE;
        ReferenceEntry<K, V> nextAccess = LocalCache.nullEntry();
        ReferenceEntry<K, V> nextWrite;
        ReferenceEntry<K, V> previousAccess = LocalCache.nullEntry();
        ReferenceEntry<K, V> previousWrite;
        volatile long writeTime = Long.MAX_VALUE;

        StrongAccessWriteEntry(K k2, int n2, @NullableDecl ReferenceEntry<K, V> referenceEntry) {
            super(k2, n2, referenceEntry);
            this.nextWrite = LocalCache.nullEntry();
            this.previousWrite = LocalCache.nullEntry();
        }

        @Override
        public long getAccessTime() {
            return this.accessTime;
        }

        @Override
        public ReferenceEntry<K, V> getNextInAccessQueue() {
            return this.nextAccess;
        }

        @Override
        public ReferenceEntry<K, V> getNextInWriteQueue() {
            return this.nextWrite;
        }

        @Override
        public ReferenceEntry<K, V> getPreviousInAccessQueue() {
            return this.previousAccess;
        }

        @Override
        public ReferenceEntry<K, V> getPreviousInWriteQueue() {
            return this.previousWrite;
        }

        @Override
        public long getWriteTime() {
            return this.writeTime;
        }

        @Override
        public void setAccessTime(long l2) {
            this.accessTime = l2;
        }

        @Override
        public void setNextInAccessQueue(ReferenceEntry<K, V> referenceEntry) {
            this.nextAccess = referenceEntry;
        }

        @Override
        public void setNextInWriteQueue(ReferenceEntry<K, V> referenceEntry) {
            this.nextWrite = referenceEntry;
        }

        @Override
        public void setPreviousInAccessQueue(ReferenceEntry<K, V> referenceEntry) {
            this.previousAccess = referenceEntry;
        }

        @Override
        public void setPreviousInWriteQueue(ReferenceEntry<K, V> referenceEntry) {
            this.previousWrite = referenceEntry;
        }

        @Override
        public void setWriteTime(long l2) {
            this.writeTime = l2;
        }
    }

    static class StrongEntry<K, V>
    extends AbstractReferenceEntry<K, V> {
        final int hash;
        final K key;
        @NullableDecl
        final ReferenceEntry<K, V> next;
        volatile ValueReference<K, V> valueReference = LocalCache.unset();

        StrongEntry(K k2, int n2, @NullableDecl ReferenceEntry<K, V> referenceEntry) {
            this.key = k2;
            this.hash = n2;
            this.next = referenceEntry;
        }

        @Override
        public int getHash() {
            return this.hash;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public ReferenceEntry<K, V> getNext() {
            return this.next;
        }

        @Override
        public ValueReference<K, V> getValueReference() {
            return this.valueReference;
        }

        @Override
        public void setValueReference(ValueReference<K, V> valueReference) {
            this.valueReference = valueReference;
        }
    }

    static class StrongValueReference<K, V>
    implements ValueReference<K, V> {
        final V referent;

        StrongValueReference(V v2) {
            this.referent = v2;
        }

        @Override
        public ValueReference<K, V> copyFor(ReferenceQueue<V> referenceQueue, V v2, ReferenceEntry<K, V> referenceEntry) {
            return this;
        }

        @Override
        public V get() {
            return this.referent;
        }

        @Override
        public ReferenceEntry<K, V> getEntry() {
            return null;
        }

        @Override
        public int getWeight() {
            return 1;
        }

        @Override
        public boolean isActive() {
            return true;
        }

        @Override
        public boolean isLoading() {
            return false;
        }

        @Override
        public void notifyNewValue(V v2) {
        }

        @Override
        public V waitForValue() {
            return this.get();
        }
    }

    static final class StrongWriteEntry<K, V>
    extends StrongEntry<K, V> {
        ReferenceEntry<K, V> nextWrite;
        ReferenceEntry<K, V> previousWrite;
        volatile long writeTime = Long.MAX_VALUE;

        StrongWriteEntry(K k2, int n2, @NullableDecl ReferenceEntry<K, V> referenceEntry) {
            super(k2, n2, referenceEntry);
            this.nextWrite = LocalCache.nullEntry();
            this.previousWrite = LocalCache.nullEntry();
        }

        @Override
        public ReferenceEntry<K, V> getNextInWriteQueue() {
            return this.nextWrite;
        }

        @Override
        public ReferenceEntry<K, V> getPreviousInWriteQueue() {
            return this.previousWrite;
        }

        @Override
        public long getWriteTime() {
            return this.writeTime;
        }

        @Override
        public void setNextInWriteQueue(ReferenceEntry<K, V> referenceEntry) {
            this.nextWrite = referenceEntry;
        }

        @Override
        public void setPreviousInWriteQueue(ReferenceEntry<K, V> referenceEntry) {
            this.previousWrite = referenceEntry;
        }

        @Override
        public void setWriteTime(long l2) {
            this.writeTime = l2;
        }
    }

    final class ValueIterator
    extends HashIterator<V> {
        ValueIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().getValue();
        }
    }

    static interface ValueReference<K, V> {
        public ValueReference<K, V> copyFor(ReferenceQueue<V> var1, @NullableDecl V var2, ReferenceEntry<K, V> var3);

        @NullableDecl
        public V get();

        @NullableDecl
        public ReferenceEntry<K, V> getEntry();

        public int getWeight();

        public boolean isActive();

        public boolean isLoading();

        public void notifyNewValue(@NullableDecl V var1);

        public V waitForValue() throws ExecutionException;
    }

    final class Values
    extends AbstractCollection<V> {
        private final ConcurrentMap<?, ?> map;

        Values(ConcurrentMap<?, ?> concurrentMap) {
            this.map = concurrentMap;
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public boolean contains(Object object) {
            return this.map.containsValue(object);
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public Object[] toArray() {
            return LocalCache.toArrayList(this).toArray();
        }

        @Override
        public <E> E[] toArray(E[] EArray) {
            return LocalCache.toArrayList(this).toArray(EArray);
        }
    }

    static final class WeakAccessEntry<K, V>
    extends WeakEntry<K, V> {
        volatile long accessTime = Long.MAX_VALUE;
        ReferenceEntry<K, V> nextAccess = LocalCache.nullEntry();
        ReferenceEntry<K, V> previousAccess = LocalCache.nullEntry();

        WeakAccessEntry(ReferenceQueue<K> referenceQueue, K k2, int n2, @NullableDecl ReferenceEntry<K, V> referenceEntry) {
            super(referenceQueue, k2, n2, referenceEntry);
        }

        @Override
        public long getAccessTime() {
            return this.accessTime;
        }

        @Override
        public ReferenceEntry<K, V> getNextInAccessQueue() {
            return this.nextAccess;
        }

        @Override
        public ReferenceEntry<K, V> getPreviousInAccessQueue() {
            return this.previousAccess;
        }

        @Override
        public void setAccessTime(long l2) {
            this.accessTime = l2;
        }

        @Override
        public void setNextInAccessQueue(ReferenceEntry<K, V> referenceEntry) {
            this.nextAccess = referenceEntry;
        }

        @Override
        public void setPreviousInAccessQueue(ReferenceEntry<K, V> referenceEntry) {
            this.previousAccess = referenceEntry;
        }
    }

    static final class WeakAccessWriteEntry<K, V>
    extends WeakEntry<K, V> {
        volatile long accessTime = Long.MAX_VALUE;
        ReferenceEntry<K, V> nextAccess = LocalCache.nullEntry();
        ReferenceEntry<K, V> nextWrite;
        ReferenceEntry<K, V> previousAccess = LocalCache.nullEntry();
        ReferenceEntry<K, V> previousWrite;
        volatile long writeTime = Long.MAX_VALUE;

        WeakAccessWriteEntry(ReferenceQueue<K> referenceQueue, K k2, int n2, @NullableDecl ReferenceEntry<K, V> referenceEntry) {
            super(referenceQueue, k2, n2, referenceEntry);
            this.nextWrite = LocalCache.nullEntry();
            this.previousWrite = LocalCache.nullEntry();
        }

        @Override
        public long getAccessTime() {
            return this.accessTime;
        }

        @Override
        public ReferenceEntry<K, V> getNextInAccessQueue() {
            return this.nextAccess;
        }

        @Override
        public ReferenceEntry<K, V> getNextInWriteQueue() {
            return this.nextWrite;
        }

        @Override
        public ReferenceEntry<K, V> getPreviousInAccessQueue() {
            return this.previousAccess;
        }

        @Override
        public ReferenceEntry<K, V> getPreviousInWriteQueue() {
            return this.previousWrite;
        }

        @Override
        public long getWriteTime() {
            return this.writeTime;
        }

        @Override
        public void setAccessTime(long l2) {
            this.accessTime = l2;
        }

        @Override
        public void setNextInAccessQueue(ReferenceEntry<K, V> referenceEntry) {
            this.nextAccess = referenceEntry;
        }

        @Override
        public void setNextInWriteQueue(ReferenceEntry<K, V> referenceEntry) {
            this.nextWrite = referenceEntry;
        }

        @Override
        public void setPreviousInAccessQueue(ReferenceEntry<K, V> referenceEntry) {
            this.previousAccess = referenceEntry;
        }

        @Override
        public void setPreviousInWriteQueue(ReferenceEntry<K, V> referenceEntry) {
            this.previousWrite = referenceEntry;
        }

        @Override
        public void setWriteTime(long l2) {
            this.writeTime = l2;
        }
    }

    static class WeakEntry<K, V>
    extends WeakReference<K>
    implements ReferenceEntry<K, V> {
        final int hash;
        @NullableDecl
        final ReferenceEntry<K, V> next;
        volatile ValueReference<K, V> valueReference = LocalCache.unset();

        WeakEntry(ReferenceQueue<K> referenceQueue, K k2, int n2, @NullableDecl ReferenceEntry<K, V> referenceEntry) {
            super(k2, referenceQueue);
            this.hash = n2;
            this.next = referenceEntry;
        }

        @Override
        public long getAccessTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getHash() {
            return this.hash;
        }

        @Override
        public K getKey() {
            return (K)this.get();
        }

        @Override
        public ReferenceEntry<K, V> getNext() {
            return this.next;
        }

        @Override
        public ReferenceEntry<K, V> getNextInAccessQueue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getNextInWriteQueue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getPreviousInAccessQueue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getPreviousInWriteQueue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ValueReference<K, V> getValueReference() {
            return this.valueReference;
        }

        @Override
        public long getWriteTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setAccessTime(long l2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setNextInAccessQueue(ReferenceEntry<K, V> referenceEntry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setNextInWriteQueue(ReferenceEntry<K, V> referenceEntry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPreviousInAccessQueue(ReferenceEntry<K, V> referenceEntry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPreviousInWriteQueue(ReferenceEntry<K, V> referenceEntry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setValueReference(ValueReference<K, V> valueReference) {
            this.valueReference = valueReference;
        }

        @Override
        public void setWriteTime(long l2) {
            throw new UnsupportedOperationException();
        }
    }

    static class WeakValueReference<K, V>
    extends WeakReference<V>
    implements ValueReference<K, V> {
        final ReferenceEntry<K, V> entry;

        WeakValueReference(ReferenceQueue<V> referenceQueue, V v2, ReferenceEntry<K, V> referenceEntry) {
            super(v2, referenceQueue);
            this.entry = referenceEntry;
        }

        @Override
        public ValueReference<K, V> copyFor(ReferenceQueue<V> referenceQueue, V v2, ReferenceEntry<K, V> referenceEntry) {
            return new WeakValueReference<K, V>(referenceQueue, v2, referenceEntry);
        }

        @Override
        public ReferenceEntry<K, V> getEntry() {
            return this.entry;
        }

        @Override
        public int getWeight() {
            return 1;
        }

        @Override
        public boolean isActive() {
            return true;
        }

        @Override
        public boolean isLoading() {
            return false;
        }

        @Override
        public void notifyNewValue(V v2) {
        }

        @Override
        public V waitForValue() {
            return (V)this.get();
        }
    }

    static final class WeakWriteEntry<K, V>
    extends WeakEntry<K, V> {
        ReferenceEntry<K, V> nextWrite;
        ReferenceEntry<K, V> previousWrite;
        volatile long writeTime = Long.MAX_VALUE;

        WeakWriteEntry(ReferenceQueue<K> referenceQueue, K k2, int n2, @NullableDecl ReferenceEntry<K, V> referenceEntry) {
            super(referenceQueue, k2, n2, referenceEntry);
            this.nextWrite = LocalCache.nullEntry();
            this.previousWrite = LocalCache.nullEntry();
        }

        @Override
        public ReferenceEntry<K, V> getNextInWriteQueue() {
            return this.nextWrite;
        }

        @Override
        public ReferenceEntry<K, V> getPreviousInWriteQueue() {
            return this.previousWrite;
        }

        @Override
        public long getWriteTime() {
            return this.writeTime;
        }

        @Override
        public void setNextInWriteQueue(ReferenceEntry<K, V> referenceEntry) {
            this.nextWrite = referenceEntry;
        }

        @Override
        public void setPreviousInWriteQueue(ReferenceEntry<K, V> referenceEntry) {
            this.previousWrite = referenceEntry;
        }

        @Override
        public void setWriteTime(long l2) {
            this.writeTime = l2;
        }
    }

    static final class WeightedSoftValueReference<K, V>
    extends SoftValueReference<K, V> {
        final int weight;

        WeightedSoftValueReference(ReferenceQueue<V> referenceQueue, V v2, ReferenceEntry<K, V> referenceEntry, int n2) {
            super(referenceQueue, v2, referenceEntry);
            this.weight = n2;
        }

        @Override
        public ValueReference<K, V> copyFor(ReferenceQueue<V> referenceQueue, V v2, ReferenceEntry<K, V> referenceEntry) {
            return new WeightedSoftValueReference<K, V>(referenceQueue, v2, referenceEntry, this.weight);
        }

        @Override
        public int getWeight() {
            return this.weight;
        }
    }

    static final class WeightedStrongValueReference<K, V>
    extends StrongValueReference<K, V> {
        final int weight;

        WeightedStrongValueReference(V v2, int n2) {
            super(v2);
            this.weight = n2;
        }

        @Override
        public int getWeight() {
            return this.weight;
        }
    }

    static final class WeightedWeakValueReference<K, V>
    extends WeakValueReference<K, V> {
        final int weight;

        WeightedWeakValueReference(ReferenceQueue<V> referenceQueue, V v2, ReferenceEntry<K, V> referenceEntry, int n2) {
            super(referenceQueue, v2, referenceEntry);
            this.weight = n2;
        }

        @Override
        public ValueReference<K, V> copyFor(ReferenceQueue<V> referenceQueue, V v2, ReferenceEntry<K, V> referenceEntry) {
            return new WeightedWeakValueReference<K, V>(referenceQueue, v2, referenceEntry, this.weight);
        }

        @Override
        public int getWeight() {
            return this.weight;
        }
    }

    static final class WriteQueue<K, V>
    extends AbstractQueue<ReferenceEntry<K, V>> {
        final ReferenceEntry<K, V> head = new AbstractReferenceEntry<K, V>(){
            ReferenceEntry<K, V> nextWrite = this;
            ReferenceEntry<K, V> previousWrite = this;

            @Override
            public ReferenceEntry<K, V> getNextInWriteQueue() {
                return this.nextWrite;
            }

            @Override
            public ReferenceEntry<K, V> getPreviousInWriteQueue() {
                return this.previousWrite;
            }

            @Override
            public long getWriteTime() {
                return Long.MAX_VALUE;
            }

            @Override
            public void setNextInWriteQueue(ReferenceEntry<K, V> referenceEntry) {
                this.nextWrite = referenceEntry;
            }

            @Override
            public void setPreviousInWriteQueue(ReferenceEntry<K, V> referenceEntry) {
                this.previousWrite = referenceEntry;
            }

            @Override
            public void setWriteTime(long l2) {
            }
        };

        WriteQueue() {
        }

        @Override
        public void clear() {
            ReferenceEntry<K, V> referenceEntry;
            ReferenceEntry<K, V> referenceEntry2 = this.head.getNextInWriteQueue();
            while (referenceEntry2 != (referenceEntry = this.head)) {
                referenceEntry = referenceEntry2.getNextInWriteQueue();
                LocalCache.nullifyWriteOrder(referenceEntry2);
                referenceEntry2 = referenceEntry;
            }
            referenceEntry.setNextInWriteQueue(referenceEntry);
            referenceEntry2 = this.head;
            referenceEntry2.setPreviousInWriteQueue(referenceEntry2);
        }

        @Override
        public boolean contains(Object object) {
            boolean bl = ((ReferenceEntry)object).getNextInWriteQueue() != NullEntry.INSTANCE;
            return bl;
        }

        @Override
        public boolean isEmpty() {
            boolean bl = this.head.getNextInWriteQueue() == this.head;
            return bl;
        }

        @Override
        public Iterator<ReferenceEntry<K, V>> iterator() {
            return new AbstractSequentialIterator<ReferenceEntry<K, V>>((ReferenceEntry)this.peek()){

                @Override
                protected ReferenceEntry<K, V> computeNext(ReferenceEntry<K, V> referenceEntry) {
                    ReferenceEntry referenceEntry2 = referenceEntry.getNextInWriteQueue();
                    referenceEntry = referenceEntry2;
                    if (referenceEntry2 == WriteQueue.this.head) {
                        referenceEntry = null;
                    }
                    return referenceEntry;
                }
            };
        }

        @Override
        public boolean offer(ReferenceEntry<K, V> referenceEntry) {
            LocalCache.connectWriteOrder(referenceEntry.getPreviousInWriteQueue(), referenceEntry.getNextInWriteQueue());
            LocalCache.connectWriteOrder(this.head.getPreviousInWriteQueue(), referenceEntry);
            LocalCache.connectWriteOrder(referenceEntry, this.head);
            return true;
        }

        @Override
        public ReferenceEntry<K, V> peek() {
            ReferenceEntry<K, V> referenceEntry;
            ReferenceEntry<K, V> referenceEntry2 = referenceEntry = this.head.getNextInWriteQueue();
            if (referenceEntry == this.head) {
                referenceEntry2 = null;
            }
            return referenceEntry2;
        }

        @Override
        public ReferenceEntry<K, V> poll() {
            ReferenceEntry<K, V> referenceEntry = this.head.getNextInWriteQueue();
            if (referenceEntry == this.head) {
                return null;
            }
            this.remove(referenceEntry);
            return referenceEntry;
        }

        @Override
        public boolean remove(Object referenceEntry) {
            ReferenceEntry referenceEntry2 = referenceEntry;
            referenceEntry = referenceEntry2.getPreviousInWriteQueue();
            ReferenceEntry referenceEntry3 = referenceEntry2.getNextInWriteQueue();
            LocalCache.connectWriteOrder(referenceEntry, referenceEntry3);
            LocalCache.nullifyWriteOrder(referenceEntry2);
            boolean bl = referenceEntry3 != NullEntry.INSTANCE;
            return bl;
        }

        @Override
        public int size() {
            int n2 = 0;
            for (ReferenceEntry<K, V> referenceEntry = this.head.getNextInWriteQueue(); referenceEntry != this.head; referenceEntry = referenceEntry.getNextInWriteQueue()) {
                ++n2;
            }
            return n2;
        }
    }

    final class WriteThroughEntry
    implements Map.Entry<K, V> {
        final K key;
        V value;

        WriteThroughEntry(K k2, V v2) {
            this.key = k2;
            this.value = v2;
        }

        @Override
        public boolean equals(@NullableDecl Object object) {
            boolean bl;
            boolean bl2 = object instanceof Map.Entry;
            boolean bl3 = bl = false;
            if (bl2) {
                object = (Map.Entry)object;
                bl3 = bl;
                if (this.key.equals(object.getKey())) {
                    bl3 = bl;
                    if (this.value.equals(object.getValue())) {
                        bl3 = true;
                    }
                }
            }
            return bl3;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public int hashCode() {
            return this.key.hashCode() ^ this.value.hashCode();
        }

        @Override
        public V setValue(V v2) {
            Object v3 = LocalCache.this.put(this.key, v2);
            this.value = v2;
            return v3;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.getKey());
            stringBuilder.append("=");
            stringBuilder.append(this.getValue());
            return stringBuilder.toString();
        }
    }
}

