/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.cache;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class CacheStats {
    private final long evictionCount;
    private final long hitCount;
    private final long loadExceptionCount;
    private final long loadSuccessCount;
    private final long missCount;
    private final long totalLoadTime;

    public CacheStats(long l2, long l3, long l4, long l5, long l6, long l7) {
        boolean bl = true;
        boolean bl2 = l2 >= 0L;
        Preconditions.checkArgument(bl2);
        bl2 = l3 >= 0L;
        Preconditions.checkArgument(bl2);
        bl2 = l4 >= 0L;
        Preconditions.checkArgument(bl2);
        bl2 = l5 >= 0L;
        Preconditions.checkArgument(bl2);
        bl2 = l6 >= 0L;
        Preconditions.checkArgument(bl2);
        bl2 = l7 >= 0L ? bl : false;
        Preconditions.checkArgument(bl2);
        this.hitCount = l2;
        this.missCount = l3;
        this.loadSuccessCount = l4;
        this.loadExceptionCount = l5;
        this.totalLoadTime = l6;
        this.evictionCount = l7;
    }

    public double averageLoadPenalty() {
        double d2;
        long l2 = this.loadSuccessCount + this.loadExceptionCount;
        if (l2 == 0L) {
            d2 = 0.0;
        } else {
            d2 = this.totalLoadTime;
            double d3 = l2;
            Double.isNaN(d2);
            Double.isNaN(d3);
            d2 /= d3;
        }
        return d2;
    }

    public boolean equals(@NullableDecl Object object) {
        boolean bl;
        boolean bl2 = object instanceof CacheStats;
        boolean bl3 = bl = false;
        if (bl2) {
            object = (CacheStats)object;
            bl3 = bl;
            if (this.hitCount == ((CacheStats)object).hitCount) {
                bl3 = bl;
                if (this.missCount == ((CacheStats)object).missCount) {
                    bl3 = bl;
                    if (this.loadSuccessCount == ((CacheStats)object).loadSuccessCount) {
                        bl3 = bl;
                        if (this.loadExceptionCount == ((CacheStats)object).loadExceptionCount) {
                            bl3 = bl;
                            if (this.totalLoadTime == ((CacheStats)object).totalLoadTime) {
                                bl3 = bl;
                                if (this.evictionCount == ((CacheStats)object).evictionCount) {
                                    bl3 = true;
                                }
                            }
                        }
                    }
                }
            }
        }
        return bl3;
    }

    public long evictionCount() {
        return this.evictionCount;
    }

    public int hashCode() {
        return Objects.hashCode(this.hitCount, this.missCount, this.loadSuccessCount, this.loadExceptionCount, this.totalLoadTime, this.evictionCount);
    }

    public long hitCount() {
        return this.hitCount;
    }

    public double hitRate() {
        double d2;
        long l2 = this.requestCount();
        if (l2 == 0L) {
            d2 = 1.0;
        } else {
            double d3 = this.hitCount;
            d2 = l2;
            Double.isNaN(d3);
            Double.isNaN(d2);
            d2 = d3 / d2;
        }
        return d2;
    }

    public long loadCount() {
        return this.loadSuccessCount + this.loadExceptionCount;
    }

    public long loadExceptionCount() {
        return this.loadExceptionCount;
    }

    public double loadExceptionRate() {
        double d2;
        long l2 = this.loadSuccessCount;
        long l3 = this.loadExceptionCount;
        if ((l2 += l3) == 0L) {
            d2 = 0.0;
        } else {
            double d3 = l3;
            d2 = l2;
            Double.isNaN(d3);
            Double.isNaN(d2);
            d2 = d3 / d2;
        }
        return d2;
    }

    public long loadSuccessCount() {
        return this.loadSuccessCount;
    }

    public CacheStats minus(CacheStats cacheStats) {
        return new CacheStats(Math.max(0L, this.hitCount - cacheStats.hitCount), Math.max(0L, this.missCount - cacheStats.missCount), Math.max(0L, this.loadSuccessCount - cacheStats.loadSuccessCount), Math.max(0L, this.loadExceptionCount - cacheStats.loadExceptionCount), Math.max(0L, this.totalLoadTime - cacheStats.totalLoadTime), Math.max(0L, this.evictionCount - cacheStats.evictionCount));
    }

    public long missCount() {
        return this.missCount;
    }

    public double missRate() {
        double d2;
        long l2 = this.requestCount();
        if (l2 == 0L) {
            d2 = 0.0;
        } else {
            d2 = this.missCount;
            double d3 = l2;
            Double.isNaN(d2);
            Double.isNaN(d3);
            d2 /= d3;
        }
        return d2;
    }

    public CacheStats plus(CacheStats cacheStats) {
        return new CacheStats(this.hitCount + cacheStats.hitCount, this.missCount + cacheStats.missCount, this.loadSuccessCount + cacheStats.loadSuccessCount, this.loadExceptionCount + cacheStats.loadExceptionCount, this.totalLoadTime + cacheStats.totalLoadTime, this.evictionCount + cacheStats.evictionCount);
    }

    public long requestCount() {
        return this.hitCount + this.missCount;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("hitCount", this.hitCount).add("missCount", this.missCount).add("loadSuccessCount", this.loadSuccessCount).add("loadExceptionCount", this.loadExceptionCount).add("totalLoadTime", this.totalLoadTime).add("evictionCount", this.evictionCount).toString();
    }

    public long totalLoadTime() {
        return this.totalLoadTime;
    }
}

