/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.cache;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.LocalCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.compatqual.MonotonicNonNullDecl;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class CacheBuilderSpec {
    private static final Splitter KEYS_SPLITTER = Splitter.on(',').trimResults();
    private static final Splitter KEY_VALUE_SPLITTER = Splitter.on('=').trimResults();
    private static final ImmutableMap<String, ValueParser> VALUE_PARSERS = ImmutableMap.builder().put("initialCapacity", new InitialCapacityParser()).put("maximumSize", (InitialCapacityParser)((Object)new MaximumSizeParser())).put("maximumWeight", (InitialCapacityParser)((Object)new MaximumWeightParser())).put("concurrencyLevel", (InitialCapacityParser)((Object)new ConcurrencyLevelParser())).put("weakKeys", (InitialCapacityParser)((Object)new KeyStrengthParser(LocalCache.Strength.WEAK))).put("softValues", (InitialCapacityParser)((Object)new ValueStrengthParser(LocalCache.Strength.SOFT))).put("weakValues", (InitialCapacityParser)((Object)new ValueStrengthParser(LocalCache.Strength.WEAK))).put("recordStats", (InitialCapacityParser)((Object)new RecordStatsParser())).put("expireAfterAccess", (InitialCapacityParser)((Object)new AccessDurationParser())).put("expireAfterWrite", (InitialCapacityParser)((Object)new WriteDurationParser())).put("refreshAfterWrite", (InitialCapacityParser)((Object)new RefreshDurationParser())).put("refreshInterval", (InitialCapacityParser)((Object)new RefreshDurationParser())).build();
    long accessExpirationDuration;
    @MonotonicNonNullDecl
    TimeUnit accessExpirationTimeUnit;
    @MonotonicNonNullDecl
    Integer concurrencyLevel;
    @MonotonicNonNullDecl
    Integer initialCapacity;
    @MonotonicNonNullDecl
    LocalCache.Strength keyStrength;
    @MonotonicNonNullDecl
    Long maximumSize;
    @MonotonicNonNullDecl
    Long maximumWeight;
    @MonotonicNonNullDecl
    Boolean recordStats;
    long refreshDuration;
    @MonotonicNonNullDecl
    TimeUnit refreshTimeUnit;
    private final String specification;
    @MonotonicNonNullDecl
    LocalCache.Strength valueStrength;
    long writeExpirationDuration;
    @MonotonicNonNullDecl
    TimeUnit writeExpirationTimeUnit;

    private CacheBuilderSpec(String string2) {
        this.specification = string2;
    }

    public static CacheBuilderSpec disableCaching() {
        return CacheBuilderSpec.parse("maximumSize=0");
    }

    @NullableDecl
    private static Long durationInNanos(long l2, @NullableDecl TimeUnit object) {
        object = object == null ? null : Long.valueOf(object.toNanos(l2));
        return object;
    }

    private static String format(String string2, Object ... objectArray) {
        return String.format(Locale.ROOT, string2, objectArray);
    }

    public static CacheBuilderSpec parse(String object) {
        CacheBuilderSpec cacheBuilderSpec = new CacheBuilderSpec((String)object);
        if (!((String)object).isEmpty()) {
            for (String string2 : KEYS_SPLITTER.split((CharSequence)object)) {
                object = ImmutableList.copyOf(KEY_VALUE_SPLITTER.split(string2));
                Preconditions.checkArgument(object.isEmpty() ^ true, "blank key-value pair");
                int n2 = object.size();
                boolean bl = false;
                boolean bl2 = n2 <= 2;
                Preconditions.checkArgument(bl2, "key-value pair %s with more than one equals sign", (Object)string2);
                string2 = (String)object.get(0);
                ValueParser valueParser = VALUE_PARSERS.get(string2);
                bl2 = bl;
                if (valueParser != null) {
                    bl2 = true;
                }
                Preconditions.checkArgument(bl2, "unknown key %s", (Object)string2);
                object = object.size() == 1 ? null : (String)object.get(1);
                valueParser.parse(cacheBuilderSpec, string2, (String)object);
            }
        }
        return cacheBuilderSpec;
    }

    public boolean equals(@NullableDecl Object object) {
        boolean bl = true;
        if (this == object) {
            return true;
        }
        if (!(object instanceof CacheBuilderSpec)) {
            return false;
        }
        object = (CacheBuilderSpec)object;
        if (!(Objects.equal(this.initialCapacity, ((CacheBuilderSpec)object).initialCapacity) && Objects.equal(this.maximumSize, ((CacheBuilderSpec)object).maximumSize) && Objects.equal(this.maximumWeight, ((CacheBuilderSpec)object).maximumWeight) && Objects.equal(this.concurrencyLevel, ((CacheBuilderSpec)object).concurrencyLevel) && Objects.equal((Object)this.keyStrength, (Object)((CacheBuilderSpec)object).keyStrength) && Objects.equal((Object)this.valueStrength, (Object)((CacheBuilderSpec)object).valueStrength) && Objects.equal(this.recordStats, ((CacheBuilderSpec)object).recordStats) && Objects.equal(CacheBuilderSpec.durationInNanos(this.writeExpirationDuration, this.writeExpirationTimeUnit), CacheBuilderSpec.durationInNanos(((CacheBuilderSpec)object).writeExpirationDuration, ((CacheBuilderSpec)object).writeExpirationTimeUnit)) && Objects.equal(CacheBuilderSpec.durationInNanos(this.accessExpirationDuration, this.accessExpirationTimeUnit), CacheBuilderSpec.durationInNanos(((CacheBuilderSpec)object).accessExpirationDuration, ((CacheBuilderSpec)object).accessExpirationTimeUnit)) && Objects.equal(CacheBuilderSpec.durationInNanos(this.refreshDuration, this.refreshTimeUnit), CacheBuilderSpec.durationInNanos(((CacheBuilderSpec)object).refreshDuration, ((CacheBuilderSpec)object).refreshTimeUnit)))) {
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.initialCapacity, this.maximumSize, this.maximumWeight, this.concurrencyLevel, this.keyStrength, this.valueStrength, this.recordStats, CacheBuilderSpec.durationInNanos(this.writeExpirationDuration, this.writeExpirationTimeUnit), CacheBuilderSpec.durationInNanos(this.accessExpirationDuration, this.accessExpirationTimeUnit), CacheBuilderSpec.durationInNanos(this.refreshDuration, this.refreshTimeUnit)});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    CacheBuilder<Object, Object> toCacheBuilder() {
        TimeUnit timeUnit;
        TimeUnit timeUnit2;
        TimeUnit timeUnit3;
        Boolean bl;
        Integer n2;
        Long l2;
        Long l3;
        CacheBuilder<Object, Object> cacheBuilder = CacheBuilder.newBuilder();
        Integer n3 = this.initialCapacity;
        if (n3 != null) {
            cacheBuilder.initialCapacity(n3);
        }
        if ((l3 = this.maximumSize) != null) {
            cacheBuilder.maximumSize(l3);
        }
        if ((l2 = this.maximumWeight) != null) {
            cacheBuilder.maximumWeight(l2);
        }
        if ((n2 = this.concurrencyLevel) != null) {
            cacheBuilder.concurrencyLevel(n2);
        }
        if (this.keyStrength != null) {
            if (1.$SwitchMap$com$google$common$cache$LocalCache$Strength[this.keyStrength.ordinal()] != 1) throw new AssertionError();
            cacheBuilder.weakKeys();
        }
        if (this.valueStrength != null) {
            int n4 = 1.$SwitchMap$com$google$common$cache$LocalCache$Strength[this.valueStrength.ordinal()];
            if (n4 != 1) {
                if (n4 != 2) throw new AssertionError();
                cacheBuilder.softValues();
            } else {
                cacheBuilder.weakValues();
            }
        }
        if ((bl = this.recordStats) != null && bl.booleanValue()) {
            cacheBuilder.recordStats();
        }
        if ((timeUnit3 = this.writeExpirationTimeUnit) != null) {
            cacheBuilder.expireAfterWrite(this.writeExpirationDuration, timeUnit3);
        }
        if ((timeUnit2 = this.accessExpirationTimeUnit) != null) {
            cacheBuilder.expireAfterAccess(this.accessExpirationDuration, timeUnit2);
        }
        if ((timeUnit = this.refreshTimeUnit) == null) return cacheBuilder;
        cacheBuilder.refreshAfterWrite(this.refreshDuration, timeUnit);
        return cacheBuilder;
    }

    public String toParsableString() {
        return this.specification;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).addValue(this.toParsableString()).toString();
    }

    static class AccessDurationParser
    extends DurationParser {
        AccessDurationParser() {
        }

        @Override
        protected void parseDuration(CacheBuilderSpec cacheBuilderSpec, long l2, TimeUnit timeUnit) {
            boolean bl = cacheBuilderSpec.accessExpirationTimeUnit == null;
            Preconditions.checkArgument(bl, "expireAfterAccess already set");
            cacheBuilderSpec.accessExpirationDuration = l2;
            cacheBuilderSpec.accessExpirationTimeUnit = timeUnit;
        }
    }

    static class ConcurrencyLevelParser
    extends IntegerParser {
        ConcurrencyLevelParser() {
        }

        @Override
        protected void parseInteger(CacheBuilderSpec cacheBuilderSpec, int n2) {
            boolean bl = cacheBuilderSpec.concurrencyLevel == null;
            Preconditions.checkArgument(bl, "concurrency level was already set to ", (Object)cacheBuilderSpec.concurrencyLevel);
            cacheBuilderSpec.concurrencyLevel = n2;
        }
    }

    static abstract class DurationParser
    implements ValueParser {
        DurationParser() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void parse(CacheBuilderSpec object, String string2, String string3) {
            boolean bl = string3 != null && !string3.isEmpty();
            Preconditions.checkArgument(bl, "value of key %s omitted", (Object)string2);
            try {
                TimeUnit timeUnit;
                block7: {
                    block8: {
                        char c2 = string3.charAt(string3.length() - 1);
                        if (c2 == 'd') break block8;
                        if (c2 != 'h') {
                            if (c2 != 'm') {
                                if (c2 != 's') {
                                    object = new IllegalArgumentException(CacheBuilderSpec.format("key %s invalid format.  was %s, must end with one of [dDhHmMsS]", new Object[]{string2, string3}));
                                    throw object;
                                }
                                timeUnit = TimeUnit.SECONDS;
                                break block7;
                            } else {
                                timeUnit = TimeUnit.MINUTES;
                            }
                            break block7;
                        } else {
                            timeUnit = TimeUnit.HOURS;
                        }
                        break block7;
                    }
                    timeUnit = TimeUnit.DAYS;
                }
                this.parseDuration((CacheBuilderSpec)object, Long.parseLong(string3.substring(0, string3.length() - 1)), timeUnit);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(CacheBuilderSpec.format("key %s value set to %s, must be integer", new Object[]{string2, string3}));
            }
        }

        protected abstract void parseDuration(CacheBuilderSpec var1, long var2, TimeUnit var4);
    }

    static class InitialCapacityParser
    extends IntegerParser {
        InitialCapacityParser() {
        }

        @Override
        protected void parseInteger(CacheBuilderSpec cacheBuilderSpec, int n2) {
            boolean bl = cacheBuilderSpec.initialCapacity == null;
            Preconditions.checkArgument(bl, "initial capacity was already set to ", (Object)cacheBuilderSpec.initialCapacity);
            cacheBuilderSpec.initialCapacity = n2;
        }
    }

    static abstract class IntegerParser
    implements ValueParser {
        IntegerParser() {
        }

        @Override
        public void parse(CacheBuilderSpec cacheBuilderSpec, String string2, String string3) {
            boolean bl = string3 != null && !string3.isEmpty();
            Preconditions.checkArgument(bl, "value of key %s omitted", (Object)string2);
            try {
                this.parseInteger(cacheBuilderSpec, Integer.parseInt(string3));
                return;
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(CacheBuilderSpec.format("key %s value set to %s, must be integer", new Object[]{string2, string3}), numberFormatException);
            }
        }

        protected abstract void parseInteger(CacheBuilderSpec var1, int var2);
    }

    static class KeyStrengthParser
    implements ValueParser {
        private final LocalCache.Strength strength;

        public KeyStrengthParser(LocalCache.Strength strength) {
            this.strength = strength;
        }

        @Override
        public void parse(CacheBuilderSpec cacheBuilderSpec, String string2, @NullableDecl String string3) {
            boolean bl = true;
            boolean bl2 = string3 == null;
            Preconditions.checkArgument(bl2, "key %s does not take values", (Object)string2);
            bl2 = cacheBuilderSpec.keyStrength == null ? bl : false;
            Preconditions.checkArgument(bl2, "%s was already set to %s", (Object)string2, (Object)cacheBuilderSpec.keyStrength);
            cacheBuilderSpec.keyStrength = this.strength;
        }
    }

    static abstract class LongParser
    implements ValueParser {
        LongParser() {
        }

        @Override
        public void parse(CacheBuilderSpec cacheBuilderSpec, String string2, String string3) {
            boolean bl = string3 != null && !string3.isEmpty();
            Preconditions.checkArgument(bl, "value of key %s omitted", (Object)string2);
            try {
                this.parseLong(cacheBuilderSpec, Long.parseLong(string3));
                return;
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(CacheBuilderSpec.format("key %s value set to %s, must be integer", new Object[]{string2, string3}), numberFormatException);
            }
        }

        protected abstract void parseLong(CacheBuilderSpec var1, long var2);
    }

    static class MaximumSizeParser
    extends LongParser {
        MaximumSizeParser() {
        }

        @Override
        protected void parseLong(CacheBuilderSpec cacheBuilderSpec, long l2) {
            Long l3 = cacheBuilderSpec.maximumSize;
            boolean bl = true;
            boolean bl2 = l3 == null;
            Preconditions.checkArgument(bl2, "maximum size was already set to ", (Object)cacheBuilderSpec.maximumSize);
            bl2 = cacheBuilderSpec.maximumWeight == null ? bl : false;
            Preconditions.checkArgument(bl2, "maximum weight was already set to ", (Object)cacheBuilderSpec.maximumWeight);
            cacheBuilderSpec.maximumSize = l2;
        }
    }

    static class MaximumWeightParser
    extends LongParser {
        MaximumWeightParser() {
        }

        @Override
        protected void parseLong(CacheBuilderSpec cacheBuilderSpec, long l2) {
            Long l3 = cacheBuilderSpec.maximumWeight;
            boolean bl = true;
            boolean bl2 = l3 == null;
            Preconditions.checkArgument(bl2, "maximum weight was already set to ", (Object)cacheBuilderSpec.maximumWeight);
            bl2 = cacheBuilderSpec.maximumSize == null ? bl : false;
            Preconditions.checkArgument(bl2, "maximum size was already set to ", (Object)cacheBuilderSpec.maximumSize);
            cacheBuilderSpec.maximumWeight = l2;
        }
    }

    static class RecordStatsParser
    implements ValueParser {
        RecordStatsParser() {
        }

        @Override
        public void parse(CacheBuilderSpec cacheBuilderSpec, String string2, @NullableDecl String string3) {
            boolean bl = false;
            boolean bl2 = string3 == null;
            Preconditions.checkArgument(bl2, "recordStats does not take values");
            bl2 = bl;
            if (cacheBuilderSpec.recordStats == null) {
                bl2 = true;
            }
            Preconditions.checkArgument(bl2, "recordStats already set");
            cacheBuilderSpec.recordStats = true;
        }
    }

    static class RefreshDurationParser
    extends DurationParser {
        RefreshDurationParser() {
        }

        @Override
        protected void parseDuration(CacheBuilderSpec cacheBuilderSpec, long l2, TimeUnit timeUnit) {
            boolean bl = cacheBuilderSpec.refreshTimeUnit == null;
            Preconditions.checkArgument(bl, "refreshAfterWrite already set");
            cacheBuilderSpec.refreshDuration = l2;
            cacheBuilderSpec.refreshTimeUnit = timeUnit;
        }
    }

    private static interface ValueParser {
        public void parse(CacheBuilderSpec var1, String var2, @NullableDecl String var3);
    }

    static class ValueStrengthParser
    implements ValueParser {
        private final LocalCache.Strength strength;

        public ValueStrengthParser(LocalCache.Strength strength) {
            this.strength = strength;
        }

        @Override
        public void parse(CacheBuilderSpec cacheBuilderSpec, String string2, @NullableDecl String string3) {
            boolean bl = true;
            boolean bl2 = string3 == null;
            Preconditions.checkArgument(bl2, "key %s does not take values", (Object)string2);
            bl2 = cacheBuilderSpec.valueStrength == null ? bl : false;
            Preconditions.checkArgument(bl2, "%s was already set to %s", (Object)string2, (Object)cacheBuilderSpec.valueStrength);
            cacheBuilderSpec.valueStrength = this.strength;
        }
    }

    static class WriteDurationParser
    extends DurationParser {
        WriteDurationParser() {
        }

        @Override
        protected void parseDuration(CacheBuilderSpec cacheBuilderSpec, long l2, TimeUnit timeUnit) {
            boolean bl = cacheBuilderSpec.writeExpirationTimeUnit == null;
            Preconditions.checkArgument(bl, "expireAfterWrite already set");
            cacheBuilderSpec.writeExpirationDuration = l2;
            cacheBuilderSpec.writeExpirationTimeUnit = timeUnit;
        }
    }
}

