/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base.internal;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public class Finalizer
implements Runnable {
    private static final String FINALIZABLE_REFERENCE = "com.google.common.base.FinalizableReference";
    @NullableDecl
    private static final Constructor<Thread> bigThreadConstructor;
    @NullableDecl
    private static final Field inheritableThreadLocals;
    private static final Logger logger;
    private final WeakReference<Class<?>> finalizableReferenceClassReference;
    private final PhantomReference<Object> frqReference;
    private final ReferenceQueue<Object> queue;

    static {
        logger = Logger.getLogger(Finalizer.class.getName());
        bigThreadConstructor = Finalizer.getBigThreadConstructor();
        Field field = bigThreadConstructor == null ? Finalizer.getInheritableThreadLocalsField() : null;
        inheritableThreadLocals = field;
    }

    private Finalizer(Class<?> clazz, ReferenceQueue<Object> referenceQueue, PhantomReference<Object> phantomReference) {
        this.queue = referenceQueue;
        this.finalizableReferenceClassReference = new WeakReference(clazz);
        this.frqReference = phantomReference;
    }

    private boolean cleanUp(Reference<?> reference) {
        Reference<Object> reference2;
        Method method = this.getFinalizeReferentMethod();
        if (method == null) {
            return false;
        }
        do {
            reference.clear();
            if (reference == this.frqReference) {
                return false;
            }
            try {
                method.invoke(reference, new Object[0]);
            }
            catch (Throwable throwable) {
                logger.log(Level.SEVERE, "Error cleaning up after reference.", throwable);
            }
            reference2 = this.queue.poll();
            reference = reference2;
        } while (reference2 != null);
        return true;
    }

    @NullableDecl
    private static Constructor<Thread> getBigThreadConstructor() {
        try {
            Constructor<Thread> constructor = Thread.class.getConstructor(ThreadGroup.class, Runnable.class, String.class, Long.TYPE, Boolean.TYPE);
            return constructor;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @NullableDecl
    private Method getFinalizeReferentMethod() {
        GenericDeclaration genericDeclaration = (Class)this.finalizableReferenceClassReference.get();
        if (genericDeclaration == null) {
            return null;
        }
        try {
            genericDeclaration = genericDeclaration.getMethod("finalizeReferent", new Class[0]);
            return genericDeclaration;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)noSuchMethodException);
        }
    }

    @NullableDecl
    private static Field getInheritableThreadLocalsField() {
        try {
            Field field = Thread.class.getDeclaredField("inheritableThreadLocals");
            field.setAccessible(true);
            return field;
        }
        catch (Throwable throwable) {
            logger.log(Level.INFO, "Couldn't access Thread.inheritableThreadLocals. Reference finalizer threads will inherit thread local values.");
            return null;
        }
    }

    public static void startFinalizer(Class<?> constructor, ReferenceQueue<Object> object, PhantomReference<Object> object2) {
        if (((Class)((Object)constructor)).getName().equals(FINALIZABLE_REFERENCE)) {
            Finalizer finalizer;
            block8: {
                finalizer = new Finalizer((Class<?>)((Object)constructor), (ReferenceQueue<Object>)object, (PhantomReference<Object>)object2);
                object2 = Finalizer.class.getName();
                constructor = bigThreadConstructor;
                if (constructor != null) {
                    try {
                        constructor = (Thread)constructor.newInstance(null, finalizer, object2, 0L, false);
                        break block8;
                    }
                    catch (Throwable throwable) {
                        logger.log(Level.INFO, "Failed to create a thread without inherited thread-local values", throwable);
                    }
                }
                constructor = null;
            }
            object = constructor;
            if (constructor == null) {
                object = new Thread((ThreadGroup)null, finalizer, (String)object2);
            }
            ((Thread)object).setDaemon(true);
            try {
                if (inheritableThreadLocals != null) {
                    inheritableThreadLocals.set(object, null);
                }
            }
            catch (Throwable throwable) {
                logger.log(Level.INFO, "Failed to clear thread local values inherited by reference finalizer thread.", throwable);
            }
            ((Thread)object).start();
            return;
        }
        throw new IllegalArgumentException("Expected com.google.common.base.FinalizableReference.");
    }

    @Override
    public void run() {
        while (true) {
            try {
                boolean bl = this.cleanUp(this.queue.remove());
                if (bl) continue;
                return;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }
}

