/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.Preconditions;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class Throwables {
    private static final String JAVA_LANG_ACCESS_CLASSNAME = "sun.misc.JavaLangAccess";
    static final String SHARED_SECRETS_CLASSNAME = "sun.misc.SharedSecrets";
    @NullableDecl
    private static final Method getStackTraceDepthMethod;
    @NullableDecl
    private static final Method getStackTraceElementMethod;
    @NullableDecl
    private static final Object jla;

    static {
        Object object = jla = Throwables.getJLA();
        Object var1_1 = null;
        object = object == null ? null : Throwables.getGetMethod();
        getStackTraceElementMethod = object;
        object = jla == null ? var1_1 : Throwables.getSizeMethod();
        getStackTraceDepthMethod = object;
    }

    private Throwables() {
    }

    public static List<Throwable> getCausalChain(Throwable throwable) {
        Preconditions.checkNotNull(throwable);
        ArrayList<Throwable> arrayList = new ArrayList<Throwable>(4);
        arrayList.add(throwable);
        boolean bl = false;
        Throwable throwable2 = throwable;
        Throwable throwable3 = throwable;
        throwable = throwable2;
        while ((throwable2 = throwable3.getCause()) != null) {
            arrayList.add(throwable2);
            if (throwable2 != throwable) {
                throwable3 = throwable;
                if (bl) {
                    throwable3 = throwable.getCause();
                }
                bl ^= true;
                throwable = throwable3;
                throwable3 = throwable2;
                continue;
            }
            throw new IllegalArgumentException("Loop in causal chain detected.", throwable2);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public static <X extends Throwable> X getCauseAs(Throwable throwable, Class<X> serializable) {
        try {
            serializable = (Throwable)serializable.cast(throwable.getCause());
        }
        catch (ClassCastException classCastException) {
            classCastException.initCause(throwable);
            throw classCastException;
        }
        return (X)serializable;
    }

    @NullableDecl
    private static Method getGetMethod() {
        return Throwables.getJlaMethod("getStackTraceElement", Throwable.class, Integer.TYPE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NullableDecl
    private static Object getJLA() {
        Object object = null;
        try {
            Object object2 = Class.forName(SHARED_SECRETS_CLASSNAME, false, null).getMethod("getJavaLangAccess", new Class[0]).invoke(null, new Object[0]);
            return object2;
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            return object;
        }
    }

    @NullableDecl
    private static Method getJlaMethod(String object, Class<?> ... classArray) throws ThreadDeath {
        try {
            object = Class.forName(JAVA_LANG_ACCESS_CLASSNAME, false, null).getMethod((String)object, classArray);
            return object;
        }
        catch (Throwable throwable) {
            return null;
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
    }

    public static Throwable getRootCause(Throwable throwable) {
        boolean bl = false;
        Throwable throwable2 = throwable;
        Throwable throwable3 = throwable;
        throwable = throwable2;
        while ((throwable2 = throwable3.getCause()) != null) {
            if (throwable2 != throwable) {
                throwable3 = throwable;
                if (bl) {
                    throwable3 = throwable.getCause();
                }
                bl ^= true;
                throwable = throwable3;
                throwable3 = throwable2;
                continue;
            }
            throw new IllegalArgumentException("Loop in causal chain detected.", throwable2);
        }
        return throwable3;
    }

    @NullableDecl
    private static Method getSizeMethod() {
        Method method;
        block3: {
            method = Throwables.getJlaMethod("getStackTraceDepth", Throwable.class);
            if (method != null) break block3;
            return null;
        }
        try {
            Object object = Throwables.getJLA();
            Throwable throwable = new Throwable();
            method.invoke(object, throwable);
            return method;
        }
        catch (IllegalAccessException | UnsupportedOperationException | InvocationTargetException exception) {
            return null;
        }
    }

    public static String getStackTraceAsString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    private static Object invokeAccessibleNonThrowingMethod(Method object, Object object2, Object ... objectArray) {
        try {
            object = ((Method)object).invoke(object2, objectArray);
            return object;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw Throwables.propagate(invocationTargetException.getCause());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
    }

    private static List<StackTraceElement> jlaStackTrace(final Throwable throwable) {
        Preconditions.checkNotNull(throwable);
        return new AbstractList<StackTraceElement>(){

            @Override
            public StackTraceElement get(int n2) {
                return (StackTraceElement)Throwables.invokeAccessibleNonThrowingMethod(getStackTraceElementMethod, jla, new Object[]{throwable, n2});
            }

            @Override
            public int size() {
                return (Integer)Throwables.invokeAccessibleNonThrowingMethod(getStackTraceDepthMethod, jla, new Object[]{throwable});
            }
        };
    }

    public static List<StackTraceElement> lazyStackTrace(Throwable list) {
        list = Throwables.lazyStackTraceIsLazy() ? Throwables.jlaStackTrace((Throwable)((Object)list)) : Collections.unmodifiableList(Arrays.asList(((Throwable)((Object)list)).getStackTrace()));
        return list;
    }

    public static boolean lazyStackTraceIsLazy() {
        boolean bl = getStackTraceElementMethod != null && getStackTraceDepthMethod != null;
        return bl;
    }

    @Deprecated
    public static RuntimeException propagate(Throwable throwable) {
        Throwables.throwIfUnchecked(throwable);
        throw new RuntimeException(throwable);
    }

    @Deprecated
    public static <X extends Throwable> void propagateIfInstanceOf(@NullableDecl Throwable throwable, Class<X> clazz) throws X {
        if (throwable != null) {
            Throwables.throwIfInstanceOf(throwable, clazz);
        }
    }

    @Deprecated
    public static void propagateIfPossible(@NullableDecl Throwable throwable) {
        if (throwable != null) {
            Throwables.throwIfUnchecked(throwable);
        }
    }

    public static <X extends Throwable> void propagateIfPossible(@NullableDecl Throwable throwable, Class<X> clazz) throws X {
        Throwables.propagateIfInstanceOf(throwable, clazz);
        Throwables.propagateIfPossible(throwable);
    }

    public static <X1 extends Throwable, X2 extends Throwable> void propagateIfPossible(@NullableDecl Throwable throwable, Class<X1> clazz, Class<X2> clazz2) throws X1, X2 {
        Preconditions.checkNotNull(clazz2);
        Throwables.propagateIfInstanceOf(throwable, clazz);
        Throwables.propagateIfPossible(throwable, clazz2);
    }

    public static <X extends Throwable> void throwIfInstanceOf(Throwable throwable, Class<X> clazz) throws X {
        Preconditions.checkNotNull(throwable);
        if (!clazz.isInstance(throwable)) {
            return;
        }
        throw (Throwable)clazz.cast(throwable);
    }

    public static void throwIfUnchecked(Throwable throwable) {
        Preconditions.checkNotNull(throwable);
        if (!(throwable instanceof RuntimeException)) {
            if (!(throwable instanceof Error)) {
                return;
            }
            throw (Error)throwable;
        }
        throw (RuntimeException)throwable;
    }
}

