/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.Platform;
import com.google.common.base.Preconditions;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class Strings {
    private Strings() {
    }

    public static String commonPrefix(CharSequence charSequence, CharSequence charSequence2) {
        int n2;
        block4: {
            int n3;
            block3: {
                Preconditions.checkNotNull(charSequence);
                Preconditions.checkNotNull(charSequence2);
                n2 = Math.min(charSequence.length(), charSequence2.length());
                for (n3 = 0; n3 < n2 && charSequence.charAt(n3) == charSequence2.charAt(n3); ++n3) {
                }
                int n4 = n3 - 1;
                if (Strings.validSurrogatePairAt(charSequence, n4)) break block3;
                n2 = n3;
                if (!Strings.validSurrogatePairAt(charSequence2, n4)) break block4;
            }
            n2 = n3 - 1;
        }
        return charSequence.subSequence(0, n2).toString();
    }

    public static String commonSuffix(CharSequence charSequence, CharSequence charSequence2) {
        int n2;
        block4: {
            int n3;
            block3: {
                Preconditions.checkNotNull(charSequence);
                Preconditions.checkNotNull(charSequence2);
                n2 = Math.min(charSequence.length(), charSequence2.length());
                for (n3 = 0; n3 < n2 && charSequence.charAt(charSequence.length() - n3 - 1) == charSequence2.charAt(charSequence2.length() - n3 - 1); ++n3) {
                }
                if (Strings.validSurrogatePairAt(charSequence, charSequence.length() - n3 - 1)) break block3;
                n2 = n3;
                if (!Strings.validSurrogatePairAt(charSequence2, charSequence2.length() - n3 - 1)) break block4;
            }
            n2 = n3 - 1;
        }
        return charSequence.subSequence(charSequence.length() - n2, charSequence.length()).toString();
    }

    @NullableDecl
    public static String emptyToNull(@NullableDecl String string2) {
        return Platform.emptyToNull(string2);
    }

    public static boolean isNullOrEmpty(@NullableDecl String string2) {
        return Platform.stringIsNullOrEmpty(string2);
    }

    public static String lenientFormat(@NullableDecl String objectArray, Object ... object) {
        int n2;
        String string2 = String.valueOf(objectArray);
        int n3 = 0;
        if (object == null) {
            objectArray = new Object[]{"(Object[])null"};
        } else {
            n2 = 0;
            while (true) {
                objectArray = object;
                if (n2 >= ((Object[])object).length) break;
                object[n2] = Strings.lenientToString(object[n2]);
                ++n2;
            }
        }
        object = new StringBuilder(string2.length() + objectArray.length * 16);
        int n4 = 0;
        for (n2 = n3; n2 < objectArray.length && (n3 = string2.indexOf("%s", n4)) != -1; ++n2) {
            ((StringBuilder)object).append(string2, n4, n3);
            ((StringBuilder)object).append(objectArray[n2]);
            n4 = n3 + 2;
        }
        ((StringBuilder)object).append(string2, n4, string2.length());
        if (n2 < objectArray.length) {
            ((StringBuilder)object).append(" [");
            n4 = n2 + 1;
            ((StringBuilder)object).append(objectArray[n2]);
            for (n2 = n4; n2 < objectArray.length; ++n2) {
                ((StringBuilder)object).append(", ");
                ((StringBuilder)object).append(objectArray[n2]);
            }
            ((StringBuilder)object).append(']');
        }
        return ((StringBuilder)object).toString();
    }

    private static String lenientToString(@NullableDecl Object object) {
        try {
            String string2 = String.valueOf(object);
            return string2;
        }
        catch (Exception exception) {
            Object object2 = new StringBuilder();
            ((StringBuilder)object2).append(object.getClass().getName());
            ((StringBuilder)object2).append('@');
            ((StringBuilder)object2).append(Integer.toHexString(System.identityHashCode(object)));
            object = ((StringBuilder)object2).toString();
            object2 = Logger.getLogger("com.google.common.base.Strings");
            Level level = Level.WARNING;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Exception during lenientFormat for ");
            stringBuilder.append((String)object);
            ((Logger)object2).log(level, stringBuilder.toString(), exception);
            object2 = new StringBuilder();
            ((StringBuilder)object2).append("<");
            ((StringBuilder)object2).append((String)object);
            ((StringBuilder)object2).append(" threw ");
            ((StringBuilder)object2).append(exception.getClass().getName());
            ((StringBuilder)object2).append(">");
            return ((StringBuilder)object2).toString();
        }
    }

    public static String nullToEmpty(@NullableDecl String string2) {
        return Platform.nullToEmpty(string2);
    }

    public static String padEnd(String string2, int n2, char c2) {
        Preconditions.checkNotNull(string2);
        if (string2.length() >= n2) {
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder(n2);
        stringBuilder.append(string2);
        for (int i2 = string2.length(); i2 < n2; ++i2) {
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public static String padStart(String string2, int n2, char c2) {
        Preconditions.checkNotNull(string2);
        if (string2.length() >= n2) {
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder(n2);
        for (int i2 = string2.length(); i2 < n2; ++i2) {
            stringBuilder.append(c2);
        }
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    public static String repeat(String object, int n2) {
        Preconditions.checkNotNull(object);
        boolean bl = true;
        if (n2 <= 1) {
            if (n2 < 0) {
                bl = false;
            }
            Preconditions.checkArgument(bl, "invalid count: %s", n2);
            if (n2 == 0) {
                object = "";
            }
            return object;
        }
        int n3 = ((String)object).length();
        long l2 = (long)n3 * (long)n2;
        int n4 = (int)l2;
        if ((long)n4 == l2) {
            char[] cArray = new char[n4];
            ((String)object).getChars(0, n3, cArray, 0);
            for (n2 = n3; n2 < (n3 = n4 - n2); n2 <<= 1) {
                System.arraycopy(cArray, 0, cArray, n2, n2);
            }
            System.arraycopy(cArray, 0, cArray, n2, n3);
            return new String(cArray);
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Required array size too large: ");
        ((StringBuilder)object).append(l2);
        object = new ArrayIndexOutOfBoundsException(((StringBuilder)object).toString());
        throw object;
    }

    static boolean validSurrogatePairAt(CharSequence charSequence, int n2) {
        boolean bl = true;
        if (n2 < 0 || n2 > charSequence.length() - 2 || !Character.isHighSurrogate(charSequence.charAt(n2)) || !Character.isLowSurrogate(charSequence.charAt(n2 + 1))) {
            bl = false;
        }
        return bl;
    }
}

