/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.AbstractIterator;
import com.google.common.base.CharMatcher;
import com.google.common.base.CommonMatcher;
import com.google.common.base.CommonPattern;
import com.google.common.base.JdkPattern;
import com.google.common.base.Joiner;
import com.google.common.base.Platform;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public final class Splitter {
    private final int limit;
    private final boolean omitEmptyStrings;
    private final Strategy strategy;
    private final CharMatcher trimmer;

    private Splitter(Strategy strategy) {
        this(strategy, false, CharMatcher.none(), Integer.MAX_VALUE);
    }

    private Splitter(Strategy strategy, boolean bl, CharMatcher charMatcher, int n2) {
        this.strategy = strategy;
        this.omitEmptyStrings = bl;
        this.trimmer = charMatcher;
        this.limit = n2;
    }

    public static Splitter fixedLength(final int n2) {
        boolean bl = n2 > 0;
        Preconditions.checkArgument(bl, "The length may not be less than 1");
        return new Splitter(new Strategy(){

            public SplittingIterator iterator(Splitter splitter, CharSequence charSequence) {
                return new SplittingIterator(splitter, charSequence){

                    @Override
                    public int separatorEnd(int n2) {
                        return n2;
                    }

                    @Override
                    public int separatorStart(int n2) {
                        if ((n2 += n2) >= this.toSplit.length()) {
                            n2 = -1;
                        }
                        return n2;
                    }
                };
            }
        });
    }

    public static Splitter on(char c2) {
        return Splitter.on(CharMatcher.is(c2));
    }

    public static Splitter on(final CharMatcher charMatcher) {
        Preconditions.checkNotNull(charMatcher);
        return new Splitter(new Strategy(){

            public SplittingIterator iterator(Splitter splitter, CharSequence charSequence) {
                return new SplittingIterator(splitter, charSequence){

                    @Override
                    int separatorEnd(int n2) {
                        return n2 + 1;
                    }

                    @Override
                    int separatorStart(int n2) {
                        return charMatcher.indexIn(this.toSplit, n2);
                    }
                };
            }
        });
    }

    private static Splitter on(final CommonPattern commonPattern) {
        Preconditions.checkArgument(commonPattern.matcher((CharSequence)"").matches() ^ true, "The pattern may not match the empty string: %s", (Object)commonPattern);
        return new Splitter(new Strategy(){

            public SplittingIterator iterator(Splitter splitter, CharSequence charSequence) {
                return new SplittingIterator(splitter, charSequence, commonPattern.matcher(charSequence)){
                    final /* synthetic */ CommonMatcher val$matcher;
                    {
                        this.val$matcher = commonMatcher;
                        super(splitter, charSequence);
                    }

                    @Override
                    public int separatorEnd(int n2) {
                        return this.val$matcher.end();
                    }

                    @Override
                    public int separatorStart(int n2) {
                        n2 = this.val$matcher.find(n2) ? this.val$matcher.start() : -1;
                        return n2;
                    }
                };
            }
        });
    }

    public static Splitter on(final String string2) {
        boolean bl = string2.length() != 0;
        Preconditions.checkArgument(bl, "The separator may not be the empty string.");
        if (string2.length() == 1) {
            return Splitter.on(string2.charAt(0));
        }
        return new Splitter(new Strategy(){

            public SplittingIterator iterator(Splitter splitter, CharSequence charSequence) {
                return new SplittingIterator(splitter, charSequence){

                    @Override
                    public int separatorEnd(int n2) {
                        return n2 + string2.length();
                    }

                    @Override
                    public int separatorStart(int n2) {
                        int n3 = string2.length();
                        int n4 = this.toSplit.length();
                        block0: while (n2 <= n4 - n3) {
                            for (int i2 = 0; i2 < n3; ++i2) {
                                if (this.toSplit.charAt(i2 + n2) == string2.charAt(i2)) continue;
                                ++n2;
                                continue block0;
                            }
                            return n2;
                        }
                        return -1;
                    }
                };
            }
        });
    }

    public static Splitter on(Pattern pattern) {
        return Splitter.on((CommonPattern)new JdkPattern(pattern));
    }

    public static Splitter onPattern(String string2) {
        return Splitter.on(Platform.compilePattern(string2));
    }

    private Iterator<String> splittingIterator(CharSequence charSequence) {
        return this.strategy.iterator(this, charSequence);
    }

    public Splitter limit(int n2) {
        boolean bl = n2 > 0;
        Preconditions.checkArgument(bl, "must be greater than zero: %s", n2);
        return new Splitter(this.strategy, this.omitEmptyStrings, this.trimmer, n2);
    }

    public Splitter omitEmptyStrings() {
        return new Splitter(this.strategy, true, this.trimmer, this.limit);
    }

    public Iterable<String> split(final CharSequence charSequence) {
        Preconditions.checkNotNull(charSequence);
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return Splitter.this.splittingIterator(charSequence);
            }

            public String toString() {
                Joiner joiner = Joiner.on(", ");
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append('[');
                stringBuilder = joiner.appendTo(stringBuilder, (Iterable<?>)this);
                stringBuilder.append(']');
                return stringBuilder.toString();
            }
        };
    }

    public List<String> splitToList(CharSequence object) {
        Preconditions.checkNotNull(object);
        object = this.splittingIterator((CharSequence)object);
        ArrayList arrayList = new ArrayList();
        while (object.hasNext()) {
            arrayList.add(object.next());
        }
        return Collections.unmodifiableList(arrayList);
    }

    public Splitter trimResults() {
        return this.trimResults(CharMatcher.whitespace());
    }

    public Splitter trimResults(CharMatcher charMatcher) {
        Preconditions.checkNotNull(charMatcher);
        return new Splitter(this.strategy, this.omitEmptyStrings, charMatcher, this.limit);
    }

    public MapSplitter withKeyValueSeparator(char c2) {
        return this.withKeyValueSeparator(Splitter.on(c2));
    }

    public MapSplitter withKeyValueSeparator(Splitter splitter) {
        return new MapSplitter(this, splitter);
    }

    public MapSplitter withKeyValueSeparator(String string2) {
        return this.withKeyValueSeparator(Splitter.on(string2));
    }

    public static final class MapSplitter {
        private static final String INVALID_ENTRY_MESSAGE = "Chunk [%s] is not a valid entry";
        private final Splitter entrySplitter;
        private final Splitter outerSplitter;

        private MapSplitter(Splitter splitter, Splitter splitter2) {
            this.outerSplitter = splitter;
            this.entrySplitter = Preconditions.checkNotNull(splitter2);
        }

        public Map<String, String> split(CharSequence charSequence2) {
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            for (String string2 : this.outerSplitter.split(charSequence2)) {
                Iterator iterator2 = this.entrySplitter.splittingIterator(string2);
                Preconditions.checkArgument(iterator2.hasNext(), INVALID_ENTRY_MESSAGE, (Object)string2);
                String string3 = (String)iterator2.next();
                Preconditions.checkArgument(linkedHashMap.containsKey(string3) ^ true, "Duplicate key [%s] found.", (Object)string3);
                Preconditions.checkArgument(iterator2.hasNext(), INVALID_ENTRY_MESSAGE, (Object)string2);
                linkedHashMap.put(string3, (String)iterator2.next());
                Preconditions.checkArgument(iterator2.hasNext() ^ true, INVALID_ENTRY_MESSAGE, (Object)string2);
            }
            return Collections.unmodifiableMap(linkedHashMap);
        }
    }

    private static abstract class SplittingIterator
    extends AbstractIterator<String> {
        int limit;
        int offset = 0;
        final boolean omitEmptyStrings;
        final CharSequence toSplit;
        final CharMatcher trimmer;

        protected SplittingIterator(Splitter splitter, CharSequence charSequence) {
            this.trimmer = splitter.trimmer;
            this.omitEmptyStrings = splitter.omitEmptyStrings;
            this.limit = splitter.limit;
            this.toSplit = charSequence;
        }

        @Override
        protected String computeNext() {
            int n2;
            int n3 = this.offset;
            while ((n2 = this.offset) != -1) {
                if ((n2 = this.separatorStart(n2)) == -1) {
                    n2 = this.toSplit.length();
                    this.offset = -1;
                } else {
                    this.offset = this.separatorEnd(n2);
                }
                int n4 = this.offset;
                int n5 = n3;
                if (n4 == n3) {
                    this.offset = n4 + 1;
                    if (this.offset <= this.toSplit.length()) continue;
                    this.offset = -1;
                    continue;
                }
                while (true) {
                    n3 = n2;
                    if (n5 >= n2) break;
                    n3 = n2;
                    if (!this.trimmer.matches(this.toSplit.charAt(n5))) break;
                    ++n5;
                }
                while (n3 > n5 && this.trimmer.matches(this.toSplit.charAt(n3 - 1))) {
                    --n3;
                }
                if (this.omitEmptyStrings && n5 == n3) {
                    n3 = this.offset;
                    continue;
                }
                n2 = this.limit;
                if (n2 == 1) {
                    n3 = this.toSplit.length();
                    this.offset = -1;
                    while (true) {
                        n2 = n3;
                        if (n3 > n5) {
                            n2 = n3;
                            if (this.trimmer.matches(this.toSplit.charAt(n3 - 1))) {
                                --n3;
                                continue;
                            }
                        }
                        break;
                    }
                } else {
                    this.limit = n2 - 1;
                    n2 = n3;
                }
                return this.toSplit.subSequence(n5, n2).toString();
            }
            return (String)this.endOfData();
        }

        abstract int separatorEnd(int var1);

        abstract int separatorStart(int var1);
    }

    private static interface Strategy {
        public Iterator<String> iterator(Splitter var1, CharSequence var2);
    }
}

