/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.CommonPattern;
import com.google.common.base.Function;
import com.google.common.base.JdkPattern;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Platform;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class Predicates {
    private Predicates() {
    }

    public static <T> Predicate<T> alwaysFalse() {
        return ObjectPredicate.ALWAYS_FALSE.withNarrowedType();
    }

    public static <T> Predicate<T> alwaysTrue() {
        return ObjectPredicate.ALWAYS_TRUE.withNarrowedType();
    }

    public static <T> Predicate<T> and(Predicate<? super T> predicate, Predicate<? super T> predicate2) {
        return new AndPredicate(Predicates.asList(Preconditions.checkNotNull(predicate), Preconditions.checkNotNull(predicate2)));
    }

    public static <T> Predicate<T> and(Iterable<? extends Predicate<? super T>> iterable) {
        return new AndPredicate(Predicates.defensiveCopy(iterable));
    }

    @SafeVarargs
    public static <T> Predicate<T> and(Predicate<? super T> ... predicateArray) {
        return new AndPredicate(Predicates.defensiveCopy(predicateArray));
    }

    private static <T> List<Predicate<? super T>> asList(Predicate<? super T> predicate, Predicate<? super T> predicate2) {
        return Arrays.asList(predicate, predicate2);
    }

    public static <A, B> Predicate<A> compose(Predicate<B> predicate, Function<A, ? extends B> function) {
        return new CompositionPredicate(predicate, function);
    }

    public static Predicate<CharSequence> contains(Pattern pattern) {
        return new ContainsPatternPredicate((CommonPattern)new JdkPattern(pattern));
    }

    public static Predicate<CharSequence> containsPattern(String string2) {
        return new ContainsPatternFromStringPredicate(string2);
    }

    static <T> List<T> defensiveCopy(Iterable<T> object) {
        ArrayList arrayList = new ArrayList();
        object = object.iterator();
        while (object.hasNext()) {
            arrayList.add(Preconditions.checkNotNull(object.next()));
        }
        return arrayList;
    }

    private static <T> List<T> defensiveCopy(T ... TArray) {
        return Predicates.defensiveCopy(Arrays.asList(TArray));
    }

    public static <T> Predicate<T> equalTo(@NullableDecl T object) {
        object = object == null ? Predicates.isNull() : new IsEqualToPredicate(object);
        return object;
    }

    public static <T> Predicate<T> in(Collection<? extends T> collection) {
        return new InPredicate(collection);
    }

    public static Predicate<Object> instanceOf(Class<?> clazz) {
        return new InstanceOfPredicate(clazz);
    }

    public static <T> Predicate<T> isNull() {
        return ObjectPredicate.IS_NULL.withNarrowedType();
    }

    public static <T> Predicate<T> not(Predicate<T> predicate) {
        return new NotPredicate<T>(predicate);
    }

    public static <T> Predicate<T> notNull() {
        return ObjectPredicate.NOT_NULL.withNarrowedType();
    }

    public static <T> Predicate<T> or(Predicate<? super T> predicate, Predicate<? super T> predicate2) {
        return new OrPredicate(Predicates.asList(Preconditions.checkNotNull(predicate), Preconditions.checkNotNull(predicate2)));
    }

    public static <T> Predicate<T> or(Iterable<? extends Predicate<? super T>> iterable) {
        return new OrPredicate(Predicates.defensiveCopy(iterable));
    }

    @SafeVarargs
    public static <T> Predicate<T> or(Predicate<? super T> ... predicateArray) {
        return new OrPredicate(Predicates.defensiveCopy(predicateArray));
    }

    public static Predicate<Class<?>> subtypeOf(Class<?> clazz) {
        return new SubtypeOfPredicate(clazz);
    }

    private static String toStringHelper(String string2, Iterable<?> object) {
        StringBuilder stringBuilder = new StringBuilder("Predicates.");
        stringBuilder.append(string2);
        stringBuilder.append('(');
        object = object.iterator();
        boolean bl = true;
        while (object.hasNext()) {
            string2 = object.next();
            if (!bl) {
                stringBuilder.append(',');
            }
            stringBuilder.append((Object)string2);
            bl = false;
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    private static class AndPredicate<T>
    implements Predicate<T>,
    Serializable {
        private static final long serialVersionUID = 0L;
        private final List<? extends Predicate<? super T>> components;

        private AndPredicate(List<? extends Predicate<? super T>> list) {
            this.components = list;
        }

        @Override
        public boolean apply(@NullableDecl T t2) {
            for (int i2 = 0; i2 < this.components.size(); ++i2) {
                if (this.components.get(i2).apply(t2)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean equals(@NullableDecl Object object) {
            if (object instanceof AndPredicate) {
                object = (AndPredicate)object;
                return this.components.equals(((AndPredicate)object).components);
            }
            return false;
        }

        public int hashCode() {
            return this.components.hashCode() + 306654252;
        }

        public String toString() {
            return Predicates.toStringHelper("and", this.components);
        }
    }

    private static class CompositionPredicate<A, B>
    implements Predicate<A>,
    Serializable {
        private static final long serialVersionUID = 0L;
        final Function<A, ? extends B> f;
        final Predicate<B> p;

        private CompositionPredicate(Predicate<B> predicate, Function<A, ? extends B> function) {
            this.p = Preconditions.checkNotNull(predicate);
            this.f = Preconditions.checkNotNull(function);
        }

        @Override
        public boolean apply(@NullableDecl A a2) {
            return this.p.apply(this.f.apply(a2));
        }

        @Override
        public boolean equals(@NullableDecl Object object) {
            boolean bl;
            boolean bl2 = object instanceof CompositionPredicate;
            boolean bl3 = bl = false;
            if (bl2) {
                object = (CompositionPredicate)object;
                bl3 = bl;
                if (this.f.equals(((CompositionPredicate)object).f)) {
                    bl3 = bl;
                    if (this.p.equals(((CompositionPredicate)object).p)) {
                        bl3 = true;
                    }
                }
            }
            return bl3;
        }

        public int hashCode() {
            return this.f.hashCode() ^ this.p.hashCode();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.p);
            stringBuilder.append("(");
            stringBuilder.append(this.f);
            stringBuilder.append(")");
            return stringBuilder.toString();
        }
    }

    private static class ContainsPatternFromStringPredicate
    extends ContainsPatternPredicate {
        private static final long serialVersionUID = 0L;

        ContainsPatternFromStringPredicate(String string2) {
            super(Platform.compilePattern(string2));
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Predicates.containsPattern(");
            stringBuilder.append(this.pattern.pattern());
            stringBuilder.append(")");
            return stringBuilder.toString();
        }
    }

    private static class ContainsPatternPredicate
    implements Predicate<CharSequence>,
    Serializable {
        private static final long serialVersionUID = 0L;
        final CommonPattern pattern;

        ContainsPatternPredicate(CommonPattern commonPattern) {
            this.pattern = Preconditions.checkNotNull(commonPattern);
        }

        @Override
        public boolean apply(CharSequence charSequence) {
            return this.pattern.matcher(charSequence).find();
        }

        @Override
        public boolean equals(@NullableDecl Object object) {
            boolean bl;
            boolean bl2 = object instanceof ContainsPatternPredicate;
            boolean bl3 = bl = false;
            if (bl2) {
                object = (ContainsPatternPredicate)object;
                bl3 = bl;
                if (Objects.equal(this.pattern.pattern(), ((ContainsPatternPredicate)object).pattern.pattern())) {
                    bl3 = bl;
                    if (this.pattern.flags() == ((ContainsPatternPredicate)object).pattern.flags()) {
                        bl3 = true;
                    }
                }
            }
            return bl3;
        }

        public int hashCode() {
            return Objects.hashCode(this.pattern.pattern(), this.pattern.flags());
        }

        public String toString() {
            String string2 = MoreObjects.toStringHelper(this.pattern).add("pattern", this.pattern.pattern()).add("pattern.flags", this.pattern.flags()).toString();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Predicates.contains(");
            stringBuilder.append(string2);
            stringBuilder.append(")");
            return stringBuilder.toString();
        }
    }

    private static class InPredicate<T>
    implements Predicate<T>,
    Serializable {
        private static final long serialVersionUID = 0L;
        private final Collection<?> target;

        private InPredicate(Collection<?> collection) {
            this.target = Preconditions.checkNotNull(collection);
        }

        @Override
        public boolean apply(@NullableDecl T t2) {
            try {
                boolean bl = this.target.contains(t2);
                return bl;
            }
            catch (ClassCastException | NullPointerException runtimeException) {
                return false;
            }
        }

        @Override
        public boolean equals(@NullableDecl Object object) {
            if (object instanceof InPredicate) {
                object = (InPredicate)object;
                return this.target.equals(((InPredicate)object).target);
            }
            return false;
        }

        public int hashCode() {
            return this.target.hashCode();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Predicates.in(");
            stringBuilder.append(this.target);
            stringBuilder.append(")");
            return stringBuilder.toString();
        }
    }

    private static class InstanceOfPredicate
    implements Predicate<Object>,
    Serializable {
        private static final long serialVersionUID = 0L;
        private final Class<?> clazz;

        private InstanceOfPredicate(Class<?> clazz) {
            this.clazz = Preconditions.checkNotNull(clazz);
        }

        @Override
        public boolean apply(@NullableDecl Object object) {
            return this.clazz.isInstance(object);
        }

        @Override
        public boolean equals(@NullableDecl Object object) {
            boolean bl;
            boolean bl2 = object instanceof InstanceOfPredicate;
            boolean bl3 = bl = false;
            if (bl2) {
                object = (InstanceOfPredicate)object;
                bl3 = bl;
                if (this.clazz == ((InstanceOfPredicate)object).clazz) {
                    bl3 = true;
                }
            }
            return bl3;
        }

        public int hashCode() {
            return this.clazz.hashCode();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Predicates.instanceOf(");
            stringBuilder.append(this.clazz.getName());
            stringBuilder.append(")");
            return stringBuilder.toString();
        }
    }

    private static class IsEqualToPredicate<T>
    implements Predicate<T>,
    Serializable {
        private static final long serialVersionUID = 0L;
        private final T target;

        private IsEqualToPredicate(T t2) {
            this.target = t2;
        }

        @Override
        public boolean apply(T t2) {
            return this.target.equals(t2);
        }

        @Override
        public boolean equals(@NullableDecl Object object) {
            if (object instanceof IsEqualToPredicate) {
                object = (IsEqualToPredicate)object;
                return this.target.equals(((IsEqualToPredicate)object).target);
            }
            return false;
        }

        public int hashCode() {
            return this.target.hashCode();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Predicates.equalTo(");
            stringBuilder.append(this.target);
            stringBuilder.append(")");
            return stringBuilder.toString();
        }
    }

    private static class NotPredicate<T>
    implements Predicate<T>,
    Serializable {
        private static final long serialVersionUID = 0L;
        final Predicate<T> predicate;

        NotPredicate(Predicate<T> predicate) {
            this.predicate = Preconditions.checkNotNull(predicate);
        }

        @Override
        public boolean apply(@NullableDecl T t2) {
            return this.predicate.apply(t2) ^ true;
        }

        @Override
        public boolean equals(@NullableDecl Object object) {
            if (object instanceof NotPredicate) {
                object = (NotPredicate)object;
                return this.predicate.equals(((NotPredicate)object).predicate);
            }
            return false;
        }

        public int hashCode() {
            return ~this.predicate.hashCode();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Predicates.not(");
            stringBuilder.append(this.predicate);
            stringBuilder.append(")");
            return stringBuilder.toString();
        }
    }

    static enum ObjectPredicate implements Predicate<Object>
    {
        ALWAYS_TRUE{

            @Override
            public boolean apply(@NullableDecl Object object) {
                return true;
            }

            public String toString() {
                return "Predicates.alwaysTrue()";
            }
        }
        ,
        ALWAYS_FALSE{

            @Override
            public boolean apply(@NullableDecl Object object) {
                return false;
            }

            public String toString() {
                return "Predicates.alwaysFalse()";
            }
        }
        ,
        IS_NULL{

            @Override
            public boolean apply(@NullableDecl Object object) {
                boolean bl = object == null;
                return bl;
            }

            public String toString() {
                return "Predicates.isNull()";
            }
        }
        ,
        NOT_NULL{

            @Override
            public boolean apply(@NullableDecl Object object) {
                boolean bl = object != null;
                return bl;
            }

            public String toString() {
                return "Predicates.notNull()";
            }
        };


        <T> Predicate<T> withNarrowedType() {
            return this;
        }
    }

    private static class OrPredicate<T>
    implements Predicate<T>,
    Serializable {
        private static final long serialVersionUID = 0L;
        private final List<? extends Predicate<? super T>> components;

        private OrPredicate(List<? extends Predicate<? super T>> list) {
            this.components = list;
        }

        @Override
        public boolean apply(@NullableDecl T t2) {
            for (int i2 = 0; i2 < this.components.size(); ++i2) {
                if (!this.components.get(i2).apply(t2)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean equals(@NullableDecl Object object) {
            if (object instanceof OrPredicate) {
                object = (OrPredicate)object;
                return this.components.equals(((OrPredicate)object).components);
            }
            return false;
        }

        public int hashCode() {
            return this.components.hashCode() + 87855567;
        }

        public String toString() {
            return Predicates.toStringHelper("or", this.components);
        }
    }

    private static class SubtypeOfPredicate
    implements Predicate<Class<?>>,
    Serializable {
        private static final long serialVersionUID = 0L;
        private final Class<?> clazz;

        private SubtypeOfPredicate(Class<?> clazz) {
            this.clazz = Preconditions.checkNotNull(clazz);
        }

        @Override
        public boolean apply(Class<?> clazz) {
            return this.clazz.isAssignableFrom(clazz);
        }

        @Override
        public boolean equals(@NullableDecl Object object) {
            boolean bl;
            boolean bl2 = object instanceof SubtypeOfPredicate;
            boolean bl3 = bl = false;
            if (bl2) {
                object = (SubtypeOfPredicate)object;
                bl3 = bl;
                if (this.clazz == ((SubtypeOfPredicate)object).clazz) {
                    bl3 = true;
                }
            }
            return bl3;
        }

        public int hashCode() {
            return this.clazz.hashCode();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Predicates.subtypeOf(");
            stringBuilder.append(this.clazz.getName());
            stringBuilder.append(")");
            return stringBuilder.toString();
        }
    }
}

